#include "gps.h"

GpsMaemo5::GpsMaemo5(QObject *parent) : QObject(parent) {
    latitude = 0;
    longitude = 0;
    accuracy = 0;

    control = location_gpsd_control_get_default();
    device = (LocationGPSDevice*) g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);

    g_signal_connect(device, "changed", G_CALLBACK(GpsMaemo5_changed), this);
    g_object_set(G_OBJECT(control), "preferred-method", LOCATION_METHOD_ACWP, NULL);

    location_gpsd_control_start(control);
}

void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps) {
    if (device->fix) {
        if (device->fix->fields) {
            g_print("lat = %f, long = %f, eph = %f\n", gps->device->fix->latitude, gps->device->fix->longitude, gps->device->fix->eph/100.);
            gps->latitude = gps->device->fix->latitude;
            gps->longitude = gps->device->fix->longitude;
            gps->accuracy = gps->device->fix->eph/100.;
            emit gps->fix();
        }
    }
}
