#include "latitude.h"

LatitudeGUI::LatitudeGUI(QMainWindow *parent) : QMainWindow(parent) {
    glatitude = new GoogleLatitude(this);
    gps = new GpsMaemo5(this);
    setting = new QSettings();
    urllogin = QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude");

    show_lat();

    connect(glatitude, SIGNAL(getOK()), this, SLOT(get_loc()));
    connect(gps, SIGNAL(getOK()), this, SLOT(get_maemo5()));
    connect(gps, SIGNAL(getOK_acwp()), this, SLOT(get_acwp()));
    connect(gps, SIGNAL(getOK_agnss()), this, SLOT(get_agnss()));
    connect(glatitude, SIGNAL(setOK()), this, SLOT(set_OK()));
    connect(glatitude, SIGNAL(setERROR()), this, SLOT(set_ERROR()));

}

void LatitudeGUI::get_loc() {
    location_lat->setText(QString::number(glatitude->get_lat()));
    location_lon->setText(QString::number(glatitude->get_lon()));
    location_acc->setText(QString::number(glatitude->get_acc()));
    status->setText(tr("Using google.com/loc, ip-based"));
}

void LatitudeGUI::get_maemo5() {
    location_lat->setText(QString::number(gps->get_lat()));
    location_lon->setText(QString::number(gps->get_lon()));
    location_acc->setText(QString::number(gps->get_acc()));
    status->setText(tr("Using liblocation"));
}

void LatitudeGUI::get_acwp() {
    location_lat->setText(QString::number(gps->get_lat()));
    location_lon->setText(QString::number(gps->get_lon()));
    location_acc->setText(QString::number(gps->get_acc()));
    status->setText(tr("Using acwp, cell-based "));
}

void LatitudeGUI::get_agnss() {
    location_lat->setText(QString::number(gps->get_lat()));
    location_lon->setText(QString::number(gps->get_lon()));
    location_acc->setText(QString::number(gps->get_acc()));
    status->setText(tr("Using agnss, gps-based "));
}

void LatitudeGUI::set() {
    glatitude->login(login_user->text(),
                     login_pass->text());
    glatitude->set(location_lat->text().toDouble(),
                   location_lon->text().toDouble(),
                   location_acc->text().toDouble());
    status->setText(tr("Setting location..."));
}

void LatitudeGUI::set_OK() {
    status->setText(tr("Updated Location !"));
}

void LatitudeGUI::set_ERROR() {
    status->setText(tr("Error in Authentification !"));
}

void LatitudeGUI::save() {
    setting->setValue("user", login_user->text());
    setting->setValue("pass", login_pass->text());
}

void LatitudeGUI::show_map() {
    // webkit magic
    maps = new QWebView();
    connect(maps, SIGNAL(loadFinished(bool)), this, SLOT(maps_login()));
    maps->load(urllogin);

    // set widget
    setCentralWidget(maps);
    setWindowTitle(tr("Google Maps"));

    // menu
    menuBar()->clear();
    menuBar()->addAction(tr("&Latitude") ,this, SLOT(show_lat()));
}

void LatitudeGUI::show_lat() {
    // login input
    login_user = new QLineEdit(setting->value("user","my_username").toString());
    login_pass = new QLineEdit(setting->value("pass","my_password").toString());
    login_pass->setEchoMode(QLineEdit::Password);
    QPushButton *button_update = new QPushButton(tr("&Update Location"));
    // login layout
    QFormLayout *layout_login = new QFormLayout();
    layout_login->addRow(tr("&Username"), login_user);
    layout_login->addRow(tr("&Password"), login_pass);
    layout_login->addRow(button_update);
    // login connect
    connect(login_user, SIGNAL(editingFinished()), this, SLOT(save()));
    connect(login_pass, SIGNAL(editingFinished()), this, SLOT(save()));
    connect(login_user, SIGNAL(returnPressed()), login_pass, SLOT(setFocus()));
    connect(login_pass, SIGNAL(returnPressed()), this, SLOT(set()));
    connect(button_update, SIGNAL(clicked()), this, SLOT(set()));

    // location input
    location_lat = new QLineEdit(QString::number(0));
    location_lon = new QLineEdit(QString::number(0));
    location_acc = new QLineEdit(QString::number(0));
    // location layout
    QFormLayout *layout_location = new QFormLayout();
    layout_location->addRow(tr("lat :"), location_lat);
    layout_location->addRow(tr("lon :"), location_lon);
    layout_location->addRow(tr("acc :"), location_acc);

    // source button
    QPushButton *source_loc = new QPushButton(tr("&loc"));
    QPushButton *source_cell = new QPushButton(tr("&cell"));
    QPushButton *source_gps = new QPushButton(tr("&gps"));
    // source layout
    QHBoxLayout *layout_source = new QHBoxLayout();
    layout_source->addWidget(source_loc);
    layout_source->addWidget(source_cell);
    layout_source->addWidget(source_gps);
    // source connect
    connect(source_loc, SIGNAL(clicked()), glatitude, SLOT(get()));
    connect(source_cell, SIGNAL(clicked()), gps, SLOT(get_acwp()));
    connect(source_gps, SIGNAL(clicked()), gps, SLOT(get_agnss()));

    // main layout
    location = new QWidget();
    QHBoxLayout *layout_form = new QHBoxLayout();
    layout_form->addLayout(layout_login);
    layout_form->addLayout(layout_location);
    QVBoxLayout *layout = new QVBoxLayout();
    status = new QLineEdit("Ready");
    status->setReadOnly(true);
    status->setDisabled(true);
    layout->addLayout(layout_form);
    layout->addWidget(status);
    layout->addLayout(layout_source);
    location->setLayout(layout);

    // set widget
    setCentralWidget(location);
    setWindowTitle(tr("Google Latitude Updater"));

    // menu
    menuBar()->clear();
    menuBar()->addAction(tr("&Maps") ,this, SLOT(show_map()));
}

void LatitudeGUI::maps_login() {
    if ( maps->url() == urllogin ) {
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Email').value = \"%1\";").arg(
                        setting->value("user").toString()));
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Passwd').value = \"%1\";").arg(
                        setting->value("pass").toString()));
        maps->page()->mainFrame()->evaluateJavaScript("document.getElementById('gaia_loginform').submit();");
    }
}
