#include "latitude.h"

LatitudeGUI::LatitudeGUI(QMainWindow *parent) : QMainWindow(parent) {
    glatitude = new GoogleLatitude(this);
    setting = new QSettings();
    urllogin = QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude");

    show_lat();

    connect(glatitude, SIGNAL(getOK()), this, SLOT(get_loc()));
    connect(glatitude, SIGNAL(setOK()), this, SLOT(set_OK()));
    connect(glatitude, SIGNAL(setERROR()), this, SLOT(set_ERROR()));
}

void LatitudeGUI::get_loc() {
    location_lat->setText(QString::number(glatitude->get_lat()));
    location_lon->setText(QString::number(glatitude->get_lon()));
    location_acc->setText(QString::number(glatitude->get_acc()));
    statusBar()->showMessage(tr("Using google.com/loc"),2000);
}

void LatitudeGUI::get_cell() {
    statusBar()->showMessage(tr("Using cell... TODO"),2000);
}

void LatitudeGUI::get_gps() {
    statusBar()->showMessage(tr("Using gps... TODO"),2000);
}

void LatitudeGUI::set() {
    glatitude->login(login_user->text(),
                     login_pass->text());
    glatitude->set(location_lat->text().toDouble(),
                   location_lon->text().toDouble(),
                   location_acc->text().toDouble());
    statusBar()->showMessage(tr("Setting location..."),2000);
}

void LatitudeGUI::set_OK() {
    statusBar()->showMessage(tr("Location Updated !"),5000);
}

void LatitudeGUI::set_ERROR() {
    statusBar()->showMessage(tr("Error in Authentification !"),5000);
}

void LatitudeGUI::save() {
    setting->setValue("user", login_user->text());
    setting->setValue("pass", login_pass->text());
}

void LatitudeGUI::show_map() {
    maps = new QWebView();
    connect(maps, SIGNAL(loadFinished(bool)), this, SLOT(maps_login()));
    maps->load(urllogin);

    setCentralWidget(maps);
    setWindowTitle(tr("Google Maps"));

    menuBar()->clear();
    menuBar()->addAction(tr("&Latitude") ,this, SLOT(show_lat()));
}

void LatitudeGUI::show_lat() {
    location = new QWidget();
    QHBoxLayout *layout = new QHBoxLayout();
    layout->addLayout(do_login());
    layout->addLayout(do_location());
    location->setLayout(layout);

    setCentralWidget(location);
    setWindowTitle(tr("Google Latitude Updater"));

    menuBar()->clear();
    menuBar()->addAction(tr("&Maps") ,this, SLOT(show_map()));
    menuBar()->addAction(tr("&loc"), glatitude, SLOT(get()));
    menuBar()->addAction(tr("&cell"), this, SLOT(get_cell()));
    menuBar()->addAction(tr("&gps"), this, SLOT(get_gps()));
}

void LatitudeGUI::maps_login() {
    if ( maps->url() == urllogin ) {
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Email').value = \"%1\";").arg(
                        setting->value("user").toString()));
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Passwd').value = \"%1\";").arg(
                        setting->value("pass").toString()));
        maps->page()->mainFrame()->evaluateJavaScript("document.getElementById('gaia_loginform').submit();");
    }
}

QFormLayout *LatitudeGUI::do_login() {
    login_user = new QLineEdit(setting->value("user","my_username").toString());
    login_pass = new QLineEdit(setting->value("pass","my_password").toString());
    login_pass->setEchoMode(QLineEdit::Password);
    QPushButton *login_up = new QPushButton(tr("Update Location"));

    QFormLayout *layout = new QFormLayout();
    layout->addRow(tr("&Username"), login_user);
    layout->addRow(tr("&Password"), login_pass);
    layout->addRow(login_up);

    connect(login_user, SIGNAL(editingFinished()), this, SLOT(save()));
    connect(login_pass, SIGNAL(editingFinished()), this, SLOT(save()));
    connect(login_user, SIGNAL(returnPressed()), login_pass, SLOT(setFocus()));
    connect(login_pass, SIGNAL(returnPressed()), this, SLOT(set()));
    connect(login_up, SIGNAL(clicked()), this, SLOT(set()));

    return layout;
}

QFormLayout *LatitudeGUI::do_location() {
    location_lat = new QLineEdit(QString::number(0));
    location_lon = new QLineEdit(QString::number(0));
    location_acc = new QLineEdit(QString::number(0));

    QFormLayout *layout = new QFormLayout();
    layout->addRow(tr("lat :"), location_lat);
    layout->addRow(tr("lon :"), location_lon);
    layout->addRow(tr("acc :"), location_acc);

    return layout;
}
