#include "latitude.h"

LatitudeGUI::LatitudeGUI(QMainWindow *parent) : QMainWindow(parent) {
    glatitude = new GoogleLatitude(this);
    setting = new QSettings();
    maps = new QWebView();
    location = new QWidget();

    menuBar()->addAction(tr("&Maps") ,this, SLOT(showmap()));
    menuBar()->addAction(tr("&Latitude") ,this, SLOT(showlat()));
    menuBar()->addAction(tr("&Update"), this, SLOT(set()));
    menuBar()->addAction(tr("&loc") ,glatitude, SLOT(get()));

    do_maps();
    do_main();
    showlat();

    // connects
    connect(login_user, SIGNAL(editingFinished()), this, SLOT(save()));
    connect(login_pass, SIGNAL(editingFinished()), this, SLOT(save()));
    connect(glatitude, SIGNAL(getOK()), this, SLOT(get()));
    connect(glatitude, SIGNAL(setOK()), this, SLOT(gsetOK()));
    connect(glatitude, SIGNAL(setERROR()), this, SLOT(gsetERROR()));
}

void LatitudeGUI::get() {
    location_lat->setText(QString::number(glatitude->get_lat()));
    location_lon->setText(QString::number(glatitude->get_lon()));
    location_acc->setText(QString::number(glatitude->get_acc()));
    statusBar()->showMessage(tr("Using google.com/loc"),2000);
}

void LatitudeGUI::set() {
    glatitude->login(login_user->text(),
                     login_pass->text());
    glatitude->set(location_lat->text().toDouble(),
                   location_lon->text().toDouble(),
                   location_acc->text().toDouble());
    statusBar()->showMessage(tr("Setting location..."),2000);
}

void LatitudeGUI::gsetOK() {
    statusBar()->showMessage(tr("Location Updated !"),5000);
}
void LatitudeGUI::gsetERROR() {
    statusBar()->showMessage(tr("Error in Authentification !"),5000);
}

void LatitudeGUI::save() {
    setting->setValue("user", login_user->text());
    setting->setValue("pass", login_pass->text());
}

void LatitudeGUI::showmap() {
    setCentralWidget(maps);
    setWindowTitle(tr("Google Maps"));
}

void LatitudeGUI::showlat() {
    glatitude->get();
    setCentralWidget(location);
    setWindowTitle(tr("Google Latitude Updater"));
}

void LatitudeGUI::do_maps() {
    maps->load(QUrl("http://www.google.com/maps/m"));
}

void LatitudeGUI::do_main() {
    QHBoxLayout *layout = new QHBoxLayout();
    layout->addLayout(do_login());
    layout->addLayout(do_location());
    location->setLayout(layout);
}

QFormLayout *LatitudeGUI::do_login() {
    login_user = new QLineEdit(setting->value("user","my_username").toString());
    login_pass = new QLineEdit(setting->value("pass","my_password").toString());
    login_pass->setEchoMode(QLineEdit::Password);

    QFormLayout *layout = new QFormLayout();
    layout->addRow(tr("&Username"), login_user);
    layout->addRow(tr("&Password"), login_pass);

    return layout;
}

QFormLayout *LatitudeGUI::do_location() {
    location_lat = new QLineEdit(QString::number(0));
    location_lon = new QLineEdit(QString::number(0));
    location_acc = new QLineEdit(QString::number(0));

    QFormLayout *layout = new QFormLayout();
    layout->addRow(tr("lat :"), location_lat);
    layout->addRow(tr("lon :"), location_lon);
    layout->addRow(tr("acc :"), location_acc);

    return layout;
}
