
#ifndef __GOOGLEIMAGES_GOOGLE_IMAGES_ART_DOWNLOADER_H__
#define __GOOGLEIMAGES_GOOGLE_IMAGES_ART_DOWNLOADER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS


#define TYPE_PROVIDER (provider_get_type ())
#define PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROVIDER, Provider))
#define IS_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROVIDER))
#define PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROVIDER, ProviderIface))

typedef struct _Provider Provider;
typedef struct _ProviderIface ProviderIface;

#define TYPE_GOOGLE_IMAGES (google_images_get_type ())
#define GOOGLE_IMAGES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOOGLE_IMAGES, GoogleImages))
#define GOOGLE_IMAGES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOOGLE_IMAGES, GoogleImagesClass))
#define IS_GOOGLE_IMAGES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOOGLE_IMAGES))
#define IS_GOOGLE_IMAGES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOOGLE_IMAGES))
#define GOOGLE_IMAGES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOOGLE_IMAGES, GoogleImagesClass))

typedef struct _GoogleImages GoogleImages;
typedef struct _GoogleImagesClass GoogleImagesClass;
typedef struct _GoogleImagesPrivate GoogleImagesPrivate;

/* This is the interface on DBus that you must implement*/
struct _ProviderIface {
	GTypeInterface parent_iface;
	void (*Fetch) (Provider* self, const char* artist, const char* album, const char* kind);
};

/* http://live.gnome.org/MediaArtStorageSpec
 Sample implementation of com.nokia.albumart.Provider that uses Google 
 images's first result as album-art cover. There is of course no certainty 
 that the first result on Google images is indeed the album's cover. But it's
 a good estimate nonetheless.*/
struct _GoogleImages {
	GObject parent_instance;
	GoogleImagesPrivate * priv;
};

struct _GoogleImagesClass {
	GObjectClass parent_class;
};


void provider_Fetch (Provider* self, const char* artist, const char* album, const char* kind);
void provider_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult provider_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType provider_get_type (void);
Provider* provider_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GoogleImages* google_images_construct (GType object_type);
GoogleImages* google_images_new (void);
void google_images_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult google_images_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType google_images_get_type (void);
void _main (void);


G_END_DECLS

#endif
