#!/usr/bin/perl
# Copyright 2009 The Go Authors. All rights reserved.
# Use of this source code is governed by a BSD-style
# license that can be found in the LICENSE file.
#
# Generate system call table for Darwin from master list
# (for example, xnu-1228/bsd/kern/syscalls.master).

my $command = "mksysnum_darwin.sh " . join(' ', @ARGV);

print <<EOF;
// $command
// MACHINE GENERATED BY THE ABOVE COMMAND; DO NOT EDIT

package syscall

const (
EOF

while(<>){
	if(/^([0-9]+)\s+ALL\s+({ \S+\s+(\w+).*})/){
		my $num = $1;
		my $proto = $2;
		my $name = "SYS_$3";
		$name =~ y/a-z/A-Z/;

		# There are multiple entries for enosys and nosys, so comment them out.
		if($name =~ /^SYS_E?NOSYS$/){
			$name = "// $name";
		}

		print "	$name = $num;  // $proto\n";
	}
}

print <<EOF;
)
EOF
