#!/bin/sh
# Copyright 2009 The Go Authors. All rights reserved.
# Use of this source code is governed by a BSD-style
# license that can be found in the LICENSE file.

set -e

cat <<'EOF'
// Assembly constants.
// AUTOMATICALLY GENERATED BY mkasmh.sh DURING BUILD

EOF

case "$GOARCH" in
386)
	# The offsets 0 and 4 are also known to:
	#	nacl/thread.c:/^newosproc
	#	../../cmd/8l/pass.c:/D_GS
	#	../../libcgo/linux_386.c:/^start
	#	../../libcgo/darwin_386.c:/^start
	echo '#define	g	0(GS)'
	echo '#define	m	4(GS)'
	;;
amd64)
	# These registers are also known to:
	#	../../libcgo/linux_amd64.c:/^start
	echo '#define	g	R15'
	echo '#define	m	R14'
	;;
arm)
	echo '#define	g	R10'
	echo '#define	m	R9'
	echo '#define	LR	R14'
	;;
*)
	echo 'unknown $GOARCH: '$GOARCH 1>&2
	exit 1
	;;
esac
echo

awk '
/^aggr G$/ { aggr="g" }
/^aggr M$/ { aggr = "m" }
/^aggr Gobuf$/ { aggr = "gobuf" }
/^}/ { aggr = "" }

#	Gobuf 24 sched;
#	'Y' 48 stack0;
#	'Y' 56 entry;
#	'A' G 64 alllink;
aggr != "" && /^	/ {
	name=$NF;
	sub(/;/, "", name);
	offset=$(NF-1);
	printf("#define %s_%s %s\n", aggr, name, offset);
}
' runtime.acid.$GOARCH

