/*
 * This file is part of goban770
 *
 * Copyright (C) 2006,2007 Jarmo Ahosola.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef SGF_H
#define SGF_H

/* Includes */
#include <gtk/gtk.h>

/* Definitions */
typedef enum {
  SGFTERM_OK = 0,
  SGFTERM_INFINITE_LOOP,
  SGFTERM_EXCEED_EOF,
  SGFTERM_OUT_OF_MEMORY
} SgfTerminate; 

typedef enum {
  SGF_EOF = -1,
  SGF_SEMICOLON = -2,
  SGF_OPEN_BRACKET = -3,
  SGF_CLOSE_BRACKET = -4,
  SGF_OPEN_PARAMETER = -5,
  SGF_B = 0,
  SGF_W = 1,
  SGF_GM = 2,
  SGF_FF = 3,
  SGF_ST = 4,
  SGF_SZ = 5,
  SGF_KM = 6,
  SGF_C = 7,
  SGF_CR = 8,
  SGF_TR = 9,
  SGF_SQ = 10,
  SGF_MA = 11,
  SGF_M = 12,
  SGF_HA = 13,
  SGF_AB = 14,
  SGF_AW = 15,
  SGF_L = 16,
  SGF_LB = 17,
  SGF_GN = 18,
  SGF_BR = 19,
  SGF_EV = 20,
  SGF_PB = 21,
  SGF_PC = 22,
  SGF_PW = 23,
  SGF_RE = 24,
  SGF_WR = 25,
  SGF_TB = 26,
  SGF_TW = 27,
  SGF_V = 28,
  SGF_PL = 29,
  SGF_HOME = 30,
  SGF_DI = 31,
  SGF_GE = 32,
  SGF_AE = 33  
} SgfToken; 

/* Functions */
gboolean IsValidSgf(gchar * readIn, gchar * theEnd, gint * nodeCount, gint * paramCount, gint * branchCount, gint * charCount);
gint ReadGobanSize(gchar * where, gchar * upto);
gint SkipSgfToken();
SgfToken ReadSgfToken(Node * trashcanNode, MainView * main);
void ParseSgfGame(MainView * main, gchar * unparsed, gchar * endOfFile);
void ParseSgf(MainView * main, Node * node);
gboolean FindPlainNote();
gint SkipPlainNote();
gint ReadGint();
gchar * ReadNote();
gint ReadLocation();
Stone ReadColor();
Labellist * ReadOldStyleLabellist(Labellist * oldList);
Labellist * ReadLabellist(Labellist * oldList);
Pointlist * ReadPointlist(Pointlist * oldList);

GtkTextBuffer * InitSgfHandling();
void Append2File(gchar * text);
void PointList2File(Pointlist * point);
void Point2File(gint at);
void Gint2File(gint value);
void CreateSgfFile(MainView * main);
void Node2Sgf(Node * node, Node * home);

#endif
