/*
 * This file is part of goban770
 *
 * Copyright (C) 2006,2007 Jarmo Ahosola.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef LOG_H
#define LOG_H

/* Includes */
#include <gtk/gtk.h>
#include <ui/interface.h>

/* Definitions */
/* Next line should be uncommented in production version and commented in development version */
/* #define PRODUCTION_VERSION */

/* data types */
typedef enum {
    LOGMETHOD_APPEND = 0,
    LOGMETHOD_REPLACE = 1,
    LOGMETHOD_SAMPLE = 2,
    LOGMETHOD_PAUSED = 3
} LogMethod;

static char * logmethodtext[] = {
"Append",
"Replace",
"Sample",
"Paused"
};

#define MAX_LOGMETHOD 3
#define DEFAULT_LOGMETHOD 1

typedef enum {
    LOGLEVEL_NONE = 0,
    LOGLEVEL_ERROR = 1,
    LOGLEVEL_WARNING = 2,
    LOGLEVEL_ABOUT = 3,
    LOGLEVEL_STATISTICS = 4,
    LOGLEVEL_HELP = 5,
    LOGLEVEL_INFO = 6,
    LOGLEVEL_NOT_USED = 7
} LogLevel;

static char * logleveltext[] = {
"logs off",
"errors",
"warnings",
"about",
"statistics",
"help",
"info"
};

#define MAX_LOGLEVEL 6
#define DEFAULT_LOGLEVEL 6

/* LOGSCOPE_NONE must be set to zero. LOGSCOPE_FORCED must have at least all bits set that are set in other values. */ 
typedef enum {
    LOGSCOPE_NONE = 0,
    LOGSCOPE_PATH = 1 << 0,
    LOGSCOPE_MEMORY = 1 << 1,
    LOGSCOPE_LOOP = 1 << 2,
    LOGSCOPE_GO_RULES = 1 << 3,
    LOGSCOPE_GAMETREE = 1 << 4,
    LOGSCOPE_SGF = 1 << 5,
    LOGSCOPE_USER = 1 << 6,
    LOGSCOPE_FORCED = (1 << 15) - 1
} LogScope; 

#define MAX_LOGSCOPE 8

/* Order of values must be same in this list and in logscopetext list. 
   Notice that naming is different due different point of view.
   If scope is none, then message would be shown only if all messages are shown.
   If scope is forced, then message would be shown also if only minimal set of messages are shown. */
static LogScope logscopeconvert[MAX_LOGSCOPE + 1] = {
    LOGSCOPE_NONE,
    LOGSCOPE_FORCED,
    LOGSCOPE_USER,
    LOGSCOPE_PATH,
    LOGSCOPE_MEMORY,
    LOGSCOPE_LOOP,
    LOGSCOPE_GO_RULES,
    LOGSCOPE_GAMETREE,
    LOGSCOPE_SGF
};

static char * logscopetext[MAX_LOGSCOPE + 1] = {
"all",
"minimal",
"user",
"path",
"memory",
"loop",
"rules",
"tree",
"sgf"
};

#define DEFAULT_LOGSCOPE 2

/* Functions */
void Browsing();
void GuessWrong();
void GuessRight();
void TakeMoveBack();
void TakeHint();
void PeekNext();
void LastNodeEnter();
void LastNodeExit();
void EnterFile();
void PrintTrainingStatistics(gboolean isProblem);
void ResetTrainingStatistics(gboolean fileChanges, gboolean isProblem);
void init_log_service(GtkTextBuffer* logBuffer, GtkWidget * scrollWindow); /* , MainView * mainview); */
void ResetSeverestMsg();
LogLevel GetSeverestMsg();
LogMethod GetLogMethod();
void set_log2file(gboolean newValue, gchar * logAt);
void set_log_method(LogMethod method);
void set_log_level(LogLevel level);
void set_log_scope(LogScope scope);
gboolean WouldTheseParametersLog(LogLevel level, LogScope scope);
void msg2log(const char * msg, LogLevel level, LogScope scope);
void msg2logGint(const char * msg, LogLevel level, LogScope scope, gint number);
void msg2logBol(const char * yes, const char * no, LogLevel level, LogScope scope, gboolean bol);
void LogReserveMemory(const char * what);
void LogReleaseMemory(const char * what);
void UserMessage(GtkWidget * widget, Node * node, const char * msg);
void CopyLog2File();

#endif
