/*
 * This file is part of goban770
 *
 * Copyright (C) 2006,2007 Jarmo Ahosola.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef DRAW_H
#define DRAW_H

/* Includes */
#include <gtk/gtk.h>
#include <ui/interface.h>

/* Definitions */
#define GOBAN_BORDER 0
/* data types */

/* Functions */
void DrawCircle(MainView* mainview, gint x, gint y, Stone color);
void DrawSquare(MainView* mainview, gint x, gint y, Stone color);
void DrawBranchmark(MainView* mainview, gint x, gint y, gboolean active);
void DrawTriangle(MainView* mainview, gint x, gint y, Stone color);
void DrawBranchMark(MainView* mainview, gint x, gint y);
void DrawCross(MainView* mainview, gint x, gint y, Stone color);
void DrawTerritory(MainView* mainview, gint x, gint y, Stone stone);
void DrawStone(MainView* mainview, gint x, gint y, Stone stone);
void DrawSearchIcon(MainView* mainview);
void MarkCurrentMove(MainView* mainview);
void DrawStoneAtTree(MainView * main, Node * node, gboolean active);
gchar * AddGintInString(gchar * in, gint value);
gchar * Add2GintInString(gchar * in, gint value1, gint value2);
gchar * ProblemText(gchar * classification, gchar * difficulty);
gchar * X2ColumnTitle(gint x);
gchar * Gint2String(gint value);
gchar * At2String(gint at, gint gobanSize);
gchar * Y2RowTitle(gint y, gint gobanSize);
gchar * MoveRange2String(gint from, gint to);
gchar * WherePlayed2String(gint number, gint at, gint gobanSize);
void WriteText( GtkWidget * widget, GdkPixmap * pixmap, gchar * text, gint centerX, gint centerY, gint width, gint height, GdkGC * gc);
void DrawThumb(MainView * main, gint top, gint left, gint size, ThumbList * thumb);
void DrawGoban(MainView * main);
void MarkSelected(MainView* mainview, gint x, gint y);
void MarkStone(MainView* mainview, gint x, gint y, Stone * stone);
void MarkArea(MainView* mainview, gint x1, gint y1, gint x2, gint y2);
void DrawGametree( MainView * main );
void DrawNode(MainView * main, Node * node, Node * firstChild, gboolean activeParent, gint parentHeight);
void DrawCurrentNodeAtTree(MainView * main);
gint GetHoshiInterval(gint gobanSize);
void DrawHoshiPoints(MainView * main);
void DrawHoshiAt(MainView * main, gint x, gint y);
gint Y2Height(gint y);
gint X2Turn(gint x);
void MarkSelectedNode(MainView * main, Node * node);
void MarkBranch(MainView * main, Node * node);
void MarkFamily(MainView * main, Node * node);
void DrawAll(MainView * mainview);
gint GetUsedLabelCount(MainView * main, gboolean countLetters);


#endif
