/*
 * This file is part of goban770
 *
 * Copyright (C) 2005 Nokia Corporation.
 * Copyright (C) 2006,2007 Jarmo Ahosola.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef INTERFACE_H
#define INTERFACE_H

#include <game/gametree.h>
#include <gtk/gtk.h>
/* #include <gtk/glib.h> */
#include <hildon/hildon-program.h>
#include <appdata.h>
#include <dirent.h>
/* #include <game/goban.h> */

#define _(String) gettext(String)

#define GOBAN_ASPECTRATIO (12.0/13.0)
#define GOBAN_FONT_SCALE_FACTOR 250
#define MAX_GOBANSIZE 19
#define GOBAN_MAX_HEIGHT_WITH_VIRTUAL_KEYBOARD 300

/* confirmation responses */
#define CONFRESP_YES 1
#define CONFRESP_NO 2
#define CONFRESP_OK 3
#define CONFRESP_CANCEL 4
#define CONFRESP_ERROR 5

#define BIGTREE_SCALE 32
#define MINIMUM_DIAGRAM_SCALE 20
#define DEFAULT_SCALE 14

#define MAX_SHOWN_NUMBERS 1000

#define TABS_WIDTH_NORMAL 360
#define TABS_WIDTH_DIAGRAM 300

#define MAIN_VIEW_NAME "MainView"

static char * ranktext[] = {
"30k",
"29k",
"28k",
"27k",
"26k",
"25k",
"24k",
"23k",
"22k",
"21k",
"20k",
"19k",
"18k",
"17k",
"16k",
"15k",
"14k",
"13k",
"12k",
"11k",
"10k",
"9k",
"8k",
"7k",
"6k",
"5k",
"4k",
"3k",
"2k",
"1k",
"?",
"1d",
"2d",
"3d",
"4d",
"5d",
"6d",
"7d",
"8d",
"9d"
};

#define MIN_RANK -30
#define UNKNOWN_RANK 0
#define MAX_RANK 9

/* Tab pages */
#define LOG_PAGE 0
#define GAME_PAGE 1
#define ANALYSIS_PAGE 2

typedef enum {
    MAEMOPAD_NO_ERROR = 0,
    MAEMOPAD_ERROR_INVALID_URI,
    MAEMOPAD_ERROR_SAVE_FAILED,
    MAEMOPAD_ERROR_OPEN_FAILED
} MaemopadError;

typedef enum {
    TEMPMODE_NONE = 0,
    TEMPMODE_CHANGE_ORIENTATION,
    TEMPMODE_EDIT_AREA,
    TEMPMODE_FILE_THUMBS
} TemporalMode;

typedef struct _FileList FileList;
struct _FileList
{
	FileList * next;
	gchar* filename;
};

typedef struct _PlayList PlayList;
struct _PlayList
{
  PlayList * next;              /* next playlist */
  gchar * directory;            /* directory of sgf playlist */
  struct dirent **sgfplaylist;  /* files withing which user can loop with next file feature */
  int size;                     /* number of files in the playlist */
  int current;                  /* current file of the playlist */
  GtkWidget * playlist_item;    /* menu item for chosing the playlist */
  gchar * title;                /* playlist title. This pointer points inside of directory string above and should not be freed separately. */
};

#define THUMB_TOP_MARGIN 10
#define THUMB_LEFT_MARGIN 10
#define THUMB_FRAME_MARGIN 5
#define THUMB_MAX_SIZE 95
#define THUMB_HORIZONTAL_DELTA 111
#define THUMB_VERTICAL_DELTA 115
#define THUMB_TITLE_CENTER_X (THUMB_MAX_SIZE/2)
#define THUMB_TITLE_CENTER_Y (THUMB_MAX_SIZE + 8)
#define THUMB_TITLE_SPACE_X 800
#define THUMB_TITLE_SPACE_Y 480
#define THUMB_TITLE_MAX_LENGTH 14
#define SCREEN_MAX_X 800
#define SCREEN_MAX_Y 480
#define THUMBS_MAX_AT_ROW (((SCREEN_MAX_X) - (THUMB_LEFT_MARGIN))/(THUMB_HORIZONTAL_DELTA))
#define THUMBS_MAX_AT_COLUMN (((SCREEN_MAX_Y) - (THUMB_TOP_MARGIN))/(THUMB_VERTICAL_DELTA))
#define MAX_AMOUNT_OF_THUMBNAILS ((THUMBS_MAX_AT_ROW)*(THUMBS_MAX_AT_COLUMN) - 1)

typedef struct _ThumbList ThumbList;
struct _ThumbList
{
  ThumbList * next;             /* next thumbnail */
  gint sgfSZ;                   /* size of the goban in the thumbnail */
  gchar * thumb;                /* the thumb as an array. One character per location at the goban */
  gchar * title;                /* title text shown with the thumb */
  gchar * sgfPW;                /* name of white player of the game */
  gchar * sgfPB;                /* name of black player of the game */
  gint indexAtPlaylist;         /* index of the file in the thumbnailed playlist */
};

/* Struct to include view's information */
typedef struct _MainView MainView;
struct _MainView
{
    /* Handle to app's data */
    AppData *data;

    /* File classification */
    gboolean isGoProblem;
    gboolean isBigTree;

    /* Playlists */
    GSList *playlist_radio;      /* Radio group for selecting current playlist */
    PlayList * firstPlaylist;    /* First defined playlist */ 
    PlayList * currentPlaylist;  /* Currently used playlist */
    PlayList * thumbedPlaylist;  /* Playlist which of thumbnails has been made of */
    GtkWidget * playlists_menu;  /* Menu that hold the radio group */
    ThumbList * thumbnails;      /* Thumbnails created for playlist */

    /* Game root node information */
    Node * child; /* First non-root node of the game tree at the main branch. */
	 Pointlist * sgfAB; /* sgf tag AB for adding black stones in the setup position, mainly handicap stones. */
	 Pointlist * sgfAW; /* sgf tag AW for adding white stones in the setup position, usefull for problems. */
    gint sgfFF; /* sgf tag FF for fileformat of the gametree */
    gint sgfST; /* sgf tag ST for style of shown game tree */
    gint sgfSZ; /* sgf tag SZ for size of the goban. Only square boards are supported. */
    gint sgfHA; /* sgf tag HA for amount of handicap stones */
    gint sgfKMx2; /* komi multiplied by 2 */
    GtkTextBuffer * unsupportedSgf;
    gchar * sgfC; /* Comment at root node */
	 Pointlist * sgfMA; /* cross */
	 Pointlist * sgfTR; /* triangle, also sgfM would be read to here to convert old files */
	 Pointlist * sgfCR; /* circle */
	 Pointlist * sgfSQ; /* square */
	 /* Pointlist * sgfTB; black territory not yet supported at root position */
	 /* Pointlist * sgfTW; white territory not yet supported at root position */
	 Labellist * sgfLB; /* label */
    gchar * sgfGN; /* Game name */
    gchar * sgfBR; /* Black rank */
    gchar * sgfEV; /* Event */
    gchar * sgfPB; /* Black player name */
    gchar * sgfPC; /* Place where game was played */
    gchar * sgfPW; /* White player name */
    gchar * sgfRE; /* Result of the game */
    gchar * sgfWR; /* White rank */
    Stone sgfPL; /* Player in turn, if setup position at the root node */
    gchar * sgfDI; /* Problem difficulty, goproblems.com */
    gchar * sgfGE; /* Problem classification, goproblems.com */

    /* Times */
    gint clockAtStartUp;    /* Application start seconds, used for random number initialization */
    gint clockStartTime;    /* Clock start time relative to current time if running or stop time if stopped */
    gint clockStopTime;     /* Last clock stop time if clock is not running */
    gboolean clockRunning;  /* Clock is running, not stopped */
    gboolean clockInUse;    /* Clock is in use. Clock cannot be started midgame if it is not in use */
    gint mainTime;          /* Game maintime */
    
    /* Prisoners */
    gint capturedBlack;
    gint capturedWhite;

    /* Fullscreen mode is on (TRUE) or off (FALSE) */
    gboolean fullscreen;

    /* Items for menu */
    GtkWidget *file_item;
    GtkWidget *new_item;
    GtkWidget *open_item;
    GtkWidget *save_item;
    GtkWidget *saveas_item;
    GtkWidget *edit_item;
    GtkWidget *cut_item;
    GtkWidget *copy_item;
    GtkWidget *paste_item;
    GtkWidget *font_item;
    GtkWidget *fullscreen_item;
    GtkWidget *propose_item;
    GtkWidget *compare_item;
    GtkWidget *hint_item;
    GtkWidget *prune_item;
    GtkWidget *rotate_item;
    GtkWidget *circle_lp_item;
    GtkWidget *remove_cm_item;
    GtkWidget *fill_item;
    GtkWidget *create_problem_item;
    GtkWidget *set_result_item;
    GtkWidget *result_bwinr_item;
    GtkWidget *result_bwint_item;
    GtkWidget *result_bwinf_item;
    GtkWidget *result_wwinr_item;
    GtkWidget *result_wwint_item;
    GtkWidget *result_wwinf_item;
    GtkWidget *result_void_item;
    GtkWidget *result_unknown_item;
    GtkWidget *result_estimate_item;
    GtkWidget *playlist_item;
    GtkWidget *refresh_playlist_item;
    GtkWidget *thumb_playlist_item;
    GtkWidget *game_edit_item;
    GtkWidget *options_item;
    GtkWidget *shownext_item;
    GtkWidget *boardmarkup_item;
    GtkWidget *childview_item;
    GtkWidget *diagramview_item;
    GtkWidget *resetnumbering_item;
    GtkWidget *numberNPlays_item;
    GtkWidget *rndOrientation_item;
    GtkWidget *autoRefute_item;
    GtkWidget *alphaTesting_item;
    GtkWidget *load_options_item;
    GtkWidget *merge_load_item;
    GtkWidget *minimal_load_item;
    GtkWidget *try_load_item;
    GtkWidget *omit_empty_nodes_item;
    GtkWidget *problem2step_item;
    GtkWidget *problemTraining_item;
    GtkWidget *manualOnly_item;
    GtkWidget *bigTreeVariations_item;
    
    /* Items for popup menu */
    GSList *mousemode_radio;
    GtkWidget *mousemode_menu;
    GtkWidget *play_item;
    GtkWidget *training_item;
    GtkWidget *territory_item;
    GtkWidget *search_item;
    GtkWidget *diagram_item;
    GtkWidget *addblack_item;
    GtkWidget *addwhite_item;
    GtkWidget *numbering_item;
    GtkWidget *labeling_item;
    GtkWidget *triangle_item;
    GtkWidget *square_item;
    GtkWidget *circle_item;
    GtkWidget *cross_item;
    GtkWidget *CurrentMouseMode;
    TemporalMode temporal_mode;
    
    /* Options */
    gint numberLastPlays;
    gboolean shownext;
    gboolean resetNumbering;
    gboolean diagramview;
    gboolean rndOrientation; /* Randomize goban orientation when loading go-problem files */
    gboolean step_2;
    gboolean transparentCaptured;
    gboolean analysisAutoRefute;
    gboolean alphaTesting;
    gboolean mergeload;
    gboolean minimalload;
    gboolean problem2step;
    gboolean problemTraining;
    gboolean manualOnly;
    gboolean bigTreeVariations;
    gboolean omitEmptyNodes;
    gint tryLoad;

    /* Toolbar */
    GtkWidget* toolbar;
    GtkWidget* iconw;
    GtkToolItem* alphatesting_tb;
    GtkToolItem* gotofirst_tb;
    GtkToolItem* gotohome_tb;
    GtkToolItem* gotomain_tb;
    GtkToolItem* gotovari_tb;
    GtkToolItem* gotopbra_tb;
    GtkToolItem* gotoprev_tb;
    GtkToolItem* gotonext_tb;
    GtkToolItem* gotonbra_tb;
    GtkToolItem* gotolast_tb;
    GtkToolItem* menu_tb;
    GtkToolItem* new_tb;
    GtkToolItem* open_tb;
    GtkToolItem* nextfile_tb;
    GtkToolItem* index_tb;
    GtkToolItem* save_tb;
    GtkToolItem* saveas_tb;
    GtkToolItem* separator_tb1;
    GtkToolItem* cut_tb;
    GtkToolItem* copy_tb;
    GtkToolItem* paste_tb;
    GtkToolItem* separator_tb2;
    GtkToolItem* font_tb;
    GtkToolItem* fullscreen_tb;
    GtkToolItem* givehint_tb;
    GtkToolItem* findmainline_tb;
    GtkToolItem* clear_tb;
    GtkToolItem* add_tb;
    GtkToolItem* delete_tb;
    GtkToolItem* mark_territory_tb;
    GtkToolItem* step_2_option_tb;
    GtkWidget* step_2_option_icon;
    GtkToolItem* set_mark_tb;
    GtkWidget* set_mark_icon;
    GtkToolItem* transparent_tb;
    GtkWidget* transparent_icon;
    GtkToolItem* resetNumbering_tb;
    GtkWidget* resetNumbering_icon;
    GtkToolItem* numberNlast_tb;
    GtkWidget* numberNlast_icon;

    /* Application layout */
    GtkWidget* toplevel;   /* hbox containing aspectframe and notebook */
    /* GtkWidget* aspectframe;   / * aspectframe containing goban needed to maintain ratio of height and width of goban */
    GtkWidget* gobanFrame;   /* frame containing goban view */
    GtkWidget* goban_view;   /* drawing area that show the goban */
    GtkWidget* notebook;   /* notebook containing all alternative parts of application layout as pages */
    GtkWidget* game_recording_page;   /* page containing widgets needed while recording game at tournament */
    GtkWidget* game_recording_tab;   /* widget shown at tab where game recording view is selected from */
    /* GtkWidget* game_recording_placeholder;    temporary content of game recording page */
    GtkWidget* analysis_page;   /* page containing widgets needed while analysing game */
    GtkWidget* analysis_tab;   /* widget shown at tab where analysis view is selected from */
    /* GtkWidget* analysis_placeholder;    temporary content of analysis page */
	 GdkPixmap* gobanPixmap;   /* Offscreen prawing area for the goban */
    GtkWidget* gametree_view;   /* drawing area that show the gametree */
	 GdkPixmap* gametreePixmap;   /* Offscreen drawing area for the gametree */
    GtkWidget* debug_page;   /* page containing widgets needed while debuging game */
    GtkWidget* debug_tab_all;   /* widget containing all possible tab title widgets */
    GtkWidget* debug_tab;   /* widget shown at tab where debug view is selected from */
    GtkWidget* debug_info_tab;   /* widget shown at debug tab containing info */
    GtkWidget* debug_help_tab;   /* widget shown at debug tab containing help */
    GtkWidget* debug_stat_tab;   /* widget shown at debug tab containing statistics */
    GtkWidget* debug_about_tab;   /* widget shown at debug tab containing about information */
    GtkWidget* debug_warn_tab;   /* widget shown at debug tab containing warnings */
    GtkWidget* debug_error_tab;   /* widget shown at debug tab containing errors */
    GtkWidget* current_debug_tab; /* widget chosen currently for showing as debug tab */
    GtkWidget* debug_edit;   /* space reserved for log section copy, cut etc. */
    GtkWidget* debug_options;   /* section containing widgets to control debuging game */
    GtkWidget* debug_method_combo;   /* combo box for selecting method of debuging */
    GtkWidget* debug_level_combo;   /* combo box for selecting level of debuging */
    GtkWidget* debug_scope_combo;   /* combo box for selecting scope of debuging */
    GtkWidget* faq_button;   /* button for showing FAQ */
    GtkWidget* debug_clear_button;   /* button for clearing debug printout */
	 GtkWidget* debug_clearButton_image;
    GtkWidget* debug_scrolledwindow;   /* debug textview is under this widget */
    GtkWidget* debug_textview;         /* widget that shows the debug text */
    GtkWidget* anal_note_frame;  /* analysis note page top frame for containing notes */
    GtkWidget* note_scrolledwindow; /* scrolled window for notes */
    GtkWidget* note_textview;         /* widget that shows the note text */
    GtkWidget* anal_gametree_frame;  /* analysis note page top frame for containing game tree */
    GtkWidget* gamedata_vbox; /* Container for game data */
    GtkWidget* game_title_element; /* UI element for holding game title */
    GtkWidget* game_result_element; /* UI element for holding game result */
    GtkWidget* black_frame; /* Frame for information about black player */
    GtkWidget* black_rows_vbox; /* Lines for black data */
    GtkWidget* black_id_hbox; /* Line for black player name and rank */
    GtkWidget* black_name; /* Input box for name of black player */
    GtkWidget* black_rank; /* Input drop down for rank of black player */
    GtkWidget* black_time_text; /* Text for showing remaining black time */
    GtkWidget* black_prisoners_text; /* Text for telling captured white stones */
    GtkWidget* white_frame; /* Frame for information about white player */
    GtkWidget* white_rows_vbox; /* Lines for white data */
    GtkWidget* white_id_hbox; /* Line for white player name and rank */
    GtkWidget* white_name; /* Input box for name of white player */
    GtkWidget* white_rank; /* Input drop down for rank of white player */
    GtkWidget* white_time_text; /* Text for showing remaining white time */
    GtkWidget* white_prisoners_text; /* Text for telling captured black stones */
    GtkWidget* game_buttons_hbox; /* Game buttons container */
    GtkWidget* startClock_button; /* Button for starting clock */
    GtkWidget* stopClock_button; /* Button for stopping clock */
    GtkWidget* pass_button; /* Button for passing */
	 /* Debug parameters */
	 gint debugMethod;  /* Indication of how logging is done */
	 gint debugScope;  /* Functionality or section of the program debuged */
	 gint debugLevel;  /* Level of severity below which messages are not shown */
	 
	 /* Goban parameters */
	 GdkColor gobanColor;  /* color for the goban */
	 GdkColor indicationColor;  /* color for indication */
	 GdkGC * gobanGC; /* gc for goban color */
	 GdkGC * indicateGC; /* gc for indication color */
	 /* gint gobanSize;   / * width and height of goban in measure of stones. So 19, means goban of 19x19 stones */
    gint rowHeight; /* amount of pixels from one horizontal goban line to next horizontal goban line */
    gint colWidth; /* amount of pixels from one vertical goban line to next vertical goban line */ 
    gint stoneSize; /* both vertical and horizontal dimension available for stone graphics */
    gint stoneCenter; /* diameter of a stone round down */
    gint centerX; /* pixel position X-coordinate of tengen within goban drawing area */
    gint centerY; /* pixel position Y-coordinate of tengen within goban drawing area */
    gint centerMostStone; /* index position in stones coordinates of tengen. Note: left top corner is 0,0 */
    gboolean mouseAtGoban; /* True if pointer currently touch goban area */
    gint mouseGobanClickX; /* Locaton in term of stones where the pointer was pointed at */
    gint mouseGobanClickY; /* Locaton in term of stones where the pointer was pointed at */
    gint mouseGobanCurrentX; /* Location in term of stones where dragged pointer currently is */
    gint mouseGobanCurrentY; /* Location in term of stones where dragged pointer currently is */
    gint select_left; /* Left border of selection area */
    gint select_right; /* Right border of selection area */
    gint select_top; /* Top border of selection area */
    gint select_bottom; /* Bottom border of selection area */
    
    /* Game parameters */
	 Node * currentNode; /* The gametree node which position is currently shown on goban. NULL if at root. */
	 Node * panicNode; /* The game tree node at which panic button reverts the position */
	 Node * compareNode; /* The game tree node that has been previously marked for comparison */
	 Node * noteNode; /* Node which note is currently shown */
	 Stone playerInTurn; /* Player in turn at position currently shown on goban. STONE_NONE if placing handicap. */
    gint koAt; /* Position where simple ko rule deny playing at */

    /* Game tree parameters */
    gint gridSize; /* Minimum number of pixels reserved for node and it's neighbourhood at game tree */
    gint gridRestore;
    Node * mouseGtreeCurrent; /* Current location of mouse at game tree */
    Node * mouseGtreeClick; /* Mouse press down location at game tree */
    gboolean mouseAtGtree; /* Mouse is pressed at game tree currently */ 

    /* Textview related */
    GtkTextBuffer* debugBuffer;       /* buffer that contains the debug text */
    GtkTextBuffer* noteBuffer;       /* buffer that contains the note text */
    GtkTextBuffer* fileBuffer;       /* buffer that contains the file text */
    GtkClipboard* clipboard;     /* clipboard for copy/paste */
   
    PangoFontDescription* font_desc;    /* font used in textview */

    gboolean file_edited;     /* tells is our file on view edited */
    gchar* file_name;         /* directory/file under editing */
    gchar* directory_NOT_IN_USE;         /* directory of sgf playlist */
    FileList * filesToCycle_NOT_IN_USE;  /* looped list of files that user can cycle within. Points to the current file in the list */
    struct dirent **sgfplaylist;  /* files withing which user can loop with next file feature */
    int playlistsize;             /* number of files in the playlist */
    int playlistcurrent;          /* current file of the playlist */
};

/* Publics: */
MainView* interface_main_view_new( AppData* data );
void interface_main_view_destroy( MainView* main );
char* interface_file_chooser( MainView* main, GtkFileChooserAction action );
PangoFontDescription* interface_font_chooser( MainView * main );
gint interface_save_changes_note( MainView* main );
void interface_error( MaemopadError me, MainView *main );

#endif
