/*
 * This file is part of goban770
 *
 * Copyright (C) 2005 Nokia Corporation.
 * Copyright (C) 2006,2007 Jarmo Ahosola.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef CALLBACKS_H
#define CALLBACKS_H

#include <ui/interface.h>
#include <utils/draw.h>
#include <gtk/gtk.h>
#include <appdata.h>


void Panicable(MainView * mainview);
void SetStyle(MainView * mainview);
void ResetGame(gint newSize, MainView * mainview);
/* Game recording page events */
void pass_event (GtkButton *button, gpointer data ); 
/* log events */
void faq_event (GtkButton *button, gpointer data ); 
void delete_logs_event (GtkButton *button, gpointer data ); 
void debug_method_combo_event (GtkComboBox *widget, gpointer data ); 
void debug_scope_combo_event (GtkComboBox *widget, gpointer data ); 
void debug_level_combo_event (GtkComboBox *widget, gpointer data ); 
/* key detection */
gboolean key_press_cb ( GtkWidget * widget, GdkEventKey * event, gpointer data );
/* offscreen drawing */
gboolean configure_goban_event( GtkWidget * widget, GdkEventConfigure *event, gpointer data );
gboolean expose_goban_event( GtkWidget * widget, GdkEventExpose *event, gpointer data );
gboolean configure_gametree_event( GtkWidget * widget, GdkEventConfigure *event, gpointer data );
gboolean expose_gametree_event( GtkWidget * widget, GdkEventExpose *event, gpointer data );
/* goban input */
gboolean button_press_goban_event( GtkWidget * widget, GdkEventButton *event, gpointer data );
gboolean button_release_goban_event( GtkWidget * widget, GdkEventButton *event, gpointer data );
gboolean motion_notify_goban_event( GtkWidget * widget, GdkEventMotion *event, gpointer data );
/* gametree input */
gboolean button_press_gametree_event( GtkWidget * widget, GdkEventButton *event, gpointer data );
gboolean button_release_gametree_event( GtkWidget * widget, GdkEventButton *event, gpointer data );
gboolean motion_notify_gametree_event( GtkWidget * widget, GdkEventMotion *event, gpointer data );
/* edit-> cut/copy/paste */
void callback_edit_cut ( GtkAction * action, gpointer data );
void callback_edit_copy ( GtkAction * action, gpointer data );
void callback_edit_paste ( GtkAction * action, gpointer data );
/* Game tree browsing */
void callback_first ( GtkAction * action, gpointer data );
void callback_home ( GtkAction * action, gpointer data );
void callback_previous ( GtkAction * action, gpointer data );
void callback_next ( GtkAction * action, gpointer data );
void callback_last ( GtkAction * action, gpointer data );
void callback_mainline ( GtkAction * action, gpointer data );
void callback_variation ( GtkAction * action, gpointer data );
void callback_nbranch ( GtkAction * action, gpointer data );
void callback_pbranch ( GtkAction * action, gpointer data );
/* Icon to open the main menu */
void callback_open_menu ( GtkAction * action, gpointer data );
/* file-> new/open/save */
void callback_file_new ( GtkAction * action, gpointer data );
void callback_file_open ( GtkAction * action, gpointer data );
void callback_next_file ( GtkAction * action, gpointer data );
void callback_file_save ( GtkAction * action, gpointer data );
void callback_file_saveas ( GtkAction * action, gpointer data );
/* font */
void callback_font ( GtkAction * action, gpointer data );
/* fullscreen */
void callback_fullscreen ( GtkAction * action, gpointer data );
void callback_propose ( GtkAction * action, gpointer data );
void callback_compare ( GtkAction * action, gpointer data );
void callback_hint ( GtkAction * action, gpointer data );
void callback_clear_territory ( GtkAction * action, gpointer data );
void callback_prune ( GtkAction * action, gpointer data );
void callback_rotate ( GtkAction * action, gpointer data );
void callback_circle_lp ( GtkAction * action, gpointer data );
void callback_remove_cm ( GtkAction * action, gpointer data );
void callback_fill ( GtkAction * action, gpointer data );
void callback_create_problem ( GtkAction * action, gpointer data );
void callback_add_kikashi ( GtkAction * action, gpointer data );
void callback_delete ( GtkAction * action, gpointer data );
void callback_shownext ( GtkAction * action, gpointer data );
void callback_boardmarkup ( GtkAction * action, gpointer data );
void callback_childview ( GtkAction * action, gpointer data );
void callback_diagram ( GtkAction * action, gpointer data );
void callback_resetnumbering ( GtkWidget * action, gpointer data );
void callback_number_n_plays_tb(GtkToggleToolButton * tb, gpointer data );
void callback_number_n_plays_menu(GtkCheckMenuItem * menu, gpointer data );
void number_n_plays( gpointer data, gboolean setTb );
void callback_rndOrientation ( GtkAction * action, gpointer data );
void callback_problem2step ( GtkAction * action, gpointer data );
void callback_problemTraining ( GtkAction * action, gpointer data );
void callback_autoRefute ( GtkAction * action, gpointer data );
void callback_mousemode ( GtkRadioMenuItem * item, gpointer data );
void callback_mterri ( GtkAction * action, gpointer data );
void callback_step_2_option ( GtkAction * action, gpointer data );
void callback_transparent ( GtkAction * action, gpointer data );
void callback_manualOnly ( GtkAction * action, gpointer data );
void callback_tryLoad ( GtkAction * action, gpointer data );
void callback_bigTreeVariations ( GtkAction * action, gpointer data );
/* help */
void callback_help ( GtkAction * action, gpointer data );

/* buffer modified */
void callback_buffer_modified ( GtkAction * action, gpointer data );
void callback_note_modified ( GtkAction * action, gpointer data );

void OnceEverySecond ( gpointer data );

void callback_alphaTesting ( GtkAction * action, gpointer data );
void callback_test ( GtkAction * action, gpointer data );
void callback_mergeLoad ( GtkAction * action, gpointer data );
void callback_minimalLoad ( GtkAction * action, gpointer data );
void callback_omitEmptyNodes ( GtkAction * action, gpointer data );
void callback_set_bwinr ( GtkAction * action, gpointer data );
void callback_set_bwint ( GtkAction * action, gpointer data );
void callback_set_bwinf ( GtkAction * action, gpointer data );
void callback_set_wwinr ( GtkAction * action, gpointer data );
void callback_set_wwint ( GtkAction * action, gpointer data );
void callback_set_wwinf ( GtkAction * action, gpointer data );
void callback_set_void ( GtkAction * action, gpointer data );
void callback_set_unknown ( GtkAction * action, gpointer data );
void callback_set_estimate ( GtkAction * action, gpointer data );
void callback_playlist ( GtkRadioMenuItem * item, gpointer data );
void callback_refresh_playlist ( GtkAction * action, gpointer data );
void callback_thumb_playlist ( GtkAction * action, gpointer data );
void callback_index ( GtkAction * action, gpointer data );

/* data types */
typedef enum {
    GOBANSTONE_OFFBOARD = 0,
    GOBANSTONE_WHITE = 1,
    GOBANSTONE_BLACK = 2,
    GOBANSTONE_EMPTY = 3
} GobanStone; /* What is shown as stone or place of stone */


#endif
