/*
 * This file is part of goban770
 *
 * Copyright (C) 2006,2007 Jarmo Ahosola.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef GOBAN_H
#define GOBAN_H

/* Includes */
#include <gtk/gtk.h>
#include <ui/interface.h>
#include <glib.h> 

/* Definitions */
#define LOCATION2X(location) ((location)%(goban_h_goban_size)) 
#define LOCATION2Y(location) ((location)/(goban_h_goban_size))
#define AT_NORTH_EDGE(location) ((LOCATION2Y(location)) == 0)
#define AT_WEST_EDGE(location) ((LOCATION2X(location)) == 0)
#define AT_SOUTH_EDGE(location) ((LOCATION2Y(location)) == (goban_h_goban_size-1))
#define AT_EAST_EDGE(location) ((LOCATION2X(location)) == (goban_h_goban_size-1))
#define NORTH_OF(location) ((location) - (goban_h_goban_size))
#define SOUTH_OF(location) ((location) + (goban_h_goban_size))
#define WEST_OF(location) ((location) - 1)
#define EAST_OF(location) ((location) + 1)
#define MAX_GOBAN_SPACE ((MAX_GOBANSIZE)*(MAX_GOBANSIZE))
#define XY2LOCATION(x,y) ((x)+((y)*(goban_h_goban_size)))
#define MISSCLICKLIMIT 40

/* data types */
/*
typedef enum {
    GOBANSYMBOL_NO_SYMBOL = 0,
    GOBANSYMBOL_TRIANGLE,
    GOBANSYMBOL_CROSS,
    GOBANSYMBOL_SQUARE,
    GOBANSYMBOL_CIRCLE,
    GOBANSYMBOL_TEXT,
    GOBANSYMBOL_WHITE_TERRITORY,
    GOBANSYMBOL_BLACK_TERRITORY
} GobanSymbol; * What is shown on stone or place of stone *
*/

/* Functions */
gboolean IsOutofGoban(gint x, gint y, MainView* main);
gboolean IsValidClick(gint x, gint y, MainView* main);
gint GetClickedNumber(gint x, gint y, MainView* main, gint column);
gint viewx2gobanx(gint x, MainView* main );
gint viewy2gobany(gint y, MainView* main );
gint gobanx2viewx(gint x, MainView* main );
gint gobany2viewy(gint y, MainView* main );
Node * findStartOfNumbering( MainView* main );
gint setCurrentPosition( MainView* main );
gboolean HasLiberty(gint groupAt);
gint RemoveGroup(gint at, gboolean transparentCaptured);
gint CaptureNeighbours(gint at, gboolean transparentCaptured);
gint FindKo(gint at);
gboolean MakeMove(gint x, gint y, Stone color, MainView *main, gboolean transparentCaptured);
void InitGoban(gint size);
void SetPlayerInTurn(MainView* main);
gint XY2Location(gint x,gint y);
Stone GetStoneAt(gint at);
void SetStoneAt(gint at, Stone stone);
Stone GetStoneXY(gint x,gint y);
gint Location2X(gint at);
gint Location2Y(gint at);
void PlayMoves( Node * from, MainView * mainview, gboolean stopAtIllegal);
void CreateWhatIf( gint isX, gint isY, gint wereX, gint wereY, MainView * mainview);
gint RotateLocation(gint at, gint orientation);
void RotateGoban(MainView * main, gint orientation);
void RotateList(Pointlist * plist, gint orientation);
void RotateLabels(Labellist * llist, gint orientation);
void RotateNode(Node * node, gint orientation);
void SetTerritoryAtGroups(MainView * main);
void ClearTerritoryAtGroups(MainView * main);
gboolean IsNeighbour(gint at, Pointlist * list, Stone stone, Pointlist * deny);
/* gboolean IsNear(gint at, Pointlist * list); */
gint HowNear(gint at, Pointlist * list);
Pointlist * ExpandTerritory(Pointlist * expandable, Pointlist * mine, Pointlist * opponent);
void ExpandTerritories(Pointlist * first, Pointlist * second);
void PessimisticExpand(Node * node);
void MarkGroupDead(MainView * main, gint at);
void MarkGroupAlive(MainView * main, gint at);
void SwapGroupStatus(MainView * main, gint at);
void MarkDeadListedGroupsOfColor(MainView * main, Pointlist * lethalArea, Stone color);
void DragLabellist(Labellist * llist, gint offset, MainView * main);
void DragPointlist(Pointlist * plist, gint offset, MainView * main);
void DragArea(MainView * main);

#endif
