/*
 * This file is part of goban770
 *
 * Copyright (C) 2006,2007 Jarmo Ahosola.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef GAMETREE_H
#define GAMETREE_H

#include <gtk/gtk.h>
#include <ui/interface.h>
/* #include <hildon-widgets/hildon-program.h> */
/* #include <appdata.h> */

typedef enum {
    STONE_TRANSPARENT_BLACK = 0,
    STONE_BLACK = 1,
    STONE_NONE = 2,
    STONE_WHITE = 3,
    STONE_TRANSPARENT_WHITE = 4,
    STONE_MARKED_NONE = 5
} Stone;

#define OPPONENT(x) ((STONE_BLACK) + (STONE_WHITE) - (x))
/* #define IS_EMPTY(x) (TRUE) */
#define IS_EMPTY(x) (( ((x) == STONE_NONE) || ((x) == STONE_MARKED_NONE) || ((x) == STONE_TRANSPARENT_WHITE) || ((x) == STONE_TRANSPARENT_BLACK) )?TRUE:FALSE)
#define MAX_TREELEVELS 500
#define MAX_LABEL_LENGTH 3
#define BIG_TREE_LIMIT 100

/* Alternatives for played stone location */
#define AT_IS_PASS -1
#define AT_IS_SETUP -2
#define AT_IS_UNDEFINED -3

/* Struct to contain point of point list */
typedef struct _Pointlist Pointlist;
struct _Pointlist
{
	 Pointlist * next; /* NULL if last point in the list */
	 /* gint x; / * X-coordinate of the point */
	 /* gint y; / * Y-coordinate of the point */
	 gint at;
};

typedef struct _Labellist Labellist;
struct _Labellist
{
	 Labellist * next; /* NULL if last point in the list */
	 gint at;
	 gchar label[MAX_LABEL_LENGTH + 1]; /* label */
};

/* Struct to contain single node of game tree */
typedef struct _Node Node;
struct _Node
{
	 Node * parent; /* NULL if parent is root node */
	 Node * child; /* NULL if node is leaf node */
	 Node * sibling; /* Linked to self if no alternatives. Linked as loop. */
	 gint nodeHeight; /* 0 at main line. Used for drawing node at correct height at game tree. */
	 gint nodeTurnNumber; /* 1 for the first move of the game */
	 gint nodeDrawX; /* 1 for the first move of the game */
	 gint sgfVx2; /* Estimated score times 2 */
	 /* gint x; / * X-coordinate of stone played at the node */
	 /* gint y; / * Y-coordinate of stone played at the node */
	 gint at; /* location of played stone */
	 Stone stone; /* Color of played stone */
	 Pointlist * sgfMA; /* cross */
	 Pointlist * sgfTR; /* triangle, also sgfM would be read to here to convert old files */
	 Pointlist * sgfCR; /* circle */
	 Pointlist * sgfSQ; /* square */
	 Pointlist * sgfTB; /* black territory */
	 Pointlist * sgfTW; /* white territory */
	 Pointlist * sgfAB; /* black setup stones */
	 Pointlist * sgfAW; /* white setup stones */
	 Pointlist * sgfAE; /* removed setup stones */
	 Labellist * sgfLB; /* label */
	 gchar * sgfC; /* Comments assosiated to the node. NULL if no comments. */
	 GtkTextBuffer * unsupportedSgf; /* Sgf tags relating to the node that current version does not support. */
	 gboolean activeBranch; /* Branch selected at gametree if parent is also selected. */
	 gboolean underTheStones; /* When numbering stones the stone cannot be given number of current node because it's symbol space is reserved by stone earlier played at that location */
};

/* Publics: */
void GetTreeMeasures(gint * width, gint * height, gint * nodes, gint * leafs);
Pointlist * NewPoint(gint point);
Pointlist * AddPoint2List(gint at, Pointlist * list);
Pointlist * CopyList(Pointlist * list);
Labellist * NewLabel(gint point);
void DestroyPointlist(Pointlist * plist);
void DestroyLabellist(Labellist * llist);
Node * node_destroy(  Node * node );
void kill_family(  Node * node );
Node * NewNode( Node * parent, Stone stone, Node * bigSister, gint playAt, gint koAt );
/* Node * NewNode( Node * parent, gint x, gint y, Stone stone, Node * bigSister, gint playAt, gint koAt ); */
Node * node_new( Node * parent, gint x, gint y, Stone stone, Node * bigSister );
Node * back_in_tree( Node * current );
Node * forward_in_tree( Node * current, Node * childOfRoot );
Node * upper_branch_in_tree( Node * current );
Node * lower_branch_in_tree( Node * current );
Node * get_at_xy( Node * sister, gint x, gint y);
void set_active( Node * node );
Node * get_active( Node * node );
Node * get_bigsister( Node * node );
Node * AddNonmove2GameTree(Node * parent, Node * childOfRoot, gint nonstone, Stone color);
Node * AddMove2GameTree(Node * parent, Node * childOfRoot, gint x, gint y, Stone color, gint koAt);
gint GetTreeWidth();
gint GetTreeHeight();
void UpdateTreeDimensions(Node * node);
void MeasureTree(Node * node);
void MakeTreeLayout(Node * childOfRoot);
Node * GetNodeAt(Node * node, gint height, gint turn, gboolean fullTree);
/* Pointlist * NewPoint(gint point);
void DestroyPointlist(Pointlist * plist); */
void MoveBranchTo(Node * what,Node * where);
Node * LiftBranchUpwards(Node * node, gint height);
gboolean MoveStoneInHistory(Node * node,gint fromX,gint fromY,gint toX,gint toY);
void MovePoint(Pointlist * point, gint fromAt, gint toAt);
gboolean IsLabelInList(gint at, Labellist * llist);
gboolean IsPointInList(gint at, Pointlist * point);
Pointlist * RemovePoint(Pointlist * point, gint at);
void ResetActive( Node * firstChild );
Node * FindAncestorAtXY( Node * descendant , gint x, gint y);
void CircleLastPlayed(Node * node);
void RemoveCustomMarkings(Node * node);
Node * SelectBestLineOfPlay(Node * node, gint branchCount);
Node * RandomSibling(Node * oneOfThem);
gint CountLeafs(Node * subTreeRoot);
Stone GetGoodForColor(Node * position);
Node * RefutePlay(Node * play);
void ReNumberMovesOfTree(Node * node, gint moveNumber);
void MakePrunedLayout(Node * node, gint moveNumber);

#endif
