import os
import sys
import time
from PySide.QtCore import *
from PySide.QtGui import *
from PySide.QtMaemo5 import QMaemo5ValueButton, QMaemo5ListPickSelector

# Some global variables
GnGeoGuiVersion = "0.0.6-1"
CommentChar = '#'
OptionChar =  ' '
Home = os.path.expanduser("~")
GnGeo_CfgFile = Home + '/.gngeo/gngeorc'
GnGeoGui_CfgFile = Home + '/.gngeo-gui/gngeo-gui.cfg'
GnGeoGui_LogFile = Home + '/.gngeo-gui/gngeo-output.log'
P1buttons = ""
P2buttons = ""
P1joybuttons = ""
P2joybuttons = ""
P1hotbuttons0 = ""
P1hotbuttons1 = ""
P1hotbuttons2 = ""
P1hotbuttons3 = ""
P2hotbuttons0 = ""
P2hotbuttons1 = ""
P2hotbuttons2 = ""
P2hotbuttons3 = ""
quitbutton = ""
resetbutton = ""
savestatebutton = ""
loadstatebutton = ""
BiosPath = ""
RomrcPath = ""
RomPath = ""
ExecPath = ""

def parse_config(self, filename):
        options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if CommentChar in line:
                # split on comment char, keep only the part before
                line, comment = line.split(CommentChar, 1)
            # Second, find lines with an option=value:
            if OptionChar in line:
                 # split on option char:
                 option, value = line.split(OptionChar, 1)
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 options[option] = value
        f.close()
        return options


class Ui_MainWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self, None)
        self.setWindowTitle("GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
	'''
	Check for required files
	'''
        self.gui_opts = parse_config(self,GnGeoGui_CfgFile)
	if not "exec_path" in self.gui_opts:
		QMessageBox.critical(self, "Critical",  "exec_path not set in '" + GnGeoGui_CfgFile + "'")
    		sys.exit()
	if not os.path.isfile(self.gui_opts["exec_path"] + "/gngeo"):
		QMessageBox.critical(self, "Critical",  "'" + self.gui_opts["exec_path"] + "/gngeo' not found!")
        	widget = pathWindow(self)
		widget.show()
	try:
	        open(GnGeo_CfgFile ,"r")
	except:
		QMessageBox.critical(self, "Critical", "Config file '" + GnGeo_CfgFile + "' not readable!")
    		sys.exit()
	global AboutGnGeo
	VersionGnGeo = self.gui_opts["exec_path"] + "/gngeo --version" 
	fin,fout = os.popen4(VersionGnGeo)
	AboutGnGeo = fout.read()
	AboutGnGeo = "Using " + AboutGnGeo.replace('\n','<br>')
	# Load config
        self.options = parse_config(self,GnGeo_CfgFile)
	AllGnGeoOpts = [ "68kclock", "autoframeskip", "biospath", "country", "effect", "fullscreen", "hwsurface", 
	                 "interpolation", "joystick", "p1joy", "p1joydev", "p2key", "p2joy", "p2joydev", "p2key", "raster", 
	                 "romrcdir", "samplerate", "scale", "showfps", "sleepidle", "sound", "system", "z80clock", "quit_key",
	                 "reset_key", "load_state_key","save_state_key","p1hotkey0","p1hotkey1","p1hotkey2","p1hotkey3",
			 "p2hotkey0", "p2hotkey1","p2hotkey2","p2hotkey3" ]
	for GnGeoOpt in AllGnGeoOpts:
		try:
			 self.options[GnGeoOpt]
		except: 
			QMessageBox.critical(self, "Warning",  "Cannot find variable " + GnGeoOpt + " in " + GnGeo_CfgFile)
	myPaths = [ "rompath", "biospath", "romrcdir" ]
	for myPath in myPaths:
		if not os.path.isdir(self.options[myPath]):
			QMessageBox.critical(self, "Critical",  myPath + " '" + self.options[myPath] + "' not found!")
        		widget = pathWindow(self)
			widget.show()
	if not (os.path.exists(self.options["biospath"] + "/sfix.sfx")) \
	and not (os.path.exists(self.options["biospath"] + "/sfix.sfix")):
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + self.options["biospath"])
	if not os.path.exists(self.options["romrcdir"] + "/kof96.rc"):
		QMessageBox.critical(self, "Warning",  "Cannot find romrc files in " + self.options["romrcdir"])
	# Set background image
        backgroundLabel = QLabel(self)
        AboutTxt = "<img src=/opt/gngeo-gui/neogeo_background.png />" 
        backgroundLabel.setText(AboutTxt)
	backgroundLabel.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(backgroundLabel)
	# Get Gametitles from rompath
	ListCmd = self.gui_opts["exec_path"] + "/gngeo --scandir=" + self.options["rompath"] 
	fin,fout = os.popen4(ListCmd)
	romList = fout.read()
	romList = romList.replace('\n',':\n')
	romList = romList.split(':')
	# Remove header in romlist
	romList = romList[3:-1]
	if not romList:
		Games = "No roms found!"
	else:
		Games = ""
	Teller = 1
	GameFile = ""
	for Item in romList:
		if Item[0] != "\n":
			if Teller == 0:
				GameFile = GameFile + Item + ":"
				Teller = 1
			else:
				Games = Games + Item + ":"
				Teller = 0
	# Remove the last ":"
	Games = Games[:-1]
	GameFile = GameFile[:-1]
	Games = Games.split(":")
	self.GameFile = GameFile.split(":")
        self.combo = QComboBox(self)
        self.combo.setStyleSheet( \
	"QComboBox { color: gray; \
	 border: 6px solid #045FB4; \
	 border-radius: 3px; \
	 min-width: 6em; \
	 }" )
	self.combo.setGeometry(QRect(170, 230, 450, 60))
	for Game in Games:
        	self.combo.addItem(Game)

	self.combo.setEditable(True)
	self.combo.lineEdit().setAlignment(Qt.AlignCenter)  
	self.combo.lineEdit().setReadOnly(True)
	self.combo.lineEdit().setAlignment(Qt.AlignCenter)  
	for x in range(0,self.combo.count()):
		self.combo.setItemData(x, Qt.AlignCenter, Qt.TextAlignmentRole)
	self.combo.setEditable(False)


	# Define menubar
	aboutAction = QAction( '&About', self)
        aboutAction.triggered.connect(self.slotAbout)
	configAction = QAction( '&Config', self)
        configAction.triggered.connect(self.slotConfig)

        menubar = self.menuBar()
        fileMenu = menubar.addMenu('&MainMenu')
        fileMenu.addAction(configAction)
        fileMenu.addAction(aboutAction)

        self.startButton = QPushButton("Start",self)
        self.startButton.setGeometry(QRect(0, 370, 400, 55))
        font = QFont()
        font.setPointSize(24)
        self.startButton.setFont(font)
	QObject.connect(self.startButton
		, SIGNAL("clicked()")
		, self.on_start_clicked)

        self.onesmutePushButton = QPushButton("Mute",self)
	self.onesmutePushButton.setCheckable(True)
        self.onesmutePushButton.setGeometry(QRect(400, 370, 400, 55))
        self.onesmutePushButton.setFont(font)
	if self.options["sound"] == "true":
            self.onesmutePushButton.setChecked(False)
	else:
            self.onesmutePushButton.setChecked(True)

	self.logMsg = QLabel(self)
      	self.logMsg.setStyleSheet( \
	"QLabel { background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, \
         stop: 0 #bbb, stop: 0.1 #999, stop: 0.49 #444, stop: 0.5 #666, stop: 1 #444); \
         font-size: 20px; font-family: monospace; font-weight: bold;}" \
      	) 
	self.logMsg.setGeometry(0, 350, 800, 20)


    def on_start_clicked(self):
	gameNbr = self.combo.currentIndex()
	self.gameFile = self.GameFile[gameNbr]
	global MyTeller
	global regel

        if self.onesmutePushButton.isChecked():
		SOUND_OPT=" --no-sound "
        else:  SOUND_OPT=" --sound "

	if self.gameFile:
		QProcess.startDetached(self.gui_opts["exec_path"]+"/gngeo "+SOUND_OPT+self.options["rompath"]+'/'+self.gameFile)
		time.sleep(0.1)    # Sleep briefly
		file = open(GnGeoGui_LogFile,'r')
		self.MyTeller = 0
		def follow(thefile):
			    thefile.seek(0,1)      # Go to the end of the file
			    while True:
			         line = thefile.readline()
			         if not line:
				     self.MyTeller = self.MyTeller + 1
			             time.sleep(0.1)    # Sleep briefly
			             continue
			         yield line

		loglines = follow(file)
		for line in loglines:
		    if '\r' in line:
			line = line.strip('\n')
			line = line.replace('\r','\n')
			lines = line.split('\n')
			for subline in lines:
				regel = subline
				self.logMsg.setText(regel)
				# Keep the app responsive in this loop
				QCoreApplication.processEvents()
			#print >> sys.stderr,line
		    if (self.MyTeller > 90) or (self.MyTeller == 0) or ("Convert" in line):
			file.close()
			open(GnGeoGui_LogFile, 'w').close()
			break

	if (self.gui_opts["exit_after_launch"] == "true"):
		time.sleep(5)
		os._exit(0)

    def slotAbout(self):
        a = AboutWindow(self)
        a.show()

    def slotConfig(self):
        a = ConfigWindow(self)
        a.show()

    def slotJoyconf(self):
        a = JoyconfWindow(self)
        a.show()

class AboutWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("About GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.label = QLabel(self)
	AboutTxt = "<h3>Gngeo-gui " + GnGeoGuiVersion + "</h3><p>" \
                   "<img src=/opt/usr/share/icons/hicolor/64x64/apps/gngeo_gui.png /><br>" \
                   "GnGeo-gui is a Graphical User Interface for GnGeo<p> " \
                   "GnGeo emulates the NeoGeo gameconsole from SNK &#174;</p>" \
                   "<p>GnGeo-gui is written in PySide by <i>Arno Dekker</i> 2011-12<p>" %dict()
	AboutTxt = AboutTxt + AboutGnGeo
        self.label.setText(AboutTxt)
	self.label.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(self.label)

class ConfigWindow(QMainWindow):
    def __init__(self,parent):
        QMainWindow.__init__(self,parent)
        self.setWindowTitle("Configuration GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
	area = QScrollArea()
	lay = QVBoxLayout()
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	self.setCentralWidget(area)
	wg.resize(750,660);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
        self.options = parse_config(self,GnGeo_CfgFile)
        self.gui_opts = parse_config(self,GnGeoGui_CfgFile)
        font = QFont()
        font.setPointSize(20)
	self.setLayout(grid)
	# showfps
        self.showfpsPushButton = QPushButton("Showfps",self)
	self.showfpsPushButton.setCheckable(True)
        grid.addWidget(self.showfpsPushButton,1,1)
        self.showfpsPushButton.setFont(font)
	if self.options["showfps"] == "true":
            self.showfpsPushButton.setChecked(True)
	# fullscreen
        self.fullscreenPushButton = QPushButton("Fullscreen",self)
	self.fullscreenPushButton.setCheckable(True)
        grid.addWidget(self.fullscreenPushButton,1,2)
        self.fullscreenPushButton.setFont(font)
	if self.options["fullscreen"] == "true":
            self.fullscreenPushButton.setChecked(True)
	# sound
        self.soundPushButton = QPushButton("Sound",self)
	self.soundPushButton.setCheckable(True)
        grid.addWidget(self.soundPushButton,1,3)
        self.soundPushButton.setFont(font)
	if self.options["sound"] == "true":
            self.soundPushButton.setChecked(True)
	# autoframeskip
        self.autoframePushButton = QPushButton("Autoframeskip",self)
	self.autoframePushButton.setCheckable(True)
        grid.addWidget(self.autoframePushButton,2,1)
        self.autoframePushButton.setFont(font)
	if self.options["autoframeskip"] == "true":
            self.autoframePushButton.setChecked(True)
	# raster
        self.rasterPushButton = QPushButton("Raster",self)
	self.rasterPushButton.setCheckable(True)
        grid.addWidget(self.rasterPushButton,2,2)
        self.rasterPushButton.setFont(font)
	if self.options["raster"] == "true":
            self.rasterPushButton.setChecked(True)
	# interpolation
        self.interpolationPushButton = QPushButton("Interpolation",self)
	self.interpolationPushButton.setCheckable(True)
        grid.addWidget(self.interpolationPushButton,2,3)
        self.interpolationPushButton.setFont(font)
	if self.options["interpolation"] == "true":
            self.interpolationPushButton.setChecked(True)
	# sleepidle
        self.sleepidlePushButton = QPushButton("Sleepidle",self)
	self.sleepidlePushButton.setCheckable(True)
        grid.addWidget(self.sleepidlePushButton,3,1)
        self.sleepidlePushButton.setFont(font)
	if self.options["sleepidle"] == "true":
            self.sleepidlePushButton.setChecked(True)
	# hwsurface
        self.hwsurfacePushButton = QPushButton("Hwsurface",self)
	self.hwsurfacePushButton.setCheckable(True)
        grid.addWidget(self.hwsurfacePushButton,3,2)
        self.hwsurfacePushButton.setFont(font)
	if self.options["hwsurface"] == "true":
            self.hwsurfacePushButton.setChecked(True)
	# joystick
        self.joystickPushButton = QPushButton("Joystick",self)
	self.joystickPushButton.setCheckable(True)
        grid.addWidget(self.joystickPushButton,3,3)
        self.joystickPushButton.setFont(font)
	if self.options["joystick"] == "true":
		self.joystickPushButton.setChecked(True)
	# system
	self.systemButton = QMaemo5ValueButton("system")
        self.systemButton.setValueLayout(QMaemo5ValueButton.ValueUnderTextCentered)
	model = QStandardItemModel(0,0) # (rows, columns)
	systems = self.listDefaultFirst("system",['arcade','home','unibios'])
	for sysType in systems:
		if sysType == 'unibios':
			if os.path.exists(self.options["biospath"] + "/uni-bios.rom"):
				model.appendRow(QStandardItem("unibios"))
		else:
       		 	model.appendRow(QStandardItem(sysType))
	lps = QMaemo5ListPickSelector()
	lps.setModel(model)
	lps.setCurrentIndex(0)
        #and list selector to button
        self.systemButton.setPickSelector(lps)
        grid.addWidget(self.systemButton,4,1)

	# country
	self.regionButton = QMaemo5ValueButton("region")
        self.regionButton.setValueLayout(QMaemo5ValueButton.ValueUnderTextCentered)
	modelc = QStandardItemModel(0,0) # (rows, columns)
	countries = self.listDefaultFirst("country",['japan', 'usa', 'europe'])
	for Location in countries:
		modelc.appendRow(QStandardItem(Location))
	lpc = QMaemo5ListPickSelector()
	lpc.setModel(modelc)
	lpc.setCurrentIndex(0)
        self.regionButton.setPickSelector(lpc)
        grid.addWidget(self.regionButton,4,2)
	# effect
	self.effectButton = QMaemo5ValueButton("effect")
        self.effectButton.setValueLayout(QMaemo5ValueButton.ValueUnderTextCentered)
	modele = QStandardItemModel(0,0) # (rows, columns)
	effects = self.listDefaultFirst("effect",['none', 'scanline', 'scanline50', 'scale2x',
	                                          'scale3x', 'scale4x', 'scale2x50', 'scale2x75',
	                                          'hq2x', 'hq3x', 'lq2x', 'lq3x', 'doublex'])
	for effect in effects:
		modele.appendRow(QStandardItem(effect))
	lpe = QMaemo5ListPickSelector()
	lpe.setModel(modele)
	lpe.setCurrentIndex(0)
        self.effectButton.setPickSelector(lpe)
        grid.addWidget(self.effectButton,4,3)
	# Samplerate
	grid.addWidget(QLabel("<center>sound rate:</center>"), 5, 1)
        self.comboSampleRate = QComboBox(self)
        grid.addWidget(self.comboSampleRate,6,1)
	Sam_Rates = self.listDefaultFirst("samplerate",['8192','11025','22050','32000','44100','48000'])
	for SampRate in Sam_Rates:
		self.comboSampleRate.addItem(SampRate)
	# Z80 CPU clock
	grid.addWidget(QLabel("<center>Z80 CPU clock:</center>"), 5, 2)
	self.Z80SpinBox = QDoubleSpinBox()
	self.Z80SpinBox.setRange(-80,80)
	self.Z80SpinBox.setAlignment(Qt.AlignCenter)
	self.Z80SpinBox.setValue(float(self.options["z80clock"]))
	self.Z80SpinBox.setDecimals(0)
	self.Z80SpinBox.setSuffix(" %")
	grid.addWidget(self.Z80SpinBox, 6,2)
	# 68K CPU clock
	grid.addWidget(QLabel("<center>68K CPU clock:</center>"), 5, 3)
	self.M68KSpinBox = QDoubleSpinBox()
	self.M68KSpinBox.setRange(-80,80)
	self.M68KSpinBox.setAlignment(Qt.AlignCenter)
	self.M68KSpinBox.setValue(float(self.options["68kclock"]))
	self.M68KSpinBox.setDecimals(0)
	self.M68KSpinBox.setSuffix(" %")
	grid.addWidget(self.M68KSpinBox, 6,3)
	# Joystick device P1 (/dev/input/js?)
	self.joyp1devButton = QMaemo5ValueButton("P1 joystick device")
        self.joyp1devButton.setValueLayout(QMaemo5ValueButton.ValueUnderTextCentered)
	modelp1dev = QStandardItemModel(0,0) # (rows, columns)
	JoyP1devs = self.listDefaultFirst("p1joydev",['0', '1', '2', '3'])
	for JoyP1dev in JoyP1devs:
		modelp1dev.appendRow(QStandardItem(JoyP1dev))
	lpjp1 = QMaemo5ListPickSelector()
	lpjp1.setModel(modelp1dev)
	lpjp1.setCurrentIndex(0)
        self.joyp1devButton.setPickSelector(lpjp1)
        grid.addWidget(self.joyp1devButton,7,1)
	# Joystick device P2 (/dev/input/js?)
	self.joyp2devButton = QMaemo5ValueButton("P2 joystick device")
        self.joyp2devButton.setValueLayout(QMaemo5ValueButton.ValueUnderTextCentered)
	modelp2dev = QStandardItemModel(0,0) # (rows, columns)
	JoyP2devs = self.listDefaultFirst("p2joydev",['0', '1', '2', '3'])
	for JoyP2dev in JoyP2devs:
		modelp2dev.appendRow(QStandardItem(JoyP2dev))
	lpjp2 = QMaemo5ListPickSelector()
	lpjp2.setModel(modelp2dev)
	lpjp2.setCurrentIndex(0)
        self.joyp2devButton.setPickSelector(lpjp2)
        grid.addWidget(self.joyp2devButton,7,2)
        # Exit on start button
        self.exitPushButton = QPushButton("exit after start game",self)
	self.exitPushButton.setCheckable(True)
        grid.addWidget(self.exitPushButton,7,3)
	if self.gui_opts["exit_after_launch"] == "true":
		self.exitPushButton.setChecked(True)
	# Path button
        self.pathButton = QPushButton("paths def",self)
        self.pathButton.setFont(font)
        grid.addWidget(self.pathButton,8,1)
	QObject.connect(self.pathButton
		, SIGNAL("clicked()")
		, self.on_paths_clicked)
	# Keys button
        self.keysButton = QPushButton("key def",self)
        self.keysButton.setFont(font)
        grid.addWidget(self.keysButton,8,2)
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_keys_clicked)
	# Joystick config
        self.joyconfButton = QPushButton("joystick def",self)
        self.joyconfButton.setFont(font)
        grid.addWidget(self.joyconfButton,8,3)
	QObject.connect(self.joyconfButton
		, SIGNAL("clicked()")
		, self.on_defjoy_clicked)
	# hotkey config
        self.hotkeyButton = QPushButton("hotkey def",self)
        self.hotkeyButton.setFont(font)
        grid.addWidget(self.hotkeyButton,9,1)
	QObject.connect(self.hotkeyButton
		, SIGNAL("clicked()")
		, self.on_hotkeys_clicked)
	# Save button
        self.saveButton = QPushButton("SAVE",self)
        self.saveButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
        self.saveButton.setFont(font)
        grid.addWidget(self.saveButton,10,1,1,3)
	QObject.connect(self.saveButton
		, SIGNAL("clicked()")
		, self.on_save_clicked)


    def on_save_clicked(self):
        if self.soundPushButton.isChecked():
           self.options["sound"] = "true"
        else: self.options["sound"] = "false" 
        if self.showfpsPushButton.isChecked():
           self.options["showfps"] = "true"
        else: self.options["showfps"] = "false" 
        if self.fullscreenPushButton.isChecked():
           self.options["fullscreen"] = "true"
        else: self.options["fullscreen"] = "false" 
        if self.autoframePushButton.isChecked():
           self.options["autoframeskip"] = "true"
        else: self.options["autoframeskip"] = "false" 
        if self.rasterPushButton.isChecked():
           self.options["raster"] = "true"
        else: self.options["raster"] = "false" 
        if self.interpolationPushButton.isChecked():
           self.options["interpolation"] = "true"
        else: self.options["interpolation"] = "false" 
        if self.sleepidlePushButton.isChecked():
           self.options["sleepidle"] = "true"
        else: self.options["sleepidle"] = "false" 
        if self.hwsurfacePushButton.isChecked():
           self.options["hwsurface"] = "true"
        else: self.options["hwsurface"] = "false" 
        if self.joystickPushButton.isChecked():
           self.options["joystick"] = "true"
        else: self.options["joystick"] = "false" 
        if self.exitPushButton.isChecked():
           doExit = "true"
        else: doExit = "false" 
	self.options["68kclock"] = "%.0f" % self.M68KSpinBox.value()
	self.options["z80clock"] = "%.0f" % self.Z80SpinBox.value()
	self.options["system"] = self.systemButton.valueText()
	self.options["country"] = self.regionButton.valueText()
	self.options["effect"] = self.effectButton.valueText()
	self.options["samplerate"] = self.comboSampleRate.currentText()
	self.options["p1joydev"] = self.joyp1devButton.valueText()
	self.options["p2joydev"] = self.joyp2devButton.valueText()
	if BiosPath != "":
		self.options["biospath"] = BiosPath
	if RomrcPath != "":
		self.options["romrcdir"] = RomrcPath
	if RomPath != "":
		self.options["rompath"] = RomPath
	if quitbutton != "":
		self.options["quit_key"] = quitbutton
	if resetbutton != "":
		self.options["reset_key"] = resetbutton
	if savestatebutton != "":
		self.options["save_state_key"] = savestatebutton
	if loadstatebutton != "":
		self.options["load_state_key"] = loadstatebutton
	if P1buttons != "":
		tot_sleutel=""
		for sleutel in P1buttons:
			tot_sleutel = tot_sleutel + str(sleutel) + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1key"] = tot_sleutel

	if P2buttons != "":
		tot_sleutel=""
		for sleutel in P2buttons:
			tot_sleutel = tot_sleutel + str(sleutel) + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2key"] = tot_sleutel

	if P1joybuttons != "":
		tot_sleutel=""
		for sleutel in P1joybuttons:
			tot_sleutel = tot_sleutel + str(sleutel) + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1joy"] = tot_sleutel

	if P2joybuttons != "":
		tot_sleutel=""
		for sleutel in P2joybuttons:
			tot_sleutel = tot_sleutel + str(sleutel) + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2joy"] = tot_sleutel

	if P1hotbuttons0 != "":
		tot_sleutel=""
		for sleutel in P1hotbuttons0:
			if sleutel != "":
				tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1hotkey0"] = tot_sleutel
	if P1hotbuttons1 != "":
		tot_sleutel=""
		for sleutel in P1hotbuttons1:
			if sleutel != "":
				tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1hotkey1"] = tot_sleutel
	if P1hotbuttons2 != "":
		tot_sleutel=""
		for sleutel in P1hotbuttons2:
			if sleutel != "":
				tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1hotkey2"] = tot_sleutel
	if P1hotbuttons3 != "":
		tot_sleutel=""
		for sleutel in P1hotbuttons3:
			if sleutel != "":
				tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1hotkey3"] = tot_sleutel

	if P2hotbuttons0 != "":
		tot_sleutel=""
		for sleutel in P2hotbuttons0:
			if sleutel != "":
				tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2hotkey0"] = tot_sleutel
	if P2hotbuttons1 != "":
		tot_sleutel=""
		for sleutel in P2hotbuttons1:
			if sleutel != "":
				tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2hotkey1"] = tot_sleutel
	if P2hotbuttons2 != "":
		tot_sleutel=""
		for sleutel in P2hotbuttons2:
			if sleutel != "":
				tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2hotkey2"] = tot_sleutel
	if P2hotbuttons3 != "":
		tot_sleutel=""
		for sleutel in P2hotbuttons3:
			if sleutel != "":
				tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2hotkey3"] = tot_sleutel

	if (ExecPath != "") or ((doExit == "true") and (self.gui_opts["exit_after_launch"] == "false")) or ((doExit == "false") and (self.gui_opts["exit_after_launch"] == "true")):
		# Change in gngeo-gui config, we need to save it
		try:
			ConfigFile = open(GnGeoGui_CfgFile,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GnGeoGui_CfgFile)
		else:
			ConfigFile.write("# Generated by gngeo-gui\n")
			if ExecPath != "":
				ConfigFile.write("exec_path" + " " + ExecPath + "\n")
			else:
				ConfigFile.write("exec_path" + " " + self.gui_opts["exec_path"] + "\n")
			ConfigFile.write("exit_after_launch" + " " + doExit + "\n")
			ConfigFile.close()

        orgConfigFile = open(GnGeo_CfgFile,"r")
	try:
	        copyFile = open(GnGeo_CfgFile + ".old" ,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + GnGeo_CfgFile + ".old")
	else:
		for line in orgConfigFile.readlines():
			copyFile.write(line)
		orgConfigFile.close()
		copyFile.close()
		try:
			newConfigFile = open(GnGeo_CfgFile,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GnGeo_CfgFile)
		else:
			newConfigFile.write("# Generated by gngeo-gui\n")
			for option in self.options:
				newConfigFile.write(option + " " + self.options[option] + "\n")
			newConfigFile.close()
			os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
			           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
			           string:"Configuration is succesfully saved"')

    def listDefaultFirst(self, optVal,List):
	Position = List.index(self.options[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def on_keys_clicked(self):
        widget = keyWindow(self)
        widget.show()

    def on_hotkeys_clicked(self):
        widget = hotkeyWindow(self)
        widget.show()

    def on_paths_clicked(self):
        widget = pathWindow(self)
        widget.show()
	
    def on_defjoy_clicked(self):
        widget = JoykeyWindow(self)
        widget.show()

class keyWindow(QDialog):
    def __init__(self, parent=None):
        super(keyWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui button config")
	# order : A,B,C,D,START,COIN,UP,DOWN,LEFT,RIGHT[,HOTKEY0,HOTKEY1]
       	self.options = parse_config(self,GnGeo_CfgFile)
	
	try:
		self.P1Resetkey=self.options["reset_key"]
	except:
		self.P1Resetkey=114 # 'r'
	try:
		self.P1Exitkey=self.options["quit_key"]
	except:
		self.P1Exitkey=113 # 'q'
	try:
		self.P1Savestatekey=self.options["save_state_key"]
	except:
		self.P1Savestatekey=115 # 's'
	try:
		self.P1Loadstatekey=self.options["load_state_key"]
	except:
		self.P1Loadstatekey=108 # 'l'
	if P1buttons == "":
		self.P1Keys=self.options["p1key"].split(",")
	else:
		self.P1Keys = P1buttons
	if P2buttons == "":
		self.P2Keys=self.options["p2key"].split(",")
	else:
		self.P2Keys = P2buttons
	# P1 keys
	P1Akey=self.P1Keys[0]
	P1Bkey=self.P1Keys[1]
	P1Ckey=self.P1Keys[2]
	P1Dkey=self.P1Keys[3]
	P1Startkey=self.P1Keys[4]
	P1Coinkey=self.P1Keys[5]
	P1Upkey=self.P1Keys[6]
	P1Downkey=self.P1Keys[7]
	P1Leftkey=self.P1Keys[8]
	P1Rightkey=self.P1Keys[9]
	# if hotkeys are not defined:
	if len(self.P1Keys) < 11:
		self.P1Keys.append(-1)
	P1hotkey0=self.P1Keys[10]
	if len(self.P1Keys) < 12:
		self.P1Keys.append(-1)
	P1hotkey1=self.P1Keys[11]
	if len(self.P1Keys) < 13:
		self.P1Keys.append(-1)
	P1hotkey2=self.P1Keys[12]
	if len(self.P1Keys) < 14:
		self.P1Keys.append(-1)
	P1hotkey3=self.P1Keys[13]
	# P2 keys
	P2Akey=self.P2Keys[0]
	P2Bkey=self.P2Keys[1]
	P2Ckey=self.P2Keys[2]
	P2Dkey=self.P2Keys[3]
	P2Startkey=self.P2Keys[4]
	P2Coinkey=self.P2Keys[5]
	P2Upkey=self.P2Keys[6]
	P2Downkey=self.P2Keys[7]
	P2Leftkey=self.P2Keys[8]
	P2Rightkey=self.P2Keys[9]
	if len(self.P2Keys) < 11:
		self.P2Keys.append(-1)
	P2hotkey0=self.P2Keys[10]
	if len(self.P2Keys) < 12:
		self.P2Keys.append(-1)
	P2hotkey1=self.P2Keys[11]
	if len(self.P2Keys) < 13:
		self.P2Keys.append(-1)
	P2hotkey2=self.P2Keys[12]
	if len(self.P2Keys) < 14:
		self.P2Keys.append(-1)
	P2hotkey3=self.P2Keys[13]
	# Layout
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.resize(750,1500);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	minKeyValue=1
	maxKeyValue=307
	grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
	grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
	grid.addWidget(QLabel("<center>PLAYER 2</center>"), 1, 3)
	grid.addWidget(QLabel("<center>[pick]</center>"), 1, 4)
	# Add button list
        cntr=2
	for pButton in ['A','B','C','D','START','COIN','UP','DOWN','LEFT','RIGHT','HOTKEY0','HOTKEY1','HOTKEY2','HOTKEY3','RESET','EXIT','SAVEST.','LOADST.']:
		grid.addWidget(QLabel(pButton), cntr, 0)
		cntr=cntr+1
	# A-button P1
	self.P1AkeySpinBox = QDoubleSpinBox()
	self.P1AkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1AkeySpinBox.setValue(float(P1Akey))
	self.P1AkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1AkeySpinBox, 2, 1)
	self.P1AButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1AButton, 2, 2)
	# A-button P2
	self.P2AkeySpinBox = QDoubleSpinBox()
	self.P2AkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2AkeySpinBox.setValue(float(P2Akey))
	self.P2AkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2AkeySpinBox, 2, 3)
	self.P2AButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2AButton, 2, 4)
	# B-button P1
	self.P1BkeySpinBox = QDoubleSpinBox()
	self.P1BkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1BkeySpinBox.setValue(float(P1Bkey))
	self.P1BkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1BkeySpinBox, 3, 1)
	self.P1BButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1BButton, 3, 2)
	# B-button P2
	self.P2BkeySpinBox = QDoubleSpinBox()
	self.P2BkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2BkeySpinBox.setValue(float(P2Bkey))
	self.P2BkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2BkeySpinBox, 3, 3)
	self.P2BButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2BButton, 3, 4)
	# C-button P1
	self.P1CkeySpinBox = QDoubleSpinBox()
	self.P1CkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CkeySpinBox.setValue(float(P1Ckey))
	self.P1CkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CkeySpinBox, 4, 1)
	self.P1CButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1CButton, 4, 2)
	# C-button P2
	self.P2CkeySpinBox = QDoubleSpinBox()
	self.P2CkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CkeySpinBox.setValue(float(P2Ckey))
	self.P2CkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CkeySpinBox, 4, 3)
	self.P2CButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2CButton, 4, 4)
	# D-button P1
	self.P1DkeySpinBox = QDoubleSpinBox()
	self.P1DkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DkeySpinBox.setValue(float(P1Dkey))
	self.P1DkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DkeySpinBox, 5, 1)
	self.P1DButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1DButton, 5, 2)
	# D-button P2
	self.P2DkeySpinBox = QDoubleSpinBox()
	self.P2DkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DkeySpinBox.setValue(float(P2Dkey))
	self.P2DkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DkeySpinBox, 5, 3)
	self.P2DButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2DButton, 5, 4)
	# Start-button P1
	self.P1StartkeySpinBox = QDoubleSpinBox()
	self.P1StartkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1StartkeySpinBox.setValue(float(P1Startkey))
	self.P1StartkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1StartkeySpinBox, 6, 1)
	self.P1StartButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1StartButton, 6, 2)
	# Start-button P2
	self.P2StartkeySpinBox = QDoubleSpinBox()
	self.P2StartkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2StartkeySpinBox.setValue(float(P2Startkey))
	self.P2StartkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2StartkeySpinBox, 6, 3)
	self.P2StartButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2StartButton, 6, 4)
	# Coin-button P1
	self.P1CoinkeySpinBox = QDoubleSpinBox()
	self.P1CoinkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CoinkeySpinBox.setValue(float(P1Coinkey))
	self.P1CoinkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CoinkeySpinBox, 7, 1)
	self.P1CoinButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1CoinButton, 7, 2)
	# Coin-button P2
	self.P2CoinkeySpinBox = QDoubleSpinBox()
	self.P2CoinkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CoinkeySpinBox.setValue(float(P2Coinkey))
	self.P2CoinkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CoinkeySpinBox, 7, 3)
	self.P2CoinButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2CoinButton, 7, 4)
	# Up-key P1
	self.P1UpkeySpinBox = QDoubleSpinBox()
	self.P1UpkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1UpkeySpinBox.setValue(float(P1Upkey))
	self.P1UpkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1UpkeySpinBox, 8, 1)
	self.P1UpButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1UpButton, 8, 2)
	# Up-key P2
	self.P2UpkeySpinBox = QDoubleSpinBox()
	self.P2UpkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2UpkeySpinBox.setValue(float(P2Upkey))
	self.P2UpkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2UpkeySpinBox, 8, 3)
	self.P2UpButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2UpButton, 8, 4)
	# Down-key P1
	self.P1DownkeySpinBox = QDoubleSpinBox()
	self.P1DownkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DownkeySpinBox.setValue(float(P1Downkey))
	self.P1DownkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DownkeySpinBox, 9, 1)
	self.P1DownButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1DownButton, 9, 2)
	# Down-key P2
	self.P2DownkeySpinBox = QDoubleSpinBox()
	self.P2DownkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DownkeySpinBox.setValue(float(P2Downkey))
	self.P2DownkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DownkeySpinBox, 9, 3)
	self.P2DownButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2DownButton, 9, 4)
	# Left-key P1
	self.P1LeftkeySpinBox = QDoubleSpinBox()
	self.P1LeftkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1LeftkeySpinBox.setValue(float(P1Leftkey))
	self.P1LeftkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1LeftkeySpinBox, 10, 1)
	self.P1LeftButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1LeftButton, 10, 2)
	# Left-key P2
	self.P2LeftkeySpinBox = QDoubleSpinBox()
	self.P2LeftkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2LeftkeySpinBox.setValue(float(P2Leftkey))
	self.P2LeftkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2LeftkeySpinBox, 10, 3)
	self.P2LeftButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2LeftButton, 10, 4)
	# Right-key P1
	self.P1RightkeySpinBox = QDoubleSpinBox()
	self.P1RightkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1RightkeySpinBox.setValue(float(P1Rightkey))
	self.P1RightkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1RightkeySpinBox, 11, 1)
	self.P1RightButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1RightButton, 11, 2)
	# Right-key P2
	self.P2RightkeySpinBox = QDoubleSpinBox()
	self.P2RightkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2RightkeySpinBox.setValue(float(P2Rightkey))
	self.P2RightkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2RightkeySpinBox, 11, 3)
	self.P2RightButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2RightButton, 11, 4)
	# Hot-key0 P1
	self.P1Hotkey0SpinBox = QDoubleSpinBox()
	self.P1Hotkey0SpinBox.setRange(-1, maxKeyValue)
	self.P1Hotkey0SpinBox.setValue(float(P1hotkey0))
	self.P1Hotkey0SpinBox.setDecimals(0)
	grid.addWidget(self.P1Hotkey0SpinBox, 12, 1)
	self.P1Hotkey0Button = MyKeyPressed("key",self)
	grid.addWidget(self.P1Hotkey0Button, 12, 2)
	# Hot-key1 P1
	self.P1Hotkey1SpinBox = QDoubleSpinBox()
	self.P1Hotkey1SpinBox.setRange(-1, maxKeyValue)
	self.P1Hotkey1SpinBox.setValue(float(P1hotkey1))
	self.P1Hotkey1SpinBox.setDecimals(0)
	grid.addWidget(self.P1Hotkey1SpinBox, 13, 1)
	self.P1Hotkey1Button = MyKeyPressed("key",self)
	grid.addWidget(self.P1Hotkey1Button, 13, 2)
	# Hot-key2 P1
	self.P1Hotkey2SpinBox = QDoubleSpinBox()
	self.P1Hotkey2SpinBox.setRange(-1, maxKeyValue)
	self.P1Hotkey2SpinBox.setValue(float(P1hotkey2))
	self.P1Hotkey2SpinBox.setDecimals(0)
	grid.addWidget(self.P1Hotkey2SpinBox, 14, 1)
	self.P1Hotkey2Button = MyKeyPressed("key",self)
	grid.addWidget(self.P1Hotkey2Button, 14, 2)
	# Hot-key3 P1
	self.P1Hotkey3SpinBox = QDoubleSpinBox()
	self.P1Hotkey3SpinBox.setRange(-1, maxKeyValue)
	self.P1Hotkey3SpinBox.setValue(float(P1hotkey3))
	self.P1Hotkey3SpinBox.setDecimals(0)
	grid.addWidget(self.P1Hotkey3SpinBox, 15, 1)
	self.P1Hotkey3Button = MyKeyPressed("key",self)
	grid.addWidget(self.P1Hotkey3Button, 15, 2)
	# Hot-key0 P2
	self.P2Hotkey0SpinBox = QDoubleSpinBox()
	self.P2Hotkey0SpinBox.setRange(-1, maxKeyValue)
	self.P2Hotkey0SpinBox.setValue(float(P2hotkey0))
	self.P2Hotkey0SpinBox.setDecimals(0)
	grid.addWidget(self.P2Hotkey0SpinBox, 12, 3)
	self.P2Hotkey0Button = MyKeyPressed("key",self)
	grid.addWidget(self.P2Hotkey0Button, 12, 4)
	# Hot-key1 P2
	self.P2Hotkey1SpinBox = QDoubleSpinBox()
	self.P2Hotkey1SpinBox.setRange(-1, maxKeyValue)
	self.P2Hotkey1SpinBox.setValue(float(P2hotkey1))
	self.P2Hotkey1SpinBox.setDecimals(0)
	grid.addWidget(self.P2Hotkey1SpinBox, 13, 3)
	self.P2Hotkey1Button = MyKeyPressed("key",self)
	grid.addWidget(self.P2Hotkey1Button, 13, 4)
	# Hot-key2 P2
	self.P2Hotkey2SpinBox = QDoubleSpinBox()
	self.P2Hotkey2SpinBox.setRange(-1, maxKeyValue)
	self.P2Hotkey2SpinBox.setValue(float(P2hotkey2))
	self.P2Hotkey2SpinBox.setDecimals(0)
	grid.addWidget(self.P2Hotkey2SpinBox, 14, 3)
	self.P2Hotkey2Button = MyKeyPressed("key",self)
	grid.addWidget(self.P2Hotkey2Button, 14, 4)
	# Hot-key3 P2
	self.P2Hotkey3SpinBox = QDoubleSpinBox()
	self.P2Hotkey3SpinBox.setRange(-1, maxKeyValue)
	self.P2Hotkey3SpinBox.setValue(float(P2hotkey3))
	self.P2Hotkey3SpinBox.setDecimals(0)
	grid.addWidget(self.P2Hotkey3SpinBox, 15, 3)
	self.P2Hotkey3Button = MyKeyPressed("key",self)
	grid.addWidget(self.P2Hotkey3Button, 15, 4)
	# Reset-key
	self.P1ResetkeySpinBox = QDoubleSpinBox()
	self.P1ResetkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1ResetkeySpinBox.setValue(float(self.P1Resetkey))
	self.P1ResetkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1ResetkeySpinBox, 16, 1)
	self.P1ResetButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1ResetButton, 16, 2)
	# Exit-key
	self.P1ExitkeySpinBox = QDoubleSpinBox()
	self.P1ExitkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1ExitkeySpinBox.setValue(float(self.P1Exitkey))
	self.P1ExitkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1ExitkeySpinBox, 17, 1)
	self.P1ExitButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1ExitButton, 17, 2)
	# Savestate-key
	self.P1SavestatekeySpinBox = QDoubleSpinBox()
	self.P1SavestatekeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1SavestatekeySpinBox.setValue(float(self.P1Savestatekey))
	self.P1SavestatekeySpinBox.setDecimals(0)
	grid.addWidget(self.P1SavestatekeySpinBox, 18, 1)
	self.P1SavestateButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1SavestateButton, 18, 2)
	# Loadstate-key
	self.P1LoadstatekeySpinBox = QDoubleSpinBox()
	self.P1LoadstatekeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1LoadstatekeySpinBox.setValue(float(self.P1Loadstatekey))
	self.P1LoadstatekeySpinBox.setDecimals(0)
	grid.addWidget(self.P1LoadstatekeySpinBox, 19, 1)
	self.P1LoadstateButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1LoadstateButton, 19, 2)

	self.setLayout(grid)
        os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
                   /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
                   string:"Set hotkeys to -1 to disable them"')
	# P1
	self.connect(self.P1AkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1BkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1CkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1DkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1StartkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1CoinkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1ResetkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1ExitkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1Hotkey0SpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1Hotkey1SpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1Hotkey2SpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1Hotkey3SpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1SavestatekeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1LoadstatekeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1RightButton, SIGNAL("keyPressed"),self.P1updateRight)
        self.connect(self.P1LeftButton, SIGNAL("keyPressed"),self.P1updateLeft)
        self.connect(self.P1DownButton, SIGNAL("keyPressed"),self.P1updateDown)
        self.connect(self.P1UpButton, SIGNAL("keyPressed"),self.P1updateUp)
        self.connect(self.P1CoinButton, SIGNAL("keyPressed"),self.P1updateCoin)
        self.connect(self.P1StartButton, SIGNAL("keyPressed"),self.P1updateStart)
        self.connect(self.P1AButton, SIGNAL("keyPressed"),self.P1updateA)
        self.connect(self.P1BButton, SIGNAL("keyPressed"),self.P1updateB)
        self.connect(self.P1CButton, SIGNAL("keyPressed"),self.P1updateC)
        self.connect(self.P1DButton, SIGNAL("keyPressed"),self.P1updateD)
        self.connect(self.P1DButton, SIGNAL("keyPressed"),self.P1updateD)
        self.connect(self.P1Hotkey0Button, SIGNAL("keyPressed"),self.P1updateHotkey0)
        self.connect(self.P1Hotkey1Button, SIGNAL("keyPressed"),self.P1updateHotkey1)
        self.connect(self.P1Hotkey2Button, SIGNAL("keyPressed"),self.P1updateHotkey2)
        self.connect(self.P1Hotkey3Button, SIGNAL("keyPressed"),self.P1updateHotkey3)
        self.connect(self.P1ResetButton, SIGNAL("keyPressed"),self.P1updateReset)
        self.connect(self.P1ExitButton, SIGNAL("keyPressed"),self.P1updateExit)
        self.connect(self.P1SavestateButton, SIGNAL("keyPressed"),self.P1updateSavestate)
        self.connect(self.P1LoadstateButton, SIGNAL("keyPressed"),self.P1updateLoadstate)
	# P2
	self.connect(self.P2AkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2BkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2CkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2DkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2StartkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2CoinkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2Hotkey0SpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2Hotkey1SpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2Hotkey2SpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2Hotkey3SpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P2RightButton, SIGNAL("keyPressed"),self.P2updateRight)
        self.connect(self.P2LeftButton, SIGNAL("keyPressed"),self.P2updateLeft)
        self.connect(self.P2DownButton, SIGNAL("keyPressed"),self.P2updateDown)
        self.connect(self.P2UpButton, SIGNAL("keyPressed"),self.P2updateUp)
        self.connect(self.P2CoinButton, SIGNAL("keyPressed"),self.P2updateCoin)
        self.connect(self.P2StartButton, SIGNAL("keyPressed"),self.P2updateStart)
        self.connect(self.P2AButton, SIGNAL("keyPressed"),self.P2updateA)
        self.connect(self.P2BButton, SIGNAL("keyPressed"),self.P2updateB)
        self.connect(self.P2CButton, SIGNAL("keyPressed"),self.P2updateC)
        self.connect(self.P2DButton, SIGNAL("keyPressed"),self.P2updateD)
        self.connect(self.P2Hotkey0Button, SIGNAL("keyPressed"),self.P2updateHotkey0)
        self.connect(self.P2Hotkey1Button, SIGNAL("keyPressed"),self.P2updateHotkey1)
        self.connect(self.P2Hotkey2Button, SIGNAL("keyPressed"),self.P2updateHotkey2)
        self.connect(self.P2Hotkey3Button, SIGNAL("keyPressed"),self.P2updateHotkey3)

	# P1
    def P1updateRight(self):
	self.P1RightkeySpinBox.setValue(float(AsciiVal))
    def P1updateLeft(self):
	self.P1LeftkeySpinBox.setValue(float(AsciiVal))
    def P1updateUp(self):
	self.P1UpkeySpinBox.setValue(float(AsciiVal))
    def P1updateDown(self):
	self.P1DownkeySpinBox.setValue(float(AsciiVal))
    def P1updateStart(self):
	self.P1StartkeySpinBox.setValue(float(AsciiVal))
    def P1updateCoin(self):
	self.P1CoinkeySpinBox.setValue(float(AsciiVal))
    def P1updateA(self):
	self.P1AkeySpinBox.setValue(float(AsciiVal))
    def P1updateB(self):
	self.P1BkeySpinBox.setValue(float(AsciiVal))
    def P1updateC(self):
	self.P1CkeySpinBox.setValue(float(AsciiVal))
    def P1updateD(self):
	self.P1DkeySpinBox.setValue(float(AsciiVal))
    def P1updateReset(self):
	self.P1ResetkeySpinBox.setValue(float(AsciiVal))
    def P1updateExit(self):
	self.P1ExitkeySpinBox.setValue(float(AsciiVal))
    def P1updateSavestate(self):
	self.P1SavestatekeySpinBox.setValue(float(AsciiVal))
    def P1updateLoadstate(self):
	self.P1LoadstatekeySpinBox.setValue(float(AsciiVal))
    def P1updateHotkey0(self):
	self.P1Hotkey0SpinBox.setValue(float(AsciiVal))
    def P1updateHotkey1(self):
	self.P1Hotkey1SpinBox.setValue(float(AsciiVal))
    def P1updateHotkey2(self):
	self.P1Hotkey2SpinBox.setValue(float(AsciiVal))
    def P1updateHotkey3(self):
	self.P1Hotkey3SpinBox.setValue(float(AsciiVal))
	# P2
    def P2updateRight(self):
	self.P2RightkeySpinBox.setValue(float(AsciiVal))
    def P2updateLeft(self):
	self.P2LeftkeySpinBox.setValue(float(AsciiVal))
    def P2updateUp(self):
	self.P2UpkeySpinBox.setValue(float(AsciiVal))
    def P2updateDown(self):
	self.P2DownkeySpinBox.setValue(float(AsciiVal))
    def P2updateStart(self):
	self.P2StartkeySpinBox.setValue(float(AsciiVal))
    def P2updateCoin(self):
	self.P2CoinkeySpinBox.setValue(float(AsciiVal))
    def P2updateA(self):
	self.P2AkeySpinBox.setValue(float(AsciiVal))
    def P2updateB(self):
	self.P2BkeySpinBox.setValue(float(AsciiVal))
    def P2updateC(self):
	self.P2CkeySpinBox.setValue(float(AsciiVal))
    def P2updateD(self):
	self.P2DkeySpinBox.setValue(float(AsciiVal))
    def P2updateHotkey0(self):
	self.P2Hotkey0SpinBox.setValue(float(AsciiVal))
    def P2updateHotkey1(self):
	self.P2Hotkey1SpinBox.setValue(float(AsciiVal))
    def P2updateHotkey2(self):
	self.P2Hotkey2SpinBox.setValue(float(AsciiVal))
    def P2updateHotkey3(self):
	self.P2Hotkey3SpinBox.setValue(float(AsciiVal))

    def change_value(self,event):
	# P1
	self.P1Keys[0] = "%.0f" % self.P1AkeySpinBox.value()
	self.P1Keys[1] = "%.0f" % self.P1BkeySpinBox.value()
	self.P1Keys[2] = "%.0f" % self.P1CkeySpinBox.value()
	self.P1Keys[3] = "%.0f" % self.P1DkeySpinBox.value()
	self.P1Keys[4] = "%.0f" % self.P1StartkeySpinBox.value()
	self.P1Keys[5] = "%.0f" % self.P1CoinkeySpinBox.value()
	self.P1Keys[6] = "%.0f" % self.P1UpkeySpinBox.value()
	self.P1Keys[7] = "%.0f" % self.P1DownkeySpinBox.value()
	self.P1Keys[8] = "%.0f" % self.P1LeftkeySpinBox.value()
	self.P1Keys[9] = "%.0f" % self.P1RightkeySpinBox.value()
	self.P1Keys[10] = "%.0f" % self.P1Hotkey0SpinBox.value()
	self.P1Keys[11] = "%.0f" % self.P1Hotkey1SpinBox.value()
	self.P1Keys[12] = "%.0f" % self.P1Hotkey2SpinBox.value()
	self.P1Keys[13] = "%.0f" % self.P1Hotkey3SpinBox.value()
	self.P1Resetkey = "%.0f" % self.P1ResetkeySpinBox.value()
	self.P1Exitkey = "%.0f" % self.P1ExitkeySpinBox.value()
	self.P1Savestatekey = "%.0f" % self.P1SavestatekeySpinBox.value()
	self.P1Loadstatekey = "%.0f" % self.P1LoadstatekeySpinBox.value()
	# P2
	self.P2Keys[0] = "%.0f" % self.P2AkeySpinBox.value()
	self.P2Keys[1] = "%.0f" % self.P2BkeySpinBox.value()
	self.P2Keys[2] = "%.0f" % self.P2CkeySpinBox.value()
	self.P2Keys[3] = "%.0f" % self.P2DkeySpinBox.value()
	self.P2Keys[4] = "%.0f" % self.P2StartkeySpinBox.value()
	self.P2Keys[5] = "%.0f" % self.P2CoinkeySpinBox.value()
	self.P2Keys[6] = "%.0f" % self.P2UpkeySpinBox.value()
	self.P2Keys[7] = "%.0f" % self.P2DownkeySpinBox.value()
	self.P2Keys[8] = "%.0f" % self.P2LeftkeySpinBox.value()
	self.P2Keys[9] = "%.0f" % self.P2RightkeySpinBox.value()
	self.P2Keys[10] = "%.0f" % self.P2Hotkey0SpinBox.value()
	self.P2Keys[11] = "%.0f" % self.P2Hotkey1SpinBox.value()
	self.P2Keys[12] = "%.0f" % self.P2Hotkey2SpinBox.value()
	self.P2Keys[13] = "%.0f" % self.P2Hotkey3SpinBox.value()
	global P1buttons
	global P2buttons
	global quitbutton
	global resetbutton
	global savestatebutton
	global loadstatebutton
	P1buttons = self.P1Keys
	P2buttons = self.P2Keys
	quitbutton = self.P1Exitkey
	resetbutton = self.P1Resetkey
	savestatebutton = self.P1Savestatekey
	loadstatebutton = self.P1Loadstatekey

class JoykeyWindow(QDialog):
    def __init__(self, parent=None):
        super(JoykeyWindow, self).__init__(parent)
	joystickAttached = os.path.exists("/dev/input/js0")
	if (joystickAttached):
        	self.setWindowTitle("GnGeo-gui joystick config")
	else:
        	self.setWindowTitle("Gngeo-gui joystick config (no USB joystick found)")
	# order : A,B,C,D,START,COIN,UP,DOWN,LEFT,RIGHT
	if P1joybuttons == "":
        	self.options = parse_config(self,GnGeo_CfgFile)
		self.P1joyKeys=self.options["p1joy"].split(",")
	else:
		self.P1joyKeys = P1joybuttons
	if P2joybuttons == "":
        	self.options = parse_config(self,GnGeo_CfgFile)
		self.P2joyKeys=self.options["p2joy"].split(",")
	else:
		self.P2joyKeys = P2joybuttons
	# P1 keys
	P1Ajoykey=self.P1joyKeys[0]
	P1Bjoykey=self.P1joyKeys[1]
	P1Cjoykey=self.P1joyKeys[2]
	P1Djoykey=self.P1joyKeys[3]
	P1Startjoykey=self.P1joyKeys[4]
	P1Coinjoykey=self.P1joyKeys[5]
	P1Upjoykey=self.P1joyKeys[6]
	P1Downjoykey=self.P1joyKeys[7]
	P1Leftjoykey=self.P1joyKeys[8]
	P1Rightjoykey=self.P1joyKeys[9]
	# if hotkeys are not defined:
	if len(self.P1joyKeys) < 11:
		self.P1joyKeys.append(-1)
	P1hotjoykey0=self.P1joyKeys[10]
	if len(self.P1joyKeys) < 12:
		self.P1joyKeys.append(-1)
	P1hotjoykey1=self.P1joyKeys[11]
	if len(self.P1joyKeys) < 13:
		self.P1joyKeys.append(-1)
	P1hotjoykey2=self.P1joyKeys[12]
	if len(self.P1joyKeys) < 14:
		self.P1joyKeys.append(-1)
	P1hotjoykey3=self.P1joyKeys[13]
	# P2 keys
	P2Ajoykey=self.P2joyKeys[0]
	P2Bjoykey=self.P2joyKeys[1]
	P2Cjoykey=self.P2joyKeys[2]
	P2Djoykey=self.P2joyKeys[3]
	P2Startjoykey=self.P2joyKeys[4]
	P2Coinjoykey=self.P2joyKeys[5]
	P2Upjoykey=self.P2joyKeys[6]
	P2Downjoykey=self.P2joyKeys[7]
	P2Leftjoykey=self.P2joyKeys[8]
	P2Rightjoykey=self.P2joyKeys[9]
	# if hotkeys are not defined:
	if len(self.P2joyKeys) < 11:
		self.P2joyKeys.append(-1)
	P2hotjoykey0=self.P2joyKeys[10]
	if len(self.P2joyKeys) < 12:
		self.P2joyKeys.append(-1)
	P2hotjoykey1=self.P2joyKeys[11]
	if len(self.P2joyKeys) < 13:
		self.P2joyKeys.append(-1)
	P2hotjoykey2=self.P2joyKeys[12]
	if len(self.P2joyKeys) < 14:
		self.P2joyKeys.append(-1)
	P2hotjoykey3=self.P2joyKeys[13]
	# Layout
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.resize(750,1100);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	minKeyValue=-1
	maxKeyValue=30
	grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
	grid.addWidget(QLabel("<center>PLAYER 2</center>"), 1, 3)
	if (joystickAttached):
		grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
		grid.addWidget(QLabel("<center>[pick]</center>"), 1, 4)
	# Add button list
        cntr=2
	for pButton in ['A','B','C','D','START','COIN','UP','DOWN','LEFT','RIGHT','HOTKEY0','HOTKEY1','HOTKEY2','HOTKEY3']:
		grid.addWidget(QLabel(pButton), cntr, 0)
		cntr=cntr+1
	# A-button P1
	self.P1AjoykeySpinBox = QDoubleSpinBox()
	self.P1AjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1AjoykeySpinBox.setValue(float(P1Ajoykey))
	self.P1AjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1AjoykeySpinBox, 2, 1)
	# A-button P2
	self.P2AjoykeySpinBox = QDoubleSpinBox()
	self.P2AjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2AjoykeySpinBox.setValue(float(P2Ajoykey))
	self.P2AjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2AjoykeySpinBox, 2, 3)
	# B-button P1
	self.P1BjoykeySpinBox = QDoubleSpinBox()
	self.P1BjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1BjoykeySpinBox.setValue(float(P1Bjoykey))
	self.P1BjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1BjoykeySpinBox, 3, 1)
	# B-button P2
	self.P2BjoykeySpinBox = QDoubleSpinBox()
	self.P2BjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2BjoykeySpinBox.setValue(float(P2Bjoykey))
	self.P2BjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2BjoykeySpinBox, 3, 3)
	# C-button P1
	self.P1CjoykeySpinBox = QDoubleSpinBox()
	self.P1CjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CjoykeySpinBox.setValue(float(P1Cjoykey))
	self.P1CjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CjoykeySpinBox, 4, 1)
	# C-button P2
	self.P2CjoykeySpinBox = QDoubleSpinBox()
	self.P2CjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CjoykeySpinBox.setValue(float(P2Cjoykey))
	self.P2CjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CjoykeySpinBox, 4, 3)
	# D-button P1
	self.P1DjoykeySpinBox = QDoubleSpinBox()
	self.P1DjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DjoykeySpinBox.setValue(float(P1Djoykey))
	self.P1DjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DjoykeySpinBox, 5, 1)
	# D-button P2
	self.P2DjoykeySpinBox = QDoubleSpinBox()
	self.P2DjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DjoykeySpinBox.setValue(float(P2Djoykey))
	self.P2DjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DjoykeySpinBox, 5, 3)
	# Start-button P1
	self.P1StartjoykeySpinBox = QDoubleSpinBox()
	self.P1StartjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1StartjoykeySpinBox.setValue(float(P1Startjoykey))
	self.P1StartjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1StartjoykeySpinBox, 6, 1)
	# Start-button P2
	self.P2StartjoykeySpinBox = QDoubleSpinBox()
	self.P2StartjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2StartjoykeySpinBox.setValue(float(P2Startjoykey))
	self.P2StartjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2StartjoykeySpinBox, 6, 3)
	# Coin-button P1
	self.P1CoinjoykeySpinBox = QDoubleSpinBox()
	self.P1CoinjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CoinjoykeySpinBox.setValue(float(P1Coinjoykey))
	self.P1CoinjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CoinjoykeySpinBox, 7, 1)
	# Coin-button P2
	self.P2CoinjoykeySpinBox = QDoubleSpinBox()
	self.P2CoinjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CoinjoykeySpinBox.setValue(float(P2Coinjoykey))
	self.P2CoinjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CoinjoykeySpinBox, 7, 3)
	# Up-key P1
	self.P1UpjoykeySpinBox = QDoubleSpinBox()
	self.P1UpjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1UpjoykeySpinBox.setValue(float(P1Upjoykey))
	self.P1UpjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1UpjoykeySpinBox, 8, 1)
	# Up-key P2
	self.P2UpjoykeySpinBox = QDoubleSpinBox()
	self.P2UpjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2UpjoykeySpinBox.setValue(float(P2Upjoykey))
	self.P2UpjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2UpjoykeySpinBox, 8, 3)
	# Down-key P1
	self.P1DownjoykeySpinBox = QDoubleSpinBox()
	self.P1DownjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DownjoykeySpinBox.setValue(float(P1Downjoykey))
	self.P1DownjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DownjoykeySpinBox, 9, 1)
	# Down-key P2
	self.P2DownjoykeySpinBox = QDoubleSpinBox()
	self.P2DownjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DownjoykeySpinBox.setValue(float(P2Downjoykey))
	self.P2DownjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DownjoykeySpinBox, 9, 3)
	# Left-key P1
	self.P1LeftjoykeySpinBox = QDoubleSpinBox()
	self.P1LeftjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1LeftjoykeySpinBox.setValue(float(P1Leftjoykey))
	self.P1LeftjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1LeftjoykeySpinBox, 10, 1)
	# Left-key P2
	self.P2LeftjoykeySpinBox = QDoubleSpinBox()
	self.P2LeftjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2LeftjoykeySpinBox.setValue(float(P2Leftjoykey))
	self.P2LeftjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2LeftjoykeySpinBox, 10, 3)
	# Right-key P1
	self.P1RightjoykeySpinBox = QDoubleSpinBox()
	self.P1RightjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1RightjoykeySpinBox.setValue(float(P1Rightjoykey))
	self.P1RightjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1RightjoykeySpinBox, 11, 1)
	# Right-key P2
	self.P2RightjoykeySpinBox = QDoubleSpinBox()
	self.P2RightjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2RightjoykeySpinBox.setValue(float(P2Rightjoykey))
	self.P2RightjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2RightjoykeySpinBox, 11, 3)
	# hotkey0 P1
	self.P1Hotjoykey0SpinBox = QDoubleSpinBox()
	self.P1Hotjoykey0SpinBox.setRange(-1, maxKeyValue)
	self.P1Hotjoykey0SpinBox.setValue(float(P1hotjoykey0))
	self.P1Hotjoykey0SpinBox.setDecimals(0)
	grid.addWidget(self.P1Hotjoykey0SpinBox, 12, 1)
	# hotkey0 P2
	self.P2Hotjoykey0SpinBox = QDoubleSpinBox()
	self.P2Hotjoykey0SpinBox.setRange(-1, maxKeyValue)
	self.P2Hotjoykey0SpinBox.setValue(float(P2hotjoykey0))
	self.P2Hotjoykey0SpinBox.setDecimals(0)
	grid.addWidget(self.P2Hotjoykey0SpinBox, 12, 3)
	# hotkey1 P1
	self.P1Hotjoykey1SpinBox = QDoubleSpinBox()
	self.P1Hotjoykey1SpinBox.setRange(-1, maxKeyValue)
	self.P1Hotjoykey1SpinBox.setValue(float(P1hotjoykey1))
	self.P1Hotjoykey1SpinBox.setDecimals(0)
	grid.addWidget(self.P1Hotjoykey1SpinBox, 13, 1)
	# hotkey1 P2
	self.P2Hotjoykey1SpinBox = QDoubleSpinBox()
	self.P2Hotjoykey1SpinBox.setRange(-1, maxKeyValue)
	self.P2Hotjoykey1SpinBox.setValue(float(P2hotjoykey1))
	self.P2Hotjoykey1SpinBox.setDecimals(0)
	grid.addWidget(self.P2Hotjoykey1SpinBox, 13, 3)
	# hotkey2 P1
	self.P1Hotjoykey2SpinBox = QDoubleSpinBox()
	self.P1Hotjoykey2SpinBox.setRange(-1, maxKeyValue)
	self.P1Hotjoykey2SpinBox.setValue(float(P2hotjoykey2))
	self.P1Hotjoykey2SpinBox.setDecimals(0)
	grid.addWidget(self.P1Hotjoykey2SpinBox, 14, 1)
	# hotkey2 P2
	self.P2Hotjoykey2SpinBox = QDoubleSpinBox()
	self.P2Hotjoykey2SpinBox.setRange(-1, maxKeyValue)
	self.P2Hotjoykey2SpinBox.setValue(float(P2hotjoykey2))
	self.P2Hotjoykey2SpinBox.setDecimals(0)
	grid.addWidget(self.P2Hotjoykey2SpinBox, 14, 3)
	# hotkey3 P1
	self.P1Hotjoykey3SpinBox = QDoubleSpinBox()
	self.P1Hotjoykey3SpinBox.setRange(-1, maxKeyValue)
	self.P1Hotjoykey3SpinBox.setValue(float(P1hotjoykey3))
	self.P1Hotjoykey3SpinBox.setDecimals(0)
	grid.addWidget(self.P1Hotjoykey3SpinBox, 15, 1)
	# hotkey3 P2
	self.P2Hotjoykey3SpinBox = QDoubleSpinBox()
	self.P2Hotjoykey3SpinBox.setRange(-1, maxKeyValue)
	self.P2Hotjoykey3SpinBox.setValue(float(P2hotjoykey3))
	self.P2Hotjoykey3SpinBox.setDecimals(0)
	grid.addWidget(self.P2Hotjoykey3SpinBox, 15, 3)

	if (joystickAttached):
		self.P2AjoyButton = QPushButton("button",self)
		self.P1BjoyButton = QPushButton("button",self)
		self.P2BjoyButton = QPushButton("button",self)
		self.P1CjoyButton = QPushButton("button",self)
		self.P2CjoyButton = QPushButton("button",self)
		self.P1DjoyButton = QPushButton("button",self)
		self.P2DjoyButton = QPushButton("button",self)
		self.P1StartjoyButton = QPushButton("button",self)
		self.P2StartjoyButton = QPushButton("button",self)
		self.P1CoinjoyButton = QPushButton("button",self)
		self.P2CoinjoyButton = QPushButton("button",self)
		self.P1UpjoyButton = QPushButton("button",self)
		self.P2UpjoyButton = QPushButton("button",self)
		self.P1AjoyButton = QPushButton("button",self)
		self.P1RightjoyButton = QPushButton("button",self)
		self.P2RightjoyButton = QPushButton("button",self)
		self.P2LeftjoyButton = QPushButton("button",self)
		self.P1LeftjoyButton = QPushButton("button",self)
		self.P2DownjoyButton = QPushButton("button",self)
		self.P1DownjoyButton = QPushButton("button",self)
		self.P1Hotkey0joyButton = QPushButton("button",self)
		self.P1Hotkey1joyButton = QPushButton("button",self)
		self.P1Hotkey2joyButton = QPushButton("button",self)
		self.P1Hotkey3joyButton = QPushButton("button",self)
		self.P2Hotkey0joyButton = QPushButton("button",self)
		self.P2Hotkey1joyButton = QPushButton("button",self)
		self.P2Hotkey2joyButton = QPushButton("button",self)
		self.P2Hotkey3joyButton = QPushButton("button",self)
		grid.addWidget(self.P1AjoyButton, 2, 2)
		grid.addWidget(self.P2AjoyButton, 2, 4)
		grid.addWidget(self.P2RightjoyButton, 11, 4)
		grid.addWidget(self.P1RightjoyButton, 11, 2)
		grid.addWidget(self.P1Hotkey0joyButton, 12, 2)
		grid.addWidget(self.P2Hotkey0joyButton, 12, 4)
		grid.addWidget(self.P1Hotkey1joyButton, 13, 2)
		grid.addWidget(self.P2Hotkey1joyButton, 13, 4)
		grid.addWidget(self.P1Hotkey2joyButton, 14, 2)
		grid.addWidget(self.P2Hotkey2joyButton, 14, 4)
		grid.addWidget(self.P1Hotkey3joyButton, 15, 2)
		grid.addWidget(self.P2Hotkey3joyButton, 15, 4)
		grid.addWidget(self.P2LeftjoyButton, 10, 4)
		grid.addWidget(self.P2DownjoyButton, 9, 4)
		grid.addWidget(self.P1LeftjoyButton, 10, 2)
		grid.addWidget(self.P1DownjoyButton, 9, 2)
		grid.addWidget(self.P2UpjoyButton, 8, 4)
		grid.addWidget(self.P2CoinjoyButton, 7, 4)
		grid.addWidget(self.P1UpjoyButton, 8, 2)
		grid.addWidget(self.P2StartjoyButton, 6, 4)
		grid.addWidget(self.P1CoinjoyButton, 7, 2)
		grid.addWidget(self.P2DjoyButton, 5, 4)
		grid.addWidget(self.P1StartjoyButton, 6, 2)
		grid.addWidget(self.P1CjoyButton, 4, 2)
		grid.addWidget(self.P1DjoyButton, 5, 2)
		grid.addWidget(self.P2BjoyButton, 3, 4)
		grid.addWidget(self.P1BjoyButton, 3, 2)
		grid.addWidget(self.P2CjoyButton, 4, 4)

	self.setLayout(grid)
        os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
                   /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
                   string:"Set hotkeys to -1 to disable them"')
	# P1
	self.connect(self.P1AjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1BjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1CjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1DjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1StartjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1CoinjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1UpjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1DownjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1LeftjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1RightjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1Hotjoykey0SpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1Hotjoykey1SpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1Hotjoykey2SpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1Hotjoykey3SpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	if (joystickAttached):
		self.connect(self.P1RightjoyButton, SIGNAL("clicked()"),self.P1joyupdateRight)
		self.connect(self.P1LeftjoyButton, SIGNAL("clicked()"),self.P1updateLeft)
		self.connect(self.P1DownjoyButton, SIGNAL("clicked()"),self.P1updateDown)
		self.connect(self.P1UpjoyButton, SIGNAL("clicked()"),self.P1updateUp)
		self.connect(self.P1CoinjoyButton, SIGNAL("clicked()"),self.P1updateCoin)
		self.connect(self.P1StartjoyButton, SIGNAL("clicked()"),self.P1updateStart)
		self.connect(self.P1AjoyButton, SIGNAL("clicked()"),self.P1updateA)
		self.connect(self.P1BjoyButton, SIGNAL("clicked()"),self.P1updateB)
		self.connect(self.P1CjoyButton, SIGNAL("clicked()"),self.P1updateC)
		self.connect(self.P1DjoyButton, SIGNAL("clicked()"),self.P1updateD)
		self.connect(self.P1Hotkey0joyButton, SIGNAL("clicked()"),self.P1updateHotkey0)
		self.connect(self.P1Hotkey1joyButton, SIGNAL("clicked()"),self.P1updateHotkey1)
		self.connect(self.P1Hotkey2joyButton, SIGNAL("clicked()"),self.P1updateHotkey2)
		self.connect(self.P1Hotkey3joyButton, SIGNAL("clicked()"),self.P1updateHotkey3)
	# P2
	self.connect(self.P2AjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2BjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2CjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2DjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2StartjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2CoinjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2UpjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2DownjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2LeftjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2RightjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	if (joystickAttached):
		self.connect(self.P2RightjoyButton, SIGNAL("clicked()"),self.P2updateRight)
		self.connect(self.P2LeftjoyButton, SIGNAL("clicked()"),self.P2updateLeft)
		self.connect(self.P2DownjoyButton, SIGNAL("clicked()"),self.P2updateDown)
		self.connect(self.P2UpjoyButton, SIGNAL("clicked()"),self.P2updateUp)
		self.connect(self.P2CoinjoyButton, SIGNAL("clicked()"),self.P2updateCoin)
		self.connect(self.P2StartjoyButton, SIGNAL("clicked()"),self.P2updateStart)
		self.connect(self.P2AjoyButton, SIGNAL("clicked()"),self.P2updateA)
		self.connect(self.P2BjoyButton, SIGNAL("clicked()"),self.P2updateB)
		self.connect(self.P2CjoyButton, SIGNAL("clicked()"),self.P2updateC)
		self.connect(self.P2DjoyButton, SIGNAL("clicked()"),self.P2updateD)
		self.connect(self.P2Hotkey0joyButton, SIGNAL("clicked()"),self.P2updateHotkey0)
		self.connect(self.P2Hotkey1joyButton, SIGNAL("clicked()"),self.P2updateHotkey1)
		self.connect(self.P2Hotkey2joyButton, SIGNAL("clicked()"),self.P2updateHotkey2)
		self.connect(self.P2Hotkey3joyButton, SIGNAL("clicked()"),self.P2updateHotkey3)

	# P1
    def P1joyupdateRight(self):
	MyJoykeyPressed()
	self.P1RightjoykeySpinBox.setValue(float(joyVal))
    def P1updateLeft(self):
	MyJoykeyPressed()
	self.P1LeftjoykeySpinBox.setValue(float(joyVal))
    def P1updateUp(self):
	MyJoykeyPressed()
	self.P1UpjoykeySpinBox.setValue(float(joyVal))
    def P1updateDown(self):
	MyJoykeyPressed()
	self.P1DownjoykeySpinBox.setValue(float(joyVal))
    def P1updateStart(self):
	MyJoykeyPressed()
	self.P1StartjoykeySpinBox.setValue(float(joyVal))
    def P1updateCoin(self):
	MyJoykeyPressed()
	self.P1CoinjoykeySpinBox.setValue(float(joyVal))
    def P1updateA(self):
	MyJoykeyPressed()
	self.P1AjoykeySpinBox.setValue(float(joyVal))
    def P1updateB(self):
	MyJoykeyPressed()
	self.P1BjoykeySpinBox.setValue(float(joyVal))
    def P1updateC(self):
	MyJoykeyPressed()
	self.P1CjoykeySpinBox.setValue(float(joyVal))
    def P1updateD(self):
	MyJoykeyPressed()
	self.P1DjoykeySpinBox.setValue(float(joyVal))
    def P1updateHotkey0(self):
	MyJoykeyPressed()
	self.P1Hotjoykey0SpinBox.setValue(float(joyVal))
    def P1updateHotkey1(self):
	MyJoykeyPressed()
	self.P1Hotjoykey1SpinBox.setValue(float(joyVal))
    def P1updateHotkey2(self):
	MyJoykeyPressed()
	self.P1Hotjoykey2SpinBox.setValue(float(joyVal))
    def P1updateHotkey3(self):
	MyJoykeyPressed()
	self.P1Hotjoykey3SpinBox.setValue(float(joyVal))

	# P2
    def P2updateRight(self):
	MyJoykeyPressed()
	self.P2RightjoykeySpinBox.setValue(float(joyVal))
    def P2updateLeft(self):
	MyJoykeyPressed()
	self.P2LeftjoykeySpinBox.setValue(float(joyVal))
    def P2updateUp(self):
	MyJoykeyPressed()
	self.P2UpjoykeySpinBox.setValue(float(joyVal))
    def P2updateDown(self):
	MyJoykeyPressed()
	self.P2DownjoykeySpinBox.setValue(float(joyVal))
    def P2updateStart(self):
	MyJoykeyPressed()
	self.P2StartjoykeySpinBox.setValue(float(joyVal))
    def P2updateCoin(self):
	MyJoykeyPressed()
	self.P2CoinjoykeySpinBox.setValue(float(joyVal))
    def P2updateA(self):
	MyJoykeyPressed()
	self.P2AjoykeySpinBox.setValue(float(joyVal))
    def P2updateB(self):
	MyJoykeyPressed()
	self.P2BjoykeySpinBox.setValue(float(joyVal))
    def P2updateC(self):
	MyJoykeyPressed()
	self.P2CjoykeySpinBox.setValue(float(joyVal))
    def P2updateD(self):
	MyJoykeyPressed()
	self.P2DjoykeySpinBox.setValue(float(joyVal))
    def P2updateHotkey0(self):
	MyJoykeyPressed()
	self.P2Hotjoykey0SpinBox.setValue(float(joyVal))
    def P2updateHotkey1(self):
	MyJoykeyPressed()
	self.P2Hotjoykey1SpinBox.setValue(float(joyVal))
    def P2updateHotkey2(self):
	MyJoykeyPressed()
	self.P2Hotjoykey2SpinBox.setValue(float(joyVal))
    def P2updateHotkey3(self):
	MyJoykeyPressed()
	self.P2Hotjoykey3SpinBox.setValue(float(joyVal))

    def change_value_joy(self):
	# P1
	self.P1joyKeys[0] = "%.0f" % self.P1AjoykeySpinBox.value()
	self.P1joyKeys[1] = "%.0f" % self.P1BjoykeySpinBox.value()
	self.P1joyKeys[2] = "%.0f" % self.P1CjoykeySpinBox.value()
	self.P1joyKeys[3] = "%.0f" % self.P1DjoykeySpinBox.value()
	self.P1joyKeys[4] = "%.0f" % self.P1StartjoykeySpinBox.value()
	self.P1joyKeys[5] = "%.0f" % self.P1CoinjoykeySpinBox.value()
	self.P1joyKeys[6] = "%.0f" % self.P1UpjoykeySpinBox.value()
	self.P1joyKeys[7] = "%.0f" % self.P1DownjoykeySpinBox.value()
	self.P1joyKeys[8] = "%.0f" % self.P1LeftjoykeySpinBox.value()
	self.P1joyKeys[9] = "%.0f" % self.P1RightjoykeySpinBox.value()
	self.P1joyKeys[10] = "%.0f" % self.P1Hotjoykey0SpinBox.value()
	self.P1joyKeys[11] = "%.0f" % self.P1Hotjoykey1SpinBox.value()
	self.P1joyKeys[12] = "%.0f" % self.P1Hotjoykey2SpinBox.value()
	self.P1joyKeys[13] = "%.0f" % self.P1Hotjoykey3SpinBox.value()
	# P2
	self.P2joyKeys[0] = "%.0f" % self.P2AjoykeySpinBox.value()
	self.P2joyKeys[1] = "%.0f" % self.P2BjoykeySpinBox.value()
	self.P2joyKeys[2] = "%.0f" % self.P2CjoykeySpinBox.value()
	self.P2joyKeys[3] = "%.0f" % self.P2DjoykeySpinBox.value()
	self.P2joyKeys[4] = "%.0f" % self.P2StartjoykeySpinBox.value()
	self.P2joyKeys[5] = "%.0f" % self.P2CoinjoykeySpinBox.value()
	self.P2joyKeys[6] = "%.0f" % self.P2UpjoykeySpinBox.value()
	self.P2joyKeys[7] = "%.0f" % self.P2DownjoykeySpinBox.value()
	self.P2joyKeys[8] = "%.0f" % self.P2LeftjoykeySpinBox.value()
	self.P2joyKeys[9] = "%.0f" % self.P2RightjoykeySpinBox.value()
	self.P2joyKeys[10] = "%.0f" % self.P2Hotjoykey0SpinBox.value()
	self.P2joyKeys[11] = "%.0f" % self.P2Hotjoykey1SpinBox.value()
	self.P2joyKeys[12] = "%.0f" % self.P2Hotjoykey2SpinBox.value()
	self.P2joyKeys[13] = "%.0f" % self.P2Hotjoykey3SpinBox.value()
	global P1joybuttons
	global P2joybuttons
	P1joybuttons = self.P1joyKeys
	P2joybuttons = self.P2joyKeys

class MyKeyPressed(QPushButton):
    def __init__(self, *args):
        QPushButton.__init__(self, *args)

    def event(self, event):
        if (event.type()==QEvent.KeyPress):
            # we have to get the SDL keysym
	    global AsciiVal
            if (event.key() < 256):
                AsciiVal = ord(str.lower(chr(event.key())))
            if (event.key() == 16777236):
		# right
                AsciiVal = 275;
	    if (event.key() == 16777234):
                # left
                AsciiVal = 276;
            if (event.key() == 16777235):
                # up
                AsciiVal = 273;
            if (event.key() == 16777237):
                # down
                AsciiVal = 274;
            if (event.key() == 16777219):
                # BS
                AsciiVal = 8;
            if (event.key() == 16777221):
                # Return
                AsciiVal = 271;
            if (event.key() == 16777248):
                # R-Shift
                AsciiVal = 303;
            if (event.key() == 16777249):
                # R-Control
                AsciiVal = 305;
            if (event.key() == 16781571):
                # R-Alt
                AsciiVal = 307;
            self.emit(SIGNAL("keyPressed"))

        return QPushButton.event(self, event)

class MyJoykeyPressed(QPushButton):
    def __init__(self, parent=None):
        QPushButton.__init__(self, parent)

	global joyVal
	pipe = open('/dev/input/js0','r')
	action = []
	stopping = False
	while not stopping :
		for character in pipe.read(1):
			action += ['%02X' % ord(character)]
			if len(action) == 8:
	
				if action[6] == '01': # Button
					if action[4] == '01':
						joyVal = action[7]
						stopping = True
						break
				elif action[7] == '04': # Left Joystick left/right
					if action[4] == 'FF':
						# You pressed right on the left joystick
						joyVal = 4 #,1
						stopping = True
					elif action[4] == '01':
						# You pressed left on the left joystick
						joyVal = 4 #,1
						stopping = True
				elif action[7] == '05': # Left Joystick up/down
					if action[4] == 'FF':
						# You pressed down on the left joystick
						joyVal = 5 #,1
						stopping = True
					elif action[4] == '01':
						joyVal = 4 #,1
						# You pressed up on the left joystick 
						stopping = True

				action = []
				if stopping:
					break
			if stopping:
				break
		if stopping:
			break
	pipe.close()

class hotkeyWindow(QDialog):
    def __init__(self, parent=None):
        super(hotkeyWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui hotkey config")
       	self.options = parse_config(self,GnGeo_CfgFile)
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,700);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
	if P1hotbuttons0 == "":
		self.P1hotKeys0=self.options["p1hotkey0"].split(",")
	else:
		self.P1hotKeys0 = P1hotbuttons0
	if P1hotbuttons1 == "":
		self.P1hotKeys1=self.options["p1hotkey1"].split(",")
	else:
		self.P1hotKeys1 = P1hotbuttons1
	if P1hotbuttons2 == "":
		self.P1hotKeys2=self.options["p1hotkey2"].split(",")
	else:
		self.P1hotKeys2 = P1hotbuttons2
	if P1hotbuttons3 == "":
		self.P1hotKeys3=self.options["p1hotkey3"].split(",")
	else:
		self.P1hotKeys3 = P1hotbuttons3
	if P2hotbuttons0 == "":
		self.P2hotKeys0=self.options["p2hotkey0"].split(",")
	else:
		self.P2hotKeys0 = P2hotbuttons0
	if P2hotbuttons1 == "":
		self.P2hotKeys1=self.options["p2hotkey1"].split(",")
	else:
		self.P2hotKeys1 = P2hotbuttons1
	if P2hotbuttons2 == "":
		self.P2hotKeys2=self.options["p2hotkey2"].split(",")
	else:
		self.P2hotKeys2 = P2hotbuttons2
	if P2hotbuttons3 == "":
		self.P2hotKeys3=self.options["p2hotkey3"].split(",")
	else:
		self.P2hotKeys3 = P2hotbuttons3
	grid.addWidget(QLabel("P1 hotkey 0"), 1, 1)
	grid.addWidget(QLabel("P1 hotkey 1"), 2, 1)
	grid.addWidget(QLabel("P1 hotkey 2"), 3, 1)
	grid.addWidget(QLabel("P1 hotkey 3"), 4, 1)
	grid.addWidget(QLabel("P2 hotkey 0"), 5, 1)
	grid.addWidget(QLabel("P2 hotkey 1"), 6, 1)
	grid.addWidget(QLabel("P2 hotkey 2"), 7, 1)
	grid.addWidget(QLabel("P2 hotkey 3"), 8, 1)
	# p1hotkey0
        self.P1A0PushButton = QPushButton("A",self)
	self.P1A0PushButton.setCheckable(True)
        grid.addWidget(self.P1A0PushButton,1,2)
        self.P1B0PushButton = QPushButton("B",self)
	self.P1B0PushButton.setCheckable(True)
        grid.addWidget(self.P1B0PushButton,1,3)
        self.P1C0PushButton = QPushButton("C",self)
	self.P1C0PushButton.setCheckable(True)
        grid.addWidget(self.P1C0PushButton,1,4)
        self.P1D0PushButton = QPushButton("D",self)
	self.P1D0PushButton.setCheckable(True)
        grid.addWidget(self.P1D0PushButton,1,5)
	# p1hotkey1
        self.P1A1PushButton = QPushButton("A",self)
	self.P1A1PushButton.setCheckable(True)
        grid.addWidget(self.P1A1PushButton,2,2)
        self.P1B1PushButton = QPushButton("B",self)
	self.P1B1PushButton.setCheckable(True)
        grid.addWidget(self.P1B1PushButton,2,3)
        self.P1C1PushButton = QPushButton("C",self)
	self.P1C1PushButton.setCheckable(True)
        grid.addWidget(self.P1C1PushButton,2,4)
        self.P1D1PushButton = QPushButton("D",self)
	self.P1D1PushButton.setCheckable(True)
        grid.addWidget(self.P1D1PushButton,2,5)
	# p1hotkey2
        self.P1A2PushButton = QPushButton("A",self)
	self.P1A2PushButton.setCheckable(True)
        grid.addWidget(self.P1A2PushButton,3,2)
        self.P1B2PushButton = QPushButton("B",self)
	self.P1B2PushButton.setCheckable(True)
        grid.addWidget(self.P1B2PushButton,3,3)
        self.P1C2PushButton = QPushButton("C",self)
	self.P1C2PushButton.setCheckable(True)
        grid.addWidget(self.P1C2PushButton,3,4)
        self.P1D2PushButton = QPushButton("D",self)
	self.P1D2PushButton.setCheckable(True)
        grid.addWidget(self.P1D2PushButton,3,5)
	# p1hotkey3
        self.P1A3PushButton = QPushButton("A",self)
	self.P1A3PushButton.setCheckable(True)
        grid.addWidget(self.P1A3PushButton,4,2)
        self.P1B3PushButton = QPushButton("B",self)
	self.P1B3PushButton.setCheckable(True)
        grid.addWidget(self.P1B3PushButton,4,3)
        self.P1C3PushButton = QPushButton("C",self)
	self.P1C3PushButton.setCheckable(True)
        grid.addWidget(self.P1C3PushButton,4,4)
        self.P1D3PushButton = QPushButton("D",self)
	self.P1D3PushButton.setCheckable(True)
        grid.addWidget(self.P1D3PushButton,4,5)
	# p2hotkey0
        self.P2A0PushButton = QPushButton("A",self)
	self.P2A0PushButton.setCheckable(True)
        grid.addWidget(self.P2A0PushButton,5,2)
        self.P2B0PushButton = QPushButton("B",self)
	self.P2B0PushButton.setCheckable(True)
        grid.addWidget(self.P2B0PushButton,5,3)
        self.P2C0PushButton = QPushButton("C",self)
	self.P2C0PushButton.setCheckable(True)
        grid.addWidget(self.P2C0PushButton,5,4)
        self.P2D0PushButton = QPushButton("D",self)
	self.P2D0PushButton.setCheckable(True)
        grid.addWidget(self.P2D0PushButton,5,5)
	# p2hotkey1
        self.P2A1PushButton = QPushButton("A",self)
	self.P2A1PushButton.setCheckable(True)
        grid.addWidget(self.P2A1PushButton,6,2)
        self.P2B1PushButton = QPushButton("B",self)
	self.P2B1PushButton.setCheckable(True)
        grid.addWidget(self.P2B1PushButton,6,3)
        self.P2C1PushButton = QPushButton("C",self)
	self.P2C1PushButton.setCheckable(True)
        grid.addWidget(self.P2C1PushButton,6,4)
        self.P2D1PushButton = QPushButton("D",self)
	self.P2D1PushButton.setCheckable(True)
        grid.addWidget(self.P2D1PushButton,6,5)
	# p2hotkey2
        self.P2A2PushButton = QPushButton("A",self)
	self.P2A2PushButton.setCheckable(True)
        grid.addWidget(self.P2A2PushButton,7,2)
        self.P2B2PushButton = QPushButton("B",self)
	self.P2B2PushButton.setCheckable(True)
        grid.addWidget(self.P2B2PushButton,7,3)
        self.P2C2PushButton = QPushButton("C",self)
	self.P2C2PushButton.setCheckable(True)
        grid.addWidget(self.P2C2PushButton,7,4)
        self.P2D2PushButton = QPushButton("D",self)
	self.P2D2PushButton.setCheckable(True)
        grid.addWidget(self.P2D2PushButton,7,5)
	# p2hotkey3
        self.P2A3PushButton = QPushButton("A",self)
	self.P2A3PushButton.setCheckable(True)
        grid.addWidget(self.P2A3PushButton,8,2)
        self.P2B3PushButton = QPushButton("B",self)
	self.P2B3PushButton.setCheckable(True)
        grid.addWidget(self.P2B3PushButton,8,3)
        self.P2C3PushButton = QPushButton("C",self)
	self.P2C3PushButton.setCheckable(True)
        grid.addWidget(self.P2C3PushButton,8,4)
        self.P2D3PushButton = QPushButton("D",self)
	self.P2D3PushButton.setCheckable(True)
        grid.addWidget(self.P2D3PushButton,8,5)

	# A = 1, B = 2, C = 4, D = 8
	# p1hotkey0
	if "1" in self.P1hotKeys0:
		self.P1A0PushButton.setChecked(True)
	else:
		self.P1hotKeys0.insert(0,"")
	if "2" in self.P1hotKeys0:
		self.P1B0PushButton.setChecked(True)
	else:
		self.P1hotKeys0.insert(1,"")
	if "4" in self.P1hotKeys0:
		self.P1C0PushButton.setChecked(True)
	else:
		self.P1hotKeys0.insert(2,"")
	if "8" in self.P1hotKeys0:
		self.P1D0PushButton.setChecked(True)
	else:
		self.P1hotKeys0.append("")
	# p1hotkey1
	if "1" in self.P1hotKeys1:
		self.P1A1PushButton.setChecked(True)
	else:
		self.P1hotKeys1.insert(0,"")
	if "2" in self.P1hotKeys1:
		self.P1B1PushButton.setChecked(True)
	else:
		self.P1hotKeys1.insert(1,"")
	if "4" in self.P1hotKeys1:
		self.P1C1PushButton.setChecked(True)
	else:
		self.P1hotKeys1.insert(2,"")
	if "8" in self.P1hotKeys1:
		self.P1D1PushButton.setChecked(True)
	else:
		self.P1hotKeys1.append("")
	# p1hotkey2
	if "1" in self.P1hotKeys2:
		self.P1A2PushButton.setChecked(True)
	else:
		self.P1hotKeys2.insert(0,"")
	if "2" in self.P1hotKeys2:
		self.P1B2PushButton.setChecked(True)
	else:
		self.P1hotKeys2.insert(1,"")
	if "4" in self.P1hotKeys2:
		self.P1C2PushButton.setChecked(True)
	else:
		self.P1hotKeys2.insert(2,"")
	if "8" in self.P1hotKeys2:
		self.P1D2PushButton.setChecked(True)
	else:
		self.P1hotKeys2.append("")
	# p1hotkey3
	if "1" in self.P1hotKeys3:
		self.P1A3PushButton.setChecked(True)
	else:
		self.P1hotKeys3.insert(0,"")
	if "2" in self.P1hotKeys3:
		self.P1B3PushButton.setChecked(True)
	else:
		self.P1hotKeys3.insert(1,"")
	if "4" in self.P1hotKeys3:
		self.P1C3PushButton.setChecked(True)
	else:
		self.P1hotKeys3.insert(2,"")
	if "8" in self.P1hotKeys3:
		self.P1D3PushButton.setChecked(True)
	else:
		self.P1hotKeys3.append("")
	# p2hotkey0
	if "1" in self.P2hotKeys0:
		self.P2A0PushButton.setChecked(True)
	else:
		self.P2hotKeys0.insert(0,"")
	if "2" in self.P2hotKeys0:
		self.P2B0PushButton.setChecked(True)
	else:
		self.P2hotKeys0.insert(1,"")
	if "4" in self.P2hotKeys0:
		self.P2C0PushButton.setChecked(True)
	else:
		self.P2hotKeys0.insert(2,"")
	if "8" in self.P2hotKeys0:
		self.P2D0PushButton.setChecked(True)
	else:
		self.P2hotKeys0.append("")
	# p1hotkey1
	if "1" in self.P2hotKeys1:
		self.P2A1PushButton.setChecked(True)
	else:
		self.P2hotKeys1.insert(0,"")
	if "2" in self.P2hotKeys1:
		self.P2B1PushButton.setChecked(True)
	else:
		self.P2hotKeys1.insert(1,"")
	if "4" in self.P2hotKeys1:
		self.P2C1PushButton.setChecked(True)
	else:
		self.P2hotKeys1.insert(2,"")
	if "8" in self.P2hotKeys1:
		self.P2D1PushButton.setChecked(True)
	else:
		self.P2hotKeys1.append("")
	# p1hotkey2
	if "1" in self.P2hotKeys2:
		self.P2A2PushButton.setChecked(True)
	else:
		self.P2hotKeys2.insert(0,"")
	if "2" in self.P2hotKeys2:
		self.P2B2PushButton.setChecked(True)
	else:
		self.P2hotKeys2.insert(1,"")
	if "4" in self.P2hotKeys2:
		self.P2C2PushButton.setChecked(True)
	else:
		self.P2hotKeys2.insert(2,"")
	if "8" in self.P2hotKeys2:
		self.P2D2PushButton.setChecked(True)
	else:
		self.P2hotKeys2.append("")
	# p1hotkey3
	if "1" in self.P2hotKeys3:
		self.P2A3PushButton.setChecked(True)
	else:
		self.P2hotKeys3.insert(0,"")
	if "2" in self.P2hotKeys3:
		self.P2B3PushButton.setChecked(True)
	else:
		self.P2hotKeys3.insert(1,"")
	if "4" in self.P2hotKeys3:
		self.P2C3PushButton.setChecked(True)
	else:
		self.P2hotKeys3.insert(2,"")
	if "8" in self.P2hotKeys3:
		self.P2D3PushButton.setChecked(True)
	else:
		self.P2hotKeys3.append("")

	# Connect to P1 hotkey buttons
	self.connect(self.P1A0PushButton, SIGNAL("clicked()"),self.P1A0update)
	self.connect(self.P1B0PushButton, SIGNAL("clicked()"),self.P1B0update)
	self.connect(self.P1C0PushButton, SIGNAL("clicked()"),self.P1C0update)
	self.connect(self.P1D0PushButton, SIGNAL("clicked()"),self.P1D0update)
	self.connect(self.P1A1PushButton, SIGNAL("clicked()"),self.P1A1update)
	self.connect(self.P1B1PushButton, SIGNAL("clicked()"),self.P1B1update)
	self.connect(self.P1C1PushButton, SIGNAL("clicked()"),self.P1C1update)
	self.connect(self.P1D1PushButton, SIGNAL("clicked()"),self.P1D1update)
	self.connect(self.P1A2PushButton, SIGNAL("clicked()"),self.P1A2update)
	self.connect(self.P1B2PushButton, SIGNAL("clicked()"),self.P1B2update)
	self.connect(self.P1C2PushButton, SIGNAL("clicked()"),self.P1C2update)
	self.connect(self.P1D2PushButton, SIGNAL("clicked()"),self.P1D2update)
	self.connect(self.P1A3PushButton, SIGNAL("clicked()"),self.P1A3update)
	self.connect(self.P1B3PushButton, SIGNAL("clicked()"),self.P1B3update)
	self.connect(self.P1C3PushButton, SIGNAL("clicked()"),self.P1C3update)
	self.connect(self.P1D3PushButton, SIGNAL("clicked()"),self.P1D3update)
	# Connect to P2 hotkey buttons
	self.connect(self.P2A0PushButton, SIGNAL("clicked()"),self.P2A0update)
	self.connect(self.P2B0PushButton, SIGNAL("clicked()"),self.P2B0update)
	self.connect(self.P2C0PushButton, SIGNAL("clicked()"),self.P2C0update)
	self.connect(self.P2D0PushButton, SIGNAL("clicked()"),self.P2D0update)
	self.connect(self.P2A1PushButton, SIGNAL("clicked()"),self.P2A1update)
	self.connect(self.P2B1PushButton, SIGNAL("clicked()"),self.P2B1update)
	self.connect(self.P2C1PushButton, SIGNAL("clicked()"),self.P2C1update)
	self.connect(self.P2D1PushButton, SIGNAL("clicked()"),self.P2D1update)
	self.connect(self.P2A2PushButton, SIGNAL("clicked()"),self.P2A2update)
	self.connect(self.P2B2PushButton, SIGNAL("clicked()"),self.P2B2update)
	self.connect(self.P2C2PushButton, SIGNAL("clicked()"),self.P2C2update)
	self.connect(self.P2D2PushButton, SIGNAL("clicked()"),self.P2D2update)
	self.connect(self.P2A3PushButton, SIGNAL("clicked()"),self.P2A3update)
	self.connect(self.P2B3PushButton, SIGNAL("clicked()"),self.P2B3update)
	self.connect(self.P2C3PushButton, SIGNAL("clicked()"),self.P2C3update)
	self.connect(self.P2D3PushButton, SIGNAL("clicked()"),self.P2D3update)

	# player 1 hotkey update
    def P1A0update(self):
	global P1hotbuttons0
	if self.P1A0PushButton.isChecked():
		self.P1hotKeys0[0] = "1"
	else:
		self.P1hotKeys0[0] = ""
	P1hotbuttons0 = self.P1hotKeys0

    def P1B0update(self):
	global P1hotbuttons0
	if self.P1B0PushButton.isChecked():
		self.P1hotKeys0[1] = "2"
	else:
		self.P1hotKeys0[1] = ""
	P1hotbuttons0 = self.P1hotKeys0
 
    def P1C0update(self):
	global P1hotbuttons0
	if self.P1C0PushButton.isChecked():
		self.P1hotKeys0[2] = "4"
	else:
		self.P1hotKeys0[2] = ""
	P1hotbuttons0 = self.P1hotKeys0
 
    def P1D0update(self):
	global P1hotbuttons0
	if self.P1D0PushButton.isChecked():
		self.P1hotKeys0[3] = "8"
	else:
		self.P1hotKeys0[3] = ""
	P1hotbuttons0 = self.P1hotKeys0

    def P1A1update(self):
	global P1hotbuttons1
	if self.P1A1PushButton.isChecked():
		self.P1hotKeys1[0] = "1"
	else:
		self.P1hotKeys1[0] = ""
	P1hotbuttons1 = self.P1hotKeys1

    def P1B1update(self):
	global P1hotbuttons1
	if self.P1B1PushButton.isChecked():
		self.P1hotKeys1[1] = "2"
	else:
		self.P1hotKeys1[1] = ""
	P1hotbuttons1 = self.P1hotKeys1
 
    def P1C1update(self):
	global P1hotbuttons1
	if self.P1C1PushButton.isChecked():
		self.P1hotKeys1[2] = "4"
	else:
		self.P1hotKeys1[2] = ""
	P1hotbuttons1 = self.P1hotKeys1
 
    def P1D1update(self):
	global P1hotbuttons1
	if self.P1D1PushButton.isChecked():
		self.P1hotKeys1[3] = "8"
	else:
		self.P1hotKeys1[3] = ""
	P1hotbuttons1 = self.P1hotKeys1

    def P1A2update(self):
	global P1hotbuttons2
	if self.P1A2PushButton.isChecked():
		self.P1hotKeys2[0] = "1"
	else:
		self.P1hotKeys2[0] = ""
	P1hotbuttons2 = self.P1hotKeys2

    def P1B2update(self):
	global P1hotbuttons2
	if self.P1B2PushButton.isChecked():
		self.P1hotKeys2[1] = "2"
	else:
		self.P1hotKeys2[1] = ""
	P1hotbuttons2 = self.P1hotKeys2
 
    def P1C2update(self):
	global P1hotbuttons2
	if self.P1C2PushButton.isChecked():
		self.P1hotKeys2[2] = "4"
	else:
		self.P1hotKeys2[2] = ""
	P1hotbuttons2 = self.P1hotKeys2
 
    def P1D2update(self):
	global P1hotbuttons2
	if self.P1D2PushButton.isChecked():
		self.P1hotKeys2[3] = "8"
	else:
		self.P1hotKeys2[3] = ""
	P1hotbuttons2 = self.P1hotKeys2
 
    def P1A3update(self):
	global P1hotbuttons3
	if self.P1A3PushButton.isChecked():
		self.P1hotKeys3[0] = "1"
	else:
		self.P1hotKeys3[0] = ""
	P1hotbuttons3 = self.P1hotKeys3

    def P1B3update(self):
	global P1hotbuttons3
	if self.P1B3PushButton.isChecked():
		self.P1hotKeys3[1] = "2"
	else:
		self.P1hotKeys3[1] = ""
	P1hotbuttons3 = self.P1hotKeys3
 
    def P1C3update(self):
	global P1hotbuttons3
	if self.P1C3PushButton.isChecked():
		self.P1hotKeys3[2] = "4"
	else:
		self.P1hotKeys3[2] = ""
	P1hotbuttons3 = self.P1hotKeys3
 
    def P1D3update(self):
	global P1hotbuttons3
	if self.P1D3PushButton.isChecked():
		self.P1hotKeys3[3] = "8"
	else:
		self.P1hotKeys3[3] = ""
	P1hotbuttons3 = self.P1hotKeys3

	# player 2 hotkey update
    def P2A0update(self):
	global P2hotbuttons0
	if self.P2A0PushButton.isChecked():
		self.P2hotKeys0[0] = "1"
	else:
		self.P2hotKeys0[0] = ""
	P2hotbuttons0 = self.P2hotKeys0

    def P2B0update(self):
	global P2hotbuttons0
	if self.P2B0PushButton.isChecked():
		self.P2hotKeys0[1] = "2"
	else:
		self.P2hotKeys0[1] = ""
	P2hotbuttons0 = self.P2hotKeys0
 
    def P2C0update(self):
	global P2hotbuttons0
	if self.P2C0PushButton.isChecked():
		self.P2hotKeys0[2] = "4"
	else:
		self.P2hotKeys0[2] = ""
	P2hotbuttons0 = self.P2hotKeys0
 
    def P2D0update(self):
	global P2hotbuttons0
	if self.P2D0PushButton.isChecked():
		self.P2hotKeys0[3] = "8"
	else:
		self.P2hotKeys0[3] = ""
	P2hotbuttons0 = self.P2hotKeys0

    def P2A1update(self):
	global P2hotbuttons1
	if self.P2A1PushButton.isChecked():
		self.P2hotKeys1[0] = "1"
	else:
		self.P2hotKeys1[0] = ""
	P2hotbuttons1 = self.P2hotKeys1

    def P2B1update(self):
	global P2hotbuttons1
	if self.P2B1PushButton.isChecked():
		self.P2hotKeys1[1] = "2"
	else:
		self.P2hotKeys1[1] = ""
	P2hotbuttons1 = self.P2hotKeys1
 
    def P2C1update(self):
	global P2hotbuttons1
	if self.P2C1PushButton.isChecked():
		self.P2hotKeys1[2] = "4"
	else:
		self.P2hotKeys1[2] = ""
	P2hotbuttons1 = self.P2hotKeys1
 
    def P2D1update(self):
	global P2hotbuttons1
	if self.P2D1PushButton.isChecked():
		self.P2hotKeys1[3] = "8"
	else:
		self.P2hotKeys1[3] = ""
	P2hotbuttons1 = self.P2hotKeys1
    def P2A2update(self):
	global P2hotbuttons2
	if self.P2A2PushButton.isChecked():
		self.P2hotKeys2[0] = "1"
	else:
		self.P2hotKeys2[0] = ""
	P2hotbuttons2 = self.P2hotKeys2

    def P2B2update(self):
	global P2hotbuttons2
	if self.P2B2PushButton.isChecked():
		self.P2hotKeys2[1] = "2"
	else:
		self.P2hotKeys2[1] = ""
	P2hotbuttons2 = self.P2hotKeys2
 
    def P2C2update(self):
	global P2hotbuttons2
	if self.P2C2PushButton.isChecked():
		self.P2hotKeys2[2] = "4"
	else:
		self.P2hotKeys2[2] = ""
	P2hotbuttons2 = self.P2hotKeys2
 
    def P2D2update(self):
	global P2hotbuttons2
	if self.P2D2PushButton.isChecked():
		self.P2hotKeys2[3] = "8"
	else:
		self.P2hotKeys2[3] = ""
	P2hotbuttons2 = self.P2hotKeys2

    def P2A3update(self):
	global P2hotbuttons3
	if self.P2A3PushButton.isChecked():
		self.P2hotKeys3[0] = "1"
	else:
		self.P2hotKeys3[0] = ""
	P2hotbuttons3 = self.P2hotKeys3

    def P2B3update(self):
	global P2hotbuttons3
	if self.P2B3PushButton.isChecked():
		self.P2hotKeys3[1] = "2"
	else:
		self.P2hotKeys3[1] = ""
	P2hotbuttons3 = self.P2hotKeys3
 
    def P2C3update(self):
	global P2hotbuttons3
	if self.P2C3PushButton.isChecked():
		self.P2hotKeys3[2] = "4"
	else:
		self.P2hotKeys3[2] = ""
	P2hotbuttons3 = self.P2hotKeys3
 
    def P2D3update(self):
	global P2hotbuttons3
	if self.P2D3PushButton.isChecked():
		self.P2hotKeys3[3] = "8"
	else:
		self.P2hotKeys3[3] = ""
	P2hotbuttons3 = self.P2hotKeys3
 
 
class pathWindow(QDialog):
    def __init__(self, parent=None):
        super(pathWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui path configuration")
        self.options = parse_config(self,GnGeo_CfgFile)
        self.gui_opts = parse_config(self,GnGeoGui_CfgFile)
	if BiosPath == "":
		self.biosPath=self.options["biospath"]
	else:
		self.biosPath=BiosPath
	if RomrcPath == "":
		self.romrcPath=self.options["romrcdir"]
	else:
		self.romrcPath=RomrcPath
	if RomPath == "":
		self.romPath=self.options["rompath"]
	else:
		self.romPath=RomPath
	if ExecPath == "":
		self.execPath = self.gui_opts["exec_path"]
	else:
		self.execPath = ExecPath
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,380);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 10)
	grid.setColumnStretch(2, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
        self.pushBiosButton = QPushButton(self.biosPath,self)
        self.pushBiosButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("BIOS"), 1, 0 )
	grid.addWidget(self.pushBiosButton, 1, 1)
	# romrc path
	self.pushRomrcButton = QPushButton(self.romrcPath,self)
        self.pushRomrcButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("romrc"), 2, 0)
	grid.addWidget(self.pushRomrcButton, 2, 1)
	# rom path
	self.pushRomButton = QPushButton(self.romPath,self)
        self.pushRomButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms"), 3, 0)
	grid.addWidget(self.pushRomButton, 3, 1)
	# exec path
	self.pushExecButton = QPushButton(self.execPath,self)
        self.pushExecButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("GnGeo"), 4, 0)
	grid.addWidget(self.pushExecButton, 4, 1)

	self.setLayout(grid)

	QObject.connect(self.pushBiosButton
		, SIGNAL("clicked()")
		, self.on_bios_button_clicked)
	QObject.connect(self.pushRomrcButton
		, SIGNAL("clicked()")
		, self.on_romrc_button_clicked)
	QObject.connect(self.pushRomButton
		, SIGNAL("clicked()")
		, self.on_rom_button_clicked)
	QObject.connect(self.pushExecButton
		, SIGNAL("clicked()")
		, self.on_exec_button_clicked)


    def on_bios_button_clicked(self):
	global BiosPath
	BiosPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(BiosPath + "/sfix.sfx")) and (BiosPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + BiosPath)
	self.close()

    def on_romrc_button_clicked(self):
	global RomrcPath
	RomrcPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(RomrcPath + "/kof96.rc")) and (RomrcPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + RomrcPath + "/*.rc files")
	self.close()
    def on_rom_button_clicked(self):
        d = QDialog(self)

        vbox = QVBoxLayout()
        #Add Layouts
        horizontalLayout = QHBoxLayout()

        # Now create your buttons.
        homeButton = QPushButton("internal")
        rootButton = QPushButton("SD card")
        closeButton = QPushButton("Close")
        # Add buttons to your layouts, they'll show up in the order given.
        horizontalLayout.addWidget(homeButton)
        horizontalLayout.addWidget(rootButton)
        horizontalLayout.addWidget(closeButton)
        # Add layouts to your main Layout
        vbox.addLayout (horizontalLayout)
        d.setLayout(vbox)
        d.setWindowTitle("Choose roms location...")

	# Show the window!
        d.show()
        QObject.connect(homeButton
                , SIGNAL("clicked()")
                , self.on_rom_homebutton_clicked)
        QObject.connect(rootButton
                , SIGNAL("clicked()")
                , self.on_rom_rootbutton_clicked)
        QObject.connect(closeButton
                , SIGNAL("clicked()")
                , d.close)

    def on_rom_homebutton_clicked(self):
        global RomPath
        RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
        self.close()
        os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
                   /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
                   string:"Use SAVE button to save it!"')

    def on_rom_rootbutton_clicked(self):
        global RomPath
        RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/media')
        self.close()
        os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
                   /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
                   string:"Use SAVE button to save it!"')

    def on_exec_button_clicked(self):
	global ExecPath
	ExecPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home/')
	if (not os.path.isfile(ExecPath + "/gngeo")) and (ExecPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + ExecPath + "/gngeo")
	self.close()

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow()
    ui.show()
    sys.exit(app.exec_())
