import os
import sys
import time
from PySide.QtCore import *
from PySide.QtGui import *

# Some global variables
CommentChar = '#'
OptionChar =  ' '
Home = os.path.expanduser("~")
GnGeo_CfgFile = Home + '/.gngeo/gngeorc'
GnGeoGui_CfgFile = Home + '/.gngeo-gui/gngeo-gui.cfg'
GnGeoGui_LogFile = Home + '/.gngeo-gui/gngeo-output.log'
P1buttons = ""
P2buttons = ""
P1joybuttons = ""
P2joybuttons = ""
BiosPath = ""
RomrcPath = ""
RomPath = ""
ExecPath = ""

def parse_config(self, filename):
        options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if CommentChar in line:
                # split on comment char, keep only the part before
                line, comment = line.split(CommentChar, 1)
            # Second, find lines with an option=value:
            if OptionChar in line:
                 # split on option char:
                 option, value = line.split(OptionChar, 1)
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 options[option] = value
        f.close()
        return options


class Ui_MainWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self, None)
        self.setWindowTitle("GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
	'''
	Check for required files
	'''
        self.gui_opts = parse_config(self,GnGeoGui_CfgFile)
	if not "exec_path" in self.gui_opts:
		QMessageBox.critical(self, "Critical",  "exec_path not set in '" + GnGeoGui_CfgFile + "'")
    		sys.exit()
	if not os.path.isfile(self.gui_opts["exec_path"] + "/gngeo"):
		QMessageBox.critical(self, "Critical",  "'" + self.gui_opts["exec_path"] + "/gngeo' not found!")
        	widget = pathWindow(self)
		widget.show()
	try:
	        open(GnGeo_CfgFile ,"r")
	except:
		QMessageBox.critical(self, "Critical", "Config file '" + GnGeo_CfgFile + "' not readable!")
    		sys.exit()
	global AboutGnGeo
	VersionGnGeo = self.gui_opts["exec_path"] + "/gngeo --version" 
	fin,fout = os.popen4(VersionGnGeo)
	AboutGnGeo = fout.read()
	AboutGnGeo = "Using " + AboutGnGeo.replace('\n','<br>')
	# Load config
        self.options = parse_config(self,GnGeo_CfgFile)
	myPaths = [ "rompath", "biospath", "romrcdir" ]
	for myPath in myPaths:
		if not os.path.isdir(self.options[myPath]):
			QMessageBox.critical(self, "Critical",  myPath + " '" + self.options[myPath] + "' not found!")
        		widget = pathWindow(self)
			widget.show()
	if not (os.path.exists(self.options["biospath"] + "/sfix.sfx")) \
	and not (os.path.exists(self.options["biospath"] + "/sfix.sfix")):
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + self.options["biospath"])
	if not os.path.exists(self.options["romrcdir"] + "/kof96.rc"):
		QMessageBox.critical(self, "Warning",  "Cannot find romrc files in " + self.options["romrcdir"])
	# Set background image
        backgroundLabel = QLabel(self)
        AboutTxt = "<img src=/opt/gngeo-gui/neogeo_background.png />" 
        backgroundLabel.setText(AboutTxt)
	backgroundLabel.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(backgroundLabel)
	# Get Gametitles from rompath
	ListCmd = self.gui_opts["exec_path"] + "/gngeo --scandir=" + self.options["rompath"] 
	fin,fout = os.popen4(ListCmd)
	romList = fout.read()
	romList = romList.replace('\n',':\n')
	romList = romList.split(':')
	# Remove header in romlist
	romList = romList[3:-1]
	if not romList:
		Games = "No roms found!"
	else:
		Games = ""
	Teller = 1
	GameFile = ""
	for Item in romList:
		if Item[0] != "\n":
			if Teller == 0:
				GameFile = GameFile + Item + ":"
				Teller = 1
			else:
				Games = Games + Item + ":"
				Teller = 0
	# Remove the last ":"
	Games = Games[:-1]
	GameFile = GameFile[:-1]
	Games = Games.split(":")
	self.GameFile = GameFile.split(":")
        self.combo = QComboBox(self)
        self.combo.setStyleSheet( \
	"QComboBox { color: gray; \
	 border: 6px solid #045FB4; \
	 border-radius: 3px; \
	 min-width: 6em; \
	 }" )
	self.combo.setGeometry(QRect(170, 230, 450, 60))
	for Game in Games:
        	self.combo.addItem(Game)

	# Define menubar
	aboutAction = QAction( '&About', self)
        aboutAction.triggered.connect(self.slotAbout)
	configAction = QAction( '&Config', self)
        configAction.triggered.connect(self.slotConfig)

        menubar = self.menuBar()
        fileMenu = menubar.addMenu('&MainMenu')
        fileMenu.addAction(configAction)
        fileMenu.addAction(aboutAction)

        self.startButton = QPushButton("Start",self)
        self.startButton.setGeometry(QRect(0, 370, 400, 55))
        font = QFont()
        font.setPointSize(24)
        self.startButton.setFont(font)
	QObject.connect(self.startButton
		, SIGNAL("clicked()")
		, self.on_start_clicked)

        self.onesmutePushButton = QPushButton("Mute",self)
	self.onesmutePushButton.setCheckable(True)
        self.onesmutePushButton.setGeometry(QRect(400, 370, 400, 55))
        self.onesmutePushButton.setFont(font)
	if self.options["sound"] == "true":
            self.onesmutePushButton.setChecked(False)
	else:
            self.onesmutePushButton.setChecked(True)

	self.logMsg = QLabel(self)
      	self.logMsg.setStyleSheet( \
	"QLabel { background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, \
         stop: 0 #bbb, stop: 0.1 #999, stop: 0.49 #444, stop: 0.5 #666, stop: 1 #444); \
         font-size: 20px; font-family: monospace; font-weight: bold;}" \
      	) 
	self.logMsg.setGeometry(0, 350, 800, 20)


    def on_start_clicked(self):
	gameNbr = self.combo.currentIndex()
	self.gameFile = self.GameFile[gameNbr]
	global MyTeller
	global regel

        if self.onesmutePushButton.isChecked():
		SOUND_OPT=" --no-sound "
        else:  SOUND_OPT=" --sound "

	if self.gameFile:
		QProcess.startDetached(self.gui_opts["exec_path"]+"/gngeo "+SOUND_OPT+self.options["rompath"]+'/'+self.gameFile)
		time.sleep(0.1)    # Sleep briefly
		file = open(GnGeoGui_LogFile,'r')
		self.MyTeller = 0
		def follow(thefile):
			    thefile.seek(0,1)      # Go to the end of the file
			    while True:
			         line = thefile.readline()
			         if not line:
				     self.MyTeller = self.MyTeller + 1
			             time.sleep(0.1)    # Sleep briefly
			             continue
			         yield line

		loglines = follow(file)
		for line in loglines:
		    if '\r' in line:
			line = line.strip('\n')
			line = line.replace('\r','\n')
			lines = line.split('\n')
			for subline in lines:
				regel = subline
				self.logMsg.setText(regel)
				# Keep the app responsive in this loop
				QCoreApplication.processEvents()
			#print >> sys.stderr,line
		    if (self.MyTeller > 90) or (self.MyTeller == 0) or ("Convert" in line):
			file.close()
			open(GnGeoGui_LogFile, 'w').close()
			break

	if (self.gui_opts["exit_after_launch"] == "true"):
		time.sleep(5)
		os._exit(0)

    def slotAbout(self):
        a = AboutWindow(self)
        a.show()

    def slotConfig(self):
        a = ConfigWindow(self)
        a.show()

    def slotJoyconf(self):
        a = JoyconfWindow(self)
        a.show()

class AboutWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("About GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.label = QLabel(self)
        AboutTxt = "<h3>Gngeo-gui 0.0.5-6</h3><p>" \
                   "<img src=/opt/usr/share/icons/hicolor/64x64/apps/gngeo_gui.png /><br>" \
                   "GnGeo-gui is a Graphical User Interface for GnGeo<p> " \
                   "GnGeo emulates the NeoGeo gameconsole from SNK &#174;</p>" \
                   "<p>GnGeo-gui is written in PySide by <i>Arno Dekker</i> 2011<p>"
	AboutTxt = AboutTxt + AboutGnGeo
        self.label.setText(AboutTxt)
	self.label.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(self.label)

class ConfigWindow(QMainWindow):
    def __init__(self,parent):
        QMainWindow.__init__(self,parent)
        self.setWindowTitle("Configuration GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
	area = QScrollArea()
	lay = QVBoxLayout()
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	self.setCentralWidget(area)
	wg.resize(790,660);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
        self.options = parse_config(self,GnGeo_CfgFile)
        self.gui_opts = parse_config(self,GnGeoGui_CfgFile)
        font = QFont()
        font.setPointSize(20)
	self.setLayout(grid)
	# showfps
        self.showfpsPushButton = QPushButton("Showfps",self)
	self.showfpsPushButton.setCheckable(True)
        grid.addWidget(self.showfpsPushButton,1,1)
        self.showfpsPushButton.setFont(font)
	if self.options["showfps"] == "true":
            self.showfpsPushButton.setChecked(True)
	# fullscreen
        self.fullscreenPushButton = QPushButton("Fullscreen",self)
	self.fullscreenPushButton.setCheckable(True)
        grid.addWidget(self.fullscreenPushButton,1,2)
        self.fullscreenPushButton.setFont(font)
	if self.options["fullscreen"] == "true":
            self.fullscreenPushButton.setChecked(True)
	# sound
        self.soundPushButton = QPushButton("Sound",self)
	self.soundPushButton.setCheckable(True)
        grid.addWidget(self.soundPushButton,1,3)
        self.soundPushButton.setFont(font)
	if self.options["sound"] == "true":
            self.soundPushButton.setChecked(True)
	# autoframeskip
        self.autoframePushButton = QPushButton("Autoframeskip",self)
	self.autoframePushButton.setCheckable(True)
        grid.addWidget(self.autoframePushButton,2,1)
        self.autoframePushButton.setFont(font)
	if self.options["autoframeskip"] == "true":
            self.autoframePushButton.setChecked(True)
	# raster
        self.rasterPushButton = QPushButton("Raster",self)
	self.rasterPushButton.setCheckable(True)
        grid.addWidget(self.rasterPushButton,2,2)
        self.rasterPushButton.setFont(font)
	if self.options["raster"] == "true":
            self.rasterPushButton.setChecked(True)
	# interpolation
        self.interpolationPushButton = QPushButton("Interpolation",self)
	self.interpolationPushButton.setCheckable(True)
        grid.addWidget(self.interpolationPushButton,2,3)
        self.interpolationPushButton.setFont(font)
	if self.options["interpolation"] == "true":
            self.interpolationPushButton.setChecked(True)
	# sleepidle
        self.sleepidlePushButton = QPushButton("Sleepidle",self)
	self.sleepidlePushButton.setCheckable(True)
        grid.addWidget(self.sleepidlePushButton,3,1)
        self.sleepidlePushButton.setFont(font)
	if self.options["sleepidle"] == "true":
            self.sleepidlePushButton.setChecked(True)
	# hwsurface
        self.hwsurfacePushButton = QPushButton("Hwsurface",self)
	self.hwsurfacePushButton.setCheckable(True)
        grid.addWidget(self.hwsurfacePushButton,3,2)
        self.hwsurfacePushButton.setFont(font)
	if self.options["hwsurface"] == "true":
            self.hwsurfacePushButton.setChecked(True)
	# joystick
        self.joystickPushButton = QPushButton("Joystick",self)
	self.joystickPushButton.setCheckable(True)
        grid.addWidget(self.joystickPushButton,3,3)
        self.joystickPushButton.setFont(font)
	if self.options["joystick"] == "true":
		self.joystickPushButton.setChecked(True)
	# system
	grid.addWidget(QLabel("<center>system:</center>"), 4, 1)
        self.comboSystem = QComboBox(self)
        grid.addWidget(self.comboSystem,5,1)
	systems = self.listDefaultFirst("system",['arcade','home','unibios'])
	for sysType in systems:
			if sysType == 'unibios':
				if os.path.exists(self.options["biospath"] + "/uni-bios.rom"):
       			 		self.comboSystem.addItem('unibios')
			else:
	       		 	self.comboSystem.addItem(sysType)
	# country
	grid.addWidget(QLabel("<center>region:</center>"), 4, 2)
        self.comboCountry = QComboBox(self)
        grid.addWidget(self.comboCountry,5,2)
	countries = self.listDefaultFirst("country",['japan', 'usa', 'europe'])
	for Location in countries:
       		 	self.comboCountry.addItem(Location)
	# effect
	grid.addWidget(QLabel("<center>effect:</center>"), 4, 3)
        self.comboEffect = QComboBox(self)
        grid.addWidget(self.comboEffect,5,3)
	effects = self.listDefaultFirst("effect",['none', 'scanline', 'scanline50', 'scale2x', 'scale3x', 'scale4x', 'scale2x50', 'scale2x75', 'hq2x', 'hq3x', 'lq2x', 'lq3x', 'doublex'])
	for effect in effects:
		self.comboEffect.addItem(effect)
	# Samplerate
	grid.addWidget(QLabel("<center>sound rate:</center>"), 6, 1)
        self.comboSampleRate = QComboBox(self)
        grid.addWidget(self.comboSampleRate,7,1)
	Sam_Rates = self.listDefaultFirst("samplerate",['8192','11025','22050','32000','44100','48000'])
	for SampRate in Sam_Rates:
		self.comboSampleRate.addItem(SampRate)
	# Z80 CPU clock
	grid.addWidget(QLabel("<center>Z80 CPU clock:</center>"), 6, 2)
	self.Z80SpinBox = QDoubleSpinBox()
	self.Z80SpinBox.setRange(-80,80)
	self.Z80SpinBox.setAlignment(Qt.AlignCenter)
	self.Z80SpinBox.setValue(float(self.options["z80clock"]))
	self.Z80SpinBox.setDecimals(0)
	self.Z80SpinBox.setSuffix(" %")
	grid.addWidget(self.Z80SpinBox, 7,2)
	# 68K CPU clock
	grid.addWidget(QLabel("<center>68K CPU clock:</center>"), 6, 3)
	self.M68KSpinBox = QDoubleSpinBox()
	self.M68KSpinBox.setRange(-80,80)
	self.M68KSpinBox.setAlignment(Qt.AlignCenter)
	self.M68KSpinBox.setValue(float(self.options["68kclock"]))
	self.M68KSpinBox.setDecimals(0)
	self.M68KSpinBox.setSuffix(" %")
	grid.addWidget(self.M68KSpinBox, 7,3)
	# Joystick device P1 (/dev/input/js?)
	grid.addWidget(QLabel("<center>P1 joystick device:</center>"), 8,1)
        self.comboJoyp1dev = QComboBox(self)
        grid.addWidget(self.comboJoyp1dev,9,1)
	JoyP1devs = self.listDefaultFirst("p1joydev",['0', '1', '2', '3'])
	for JoyP1dev in JoyP1devs:
       		self.comboJoyp1dev.addItem(JoyP1dev)
	# Joystick device P2 (/dev/input/js?)
	grid.addWidget(QLabel("<center>P2 joystick device:</center>"), 8,2)
        self.comboJoyp2dev = QComboBox(self)
        grid.addWidget(self.comboJoyp2dev,9,2)
	JoyP2devs = self.listDefaultFirst("p2joydev",['0', '1', '2', '3'])
	for JoyP2dev in JoyP2devs:
       		self.comboJoyp2dev.addItem(JoyP2dev)
        # Exit on start button
        self.exitPushButton = QPushButton("exit after start game",self)
	self.exitPushButton.setCheckable(True)
        grid.addWidget(self.exitPushButton,9,3)
	if self.gui_opts["exit_after_launch"] == "true":
		self.exitPushButton.setChecked(True)
	# Path button
        self.pathButton = QPushButton("paths def",self)
        self.pathButton.setFont(font)
        grid.addWidget(self.pathButton,10,1)
	QObject.connect(self.pathButton
		, SIGNAL("clicked()")
		, self.on_paths_clicked)
	# Keys button
        self.keysButton = QPushButton("key def",self)
        self.keysButton.setFont(font)
        grid.addWidget(self.keysButton,10,2)
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_keys_clicked)
	# Joystick config
        self.joyconfButton = QPushButton("joystick def",self)
        self.joyconfButton.setFont(font)
        grid.addWidget(self.joyconfButton,10,3)
	QObject.connect(self.joyconfButton
		, SIGNAL("clicked()")
		, self.on_defjoy_clicked)
	# Save button
        self.saveButton = QPushButton("SAVE",self)
        self.saveButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
        self.saveButton.setFont(font)
        grid.addWidget(self.saveButton,12,1,1,3)
	QObject.connect(self.saveButton
		, SIGNAL("clicked()")
		, self.on_save_clicked)


    def on_save_clicked(self):
        if self.soundPushButton.isChecked():
           self.options["sound"] = "true"
        else: self.options["sound"] = "false" 
        if self.showfpsPushButton.isChecked():
           self.options["showfps"] = "true"
        else: self.options["showfps"] = "false" 
        if self.fullscreenPushButton.isChecked():
           self.options["fullscreen"] = "true"
        else: self.options["fullscreen"] = "false" 
        if self.autoframePushButton.isChecked():
           self.options["autoframeskip"] = "true"
        else: self.options["autoframeskip"] = "false" 
        if self.rasterPushButton.isChecked():
           self.options["raster"] = "true"
        else: self.options["raster"] = "false" 
        if self.interpolationPushButton.isChecked():
           self.options["interpolation"] = "true"
        else: self.options["interpolation"] = "false" 
        if self.sleepidlePushButton.isChecked():
           self.options["sleepidle"] = "true"
        else: self.options["sleepidle"] = "false" 
        if self.hwsurfacePushButton.isChecked():
           self.options["hwsurface"] = "true"
        else: self.options["hwsurface"] = "false" 
        if self.joystickPushButton.isChecked():
           self.options["joystick"] = "true"
        else: self.options["joystick"] = "false" 
        if self.exitPushButton.isChecked():
           doExit = "true"
        else: doExit = "false" 
	self.options["68kclock"] = "%.0f" % self.M68KSpinBox.value()
	self.options["z80clock"] = "%.0f" % self.Z80SpinBox.value()
	self.options["system"] = self.comboSystem.currentText()
	self.options["country"] = self.comboCountry.currentText()
	self.options["effect"] = self.comboEffect.currentText()
	self.options["samplerate"] = self.comboSampleRate.currentText()
	self.options["p1joydev"] = self.comboJoyp1dev.currentText()
	self.options["p2joydev"] = self.comboJoyp2dev.currentText()
	if BiosPath != "":
		self.options["biospath"] = BiosPath
	if RomrcPath != "":
		self.options["romrcdir"] = RomrcPath
	if RomPath != "":
		self.options["rompath"] = RomPath
	if P1buttons != "":
		tot_sleutel=""
		for sleutel in P1buttons:
			tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1key"] = tot_sleutel

	if P2buttons != "":
		tot_sleutel=""
		for sleutel in P2buttons:
			tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2key"] = tot_sleutel

	if P1joybuttons != "":
		tot_sleutel=""
		for sleutel in P1joybuttons:
			tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1joy"] = tot_sleutel

	if P2joybuttons != "":
		tot_sleutel=""
		for sleutel in P2joybuttons:
			tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2joy"] = tot_sleutel

	if (ExecPath != "") or ((doExit == "true") and (self.gui_opts["exit_after_launch"] == "false")) or ((doExit == "false") and (self.gui_opts["exit_after_launch"] == "true")):
		# Change in gngeo-gui config, we need to save it
		try:
			ConfigFile = open(GnGeoGui_CfgFile,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GnGeoGui_CfgFile)
		else:
			ConfigFile.write("# Generated by gngeo-gui\n")
			if ExecPath != "":
				ConfigFile.write("exec_path" + " " + ExecPath + "\n")
			else:
				ConfigFile.write("exec_path" + " " + self.gui_opts["exec_path"] + "\n")
			ConfigFile.write("exit_after_launch" + " " + doExit + "\n")
			ConfigFile.close()

        orgConfigFile = open(GnGeo_CfgFile,"r")
	try:
	        copyFile = open(GnGeo_CfgFile + ".old" ,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + GnGeo_CfgFile + ".old")
	else:
		for line in orgConfigFile.readlines():
			copyFile.write(line)
		orgConfigFile.close()
		copyFile.close()
		try:
			newConfigFile = open(GnGeo_CfgFile,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GnGeo_CfgFile)
		else:
			newConfigFile.write("# Generated by gngeo-gui\n")
			for option in self.options:
				newConfigFile.write(option + " " + self.options[option] + "\n")
			newConfigFile.close()
                        os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
                        /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
                        string:"Configuration is succesfully saved"')

    def listDefaultFirst(self, optVal,List):
	Position = List.index(self.options[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def on_keys_clicked(self):
        widget = keyWindow(self)
        widget.show()

    def on_paths_clicked(self):
        widget = pathWindow(self)
        widget.show()
	
    def on_defjoy_clicked(self):
        widget = JoykeyWindow(self)
        widget.show()

class keyWindow(QDialog):
    def __init__(self, parent=None):
        super(keyWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui button config")
	# order : A,B,C,D,START,COIN,UP,DOWN,LEFT,RIGHT
	if P1buttons == "":
        	self.options = parse_config(self,GnGeo_CfgFile)
		self.P1Keys=self.options["p1key"].split(",")
	else:
		self.P1Keys = P1buttons
	if P2buttons == "":
        	self.options = parse_config(self,GnGeo_CfgFile)
		self.P2Keys=self.options["p2key"].split(",")
	else:
		self.P2Keys = P2buttons
	# P1 keys
	P1Akey=self.P1Keys[0]
	P1Bkey=self.P1Keys[1]
	P1Ckey=self.P1Keys[2]
	P1Dkey=self.P1Keys[3]
	P1Startkey=self.P1Keys[4]
	P1Coinkey=self.P1Keys[5]
	P1Upkey=self.P1Keys[6]
	P1Downkey=self.P1Keys[7]
	P1Leftkey=self.P1Keys[8]
	P1Rightkey=self.P1Keys[9]
	# P2 keys
	P2Akey=self.P2Keys[0]
	P2Bkey=self.P2Keys[1]
	P2Ckey=self.P2Keys[2]
	P2Dkey=self.P2Keys[3]
	P2Startkey=self.P2Keys[4]
	P2Coinkey=self.P2Keys[5]
	P2Upkey=self.P2Keys[6]
	P2Downkey=self.P2Keys[7]
	P2Leftkey=self.P2Keys[8]
	P2Rightkey=self.P2Keys[9]
	# Layout
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.resize(750,900);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	minKeyValue=1
	maxKeyValue=307
	grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
	grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
	grid.addWidget(QLabel("<center>PLAYER 2</center>"), 1, 3)
	grid.addWidget(QLabel("<center>[pick]</center>"), 1, 4)
	# Add button list
        cntr=2
	for pButton in ['A','B','C','D','START','COIN','UP','DOWN','LEFT','RIGHT']:
		grid.addWidget(QLabel(pButton), cntr, 0)
		cntr=cntr+1
	# A-button P1
	self.P1AkeySpinBox = QDoubleSpinBox()
	self.P1AkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1AkeySpinBox.setValue(float(P1Akey))
	self.P1AkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1AkeySpinBox, 2, 1)
	self.P1AButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1AButton, 2, 2)
	# A-button P2
	self.P2AkeySpinBox = QDoubleSpinBox()
	self.P2AkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2AkeySpinBox.setValue(float(P2Akey))
	self.P2AkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2AkeySpinBox, 2, 3)
	self.P2AButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2AButton, 2, 4)
	# B-button P1
	self.P1BkeySpinBox = QDoubleSpinBox()
	self.P1BkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1BkeySpinBox.setValue(float(P1Bkey))
	self.P1BkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1BkeySpinBox, 3, 1)
	self.P1BButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1BButton, 3, 2)
	# B-button P2
	self.P2BkeySpinBox = QDoubleSpinBox()
	self.P2BkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2BkeySpinBox.setValue(float(P2Bkey))
	self.P2BkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2BkeySpinBox, 3, 3)
	self.P2BButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2BButton, 3, 4)
	# C-button P1
	self.P1CkeySpinBox = QDoubleSpinBox()
	self.P1CkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CkeySpinBox.setValue(float(P1Ckey))
	self.P1CkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CkeySpinBox, 4, 1)
	self.P1CButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1CButton, 4, 2)
	# C-button P2
	self.P2CkeySpinBox = QDoubleSpinBox()
	self.P2CkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CkeySpinBox.setValue(float(P2Ckey))
	self.P2CkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CkeySpinBox, 4, 3)
	self.P2CButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2CButton, 4, 4)
	# D-button P1
	self.P1DkeySpinBox = QDoubleSpinBox()
	self.P1DkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DkeySpinBox.setValue(float(P1Dkey))
	self.P1DkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DkeySpinBox, 5, 1)
	self.P1DButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1DButton, 5, 2)
	# D-button P2
	self.P2DkeySpinBox = QDoubleSpinBox()
	self.P2DkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DkeySpinBox.setValue(float(P2Dkey))
	self.P2DkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DkeySpinBox, 5, 3)
	self.P2DButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2DButton, 5, 4)
	# Start-button P1
	self.P1StartkeySpinBox = QDoubleSpinBox()
	self.P1StartkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1StartkeySpinBox.setValue(float(P1Startkey))
	self.P1StartkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1StartkeySpinBox, 6, 1)
	self.P1StartButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1StartButton, 6, 2)
	# Start-button P2
	self.P2StartkeySpinBox = QDoubleSpinBox()
	self.P2StartkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2StartkeySpinBox.setValue(float(P2Startkey))
	self.P2StartkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2StartkeySpinBox, 6, 3)
	self.P2StartButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2StartButton, 6, 4)
	# Coin-button P1
	self.P1CoinkeySpinBox = QDoubleSpinBox()
	self.P1CoinkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CoinkeySpinBox.setValue(float(P1Coinkey))
	self.P1CoinkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CoinkeySpinBox, 7, 1)
	self.P1CoinButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1CoinButton, 7, 2)
	# Coin-button P2
	self.P2CoinkeySpinBox = QDoubleSpinBox()
	self.P2CoinkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CoinkeySpinBox.setValue(float(P2Coinkey))
	self.P2CoinkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CoinkeySpinBox, 7, 3)
	self.P2CoinButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2CoinButton, 7, 4)
	# Up-key P1
	self.P1UpkeySpinBox = QDoubleSpinBox()
	self.P1UpkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1UpkeySpinBox.setValue(float(P1Upkey))
	self.P1UpkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1UpkeySpinBox, 8, 1)
	self.P1UpButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1UpButton, 8, 2)
	# Up-key P2
	self.P2UpkeySpinBox = QDoubleSpinBox()
	self.P2UpkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2UpkeySpinBox.setValue(float(P2Upkey))
	self.P2UpkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2UpkeySpinBox, 8, 3)
	self.P2UpButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2UpButton, 8, 4)
	# Down-key P1
	self.P1DownkeySpinBox = QDoubleSpinBox()
	self.P1DownkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DownkeySpinBox.setValue(float(P1Downkey))
	self.P1DownkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DownkeySpinBox, 9, 1)
	self.P1DownButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1DownButton, 9, 2)
	# Down-key P2
	self.P2DownkeySpinBox = QDoubleSpinBox()
	self.P2DownkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DownkeySpinBox.setValue(float(P2Downkey))
	self.P2DownkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DownkeySpinBox, 9, 3)
	self.P2DownButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2DownButton, 9, 4)
	# Left-key P1
	self.P1LeftkeySpinBox = QDoubleSpinBox()
	self.P1LeftkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1LeftkeySpinBox.setValue(float(P1Leftkey))
	self.P1LeftkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1LeftkeySpinBox, 10, 1)
	self.P1LeftButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1LeftButton, 10, 2)
	# Left-key P2
	self.P2LeftkeySpinBox = QDoubleSpinBox()
	self.P2LeftkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2LeftkeySpinBox.setValue(float(P2Leftkey))
	self.P2LeftkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2LeftkeySpinBox, 10, 3)
	self.P2LeftButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2LeftButton, 10, 4)
	# Right-key P1
	self.P1RightkeySpinBox = QDoubleSpinBox()
	self.P1RightkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1RightkeySpinBox.setValue(float(P1Rightkey))
	self.P1RightkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1RightkeySpinBox, 11, 1)
	self.P1RightButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1RightButton, 11, 2)
	# Right-key P1
	self.P2RightkeySpinBox = QDoubleSpinBox()
	self.P2RightkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2RightkeySpinBox.setValue(float(P2Rightkey))
	self.P2RightkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2RightkeySpinBox, 11, 3)
	self.P2RightButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2RightButton, 11, 4)

	self.setLayout(grid)
	# P1
	self.connect(self.P1AkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1BkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1CkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1DkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1StartkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1CoinkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1RightButton, SIGNAL("keyPressed"),self.P1updateRight)
        self.connect(self.P1LeftButton, SIGNAL("keyPressed"),self.P1updateLeft)
        self.connect(self.P1DownButton, SIGNAL("keyPressed"),self.P1updateDown)
        self.connect(self.P1UpButton, SIGNAL("keyPressed"),self.P1updateUp)
        self.connect(self.P1CoinButton, SIGNAL("keyPressed"),self.P1updateCoin)
        self.connect(self.P1StartButton, SIGNAL("keyPressed"),self.P1updateStart)
        self.connect(self.P1AButton, SIGNAL("keyPressed"),self.P1updateA)
        self.connect(self.P1BButton, SIGNAL("keyPressed"),self.P1updateB)
        self.connect(self.P1CButton, SIGNAL("keyPressed"),self.P1updateC)
        self.connect(self.P1DButton, SIGNAL("keyPressed"),self.P1updateD)
	# P2
	self.connect(self.P2AkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2BkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2CkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2DkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2StartkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2CoinkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P2RightButton, SIGNAL("keyPressed"),self.P2updateRight)
        self.connect(self.P2LeftButton, SIGNAL("keyPressed"),self.P2updateLeft)
        self.connect(self.P2DownButton, SIGNAL("keyPressed"),self.P2updateDown)
        self.connect(self.P2UpButton, SIGNAL("keyPressed"),self.P2updateUp)
        self.connect(self.P2CoinButton, SIGNAL("keyPressed"),self.P2updateCoin)
        self.connect(self.P2StartButton, SIGNAL("keyPressed"),self.P2updateStart)
        self.connect(self.P2AButton, SIGNAL("keyPressed"),self.P2updateA)
        self.connect(self.P2BButton, SIGNAL("keyPressed"),self.P2updateB)
        self.connect(self.P2CButton, SIGNAL("keyPressed"),self.P2updateC)
        self.connect(self.P2DButton, SIGNAL("keyPressed"),self.P2updateD)

	# P1
    def P1updateRight(self):
	self.P1RightkeySpinBox.setValue(float(AsciiVal))
    def P1updateLeft(self):
	self.P1LeftkeySpinBox.setValue(float(AsciiVal))
    def P1updateUp(self):
	self.P1UpkeySpinBox.setValue(float(AsciiVal))
    def P1updateDown(self):
	self.P1DownkeySpinBox.setValue(float(AsciiVal))
    def P1updateStart(self):
	self.P1StartkeySpinBox.setValue(float(AsciiVal))
    def P1updateCoin(self):
	self.P1CoinkeySpinBox.setValue(float(AsciiVal))
    def P1updateA(self):
	self.P1AkeySpinBox.setValue(float(AsciiVal))
    def P1updateB(self):
	self.P1BkeySpinBox.setValue(float(AsciiVal))
    def P1updateC(self):
	self.P1CkeySpinBox.setValue(float(AsciiVal))
    def P1updateD(self):
	self.P1DkeySpinBox.setValue(float(AsciiVal))
	# P2
    def P2updateRight(self):
	self.P2RightkeySpinBox.setValue(float(AsciiVal))
    def P2updateLeft(self):
	self.P2LeftkeySpinBox.setValue(float(AsciiVal))
    def P2updateUp(self):
	self.P2UpkeySpinBox.setValue(float(AsciiVal))
    def P2updateDown(self):
	self.P2DownkeySpinBox.setValue(float(AsciiVal))
    def P2updateStart(self):
	self.P2StartkeySpinBox.setValue(float(AsciiVal))
    def P2updateCoin(self):
	self.P2CoinkeySpinBox.setValue(float(AsciiVal))
    def P2updateA(self):
	self.P2AkeySpinBox.setValue(float(AsciiVal))
    def P2updateB(self):
	self.P2BkeySpinBox.setValue(float(AsciiVal))
    def P2updateC(self):
	self.P2CkeySpinBox.setValue(float(AsciiVal))
    def P2updateD(self):
	self.P2DkeySpinBox.setValue(float(AsciiVal))

    def change_value(self,event):
	# P1
	self.P1Keys[0] = "%.0f" % self.P1AkeySpinBox.value()
	self.P1Keys[1] = "%.0f" % self.P1BkeySpinBox.value()
	self.P1Keys[2] = "%.0f" % self.P1CkeySpinBox.value()
	self.P1Keys[3] = "%.0f" % self.P1DkeySpinBox.value()
	self.P1Keys[4] = "%.0f" % self.P1StartkeySpinBox.value()
	self.P1Keys[5] = "%.0f" % self.P1CoinkeySpinBox.value()
	self.P1Keys[6] = "%.0f" % self.P1UpkeySpinBox.value()
	self.P1Keys[7] = "%.0f" % self.P1DownkeySpinBox.value()
	self.P1Keys[8] = "%.0f" % self.P1LeftkeySpinBox.value()
	self.P1Keys[9] = "%.0f" % self.P1RightkeySpinBox.value()
	# P2
	self.P2Keys[0] = "%.0f" % self.P2AkeySpinBox.value()
	self.P2Keys[1] = "%.0f" % self.P2BkeySpinBox.value()
	self.P2Keys[2] = "%.0f" % self.P2CkeySpinBox.value()
	self.P2Keys[3] = "%.0f" % self.P2DkeySpinBox.value()
	self.P2Keys[4] = "%.0f" % self.P2StartkeySpinBox.value()
	self.P2Keys[5] = "%.0f" % self.P2CoinkeySpinBox.value()
	self.P2Keys[6] = "%.0f" % self.P2UpkeySpinBox.value()
	self.P2Keys[7] = "%.0f" % self.P2DownkeySpinBox.value()
	self.P2Keys[8] = "%.0f" % self.P2LeftkeySpinBox.value()
	self.P2Keys[9] = "%.0f" % self.P2RightkeySpinBox.value()
	global P1buttons
	global P2buttons
	P1buttons = self.P1Keys
	P2buttons = self.P2Keys

class JoykeyWindow(QDialog):
    def __init__(self, parent=None):
        super(JoykeyWindow, self).__init__(parent)
	joystickAttached = os.path.exists("/dev/input/js0")
	if (joystickAttached):
        	self.setWindowTitle("GnGeo-gui joystick config")
	else:
        	self.setWindowTitle("Gngeo-gui joystick config (no USB joystick found)")
	# order : A,B,C,D,START,COIN,UP,DOWN,LEFT,RIGHT
	if P1joybuttons == "":
        	self.options = parse_config(self,GnGeo_CfgFile)
		self.P1joyKeys=self.options["p1joy"].split(",")
	else:
		self.P1joyKeys = P1joybuttons
	if P2joybuttons == "":
        	self.options = parse_config(self,GnGeo_CfgFile)
		self.P2joyKeys=self.options["p2joy"].split(",")
	else:
		self.P2joyKeys = P2joybuttons
	# P1 keys
	P1Ajoykey=self.P1joyKeys[0]
	P1Bjoykey=self.P1joyKeys[1]
	P1Cjoykey=self.P1joyKeys[2]
	P1Djoykey=self.P1joyKeys[3]
	P1Startjoykey=self.P1joyKeys[4]
	P1Coinjoykey=self.P1joyKeys[5]
	P1Upjoykey=self.P1joyKeys[6]
	P1Downjoykey=self.P1joyKeys[7]
	P1Leftjoykey=self.P1joyKeys[8]
	P1Rightjoykey=self.P1joyKeys[9]
	# P2 keys
	P2Ajoykey=self.P2joyKeys[0]
	P2Bjoykey=self.P2joyKeys[1]
	P2Cjoykey=self.P2joyKeys[2]
	P2Djoykey=self.P2joyKeys[3]
	P2Startjoykey=self.P2joyKeys[4]
	P2Coinjoykey=self.P2joyKeys[5]
	P2Upjoykey=self.P2joyKeys[6]
	P2Downjoykey=self.P2joyKeys[7]
	P2Leftjoykey=self.P2joyKeys[8]
	P2Rightjoykey=self.P2joyKeys[9]
	# Layout
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.resize(750,900);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	minKeyValue=-1
	maxKeyValue=30
	grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
	grid.addWidget(QLabel("<center>PLAYER 2</center>"), 1, 3)
	if (joystickAttached):
		grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
		grid.addWidget(QLabel("<center>[pick]</center>"), 1, 4)
	# Add button list
        cntr=2
	for pButton in ['A','B','C','D','START','COIN','UP','DOWN','LEFT','RIGHT']:
		grid.addWidget(QLabel(pButton), cntr, 0)
		cntr=cntr+1
	# A-button P1
	self.P1AjoykeySpinBox = QDoubleSpinBox()
	self.P1AjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1AjoykeySpinBox.setValue(float(P1Ajoykey))
	self.P1AjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1AjoykeySpinBox, 2, 1)
	# A-button P2
	self.P2AjoykeySpinBox = QDoubleSpinBox()
	self.P2AjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2AjoykeySpinBox.setValue(float(P2Ajoykey))
	self.P2AjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2AjoykeySpinBox, 2, 3)
	# B-button P1
	self.P1BjoykeySpinBox = QDoubleSpinBox()
	self.P1BjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1BjoykeySpinBox.setValue(float(P1Bjoykey))
	self.P1BjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1BjoykeySpinBox, 3, 1)
	# B-button P2
	self.P2BjoykeySpinBox = QDoubleSpinBox()
	self.P2BjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2BjoykeySpinBox.setValue(float(P2Bjoykey))
	self.P2BjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2BjoykeySpinBox, 3, 3)
	# C-button P1
	self.P1CjoykeySpinBox = QDoubleSpinBox()
	self.P1CjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CjoykeySpinBox.setValue(float(P1Cjoykey))
	self.P1CjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CjoykeySpinBox, 4, 1)
	# C-button P2
	self.P2CjoykeySpinBox = QDoubleSpinBox()
	self.P2CjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CjoykeySpinBox.setValue(float(P2Cjoykey))
	self.P2CjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CjoykeySpinBox, 4, 3)
	# D-button P1
	self.P1DjoykeySpinBox = QDoubleSpinBox()
	self.P1DjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DjoykeySpinBox.setValue(float(P1Djoykey))
	self.P1DjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DjoykeySpinBox, 5, 1)
	# D-button P2
	self.P2DjoykeySpinBox = QDoubleSpinBox()
	self.P2DjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DjoykeySpinBox.setValue(float(P2Djoykey))
	self.P2DjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DjoykeySpinBox, 5, 3)
	# Start-button P1
	self.P1StartjoykeySpinBox = QDoubleSpinBox()
	self.P1StartjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1StartjoykeySpinBox.setValue(float(P1Startjoykey))
	self.P1StartjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1StartjoykeySpinBox, 6, 1)
	# Start-button P2
	self.P2StartjoykeySpinBox = QDoubleSpinBox()
	self.P2StartjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2StartjoykeySpinBox.setValue(float(P2Startjoykey))
	self.P2StartjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2StartjoykeySpinBox, 6, 3)
	# Coin-button P1
	self.P1CoinjoykeySpinBox = QDoubleSpinBox()
	self.P1CoinjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CoinjoykeySpinBox.setValue(float(P1Coinjoykey))
	self.P1CoinjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CoinjoykeySpinBox, 7, 1)
	# Coin-button P2
	self.P2CoinjoykeySpinBox = QDoubleSpinBox()
	self.P2CoinjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CoinjoykeySpinBox.setValue(float(P2Coinjoykey))
	self.P2CoinjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CoinjoykeySpinBox, 7, 3)
	# Up-key P1
	self.P1UpjoykeySpinBox = QDoubleSpinBox()
	self.P1UpjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1UpjoykeySpinBox.setValue(float(P1Upjoykey))
	self.P1UpjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1UpjoykeySpinBox, 8, 1)
	# Up-key P2
	self.P2UpjoykeySpinBox = QDoubleSpinBox()
	self.P2UpjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2UpjoykeySpinBox.setValue(float(P2Upjoykey))
	self.P2UpjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2UpjoykeySpinBox, 8, 3)
	# Down-key P1
	self.P1DownjoykeySpinBox = QDoubleSpinBox()
	self.P1DownjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DownjoykeySpinBox.setValue(float(P1Downjoykey))
	self.P1DownjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DownjoykeySpinBox, 9, 1)
	# Down-key P2
	self.P2DownjoykeySpinBox = QDoubleSpinBox()
	self.P2DownjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DownjoykeySpinBox.setValue(float(P2Downjoykey))
	self.P2DownjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DownjoykeySpinBox, 9, 3)
	# Left-key P1
	self.P1LeftjoykeySpinBox = QDoubleSpinBox()
	self.P1LeftjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1LeftjoykeySpinBox.setValue(float(P1Leftjoykey))
	self.P1LeftjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1LeftjoykeySpinBox, 10, 1)
	# Left-key P2
	self.P2LeftjoykeySpinBox = QDoubleSpinBox()
	self.P2LeftjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2LeftjoykeySpinBox.setValue(float(P2Leftjoykey))
	self.P2LeftjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2LeftjoykeySpinBox, 10, 3)
	# Right-key P1
	self.P1RightjoykeySpinBox = QDoubleSpinBox()
	self.P1RightjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1RightjoykeySpinBox.setValue(float(P1Rightjoykey))
	self.P1RightjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1RightjoykeySpinBox, 11, 1)
	# Right-key P1
	self.P2RightjoykeySpinBox = QDoubleSpinBox()
	self.P2RightjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2RightjoykeySpinBox.setValue(float(P2Rightjoykey))
	self.P2RightjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2RightjoykeySpinBox, 11, 3)

	if (joystickAttached):
		self.P2AjoyButton = QPushButton("button",self)
		self.P1BjoyButton = QPushButton("button",self)
		self.P2BjoyButton = QPushButton("button",self)
		self.P1CjoyButton = QPushButton("button",self)
		self.P2CjoyButton = QPushButton("button",self)
		self.P1DjoyButton = QPushButton("button",self)
		self.P2DjoyButton = QPushButton("button",self)
		self.P1StartjoyButton = QPushButton("button",self)
		self.P2StartjoyButton = QPushButton("button",self)
		self.P1CoinjoyButton = QPushButton("button",self)
		self.P2CoinjoyButton = QPushButton("button",self)
		self.P1UpjoyButton = QPushButton("button",self)
		self.P2UpjoyButton = QPushButton("button",self)
		self.P1AjoyButton = QPushButton("button",self)
		self.P1RightjoyButton = QPushButton("button",self)
		self.P2RightjoyButton = QPushButton("button",self)
		self.P2LeftjoyButton = QPushButton("button",self)
		self.P1LeftjoyButton = QPushButton("button",self)
		self.P2DownjoyButton = QPushButton("button",self)
		self.P1DownjoyButton = QPushButton("button",self)
		grid.addWidget(self.P1AjoyButton, 2, 2)
		grid.addWidget(self.P2AjoyButton, 2, 4)
		grid.addWidget(self.P2RightjoyButton, 11, 4)
		grid.addWidget(self.P1RightjoyButton, 11, 2)
		grid.addWidget(self.P2LeftjoyButton, 10, 4)
		grid.addWidget(self.P2DownjoyButton, 9, 4)
		grid.addWidget(self.P1LeftjoyButton, 10, 2)
		grid.addWidget(self.P1DownjoyButton, 9, 2)
		grid.addWidget(self.P2UpjoyButton, 8, 4)
		grid.addWidget(self.P2CoinjoyButton, 7, 4)
		grid.addWidget(self.P1UpjoyButton, 8, 2)
		grid.addWidget(self.P2StartjoyButton, 6, 4)
		grid.addWidget(self.P1CoinjoyButton, 7, 2)
		grid.addWidget(self.P2DjoyButton, 5, 4)
		grid.addWidget(self.P1StartjoyButton, 6, 2)
		grid.addWidget(self.P1CjoyButton, 4, 2)
		grid.addWidget(self.P1DjoyButton, 5, 2)
		grid.addWidget(self.P2BjoyButton, 3, 4)
		grid.addWidget(self.P1BjoyButton, 3, 2)
		grid.addWidget(self.P2CjoyButton, 4, 4)

	self.setLayout(grid)
	# P1
	self.connect(self.P1AjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1BjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1CjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1DjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1StartjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1CoinjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1UpjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1DownjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1LeftjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1RightjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	if (joystickAttached):
		self.connect(self.P1RightjoyButton, SIGNAL("clicked()"),self.P1joyupdateRight)
		self.connect(self.P1LeftjoyButton, SIGNAL("clicked()"),self.P1updateLeft)
		self.connect(self.P1DownjoyButton, SIGNAL("clicked()"),self.P1updateDown)
		self.connect(self.P1UpjoyButton, SIGNAL("clicked()"),self.P1updateUp)
		self.connect(self.P1CoinjoyButton, SIGNAL("clicked()"),self.P1updateCoin)
		self.connect(self.P1StartjoyButton, SIGNAL("clicked()"),self.P1updateStart)
		self.connect(self.P1AjoyButton, SIGNAL("clicked()"),self.P1updateA)
		self.connect(self.P1BjoyButton, SIGNAL("clicked()"),self.P1updateB)
		self.connect(self.P1CjoyButton, SIGNAL("clicked()"),self.P1updateC)
		self.connect(self.P1DjoyButton, SIGNAL("clicked()"),self.P1updateD)
	# P2
	self.connect(self.P2AjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2BjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2CjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2DjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2StartjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2CoinjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2UpjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2DownjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2LeftjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2RightjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	if (joystickAttached):
		self.connect(self.P2RightjoyButton, SIGNAL("clicked()"),self.P2updateRight)
		self.connect(self.P2LeftjoyButton, SIGNAL("clicked()"),self.P2updateLeft)
		self.connect(self.P2DownjoyButton, SIGNAL("clicked()"),self.P2updateDown)
		self.connect(self.P2UpjoyButton, SIGNAL("clicked()"),self.P2updateUp)
		self.connect(self.P2CoinjoyButton, SIGNAL("clicked()"),self.P2updateCoin)
		self.connect(self.P2StartjoyButton, SIGNAL("clicked()"),self.P2updateStart)
		self.connect(self.P2AjoyButton, SIGNAL("clicked()"),self.P2updateA)
		self.connect(self.P2BjoyButton, SIGNAL("clicked()"),self.P2updateB)
		self.connect(self.P2CjoyButton, SIGNAL("clicked()"),self.P2updateC)
		self.connect(self.P2DjoyButton, SIGNAL("clicked()"),self.P2updateD)

	# P1
    def P1joyupdateRight(self):
	MyJoykeyPressed()
	self.P1RightjoykeySpinBox.setValue(float(joyVal))
    def P1updateLeft(self):
	MyJoykeyPressed()
	self.P1LeftjoykeySpinBox.setValue(float(joyVal))
    def P1updateUp(self):
	MyJoykeyPressed()
	self.P1UpjoykeySpinBox.setValue(float(joyVal))
    def P1updateDown(self):
	MyJoykeyPressed()
	self.P1DownjoykeySpinBox.setValue(float(joyVal))
    def P1updateStart(self):
	MyJoykeyPressed()
	self.P1StartjoykeySpinBox.setValue(float(joyVal))
    def P1updateCoin(self):
	MyJoykeyPressed()
	self.P1CoinjoykeySpinBox.setValue(float(joyVal))
    def P1updateA(self):
	MyJoykeyPressed()
	self.P1AjoykeySpinBox.setValue(float(joyVal))
    def P1updateB(self):
	MyJoykeyPressed()
	self.P1BjoykeySpinBox.setValue(float(joyVal))
    def P1updateC(self):
	MyJoykeyPressed()
	self.P1CjoykeySpinBox.setValue(float(joyVal))
    def P1updateD(self):
	MyJoykeyPressed()
	self.P1DjoykeySpinBox.setValue(float(joyVal))
	# P2
    def P2updateRight(self):
	MyJoykeyPressed()
	self.P2RightjoykeySpinBox.setValue(float(joyVal))
    def P2updateLeft(self):
	MyJoykeyPressed()
	self.P2LeftjoykeySpinBox.setValue(float(joyVal))
    def P2updateUp(self):
	MyJoykeyPressed()
	self.P2UpjoykeySpinBox.setValue(float(joyVal))
    def P2updateDown(self):
	MyJoykeyPressed()
	self.P2DownjoykeySpinBox.setValue(float(joyVal))
    def P2updateStart(self):
	MyJoykeyPressed()
	self.P2StartjoykeySpinBox.setValue(float(joyVal))
    def P2updateCoin(self):
	MyJoykeyPressed()
	self.P2CoinjoykeySpinBox.setValue(float(joyVal))
    def P2updateA(self):
	MyJoykeyPressed()
	self.P2AjoykeySpinBox.setValue(float(joyVal))
    def P2updateB(self):
	MyJoykeyPressed()
	self.P2BjoykeySpinBox.setValue(float(joyVal))
    def P2updateC(self):
	MyJoykeyPressed()
	self.P2CjoykeySpinBox.setValue(float(joyVal))
    def P2updateD(self):
	MyJoykeyPressed()
	self.P2DjoykeySpinBox.setValue(float(joyVal))

    def change_value_joy(self):
	# P1
	self.P1joyKeys[0] = "%.0f" % self.P1AjoykeySpinBox.value()
	self.P1joyKeys[1] = "%.0f" % self.P1BjoykeySpinBox.value()
	self.P1joyKeys[2] = "%.0f" % self.P1CjoykeySpinBox.value()
	self.P1joyKeys[3] = "%.0f" % self.P1DjoykeySpinBox.value()
	self.P1joyKeys[4] = "%.0f" % self.P1StartjoykeySpinBox.value()
	self.P1joyKeys[5] = "%.0f" % self.P1CoinjoykeySpinBox.value()
	self.P1joyKeys[6] = "%.0f" % self.P1UpjoykeySpinBox.value()
	self.P1joyKeys[7] = "%.0f" % self.P1DownjoykeySpinBox.value()
	self.P1joyKeys[8] = "%.0f" % self.P1LeftjoykeySpinBox.value()
	self.P1joyKeys[9] = "%.0f" % self.P1RightjoykeySpinBox.value()
	# P2
	self.P2joyKeys[0] = "%.0f" % self.P2AjoykeySpinBox.value()
	self.P2joyKeys[1] = "%.0f" % self.P2BjoykeySpinBox.value()
	self.P2joyKeys[2] = "%.0f" % self.P2CjoykeySpinBox.value()
	self.P2joyKeys[3] = "%.0f" % self.P2DjoykeySpinBox.value()
	self.P2joyKeys[4] = "%.0f" % self.P2StartjoykeySpinBox.value()
	self.P2joyKeys[5] = "%.0f" % self.P2CoinjoykeySpinBox.value()
	self.P2joyKeys[6] = "%.0f" % self.P2UpjoykeySpinBox.value()
	self.P2joyKeys[7] = "%.0f" % self.P2DownjoykeySpinBox.value()
	self.P2joyKeys[8] = "%.0f" % self.P2LeftjoykeySpinBox.value()
	self.P2joyKeys[9] = "%.0f" % self.P2RightjoykeySpinBox.value()
	global P1joybuttons
	global P2joybuttons
	P1joybuttons = self.P1joyKeys
	P2joybuttons = self.P2joyKeys

class MyKeyPressed(QPushButton):
    def __init__(self, *args):
        QPushButton.__init__(self, *args)

    def event(self, event):
        if (event.type()==QEvent.KeyPress):
            # we have to get the SDL keysym
	    global AsciiVal
            if (event.key() < 256):
                AsciiVal = ord(str.lower(chr(event.key())))
            if (event.key() == 16777236):
		# right
                AsciiVal = 275;
	    if (event.key() == 16777234):
                # left
                AsciiVal = 276;
            if (event.key() == 16777235):
                # up
                AsciiVal = 273;
            if (event.key() == 16777237):
                # down
                AsciiVal = 274;
            if (event.key() == 16777219):
                # BS
                AsciiVal = 8;
            if (event.key() == 16777221):
                # Return
                AsciiVal = 271;
            if (event.key() == 16777248):
                # R-Shift
                AsciiVal = 303;
            if (event.key() == 16777249):
                # R-Control
                AsciiVal = 305;
            if (event.key() == 16781571):
                # R-Alt
                AsciiVal = 307;
            self.emit(SIGNAL("keyPressed"))

        return QPushButton.event(self, event)

class MyJoykeyPressed(QPushButton):
    def __init__(self, parent=None):
        QPushButton.__init__(self, parent)

	global joyVal
	pipe = open('/dev/input/js0','r')
	action = []
	stopping = False
	while not stopping :
		for character in pipe.read(1):
			action += ['%02X' % ord(character)]
			if len(action) == 8:
	
				if action[6] == '01': # Button
					if action[4] == '01':
						joyVal = action[7]
						stopping = True
						break
				elif action[7] == '04': # Left Joystick left/right
					if action[4] == 'FF':
						# You pressed right on the left joystick
						joyVal = 4 #,1
						stopping = True
					elif action[4] == '01':
						# You pressed left on the left joystick
						joyVal = 4 #,1
						stopping = True
				elif action[7] == '05': # Left Joystick up/down
					if action[4] == 'FF':
						# You pressed down on the left joystick
						joyVal = 5 #,1
						stopping = True
					elif action[4] == '01':
						joyVal = 4 #,1
						# You pressed up on the left joystick 
						stopping = True

				action = []
				if stopping:
					break
			if stopping:
				break
		if stopping:
			break
	pipe.close()

 
class pathWindow(QDialog):
    def __init__(self, parent=None):
        super(pathWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui path configuration")
        self.options = parse_config(self,GnGeo_CfgFile)
        self.gui_opts = parse_config(self,GnGeoGui_CfgFile)
	if BiosPath == "":
		self.biosPath=self.options["biospath"]
	else:
		self.biosPath=BiosPath
	if RomrcPath == "":
		self.romrcPath=self.options["romrcdir"]
	else:
		self.romrcPath=RomrcPath
	if RomPath == "":
		self.romPath=self.options["rompath"]
	else:
		self.romPath=RomPath
	if ExecPath == "":
		self.execPath = self.gui_opts["exec_path"]
	else:
		self.execPath = ExecPath
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,380);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 10)
	grid.setColumnStretch(2, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
        self.pushBiosButton = QPushButton(self.biosPath,self)
        self.pushBiosButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("BIOS"), 1, 0 )
	grid.addWidget(self.pushBiosButton, 1, 1)
	# romrc path
	self.pushRomrcButton = QPushButton(self.romrcPath,self)
        self.pushRomrcButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("romrc"), 2, 0)
	grid.addWidget(self.pushRomrcButton, 2, 1)
	# rom path
	self.pushRomButton = QPushButton(self.romPath,self)
        self.pushRomButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms"), 3, 0)
	grid.addWidget(self.pushRomButton, 3, 1)
	# exec path
	self.pushExecButton = QPushButton(self.execPath,self)
        self.pushExecButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("GnGeo"), 4, 0)
	grid.addWidget(self.pushExecButton, 4, 1)

	self.setLayout(grid)

	QObject.connect(self.pushBiosButton
		, SIGNAL("clicked()")
		, self.on_bios_button_clicked)
	QObject.connect(self.pushRomrcButton
		, SIGNAL("clicked()")
		, self.on_romrc_button_clicked)
	QObject.connect(self.pushRomButton
		, SIGNAL("clicked()")
		, self.on_rom_button_clicked)
	QObject.connect(self.pushExecButton
		, SIGNAL("clicked()")
		, self.on_exec_button_clicked)


    def on_bios_button_clicked(self):
	global BiosPath
	BiosPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(BiosPath + "/sfix.sfx")) and (BiosPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + BiosPath)
	self.close()

    def on_romrc_button_clicked(self):
	global RomrcPath
	RomrcPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(RomrcPath + "/kof96.rc")) and (RomrcPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + RomrcPath + "/*.rc files")
	self.close()

    def on_rom_button_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()

    def on_exec_button_clicked(self):
	global ExecPath
	ExecPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home/')
	if (not os.path.isfile(ExecPath + "/gngeo")) and (ExecPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + ExecPath + "/gngeo")
	self.close()

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow()
    ui.show()
    sys.exit(app.exec_())
