import os
import sys
import time
from PySide.QtCore import *
from PySide.QtGui import *

COMMENT_CHAR = '#'
OPTION_CHAR =  ' '
HOME = os.path.expanduser("~")
GNGEO_CFG_FILE = HOME + '/.gngeo/gngeorc'
GNGEOGUI_CFG_FILE = HOME + '/.gngeo-gui/gngeo-gui.cfg'
GNGEOGUI_LOG_FILE = HOME + '/.gngeo-gui/gngeo-output.log'
P1buttons = ""
P2buttons = ""
BiosPath = ""
RomrcPath = ""
RomPath = ""
ExecPath = ""

def parse_config(self, filename):
        options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if COMMENT_CHAR in line:
                # split on comment char, keep only the part before
                line, comment = line.split(COMMENT_CHAR, 1)
            # Second, find lines with an option=value:
            if OPTION_CHAR in line:
                 # split on option char:
                 option, value = line.split(OPTION_CHAR, 1)
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 options[option] = value
        f.close()
        return options


class Ui_MainWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self, None)
        self.resize(800, 480)
        self.setWindowTitle("GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
	'''
	Check for required files
	'''
        self.gui_opts = parse_config(self,GNGEOGUI_CFG_FILE)
	if not "exec_path" in self.gui_opts:
		QMessageBox.critical(self, "Critical",  "exec_path not set in '" + GNGEOGUI_CFG_FILE + "'")
    		sys.exit()
	if not os.path.isfile(self.gui_opts["exec_path"] + "/gngeo"):
		QMessageBox.critical(self, "Critical",  "'" + self.gui_opts["exec_path"] + "/gngeo' not found!")
        	widget = pathWindow(self)
		widget.show()
	try:
	        open(GNGEO_CFG_FILE ,"r")
	except:
		QMessageBox.critical(self, "Critical", "Config file '" + GNGEO_CFG_FILE + "' not readable!")
    		sys.exit()
	global AboutGnGeo
	VersionGnGeo = self.gui_opts["exec_path"] + "/gngeo --version" 
	fin,fout = os.popen4(VersionGnGeo)
	AboutGnGeo = fout.read()
	AboutGnGeo = "Using " + AboutGnGeo.replace('\n','<br>')
	# Load config
        self.options = parse_config(self,GNGEO_CFG_FILE)
	myPaths = [ "rompath", "biospath", "romrcdir" ]
	for myPath in myPaths:
		if not os.path.isdir(self.options[myPath]):
			QMessageBox.critical(self, "Critical",  myPath + " '" + self.options[myPath] + "' not found!")
        		widget = pathWindow(self)
			widget.show()
	if not (os.path.exists(self.options["biospath"] + "/sfix.sfx")) \
	and not (os.path.exists(self.options["biospath"] + "/sfix.sfix")):
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + self.options["biospath"])
	if not os.path.exists(self.options["romrcdir"] + "/kof96.rc"):
		QMessageBox.critical(self, "Warning",  "Cannot find romrc files in " + self.options["romrcdir"])
	# Set background image
        backgroundLabel = QLabel(self)
        AboutTxt = "<img src=/opt/gngeo-gui/neogeo_background.png />" 
        backgroundLabel.setText(AboutTxt)
	backgroundLabel.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(backgroundLabel)
	# Get Gametitles from rompath
	ListCmd = self.gui_opts["exec_path"] + "/gngeo --scandir=" + self.options["rompath"] 
	fin,fout = os.popen4(ListCmd)
	romList = fout.read()
	romList = romList.replace('\n',':\n')
	romList = romList.split(':')
	# Remove header in romlist
	romList = romList[3:-1]
	if not romList:
		Games = "No roms found! "
	else:
		Games = ""
	Teller = 1
	GameFile = ""
	for Item in romList:
		if Item[0] != "\n":
			if Teller == 0:
				GameFile = GameFile + Item + ":"
				Teller = 1
			else:
				Games = Games + Item + ":"
				Teller = 0
	# Remove the last ":"
	Games = Games[:-1]
	GameFile = GameFile[:-1]
	Games = Games.split(":")
	self.GameFile = GameFile.split(":")
        self.combo = QComboBox(self)
        self.combo.setStyleSheet( \
	"QComboBox { color: gray; \
	 border: 6px solid #045FB4; \
	 border-radius: 3px; \
	 min-width: 6em; \
	 }" )
	self.combo.setGeometry(QRect(170, 230, 450, 60))
	for Game in Games:
        	self.combo.addItem(Game)

	# Define menubar
	aboutAction = QAction( '&About', self)
	configAction = QAction( '&Config', self)
	self.exitAction = QAction( '&Exit after start game', self)
        aboutAction.triggered.connect(self.slotAbout)
        configAction.triggered.connect(self.slotConfig)
	self.exitAction.setCheckable(True)

	if self.gui_opts["exit_after_launch"] == "false":
            self.exitAction.setChecked(False)
	else:
            self.exitAction.setChecked(True)

        menubar = self.menuBar()
        fileMenu = menubar.addMenu('&MainMenu')
        fileMenu.addAction(configAction)
        fileMenu.addAction(self.exitAction)
        fileMenu.addAction(aboutAction)
        
        self.startButton = QPushButton("Start",self)
        self.startButton.setGeometry(QRect(0, 370, 400, 55))
        font = QFont()
        font.setPointSize(24)
        self.startButton.setFont(font)
	QObject.connect(self.startButton
		, SIGNAL("clicked()")
		, self.on_start_clicked)

        self.onesmutePushButton = QPushButton("Mute",self)
	self.onesmutePushButton.setCheckable(True)
        self.onesmutePushButton.setGeometry(QRect(400, 370, 400, 55))
        font = QFont()
        font.setPointSize(24)
        self.onesmutePushButton.setFont(font)
	if self.options["sound"] == "true":
            self.onesmutePushButton.setChecked(False)
	else:
            self.onesmutePushButton.setChecked(True)

	self.logMsg = QLabel(self)
      	self.logMsg.setStyleSheet( \
	"QLabel { background-color: QLinearGradient( x1: 0, y1: 0, x2: 0, y2: 1, \
         stop: 0 #bbb, stop: 0.1 #999, stop: 0.49 #444, stop: 0.5 #666, stop: 1 #444); \
         font-size: 20px; font-family: monospace; font-weight: bold;}" \
      	) 
	self.logMsg.setGeometry(0, 350, 800, 20)



    def on_start_clicked(self):
	gameNbr = self.combo.currentIndex()
	self.gameFile = self.GameFile[gameNbr]
	global MyTeller
	global regel

        if self.onesmutePushButton.isChecked():
               SOUND_OPT=" --no-sound "
        else:  SOUND_OPT=" --sound "

	if self.gameFile:
		QProcess.startDetached(self.gui_opts["exec_path"]+"/gngeo "+SOUND_OPT+self.options["rompath"]+'/'+self.gameFile)
                time.sleep(0.1)    # Sleep briefly
		file = open(GNGEOGUI_LOG_FILE,'r')
                self.MyTeller = 0
		def follow(thefile):
			    thefile.seek(0,1)      # Go to the end of the file
			    while True:
			         line = thefile.readline()
			         if not line:
				     self.MyTeller = self.MyTeller + 1
			             time.sleep(0.1)    # Sleep briefly
			             continue
			         yield line

		loglines = follow(file)
		for line in loglines:
		    if '\r' in line:
			line = line.strip('\n')
			line = line.replace('\r','\n')
			lines = line.split('\n')
			for subline in lines:
				regel = subline
				self.logMsg.setText(regel)
				# Keep the app responsive in this loop
				QCoreApplication.processEvents()
			#print >> sys.stderr,line
		    if (self.MyTeller > 90) or (self.MyTeller == 0) or ("Convert" in line):
			file.close()
			open(GNGEOGUI_LOG_FILE, 'w').close()
			break

        if (self.exitAction.isChecked()) and (self.gui_opts["exit_after_launch"] == "false"):
		try:
			ConfigFile = open(GNGEOGUI_CFG_FILE,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GNGEOGUI_CFG_FILE)
		else:
			ConfigFile.write("# Generated by gngeo-gui\n")
			ConfigFile.write("exec_path" + " " + self.gui_opts["exec_path"] + "\n")
			ConfigFile.write("exit_after_launch" + " " + "true\n")
			ConfigFile.close()

        if (not self.exitAction.isChecked()) and (self.gui_opts["exit_after_launch"] == "true"):
		try:
			ConfigFile = open(GNGEOGUI_CFG_FILE,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GNGEOGUI_CFG_FILE)
		else:
			ConfigFile.write("# Generated by gngeo-gui\n")
			ConfigFile.write("exec_path" + " " + self.gui_opts["exec_path"] + "\n")
			ConfigFile.write("exit_after_launch" + " " + "false\n")
			ConfigFile.close()

        if self.exitAction.isChecked():
               time.sleep(5)
               os._exit(0)

    def slotAbout(self):
        a = AboutWindow(self)
        a.show()

    def slotConfig(self):
        a = ConfigWindow(self)
        a.show()

class AboutWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("About GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.label = QLabel(self)
        AboutTxt = "<h3>Gngeo-gui 0.0.5-3</h3><p>" \
                   "<img src=/opt/usr/share/icons/hicolor/64x64/apps/gngeo_gui.png /><br>" \
                   "GnGeo-gui is a Graphical User Interface for GnGeo<p> " \
                   "GnGeo emulates the NeoGeo gameconsole from SNK &#174;</p>" \
                   "<p>GnGeo-gui is written in PySide by <i>Arno Dekker</i> 2011<p>"
	AboutTxt = AboutTxt + AboutGnGeo
        self.label.setText(AboutTxt)
	self.label.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(self.label)

class ConfigWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("Configuration GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.options = parse_config(self,GNGEO_CFG_FILE)
        self.gui_opts = parse_config(self,GNGEOGUI_CFG_FILE)
        font = QFont()
        font.setPointSize(20)
	#showfps
        self.showfpsPushButton = QPushButton("Showfps",self)
	self.showfpsPushButton.setCheckable(True)
        self.showfpsPushButton.setGeometry(QRect(18, 15, 250, 60))
        self.showfpsPushButton.setFont(font)
	if self.options["showfps"] == "true":
            self.showfpsPushButton.setChecked(True)
	#fullscreen
        self.fullscreenPushButton = QPushButton("Fullscreen",self)
	self.fullscreenPushButton.setCheckable(True)
        self.fullscreenPushButton.setGeometry(QRect(273, 15, 250, 60))
        self.fullscreenPushButton.setFont(font)
	if self.options["fullscreen"] == "true":
            self.fullscreenPushButton.setChecked(True)
	#sound
        self.soundPushButton = QPushButton("Sound",self)
	self.soundPushButton.setCheckable(True)
        self.soundPushButton.setGeometry(QRect(530, 15, 250, 60))
        self.soundPushButton.setFont(font)
	if self.options["sound"] == "true":
            self.soundPushButton.setChecked(True)
	#autoframeskip
        self.autoframePushButton = QPushButton("Autoframeskip",self)
	self.autoframePushButton.setCheckable(True)
        self.autoframePushButton.setGeometry(QRect(18, 85, 250, 60))
        self.autoframePushButton.setFont(font)
	if self.options["autoframeskip"] == "true":
            self.autoframePushButton.setChecked(True)
	#raster
        self.rasterPushButton = QPushButton("Raster",self)
	self.rasterPushButton.setCheckable(True)
        self.rasterPushButton.setGeometry(QRect(273, 85, 250, 60))
        self.rasterPushButton.setFont(font)
	if self.options["raster"] == "true":
            self.rasterPushButton.setChecked(True)
	#interpolation
        self.interpolationPushButton = QPushButton("Interpolation",self)
	self.interpolationPushButton.setCheckable(True)
        self.interpolationPushButton.setGeometry(QRect(530, 85, 250, 60))
        self.interpolationPushButton.setFont(font)
	if self.options["interpolation"] == "true":
            self.interpolationPushButton.setChecked(True)
	#sleepidle
        self.sleepildePushButton = QPushButton("Sleepidle",self)
	self.sleepildePushButton.setCheckable(True)
        self.sleepildePushButton.setGeometry(QRect(18, 170, 250, 60))
        self.sleepildePushButton.setFont(font)
	if self.options["sleepidle"] == "true":
            self.sleepildePushButton.setChecked(True)
	#hwsurface
        self.hwsurfacePushButton = QPushButton("Hwsurface",self)
	self.hwsurfacePushButton.setCheckable(True)
        self.hwsurfacePushButton.setGeometry(QRect(273, 170, 250, 60))
        self.hwsurfacePushButton.setFont(font)
	if self.options["hwsurface"] == "true":
            self.hwsurfacePushButton.setChecked(True)
	#joystick
        #self.joystickCheckBox = QCheckBox("Joystick",self)
        #self.joystickCheckBox.setGeometry(QRect(530, 170, 250, 60))
        #self.joystickCheckBox.setFont(font)
	#if self.options["joystick"] == "true":
        #    self.joystickCheckBox.setChecked(True)
	#system
	label = QLabel("<i>system:</i>", self)
	label.move(100,230)
        self.comboSystem = QComboBox(self)
	self.comboSystem.setGeometry(QRect(18, 260, 250, 60))
	systems = self.listDefaultFirst("system",['arcade','home'])
	for sysType in systems:
       		 	self.comboSystem.addItem(sysType)
	#country
	label = QLabel("<i>region:</i>", self)
	label.move(335,230)
        self.comboCountry = QComboBox(self)
	self.comboCountry.setGeometry(QRect(270, 260, 250, 60))
	countries = self.listDefaultFirst("country",['japan', 'usa', 'europe'])
	for Location in countries:
       		 	self.comboCountry.addItem(Location)
	#effect
	label = QLabel("<i>effect:</i>", self)
	label.move(595,230)
        self.comboEffect = QComboBox(self)
	self.comboEffect.setGeometry(QRect(530, 260, 250, 60))
	effects = self.listDefaultFirst("effect",['none', 'scanline', 'scanline50', 'scale2x', 'scale3x', 'scale4x', 'scale2x50', 'scale2x75', 'hq2x', 'hq3x', 'lq2x', 'lq3x', 'doublex'])
	for effect in effects:
       		 	self.comboEffect.addItem(effect)
	# Keys button
        self.keysButton = QPushButton("keys",self)
        self.keysButton.setGeometry(QRect(18, 330, 250, 80))
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_keys_clicked)
	# Path button
        self.keysButton = QPushButton("paths",self)
        self.keysButton.setGeometry(QRect(273, 330, 250, 80))
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_paths_clicked)
	# Samplerate
	label = QLabel("<i>sound rate:</i>", self)
	label.setGeometry(595,145,140,30)
        self.comboSampleRate = QComboBox(self)
	self.comboSampleRate.setGeometry(QRect(530, 170, 250, 60))
	Sam_Rates = self.listDefaultFirst("samplerate",['8192','11025','22050','32000','44100','48000'])
	for SampRate in Sam_Rates:
		self.comboSampleRate.addItem(SampRate)
	# Save button
        self.saveButton = QPushButton("SAVE",self)
        self.saveButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
        self.saveButton.setGeometry(QRect(530, 330, 250, 80))
	QObject.connect(self.saveButton
		, SIGNAL("clicked()")
		, self.on_save_clicked)


    def on_save_clicked(self):
        if self.soundPushButton.isChecked():
           self.options["sound"] = "true"
        else: self.options["sound"] = "false" 
        if self.showfpsPushButton.isChecked():
           self.options["showfps"] = "true"
        else: self.options["showfps"] = "false" 
        if self.fullscreenPushButton.isChecked():
           self.options["fullscreen"] = "true"
        else: self.options["fullscreen"] = "false" 
        if self.autoframePushButton.isChecked():
           self.options["autoframeskip"] = "true"
        else: self.options["autoframeskip"] = "false" 
        if self.rasterPushButton.isChecked():
           self.options["raster"] = "true"
        else: self.options["raster"] = "false" 
        if self.interpolationPushButton.isChecked():
           self.options["interpolation"] = "true"
        else: self.options["interpolation"] = "false" 
        if self.sleepildePushButton.isChecked():
           self.options["sleepidle"] = "true"
        else: self.options["sleepidle"] = "false" 
        if self.hwsurfacePushButton.isChecked():
           self.options["hwsurface"] = "true"
        else: self.options["hwsurface"] = "false" 
        #if self.joystickCheckBox.isChecked():
        #   self.options["joystick"] = "true"
        #else: self.options["joystick"] = "false" 
	self.options["system"] = self.comboSystem.currentText()
	self.options["country"] = self.comboCountry.currentText()
	self.options["effect"] = self.comboEffect.currentText()
	self.options["samplerate"] = self.comboSampleRate.currentText()
	if BiosPath != "":
		self.options["biospath"] = BiosPath
	if RomrcPath != "":
		self.options["romrcdir"] = RomrcPath
	if RomPath != "":
		self.options["rompath"] = RomPath
	if ExecPath != "":
		try:
			ConfigFile = open(GNGEOGUI_CFG_FILE,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GNGEOGUI_CFG_FILE)
		else:
			ConfigFile.write("# Generated by gngeo-gui\n")
			ConfigFile.write("exec_path" + " " + ExecPath + "\n")
			ConfigFile.write("exit_after_launch" + " " + self.gui_opts["exit_after_launch"] + "\n")
			ConfigFile.close()

	if P1buttons != "":
		tot_sleutel=""
		for sleutel in P1buttons:
			tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1key"] = tot_sleutel

	if P2buttons != "":
		tot_sleutel=""
		for sleutel in P2buttons:
			tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p2key"] = tot_sleutel

        orgConfigFile = open(GNGEO_CFG_FILE,"r")
	try:
	        copyFile = open(GNGEO_CFG_FILE + ".old" ,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + GNGEO_CFG_FILE + ".old")
	else:
		for line in orgConfigFile.readlines():
			copyFile.write(line)
		orgConfigFile.close()
		copyFile.close()
		try:
			newConfigFile = open(GNGEO_CFG_FILE,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GNGEO_CFG_FILE)
		else:
			newConfigFile.write("# Generated by gngeo-gui\n")
			for option in self.options:
				newConfigFile.write(option + " " + self.options[option] + "\n")
			newConfigFile.close()
                        os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
                        /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
                        string:"Configuration is succesfully saved"')

    def listDefaultFirst(self, optVal,List):
	Position = List.index(self.options[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def on_keys_clicked(self):
        widget = keyWindow(self)
        widget.show()

    def on_paths_clicked(self):
        widget = pathWindow(self)
        widget.show()
	
class keyWindow(QDialog):
    def __init__(self, parent=None):
        super(keyWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui button config")
	# order : A,B,C,D,START,COIN,UP,DOWN,LEFT,RIGHT
	if P1buttons == "":
        	self.options = parse_config(self,GNGEO_CFG_FILE)
		self.P1Keys=self.options["p1key"].split(",")
	else:
		self.P1Keys = P1buttons
	if P2buttons == "":
        	self.options = parse_config(self,GNGEO_CFG_FILE)
		self.P2Keys=self.options["p2key"].split(",")
	else:
		self.P2Keys = P2buttons
	# P1 keys
	P1Akey=self.P1Keys[0]
	P1Bkey=self.P1Keys[1]
	P1Ckey=self.P1Keys[2]
	P1Dkey=self.P1Keys[3]
	P1Startkey=self.P1Keys[4]
	P1Coinkey=self.P1Keys[5]
	P1Upkey=self.P1Keys[6]
	P1Downkey=self.P1Keys[7]
	P1Leftkey=self.P1Keys[8]
	P1Rightkey=self.P1Keys[9]
	# P2 keys
	P2Akey=self.P2Keys[0]
	P2Bkey=self.P2Keys[1]
	P2Ckey=self.P2Keys[2]
	P2Dkey=self.P2Keys[3]
	P2Startkey=self.P2Keys[4]
	P2Coinkey=self.P2Keys[5]
	P2Upkey=self.P2Keys[6]
	P2Downkey=self.P2Keys[7]
	P2Leftkey=self.P2Keys[8]
	P2Rightkey=self.P2Keys[9]
	# Layout
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.resize(750,900);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	minKeyValue=1
	maxKeyValue=307
	grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
	grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
	grid.addWidget(QLabel("<center>PLAYER 2</center>"), 1, 3)
	grid.addWidget(QLabel("<center>[pick]</center>"), 1, 4)
	# Add button list
        cntr=2
	for pButton in ['A','B','C','D','START','COIN','UP','DOWN','LEFT','RIGHT']:
		grid.addWidget(QLabel(pButton), cntr, 0)
		cntr=cntr+1
	# A-button P2
	self.P1AkeySpinBox = QDoubleSpinBox()
	self.P1AkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1AkeySpinBox.setValue(float(P1Akey))
	self.P1AkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1AkeySpinBox, 2, 1)
	self.P1AButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1AButton, 2, 2)
	# A-button P2
	self.P2AkeySpinBox = QDoubleSpinBox()
	self.P2AkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2AkeySpinBox.setValue(float(P2Akey))
	self.P2AkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2AkeySpinBox, 2, 3)
	self.P2AButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2AButton, 2, 4)
	# B-button P1
	self.P1BkeySpinBox = QDoubleSpinBox()
	self.P1BkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1BkeySpinBox.setValue(float(P1Bkey))
	self.P1BkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1BkeySpinBox, 3, 1)
	self.P1BButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1BButton, 3, 2)
	# B-button P2
	self.P2BkeySpinBox = QDoubleSpinBox()
	self.P2BkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2BkeySpinBox.setValue(float(P2Bkey))
	self.P2BkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2BkeySpinBox, 3, 3)
	self.P2BButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2BButton, 3, 4)
	# C-button P1
	self.P1CkeySpinBox = QDoubleSpinBox()
	self.P1CkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CkeySpinBox.setValue(float(P1Ckey))
	self.P1CkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CkeySpinBox, 4, 1)
	self.P1CButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1CButton, 4, 2)
	# C-button P2
	self.P2CkeySpinBox = QDoubleSpinBox()
	self.P2CkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CkeySpinBox.setValue(float(P2Ckey))
	self.P2CkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CkeySpinBox, 4, 3)
	self.P2CButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2CButton, 4, 4)
	# D-button P1
	self.P1DkeySpinBox = QDoubleSpinBox()
	self.P1DkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DkeySpinBox.setValue(float(P1Dkey))
	self.P1DkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DkeySpinBox, 5, 1)
	self.P1DButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1DButton, 5, 2)
	# D-button P2
	self.P2DkeySpinBox = QDoubleSpinBox()
	self.P2DkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DkeySpinBox.setValue(float(P2Dkey))
	self.P2DkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DkeySpinBox, 5, 3)
	self.P2DButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2DButton, 5, 4)
	# Start-button P1
	self.P1StartkeySpinBox = QDoubleSpinBox()
	self.P1StartkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1StartkeySpinBox.setValue(float(P1Startkey))
	self.P1StartkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1StartkeySpinBox, 6, 1)
	self.P1StartButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1StartButton, 6, 2)
	# Start-button P2
	self.P2StartkeySpinBox = QDoubleSpinBox()
	self.P2StartkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2StartkeySpinBox.setValue(float(P2Startkey))
	self.P2StartkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2StartkeySpinBox, 6, 3)
	self.P2StartButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2StartButton, 6, 4)
	# Coin-button P1
	self.P1CoinkeySpinBox = QDoubleSpinBox()
	self.P1CoinkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CoinkeySpinBox.setValue(float(P1Coinkey))
	self.P1CoinkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CoinkeySpinBox, 7, 1)
	self.P1CoinButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1CoinButton, 7, 2)
	# Coin-button P2
	self.P2CoinkeySpinBox = QDoubleSpinBox()
	self.P2CoinkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CoinkeySpinBox.setValue(float(P2Coinkey))
	self.P2CoinkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CoinkeySpinBox, 7, 3)
	self.P2CoinButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2CoinButton, 7, 4)
	# Up-key P1
	self.P1UpkeySpinBox = QDoubleSpinBox()
	self.P1UpkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1UpkeySpinBox.setValue(float(P1Upkey))
	self.P1UpkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1UpkeySpinBox, 8, 1)
	self.P1UpButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1UpButton, 8, 2)
	# Up-key P2
	self.P2UpkeySpinBox = QDoubleSpinBox()
	self.P2UpkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2UpkeySpinBox.setValue(float(P2Upkey))
	self.P2UpkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2UpkeySpinBox, 8, 3)
	self.P2UpButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2UpButton, 8, 4)
	# Down-key P1
	self.P1DownkeySpinBox = QDoubleSpinBox()
	self.P1DownkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DownkeySpinBox.setValue(float(P1Downkey))
	self.P1DownkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DownkeySpinBox, 9, 1)
	self.P1DownButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1DownButton, 9, 2)
	# Down-key P2
	self.P2DownkeySpinBox = QDoubleSpinBox()
	self.P2DownkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DownkeySpinBox.setValue(float(P2Downkey))
	self.P2DownkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DownkeySpinBox, 9, 3)
	self.P2DownButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2DownButton, 9, 4)
	# Left-key P1
	self.P1LeftkeySpinBox = QDoubleSpinBox()
	self.P1LeftkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1LeftkeySpinBox.setValue(float(P1Leftkey))
	self.P1LeftkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1LeftkeySpinBox, 10, 1)
	self.P1LeftButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1LeftButton, 10, 2)
	# Left-key P2
	self.P2LeftkeySpinBox = QDoubleSpinBox()
	self.P2LeftkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2LeftkeySpinBox.setValue(float(P2Leftkey))
	self.P2LeftkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2LeftkeySpinBox, 10, 3)
	self.P2LeftButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2LeftButton, 10, 4)
	# Right-key P1
	self.P1RightkeySpinBox = QDoubleSpinBox()
	self.P1RightkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1RightkeySpinBox.setValue(float(P1Rightkey))
	self.P1RightkeySpinBox.setDecimals(0)
	grid.addWidget(self.P1RightkeySpinBox, 11, 1)
	self.P1RightButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1RightButton, 11, 2)
	# Right-key P1
	self.P2RightkeySpinBox = QDoubleSpinBox()
	self.P2RightkeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2RightkeySpinBox.setValue(float(P2Rightkey))
	self.P2RightkeySpinBox.setDecimals(0)
	grid.addWidget(self.P2RightkeySpinBox, 11, 3)
	self.P2RightButton = MyKeyPressed("key",self)
	grid.addWidget(self.P2RightButton, 11, 4)

	self.setLayout(grid)
	# P1
	self.connect(self.P1AkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1BkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1CkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1DkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1StartkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1CoinkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1RightButton, SIGNAL("keyPressed"),self.P1updateRight)
        self.connect(self.P1LeftButton, SIGNAL("keyPressed"),self.P1updateLeft)
        self.connect(self.P1DownButton, SIGNAL("keyPressed"),self.P1updateDown)
        self.connect(self.P1UpButton, SIGNAL("keyPressed"),self.P1updateUp)
        self.connect(self.P1CoinButton, SIGNAL("keyPressed"),self.P1updateCoin)
        self.connect(self.P1StartButton, SIGNAL("keyPressed"),self.P1updateStart)
        self.connect(self.P1AButton, SIGNAL("keyPressed"),self.P1updateA)
        self.connect(self.P1BButton, SIGNAL("keyPressed"),self.P1updateB)
        self.connect(self.P1CButton, SIGNAL("keyPressed"),self.P1updateC)
        self.connect(self.P1DButton, SIGNAL("keyPressed"),self.P1updateD)
	# P2
	self.connect(self.P2AkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2BkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2CkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2DkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2StartkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2CoinkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P2RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P2RightButton, SIGNAL("keyPressed"),self.P2updateRight)
        self.connect(self.P2LeftButton, SIGNAL("keyPressed"),self.P2updateLeft)
        self.connect(self.P2DownButton, SIGNAL("keyPressed"),self.P2updateDown)
        self.connect(self.P2UpButton, SIGNAL("keyPressed"),self.P2updateUp)
        self.connect(self.P2CoinButton, SIGNAL("keyPressed"),self.P2updateCoin)
        self.connect(self.P2StartButton, SIGNAL("keyPressed"),self.P2updateStart)
        self.connect(self.P2AButton, SIGNAL("keyPressed"),self.P2updateA)
        self.connect(self.P2BButton, SIGNAL("keyPressed"),self.P2updateB)
        self.connect(self.P2CButton, SIGNAL("keyPressed"),self.P2updateC)
        self.connect(self.P2DButton, SIGNAL("keyPressed"),self.P2updateD)

	# P1
    def P1updateRight(self):
	self.P1RightkeySpinBox.setValue(float(AsciiVal))
    def P1updateLeft(self):
	self.P1LeftkeySpinBox.setValue(float(AsciiVal))
    def P1updateUp(self):
	self.P1UpkeySpinBox.setValue(float(AsciiVal))
    def P1updateDown(self):
	self.P1DownkeySpinBox.setValue(float(AsciiVal))
    def P1updateStart(self):
	self.P1StartkeySpinBox.setValue(float(AsciiVal))
    def P1updateCoin(self):
	self.P1CoinkeySpinBox.setValue(float(AsciiVal))
    def P1updateA(self):
	self.P1AkeySpinBox.setValue(float(AsciiVal))
    def P1updateB(self):
	self.P1BkeySpinBox.setValue(float(AsciiVal))
    def P1updateC(self):
	self.P1CkeySpinBox.setValue(float(AsciiVal))
    def P1updateD(self):
	self.P1DkeySpinBox.setValue(float(AsciiVal))
	# P2
    def P2updateRight(self):
	self.P2RightkeySpinBox.setValue(float(AsciiVal))
    def P2updateLeft(self):
	self.P2LeftkeySpinBox.setValue(float(AsciiVal))
    def P2updateUp(self):
	self.P2UpkeySpinBox.setValue(float(AsciiVal))
    def P2updateDown(self):
	self.P2DownkeySpinBox.setValue(float(AsciiVal))
    def P2updateStart(self):
	self.P2StartkeySpinBox.setValue(float(AsciiVal))
    def P2updateCoin(self):
	self.P2CoinkeySpinBox.setValue(float(AsciiVal))
    def P2updateA(self):
	self.P2AkeySpinBox.setValue(float(AsciiVal))
    def P2updateB(self):
	self.P2BkeySpinBox.setValue(float(AsciiVal))
    def P2updateC(self):
	self.P2CkeySpinBox.setValue(float(AsciiVal))
    def P2updateD(self):
	self.P2DkeySpinBox.setValue(float(AsciiVal))

    def change_value(self,event):
	# P1
	self.P1Keys[0] = "%.0f" % self.P1AkeySpinBox.value()
	self.P1Keys[1] = "%.0f" % self.P1BkeySpinBox.value()
	self.P1Keys[2] = "%.0f" % self.P1CkeySpinBox.value()
	self.P1Keys[3] = "%.0f" % self.P1DkeySpinBox.value()
	self.P1Keys[4] = "%.0f" % self.P1StartkeySpinBox.value()
	self.P1Keys[5] = "%.0f" % self.P1CoinkeySpinBox.value()
	self.P1Keys[6] = "%.0f" % self.P1UpkeySpinBox.value()
	self.P1Keys[7] = "%.0f" % self.P1DownkeySpinBox.value()
	self.P1Keys[8] = "%.0f" % self.P1LeftkeySpinBox.value()
	self.P1Keys[9] = "%.0f" % self.P1RightkeySpinBox.value()
	# P2
	self.P2Keys[0] = "%.0f" % self.P2AkeySpinBox.value()
	self.P2Keys[1] = "%.0f" % self.P2BkeySpinBox.value()
	self.P2Keys[2] = "%.0f" % self.P2CkeySpinBox.value()
	self.P2Keys[3] = "%.0f" % self.P2DkeySpinBox.value()
	self.P2Keys[4] = "%.0f" % self.P2StartkeySpinBox.value()
	self.P2Keys[5] = "%.0f" % self.P2CoinkeySpinBox.value()
	self.P2Keys[6] = "%.0f" % self.P2UpkeySpinBox.value()
	self.P2Keys[7] = "%.0f" % self.P2DownkeySpinBox.value()
	self.P2Keys[8] = "%.0f" % self.P2LeftkeySpinBox.value()
	self.P2Keys[9] = "%.0f" % self.P2RightkeySpinBox.value()
	global P1buttons
	global P2buttons
	P1buttons = self.P1Keys
	P2buttons = self.P2Keys

class MyKeyPressed(QPushButton):
    def __init__(self, *args):
        QPushButton.__init__(self, *args)

    def event(self, event):
        if (event.type()==QEvent.KeyPress):
            # we have to get the SDL keysym
	    global AsciiVal
            if (event.key() < 256):
                AsciiVal = ord(str.lower(chr(event.key())))
            if (event.key() == 16777236):
		# right
                AsciiVal = 275;
	    if (event.key() == 16777234):
                # left
                AsciiVal = 276;
            if (event.key() == 16777235):
                # up
                AsciiVal = 273;
            if (event.key() == 16777237):
                # down
                AsciiVal = 274;
            if (event.key() == 16777219):
                # BS
                AsciiVal = 8;
            if (event.key() == 16777221):
                # Return
                AsciiVal = 13;
            if (event.key() == 16777248):
                # R-Shift
                AsciiVal = 303;
            if (event.key() == 16777249):
                # R-Control
                AsciiVal = 305;
            if (event.key() == 16781571):
                # R-Alt
                AsciiVal = 307;
            self.emit(SIGNAL("keyPressed"))

        return QPushButton.event(self, event)


class pathWindow(QDialog):
    def __init__(self, parent=None):
        super(pathWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui path configuration")
        self.options = parse_config(self,GNGEO_CFG_FILE)
        self.gui_opts = parse_config(self,GNGEOGUI_CFG_FILE)
	if BiosPath == "":
		self.biosPath=self.options["biospath"]
	else:
		self.biosPath=BiosPath
	if RomrcPath == "":
		self.romrcPath=self.options["romrcdir"]
	else:
		self.romrcPath=RomrcPath
	if RomPath == "":
		self.romPath=self.options["rompath"]
	else:
		self.romPath=RomPath
	if ExecPath == "":
		self.execPath = self.gui_opts["exec_path"]
	else:
		self.execPath = ExecPath
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,380);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 10)
	grid.setColumnStretch(2, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
        self.pushBiosButton = QPushButton(self.biosPath,self)
        self.pushBiosButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("BIOS"), 1, 0 )
	grid.addWidget(self.pushBiosButton, 1, 1)
	# romrc path
	self.pushRomrcButton = QPushButton(self.romrcPath,self)
        self.pushRomrcButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("romrc"), 2, 0)
	grid.addWidget(self.pushRomrcButton, 2, 1)
	# rom path
	self.pushRomButton = QPushButton(self.romPath,self)
        self.pushRomButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms"), 3, 0)
	grid.addWidget(self.pushRomButton, 3, 1)
	# exec path
	self.pushExecButton = QPushButton(self.execPath,self)
        self.pushExecButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("GnGeo"), 4, 0)
	grid.addWidget(self.pushExecButton, 4, 1)

	self.setLayout(grid)

	QObject.connect(self.pushBiosButton
		, SIGNAL("clicked()")
		, self.on_bios_button_clicked)
	QObject.connect(self.pushRomrcButton
		, SIGNAL("clicked()")
		, self.on_romrc_button_clicked)
	QObject.connect(self.pushRomButton
		, SIGNAL("clicked()")
		, self.on_rom_button_clicked)
	QObject.connect(self.pushExecButton
		, SIGNAL("clicked()")
		, self.on_exec_button_clicked)


    def on_bios_button_clicked(self):
	global BiosPath
	BiosPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(BiosPath + "/sfix.sfx")) and (BiosPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + BiosPath)
	self.close()

    def on_romrc_button_clicked(self):
	global RomrcPath
	RomrcPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(RomrcPath + "/kof96.rc")) and (RomrcPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + RomrcPath + "/*.rc files")
	self.close()

    def on_rom_button_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()

    def on_exec_button_clicked(self):
	global ExecPath
	ExecPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home/')
	if (not os.path.isfile(ExecPath + "/gngeo")) and (ExecPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + ExecPath + "/gngeo")
	self.close()

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow()
    ui.show()
    sys.exit(app.exec_())

