#!/usr/bin/env python

""" glogarchive v 0.8 (C) 2010 by Kurt Fleisch
    http://www.bananenfisch.net/n900/

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import pygtk
pygtk.require('2.0')
import sys, os, shutil, sqlite3, time, gtk, hildon, cgi, csv, osso

EL_PATH = "/home/user/.rtcom-eventlogger/el-v1.db"
ARCHIVE_PATH = "/home/user/.rtcom-eventlogger/el_archive-v1.db"
ARCHIVE_OLD = "/home/user/.rtcom-eventlogger/el_archive.db"

class fenster:

    def close_application(self, widget, data=None):
        gtk.main_quit()
        return False

    def show_about(self, widget):
        self.about = gtk.AboutDialog()
        self.about.set_name("glogarchive")
        self.about.set_logo_icon_name("glogarchive")
        self.about.set_comments("to archive SMS/IM messages and calling-history from the eventlogger to an extra DB")
        self.about.set_version("0.8")
        self.about.set_copyright("by Kurt Fleisch")
        gtk.about_dialog_set_url_hook(self.openurl, self.about)
        self.about.set_website("www.bananenfisch.net/n900")
        self.about.run()
        self.about.hide()

    def show_donate(self, widget):
        self.donate = gtk.Dialog("Donate")
        label = gtk.Label("If you like this Software and also want to be a helping hand,\nyou can donate via PayPal to:\n\nmarkus@bananenfisch.net")
        label.set_justify(gtk.JUSTIFY_CENTER)
        self.donate.vbox.pack_start(label, True, True, 5)
        label.show()
        gtk.link_button_set_uri_hook(self.openurl, self.donate)
        linkbut = gtk.LinkButton("www.paypal.com/cgi-bin/webscr?cmd=_donations&business=markus%40bananenfisch%2enet&lc=AT&item_name=glogarchive&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted", "or use this link to go to PayPal directly")
        self.donate.vbox.pack_start(linkbut, True, True, 5)
        linkbut.show()
        self.donate.run()
        self.donate.hide()

    def openurl(self, widget, url, dialogwidget):
        self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (url,))
        dialogwidget.destroy()

    def __init__(self):
        self.archivedb = True
        self.viewall = True
        self.allok = True
        self.window = hildon.StackableWindow()
        self.window.set_title("glogarchive")
        self.window.connect("delete_event", self.close_application)
        self.window.set_border_width(0)

        self.osso_c = osso.Context("glogarchive", "0.8", False)
        self.osso_rpc = osso.Rpc(self.osso_c)

        if os.path.isfile(EL_PATH):
          if os.path.isfile(ARCHIVE_OLD) and not os.path.isfile(ARCHIVE_PATH):
            shutil.copy(ARCHIVE_OLD, ARCHIVE_PATH)
            os.remove(ARCHIVE_OLD)
            conn = sqlite3.connect(ARCHIVE_PATH)
            conn2 = sqlite3.connect(EL_PATH)
            dbchange = conn.cursor()
            dbread = conn2.cursor()

            dbchange.execute("ALTER TABLE Events ADD outgoing BOOL DEFAULT 0")
            dbchange.execute("ALTER TABLE Events ADD mc_profile BOOL DEFAULT 0")
            dbchange.execute("DELETE FROM EventTypes")
            conn.commit()

            dbread.execute("SELECT * FROM EventTypes")
            for row in dbread:
              dbchange.execute("INSERT INTO EventTypes VALUES (?,?,?,?)", row)
            conn.commit()

            dbchange.execute("UPDATE Events SET event_type_id = 1, outgoing = 1 WHERE event_type_id = 2")
            dbchange.execute("UPDATE Events SET event_type_id = 5, outgoing = 1 WHERE event_type_id = 6")
            dbchange.execute("UPDATE Events SET event_type_id = 7, outgoing = 1 WHERE event_type_id = 8")

            conn.commit()
            dbchange.close()
            dbread.close()

            infobox = gtk.VBox(False, 0)
            infolabel = gtk.Label("Your archive have been updated now.\nPlease restart glogarchive.")
            infobox.pack_start(infolabel, True, True, 0)
            infolabel.show()
            infobox.show()
            self.window.add(infobox)
            self.allok = False
          else:
            gmenu = hildon.AppMenu()

            butabout = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "About")
            butabout.connect("clicked", self.show_about)
            gmenu.append(butabout)
            butdonate = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Donate")
            butdonate.connect("clicked", self.show_donate)
            gmenu.append(butdonate)

            butdrop = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Drop Archive")
            butdrop.connect("clicked", drop_archive)
            gmenu.append(butdrop)
            butquit = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Quit")
            butquit.connect("clicked", self.close_application)
            gmenu.append(butquit)

            gmenu.show_all()
            self.window.set_app_menu(gmenu)

            columns = gtk.HBox(False, 0)

            boxlines = gtk.VBox(False, 0)

            butarch = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Archive new Events now!")
            butarch.connect("clicked", archive)
            boxlines.pack_start(butarch, False, False, 0)
            butarch.show()

            self.outlines = gtk.VBox(False, 0)
            scrolled_window = hildon.PannableArea()
            boxlines.pack_start(scrolled_window, True, True, 0)
            scrolled_window.show()
            scrolled_window.add_with_viewport(self.outlines)
            self.outlines.show()

            datebox = gtk.HBox(False, 0)

            self.butfrom = hildon.DateButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
            self.butfrom.set_text("From", "")
            self.butfrom.connect("value-changed", listall, True)
            datebox.pack_start(self.butfrom, True, True, 0)
            self.butfrom.show()

            self.butto = hildon.DateButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
            self.butto.set_text("To", "")
            self.butto.connect("value-changed", listall, True)
            datebox.pack_start(self.butto, True, True, 0)
            self.butto.show()

            butdate = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "View All")
            butdate.connect("clicked", listall)
            datebox.pack_start(butdate, True, True, 0)
            butdate.show()

            boxlines.pack_start(datebox, False, False, 0)
            datebox.show()

            boxlines.show()

            left = gtk.VBox(False, 0)

            self.butcharch = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Switch to Live-Database")
            self.butcharch.connect("clicked", change_db)
            left.pack_start(self.butcharch, False, False, 0)
            self.butcharch.show()
            self.labdb = gtk.Label()
            self.labdb.set_markup("You are viewing:\n<big><b><i>The Archive</i></b></big>")
            self.labdb.set_justify(gtk.JUSTIFY_CENTER)
            left.pack_start(self.labdb, False, False, 0)
            self.labdb.show()

            butgrpevt = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "View Events by Type")
            butgrpevt.connect("clicked", viewevt)
            left.pack_end(butgrpevt, False, False, 0)
            butgrpevt.show()
            butgrpnum = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "View Events by User")
            butgrpnum.connect("clicked", viewuid)
            left.pack_end(butgrpnum, False, False, 0)
            butgrpnum.show()
            butcsv = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Export to CSV-File")
            butcsv.connect("clicked", export_csv)
            left.pack_end(butcsv, False, False, 0)
            butcsv.show()

            searches = gtk.HBox(False, 0)
            self.entry = hildon.Entry(0)
            self.entry.set_max_length(100)
            butsearch = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Find")
            butsearch.connect("clicked", searchall)
            searches.pack_start(self.entry, True, True, 0)
            searches.pack_start(butsearch, True, True, 0)
            left.pack_end(searches, False, False, 0)
            self.entry.show()
            butsearch.show()
            searches.show()

            left.show()

            separator = gtk.VSeparator()
            separator.show()

            columns.pack_start(left, True, True, 0)
            columns.pack_start(separator, False, False, 4)
            columns.pack_start(boxlines, True, True, 0)
            columns.show()
            self.window.add(columns)

        else:
          infobox = gtk.VBox(False, 0)
          infolabel = gtk.Label("Error: eventlogger database not found.\nUpdate maemo 5 PR 1.2, or use glogarchive 0.7.")
          infobox.pack_start(infolabel, True, True, 0)
          infolabel.show()
          infobox.show()
          self.window.add(infobox)
          self.allok = False
        self.window.show()

def archive(widget):
  for child in ui.outlines.get_children()[:]: ui.outlines.remove(child) # child.destroy()
  label = gtk.Label("archiving, please wait...")
  label.set_alignment(0, 0)
  ui.outlines.pack_start(label, False, False, 0)
  label.show()
  if os.path.isfile(EL_PATH):
    if os.path.isfile(ARCHIVE_PATH):
      conn = sqlite3.connect(EL_PATH)
      conn2 = sqlite3.connect(ARCHIVE_PATH)
      cur = conn.cursor()
      curnew = conn2.cursor()
      curins = conn2.cursor()

      curnew.execute("select service_id, event_type_id, storage_time, start_time, end_time, is_read, flags, bytes_sent, bytes_received, local_uid, local_name, remote_uid, channel, free_text, group_uid, outgoing, mc_profile from events")
      allnew = curnew.fetchall()
      cur.execute("select service_id, event_type_id, storage_time, start_time, end_time, is_read, flags, bytes_sent, bytes_received, local_uid, local_name, remote_uid, channel, free_text, group_uid, outgoing, mc_profile from events")
      for row in cur: 
        if row not in allnew:
          curins.execute("insert into events (service_id, event_type_id, storage_time, start_time, end_time, is_read, flags, bytes_sent, bytes_received, local_uid, local_name, remote_uid, channel, free_text, group_uid, outgoing, mc_profile) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", row)
          label = gtk.Label("insert to events... type: %s, timestamp: %s" % (row[1], row[3]))
          label.set_alignment(0, 0)
          ui.outlines.pack_start(label, False, False, 0)
          label.show()
      conn2.commit()

      curnew.execute("select * from remotes")
      allnew = curnew.fetchall()

      cur.execute("select * from remotes")
      for row in cur:
        if row not in allnew:
          if row[1] in zip(*allnew)[1]:
            curins.execute("update remotes set local_uid = ?, remote_name = ?, abook_uid = ? where remote_uid = ?", (row[0], row[2], row[3], row[1]))
            label = gtk.Label("update remotes... %s %s %s %s" % row)
            label.set_alignment(0, 0)
            ui.outlines.pack_start(label, False, False, 0)
            label.show()
          else:
            curins.execute("insert into remotes values (?,?,?,?)", row)
            label = gtk.Label("insert to remotes... %s %s %s %s" % row)
            label.set_alignment(0, 0)
            ui.outlines.pack_start(label, False, False, 0)
            label.show()
      conn2.commit()
      cur.close()
      curnew.close()
      curins.close()
    else:
      label = gtk.Label("Archive not found, copying all from el-v1.db")
      label.set_alignment(0, 0)
      ui.outlines.pack_start(label, False, False, 0)
      label.show()
      shutil.copy(EL_PATH, ARCHIVE_PATH)

    label = gtk.Label("... done!")
    label.set_alignment(0, 0)
    ui.outlines.pack_start(label, False, False, 0)
    label.show()
    hildon.hildon_banner_show_information(ui.window, "", "Done")

  else:
    print("Unable to open eventlogger file")
    sys.exit(1)

def listall(widget, filter = False):
  for child in ui.outlines.get_children()[:]: ui.outlines.remove(child) # child.destroy()
  label = gtk.Label()
  label.set_markup("<i>Summary</i>")
  label.set_justify(gtk.JUSTIFY_CENTER)
  ui.outlines.pack_start(label, False, False, 0)
  label.show()

  if ui.archivedb == True:
    pfad = ARCHIVE_PATH
  else:
    pfad = EL_PATH

  if os.path.isfile(pfad):
    conn = sqlite3.connect(pfad)
    cur = conn.cursor()
    if filter == False:
      cur.execute("select events.event_type_id, count(events.id), events.outgoing from events group by events.event_type_id, events.outgoing order by events.event_type_id, events.outgoing")
      ui.viewall = True
    else:
      ui.viewall = False
      (ayear, amonth, aday) = ui.butfrom.get_date()
      (byear, bmonth, bday) = ui.butto.get_date()
      amonth = amonth+1
      bmonth = bmonth+1
      daten1 = "%d-%02d-%02d" % (ayear, amonth, aday)
      daten2 = "%d-%02d-%02d" % (byear, bmonth, bday)
      stampfrom = time.mktime(time.strptime(daten1, "%Y-%m-%d"))
      stampto = time.mktime(time.strptime(daten2+" 23:59:59", "%Y-%m-%d %H:%M:%S"))
      cur.execute("select events.event_type_id, count(events.id), events.outgoing from events where events.start_time >= ? and events.start_time <= ? group by events.event_type_id, events.outgoing order by events.event_type_id, events.outgoing", (stampfrom, stampto))
    for row in cur:
      sumzeile = gtk.HBox(False, 0)
      label1 = gtk.Label("%s:" % (gettype(row[0], row[2])))
      label1.set_alignment(0, 0)
      label2 = gtk.Label("%d" % (row[1]))
      label2.set_alignment(0, 0)
      sumzeile.pack_start(label1, False, False, 50)
      sumzeile.pack_end(label2, False, False, 50)
      label1.show()
      label2.show()
      sumzeile.show()
      ui.outlines.pack_start(sumzeile, False, False, 0)
    cur.close()
  else:
    label = gtk.Label("Unable to open Database!\nHit the Button above to archive")
    label.set_justify(gtk.JUSTIFY_CENTER)
    ui.outlines.pack_start(label, False, False, 0)
    label.show()
    hildon.hildon_banner_show_information(ui.window, "", "No Archive found!")

def viewuid(widget):
  if ui.archivedb == True:
    pfad = ARCHIVE_PATH
  else:
    pfad = EL_PATH

  if os.path.isfile(pfad):
    winuid = hildon.StackableWindow()
    winuid.set_title("glogarchive: uid")
    winuid.set_border_width(0)
    gruppen = gtk.VBox(False, 0)
    scrolled_window = hildon.PannableArea()
    winuid.add(scrolled_window)
    scrolled_window.add_with_viewport(gruppen)

    conn = sqlite3.connect(pfad)
    cur = conn.cursor()
    cur.execute("select count(Events.id), Events.start_time, Events.remote_uid, Remotes.remote_name, substr(Events.remote_uid, -7) as shortuid from Events left join Remotes on Events.remote_uid = Remotes.remote_uid group by shortuid order by Events.start_time desc")
    for row in cur:
      button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      button.set_style(hildon.BUTTON_STYLE_PICKER)
      if row[3] != None:
        ol1 = "%s (%s)" % (row[3], row[2]) 
      else:
        ol1 = "%s" % (row[2])
      lasttime = time.strftime("%d.%m.%Y %H:%M:%S", time.localtime(row[1]))
      ol2 = "%d events, last: %s" % (row[0], lasttime)
      button.set_text(ol1, ol2)
      button.set_alignment(0, 0, 0, 0)
      button.connect("clicked", viewdetail, row[4], 0, "user")
      gruppen.pack_start(button, False, False, 0)
      button.show()

    gruppen.show()
    scrolled_window.show()
    winuid.show()
    cur.close()

  else:
    label = gtk.Label("Unable to open Archive!\nHit the Button above to archive")
    label.set_justify(gtk.JUSTIFY_CENTER)
    ui.outlines.pack_start(label, False, False, 0)
    label.show()
    hildon.hildon_banner_show_information(ui.window, "", "No Archive found!")

def viewevt(widget):
  if ui.archivedb == True:
    pfad = ARCHIVE_PATH
  else:
    pfad = EL_PATH

  if os.path.isfile(pfad):
    winuid = hildon.StackableWindow()
    winuid.set_title("glogarchive: event")
    winuid.set_border_width(0)

    gruppen = gtk.VBox(False, 0)
    scrolled_window = hildon.PannableArea()
    winuid.add(scrolled_window)
    scrolled_window.add_with_viewport(gruppen)

    conn = sqlite3.connect(pfad)
    cur = conn.cursor()
    cur.execute("select id, name from EventTypes")
    for row in cur:
      button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      button.set_style(hildon.BUTTON_STYLE_PICKER)
      button.set_text(gettype(row[0], 0), row[1])
      button.set_alignment(0, 0, 0, 0)
      button.connect("clicked", viewdetail, row[0], 0, "event")
      gruppen.pack_start(button, False, False, 0)
      button.show()
      if row[0] == 1 or row[0] == 5 or row[0] == 7:
        button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        button.set_style(hildon.BUTTON_STYLE_PICKER)
        button.set_text(gettype(row[0], 1), row[1])
        button.set_alignment(0, 0, 0, 0)
        button.connect("clicked", viewdetail, row[0], 1, "event")
        gruppen.pack_start(button, False, False, 0)
        button.show()

    gruppen.show()
    scrolled_window.show()
    winuid.show()
    cur.close()

  else:
    label = gtk.Label("Unable to open Archive!\nHit the Button above to archive")
    label.set_justify(gtk.JUSTIFY_CENTER)
    ui.outlines.pack_start(label, False, False, 0)
    label.show()
    hildon.hildon_banner_show_information(ui.window, "", "No Archive found!")

def viewdetail(widget, did, inout, viewtype):
  if ui.archivedb == True:
    pfad = ARCHIVE_PATH
  else:
    pfad = EL_PATH

  winuid = hildon.StackableWindow()
  winuid.set_title("glogarchive: "+str(did))
  winuid.set_border_width(0)

  gruppen = gtk.VBox(False, 0)
  scrolled_window = hildon.PannableArea()
  winuid.add(scrolled_window)
  scrolled_window.add_with_viewport(gruppen)

  conn = sqlite3.connect(pfad)
  cur = conn.cursor()
  if viewtype == "user":
    cur.execute("select Events.event_type_id, Events.start_time, Events.free_text, Events.remote_uid, Events.outgoing from Events where substr(Events.remote_uid, -7) = ? order by Events.start_time desc", (did,))
  else:
    cur.execute("select Remotes.remote_name, Events.start_time, Events.free_text, Events.remote_uid, Events.outgoing from Events left join Remotes on Events.remote_uid = Remotes.remote_uid where Events.event_type_id = ? and Events.outgoing = ? order by Events.start_time desc", (did,inout))
  for row in cur:
    lasttime = time.strftime("%d.%m.%Y %H:%M:%S", time.localtime(row[1]))
    if viewtype == "user":
      ol1 = "<b>%s</b> <small>(%s, %s)</small>" % (gettype(row[0], row[4]), cgi.escape(row[3]), lasttime)
    else:
      if row[0] == None:
        ol1 = "%s <small>(%s)</small>" % (cgi.escape(row[3]), lasttime)
      else:
        ol1 = "%s <small>(%s, %s)</small>" % (cgi.escape(row[0]), cgi.escape(row[3]), lasttime)
    if row[2] != None: ol1 = ol1 + "\n<small><i>" + cgi.escape(row[2]) + "</i></small>"
    button = gtk.Label()
    button.set_markup(ol1)
    button.set_alignment(0, 0)
    button.set_line_wrap(True)
    gruppen.pack_start(button, False, False, 3)
    sep = gtk.HSeparator()
    gruppen.pack_start(sep, False, False, 3)
    sep.show()
    button.show()

  gruppen.show()
  scrolled_window.show()
  winuid.show()
  cur.close()

def searchall(widget):
  if ui.archivedb == True:
    pfad = ARCHIVE_PATH
  else:
    pfad = EL_PATH

  sstr = ui.entry.get_text()
  if sstr != "":
    thistitle = sstr
    sstr = "%"+sstr+"%"
    winuid = hildon.StackableWindow()
    winuid.set_title("search for "+thistitle)
    winuid.set_border_width(0)
  
    gruppen = gtk.VBox(False, 0)
    scrolled_window = hildon.PannableArea()
    winuid.add(scrolled_window)
    scrolled_window.add_with_viewport(gruppen)
  
    conn = sqlite3.connect(pfad)
    cur = conn.cursor()
    cur.execute("select Remotes.remote_name, Events.start_time, Events.free_text, Events.remote_uid, Events.event_type_id, Events.outgoing from Events left join Remotes on Events.remote_uid = Remotes.remote_uid where Events.free_text like ? or Events.remote_uid like ? or Remotes.remote_name like ? order by Events.start_time desc", (sstr, sstr, sstr))
    for row in cur:
      lasttime = time.strftime("%d.%m.%Y %H:%M:%S", time.localtime(row[1]))
      if row[0] == None:
        ol1 = "%s: %s <small>(%s)</small>" % (gettype(row[4], row[5]), cgi.escape(row[3]), lasttime)
      else:
        ol1 = "%s: %s <small>(%s, %s)</small>" % (gettype(row[4], row[5]), cgi.escape(row[0]), cgi.escape(row[3]), lasttime)
      if row[2] != None: ol1 = ol1 + "\n<small><i>" + cgi.escape(row[2]) + "</i></small>"
      button = gtk.Label()
      button.set_markup(ol1)
      button.set_alignment(0, 0)
      button.set_line_wrap(True)
      gruppen.pack_start(button, False, False, 3)
      sep = gtk.HSeparator()
      gruppen.pack_start(sep, False, False, 3)
      sep.show()
      button.show()
  
    gruppen.show()
    scrolled_window.show()
    winuid.show()
    cur.close()

def export_csv(widget):
  if ui.archivedb == True:
    pfad = ARCHIVE_PATH
    prefix = "archive-"
  else:
    pfad = EL_PATH
    prefix = "liveDB-"

  if os.path.isfile(pfad):  
    exportdir = os.getenv("MYDOCSDIR")
    if exportdir == "": exportdir = os.getenv("HOME")
    now = time.strftime("%Y%m%d-%H%M%S")
    savefile = exportdir + "/" + prefix + now + ".csv"
    csvfile = open(savefile, 'w')
    conn = sqlite3.connect(pfad)
    cur = conn.cursor()
    archcsv = csv.writer(csvfile, delimiter=';', quoting=csv.QUOTE_NONNUMERIC)
    archcsv.writerow(['ID', 'EventTypes.name', 'Events.Outgoing', 'storage_time', 'start_time', 'end_time', 'is_read', 'flags', 'bytes_sent', 'bytes_received', 'local_uid', 'local_name', 'remote_uid', 'remote_name', 'channel', 'free_text', 'group_uid'])
    cur.execute("SELECT Events.id, EventTypes.name, Events.outgoing, Events.storage_time, Events.start_time, Events.end_time, Events.is_read, Events.flags, Events.bytes_sent, Events.bytes_received, Events.local_uid, Events.local_name, Events.remote_uid, Remotes.remote_name, Events.channel, Events.free_text, Events.group_uid FROM Events LEFT JOIN EventTypes ON Events.event_type_id = EventTypes.id LEFT JOIN Remotes ON Events.remote_uid = Remotes.remote_uid ORDER BY Events.start_time")
    for row in cur:
      archcsv.writerow(row)
    hildon.hildon_banner_show_information(ui.window, "", "File saved to:\n"+savefile)
    csvfile.close()
  else:
    hildon.hildon_banner_show_information(ui.window, "", "No Archive found!")

def drop_archive(widget):
  note = hildon.Note("confirmation", ui.window, "Are you sure to delete the archive?")
  retcode = gtk.Dialog.run(note)
  note.destroy()
  if retcode == gtk.RESPONSE_OK:
    if os.path.isfile(ARCHIVE_PATH):
      os.remove(ARCHIVE_PATH)
      hildon.hildon_banner_show_information(ui.window, "", "Done")
    else:
      hildon.hildon_banner_show_information(ui.window, "", "No Archive found")

def change_db(widget):
  if ui.archivedb == True:
    ui.archivedb = False
    ui.labdb.set_markup("You are viewing:\n<big><b><i>The Live-Eventlogger</i></b></big>")
    ui.butcharch.set_label("Switch to Archive")
  else:
    ui.archivedb = True
    ui.labdb.set_markup("You are viewing:\n<big><b><i>The Archive</i></b></big>")
    ui.butcharch.set_label("Switch to Live-Database")
  if ui.viewall == True:
    listall(ui)
  else:
    listall(ui, True)

def gettype(typename, inout):
  if typename == 1 and inout == 0: return "in CALL"
  if typename == 1 and inout == 1: return "out CALL"
  if typename == 3: return "missed CALL"
  if typename == 4: return "voicemail"
  if typename == 5 and inout == 0: return "in CHAT"
  if typename == 5 and inout == 1: return "out CHAT"
  if typename == 7 and inout == 0: return "in SMS"
  if typename == 7 and inout == 1: return "out SMS"
  if typename == 8: return "notice"
  if typename == 9: return "action msg"
  if typename == 10: return "autoreply msg"
  if typename == 11: return "groupchat joined"
  if typename == 12: return "groupchat leave"
  if typename == 13: return "groupchat topic change"
  return "unknown type"

if __name__ == "__main__":
  ui = fenster()
  if ui.allok == True:
    listall(ui)
  gtk.main()
