#!/usr/bin/env python
from __future__ import with_statement
from httplib2 import Http

import random
from protobufparser import pprint
from protobufparser import proto_parse

import Image

def to_varint(value):
    ret = []
    bits = value & 0x7f
    value >>= 7
    while value:
        ret.append(chr(0x80|bits))
        bits = value & 0x7f
        value >>= 7
    ret.append(chr(bits))
    return ''.join(ret)

def encode_image(image):
    trailingBytes = "\x18\x4B\x20\x01\x30\x00\x92\xEC\xF4\x3B\x09\x18\x00\x38\xC6\x97\xDC\xDF\xF7\x25\x22\x00"
    size = len(image)
    x = to_varint(size)
    a = to_varint(size + 32)
    b = to_varint(size + 14)
    c = to_varint(size + 10)
    return "\x0A"+a+"\x0A"+b+"\x0A"+c+"\x0A"+x+image+trailingBytes

def gen_cssid():
    return "".join([random.choice(['0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f']) for i in xrange(16)])

class Goggles:
    def __init__(self):
        self.headers = {"Content-Type": "application/x-protobuffer", "Pragma": "no-cache", "User-Agent": "Mozilla/5.0 (iPhone; U; CPU iPhone OS 3_1_3 like Mac OS X; en-us) AppleWebKit/528.18 (KHTML, like Gecko) Version/4.0 Mobile/7E18 Safari/528.16 GoogleMobileApp/0.7.3.5675 GoogleGoggles-iPhone/1.0; gzip"}
        self.url = "http://www.google.com/goggles/container_proto?cssid=%s"
        # the following string contains some magic ints and "iPhone OS 4.1 iPhone3GS" as "user-agent"
        self.activation_magic = "\x22\x00\x62\x3C\x0A\x13\x22\x02\x65\x6E\xBA\xD3\xF0\x3B\x0A\x08\x01\x10\x01\x28\x01\x30\x00\x38\x01\x12\x1D\x0A\x09\x69\x50\x68\x6F\x6E\x65\x20\x4F\x53\x12\x03\x34\x2E\x31\x1A\x00\x22\x09\x69\x50\x68\x6F\x6E\x65\x33\x47\x53\x1A\x02\x08\x02\x22\x02\x08\x01"
        self.init_cssid()

    def init_cssid(self):
        self.cssid = gen_cssid()
        h = Http()
        h.request("http://www.google.com/goggles/container_proto?cssid="+self.cssid, "POST", self.activation_magic,headers=self.headers)
                
    def send_image(self, filename):
        if filename.startswith("http"):
            import urllib
            image = urllib.urlopen(filename).read()
        else:
            im_orig = Image.open(filename)
            orig_w, orig_h = im_orig.size

            #resize image (shrink or grow)
            #check if image is too big
            #if orig_w> 800 or orig_h>800:
            if orig_w>orig_h: #landscape or portrait
                    width = 800
                    height = 800 * orig_h/orig_w #keep ratio
            else:
                    height = 800
                    width = 800 * orig_w/orig_h

            im_output = im_orig.resize((width, height), Image.ANTIALIAS) # best down-sizing filter

            #print "debug: saving temp file"
            filename = "/home/user/.ggoggles_last.jpg"
            im_output.save(filename)
            
            with open(filename) as jpg:
                 image = jpg.read()


        h = Http()
        resp, content = h.request("http://www.google.com/goggles/container_proto?cssid="+self.cssid, "POST", encode_image(image),headers=self.headers)


        if resp['status']=='400':
           print "Error: status=400 when sending image to the server"
           #print content
           #raise Error
           return None

        return content

    def process_image(self, image):
        res=   self.send_image(image)
        if res == None:
           print "Error: res=None when processing image"
           return None
        res2 = proto_parse(res)
        return res2

if __name__ == "__main__":
    '''
       With this you can send any image and check what it will return.
    '''
    import sys
    if len(sys.argv) < 2:
        print "url or path of jpeg needed"
        sys.exit(1)
    filename = sys.argv[1]

    #TODO: too small and too big images are dropped (not in KB, but in px)
    g = Goggles()

    try:
        res = g.send_image(filename)
        pprint(res)
    except:
        print "something's wrong."
        sys.exit()

    pprint(res)
    sys.exit(0)

