/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#include <QMessageBox>
#include <QTimer>
#include <QNetworkConfiguration>
#include <QNetworkProxy>

#ifdef Q_WS_MAEMO_5
    #include <QMaemoInternetConnectivity>
#endif

#include "networkapplication.h"

NetworkApplication::NetworkApplication(int &argc, char **argv) :
    QApplication(argc, argv),
    m_session(NULL)
{
#ifdef Q_WS_MAEMO_5
    // Disable annoying connection selection popups on maemo devices
    QMaemoInternetConnectivity::setAutoConnectEnabled(false);
#endif

//    QNetworkProxy proxy;
//    proxy.setType(QNetworkProxy::HttpProxy);
//    proxy.setHostName("localhost");
//    proxy.setPort(8080);
//    QNetworkProxy::setApplicationProxy(proxy);

    m_configManager = new QNetworkConfigurationManager(this);

    // Run started in the eventloop
    QMetaObject::invokeMethod(this, "started", Qt::QueuedConnection);
}

void NetworkApplication::started()
{
    QCoreApplication::processEvents();
    emit onlineStateChanged(m_configManager->isOnline());
    connect(m_configManager, SIGNAL(onlineStateChanged(bool)), SIGNAL(onlineStateChanged(bool)));
}
