/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef GMWITEMMODEL_H
#define GMWITEMMODEL_H

#include "gmwitem.h"

#include <QAbstractTableModel>
#include <QGeoPositionInfo>

class GMWVehicle;

class GMWItemModel : public QAbstractTableModel
{
    Q_OBJECT

public:
    explicit GMWItemModel(QObject *parent = 0);

    QVariant data(const QModelIndex &index, int role) const;

    GMWItem *nearestItem(GMWItem::Type type) const;
    GMWVehicle *findVehicle(const QString &vin) const;

public slots:
    void addObject(GMWItem *item);
    void addObjects(QList<GMWItem*> items);
    void clearAll();
    void clearVehicles();
    void currentPositionChanged(const QGeoCoordinate &position, qreal direction);

    int rowCount(const QModelIndex &parent) const;
    int columnCount(const QModelIndex &parent) const;

private:
    QList<GMWItem*> m_objects;
    QGeoCoordinate m_currentPosition;

private slots:
    void itemChanged();
};

#endif // GMWITEMMODEL_H
