/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#include "menubar.h"

#include "core.h"
#include "mainwindow.h"

#include "data/gmwitemsortfilterproxymodel.h"

MenuBar::MenuBar(QWidget *parent) :
    QMenuBar(parent)
{
    QAction *refreshAllAct = new QAction(tr("&Refresh all items"), this);
    connect(refreshAllAct, SIGNAL(triggered()), Core::mainWindow(), SLOT(refreshAll()));

    QAction *refreshVehiclesAct = new QAction(tr("&Refresh vehicles"), this);
    connect(refreshVehiclesAct, SIGNAL(triggered()), Core::mainWindow(), SLOT(refreshVehicles()));

    QAction *settingsAct = new QAction(tr("&Settings"), this);
    connect(settingsAct, SIGNAL(triggered()), Core::mainWindow(), SLOT(openSettings()));

    QAction *exitAct = new QAction(tr("E&xit"), this);
    exitAct->setShortcuts(QKeySequence::Quit);
    exitAct->setStatusTip(tr("Exit the application"));
    connect(exitAct, SIGNAL(triggered()), Core::mainWindow(), SLOT(close()));

    QAction *aboutAct = new QAction(tr("&About"), this);
    aboutAct->setStatusTip(tr("Show the application's About box"));
    connect(aboutAct, SIGNAL(triggered()), Core::mainWindow(), SLOT(about()));

    m_showCarsAct = new QAction(tr("Show vehicles"), this);
    m_showCarsAct->setCheckable(true);
    m_showCarsAct->setChecked(true);
    connect(m_showCarsAct, SIGNAL(triggered(bool)), SLOT(showCars(bool)));

    m_showGasStationsAct = new QAction(tr("Show gas stations"), this);
    m_showGasStationsAct->setCheckable(true);
    m_showGasStationsAct->setChecked(true);
    connect(m_showGasStationsAct, SIGNAL(triggered(bool)), SLOT(showGasStations(bool)));

    m_showParkingLotsAct = new QAction(tr("Show parking lots"), this);
    m_showParkingLotsAct->setCheckable(true);
    m_showParkingLotsAct->setChecked(true);
    connect(m_showParkingLotsAct, SIGNAL(triggered(bool)), SLOT(showParkingLots(bool)));

    // Menus & Menu Bars
    QMenu *fileMenu = new QMenu(tr("&File"));
    addMenu(fileMenu);
    fileMenu->addAction(refreshAllAct);
    fileMenu->addAction(refreshVehiclesAct);
    fileMenu->addAction(m_showCarsAct);
    fileMenu->addAction(m_showGasStationsAct);
    fileMenu->addAction(m_showParkingLotsAct);
    fileMenu->addAction(settingsAct);

#ifndef Q_WS_MAEMO_5
    fileMenu->addAction(exitAct);
    QMenu *helpMenu = new QMenu(tr("&Help"));
    addMenu(helpMenu);
    helpMenu->addAction(aboutAct);
#else
    fileMenu->addAction(aboutAct);
    fileMenu->addAction(exitAct);
#endif

    connect(Core::proxyModel(), SIGNAL(filterChanged(GMWItem::Types)), SLOT(filterChanged(GMWItem::Types)));
}

MenuBar::~MenuBar()
{
}

void MenuBar::filterChanged(GMWItem::Types types)
{
    m_showCarsAct->setChecked(types & GMWItem::TypeVehicle);
    m_showGasStationsAct->setChecked(types & GMWItem::TypeGasStation);
    m_showParkingLotsAct->setChecked(types & GMWItem::TypeParkingLot);
}

void MenuBar::showCars(bool show) {
    if(show) {
        Core::proxyModel()->setFilterGMWObjectType(Core::proxyModel()->filterGMWObjectType() | GMWItem::TypeVehicle);
    } else {
        Core::proxyModel()->setFilterGMWObjectType(Core::proxyModel()->filterGMWObjectType() & (~GMWItem::TypeVehicle));
    }
}

void MenuBar::showGasStations(bool show) {
    if(show) {
        Core::proxyModel()->setFilterGMWObjectType(Core::proxyModel()->filterGMWObjectType() | GMWItem::TypeGasStation);
    } else {
        Core::proxyModel()->setFilterGMWObjectType(Core::proxyModel()->filterGMWObjectType() & (~GMWItem::TypeGasStation));
    }
}

void MenuBar::showParkingLots(bool show) {
    if(show) {
        Core::proxyModel()->setFilterGMWObjectType(Core::proxyModel()->filterGMWObjectType() | GMWItem::TypeParkingLot);
    } else {
        Core::proxyModel()->setFilterGMWObjectType(Core::proxyModel()->filterGMWObjectType() & (~GMWItem::TypeParkingLot));
    }
}
