/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef MENUBAR_H
#define MENUBAR_H

#include <QtGui/QMenuBar>

#include "data/gmwitem.h"

class MenuBar : public QMenuBar
{
    Q_OBJECT

public:
    MenuBar(QWidget* parent);
    ~MenuBar();

private slots:
    void filterChanged(GMWItem::Types types);

    void showCars(bool show);
    void showGasStations(bool show);
    void showParkingLots(bool show);

private:
    QAction *m_showCarsAct;
    QAction *m_showGasStationsAct;
    QAction *m_showParkingLotsAct;
};

#endif // MENUBAR_H
