/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include <QMainWindow>
#include <QGeoPositionInfo>
#include <QNetworkReply>
#include <QModelIndex>

#include "data/gmwitem.h"

QTM_USE_NAMESPACE

QT_BEGIN_NAMESPACE
class QAction;
class QMenu;
class QLabel;
QT_END_NAMESPACE

QTM_BEGIN_NAMESPACE
class QGeoPositionInfoSource;
QTM_END_NAMESPACE

class GMWMap;
class GMWObjectList;
class GMWItemModel;
class GMWItemSortFilterProxyModel;
class GMWEngine;
class ItemDialog;

namespace qmapcontrol {
    class MapControl;
}

class GMWItemSortFilterProxyModel;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();
    void initialize();

protected:
    void closeEvent(QCloseEvent *event);

signals:
    void positionUpdated(const QGeoCoordinate &currentPosition, qreal direction);

private slots:
    void loadSettings();

    void positionUpdated(const QGeoPositionInfo &info);
    void objectClicked(GMWItem *object);
    void showList();
    void orientationChanged();
    void onlineStateChanged(bool online);
    void downloadStarted();
    void downloadFinished(bool success, const QString &errorString);
    void loadedFromCache(GMWItem::Type, const QDateTime &cacheDate);
    void itemDialogClosed();

    void centerOnStartCoordinates();
    void timerEvent(QTimerEvent *event);

    void openSettings();
    void about();
    void refreshAll(bool useCache = true);
    void refreshVehicles();

private:
    void createStatusBar();
    void grabZoomKeys(bool);

    QMenuBar* createMenuBar(QWidget* parent);

    GMWObjectList *m_objectList;
    ItemDialog *m_itemDialog;
    QGeoPositionInfoSource *m_gps;

    QList<QMenuBar*> m_menus;

    qreal m_direction;

#ifdef Q_WS_MAEMO_5
    Qt::Orientation m_orientation;
#endif

    QLabel *statusBarGPS;
    QLabel *statusBarDownload;
};

#endif
