class Preferences(object):

    _OPTION_DATA_FIELD = ["NONE", "Today","Tomorrow","In a Week"]
    _OPTION_SORT_BY = ["Title", "Category", "Due", "Priority"]
    _COLUMNS_AVAILABLE = ["Done","Title","Due Date", "Due Time", "Location", "Has Reminder", "Category"] 
    
     
    _sort_by = 'Title'
    _location = 'NONE'
    _category = 'NONE'
    _notCompleted_first = False
    _portrait = 0 
    
    _show_completed = True
    
    _show_column_done = True
    _show_column_title = True
    _show_column_dueDate = True
    _show_column_dueTime = True
    _show_column_location = False
    _show_column_reminder = False
    _show_column_category = False
    
    def __init__(self, sort_by, location, category, notCompleted_first, show_completed,show_hide, portrait):        
        self._sort_by = sort_by
        self._location = location
        self._category = category
        self._notCompleted_first = notCompleted_first
        self._show_completed = show_completed
        self.set_show_hide_columns(show_hide)
        self._portrait = portrait

    def get_portrait(self):
        return self._portrait


    def set_portrait(self, value):
        self._portrait = value

    def get_option_data_field(self):
        return self._OPTION_DATA_FIELD

    def get_option_sort_by(self):
        return self._OPTION_SORT_BY


    def set_option_data_field(self, value):
        self._OPTION_DATA_FIELD = value


    def set_option_sort_by(self, value):
        self._OPTION_SORT_BY = value

    def get_sort_by(self):
        return self._sort_by


    def get_location(self):
        return self._location


    def get_category(self):
        return self._category


    def get_not_completed_first(self):
        return self._notCompleted_first


    def get_show_completed(self):
        return self._show_completed


    def set_sort_by(self, value):
        self._sort_by = value


    def set_location(self, value):
        self._location = value


    def set_category(self, value):
        self._category = value


    def set_not_completed_first(self, value):
        self._notCompleted_first = value


    def set_show_completed(self, value):
        self._show_completed = value

    def set_show_hide_columns(self,show_hide):        
        self._show_column_done = show_hide[0]
        self._show_column_title = show_hide[1]
        self._show_column_dueDate = show_hide[2]
        self._show_column_dueTime = show_hide[3]
        self._show_column_location = show_hide[4]
        self._show_column_reminder = show_hide[5]
        self._show_column_category = show_hide[6]
    
    def get_show_hide_columns(self):
        show_hide = []        
        show_hide.append(self._show_column_done)
        show_hide.append(self._show_column_title)
        show_hide.append(self._show_column_dueDate)
        show_hide.append(self._show_column_dueTime)
        show_hide.append(self._show_column_location)
        show_hide.append(self._show_column_reminder)
        show_hide.append(self._show_column_category)
        return show_hide
    
    