#!/usr/bin/env python
__author__="Rafael Brundo Uriarte"
__date__ ="$Dec 27, 2009 6:15:14 PM$"

import DB_Class
import sys
import GeoInterface
import Todo
import Location
import Reminder
import List_todo
import datetime
import BackGroundChecker
import Preferences
try:
    import alarm
except:
    print "No Alarm module found"
    alarm = None
import time
try:
    import location
except:
    print "No Alarm module found"



class Controller:
    
    def __init__(self):
        self._db = DB_Class.Database()
        sort_by, location, category, notCompleted_first, show_completed, id, column0, column1, column2, column3, column4, column5, column6, portrait = self._db.loadPreferencesDB()
        show_hide_columns = [column0,column1,column2,column3,column4,column5,column6]
        self.preferences = Preferences.Preferences(sort_by, location, category, notCompleted_first, show_completed,show_hide_columns, portrait)
        self._todoList = List_todo.List_todo(self._db.get_todos(), self.preferences)
        self._backGroundChecker = BackGroundChecker.BackGroundChecker(self)        
        reminder_uuid, reminder_time = self._get_next_reminder()
        self._backGroundChecker._set_next_reminder(reminder_uuid, reminder_time)
        self._backGroundChecker.start()                
        self._interface = GeoInterface.GeoToDo(self,None,None)        

    def _quick_add_Todo(self, title):
        self._current_todo = Todo.Todo()
        self._current_todo.title = title
        self._db.saveTodoDB(self._current_todo)
        self._todoList._add_todo(self._current_todo)

    def _remove_todo(self, uuid):
        todo = self._retrieve_todo(uuid)
        reminders_uuid = self._db.get_reminders_from_Todo(uuid)
        for reminder in reminders_uuid:
            self._delete_reminder(reminder)     
            reminder_uuid, reminder_time = self._get_next_reminder()
            self._backGroundChecker._set_next_reminder(reminder_uuid, reminder_time)       
        self._db.deleteTodoDB(todo)
        self._todoList._remove_todo(todo)
        
    def _search_address(self,text_address):
        return self._backGroundChecker._search_address(text_address)
    
    def _get_current_List(self):
        todos_uuid = []
        for todo in self._todoList._get_list_view():
            todos_uuid.append(todo.uuid) 
        return todos_uuid

    def _invert_todo_completed(self,uuid):
        self._current_todo = self._todoList._invert_todo_completed(uuid)
        if self._current_todo.completed == 1 :
            for reminder_uuid in self._db.get_reminders_from_Todo(self._current_todo.uuid):
                reminder = self._db.loadRemindernDB(reminder_uuid)
                if reminder.dateTime != 'NONE':
                    alarm.delete_event(reminder.maemoID)            
        else:
            for reminder_uuid in self._db.get_reminders_from_Todo(self._current_todo.uuid):
                reminder = self._db.loadRemindernDB(reminder_uuid)
                if reminder.dateTime != 'NONE':
                    now = datetime.datetime.now().timetuple()
                    now = time.mktime(now)                    
                    if reminder.datetime >= now:
                        self._add_reminder_maemo(reminder, self._current_todo)
                    else:
                        self._delete_reminder(reminder_uuid)                               
        self._db.saveTodoDB(self._current_todo)
        return self._current_todo.get_style()

    def _quick_search(self, textSearch):
        self._todoList._set_search(textSearch)

    def _clean_search(self):
        self._todoList._remove_search()

    def _get_categories(self):
        return self._db.get_categories();

    def _get_locations(self):
        return self._db.get_locations();

    def _set_category(self, category):
        self._todoList._set_category(category)        
        self._db.savePreferencesDB(self.preferences.get_sort_by(),self.preferences.get_location(),self.preferences.get_category(), self.preferences.get_not_completed_first(), self.preferences.get_show_completed(),self.preferences.get_show_hide_columns(), self.preferences.get_portrait())

    def _set_sorting(self, sorting):        
        self._todoList._set_sorting(sorting)
        self._db.savePreferencesDB(self.preferences.get_sort_by(),self.preferences.get_location(),self.preferences.get_category(), self.preferences.get_not_completed_first(), self.preferences.get_show_completed(),self.preferences.get_show_hide_columns(), self.preferences.get_portrait())        

    def _set_location(self, location):
        self._todoList._set_location(location)
        self._db.savePreferencesDB(self.preferences.get_sort_by(),self.preferences.get_location(),self.preferences.get_category(), self.preferences.get_not_completed_first(), self.preferences.get_show_completed(),self.preferences.get_show_hide_columns(), self.preferences.get_portrait())        

    def _retrieve_todo(self, uuid):
        return self._todoList._retrieve_todo(uuid)

    def _get_inf_location(self, location_name):
        list = []
        location = self._load_location(location_name)                                        
        if location is not None:
            list = [location.name, location.description, str(location.latitude), str(location.longitude),location.zoomlevel]
            return list
        else:
            return list
    
    def _get_add_location(self,name_location):
        location = self._load_location(name_location)
        if location is not None:                        
            return location
        else:
            location = Location.Location(name_location)            
            self._db.saveLocationDB(location)
        return location
    
    def _load_location(self, name):
        results = self._db.loadLocationDB(name)        
        if len(results) != 0:
            location = Location.Location(name)
            for atributos in results:
                location.description= atributos[1]
                location.latitude = atributos[2]                
                location.longitude = atributos[3]
                location.zoomlevel = atributos[4]
            return location
        else:
            return None        

    def _add_update_location(self, name_location, description, latitude, longitude,zoomlevel):            
        location = self._load_location(name_location)
        if location is None:
            location = Location.Location(name_location)                                            
        location.description = description
        location.latitude= latitude
        location.longitude = longitude
        location.zoomlevel = zoomlevel
        self._db.saveLocationDB(location)
        

    def _add_reminder(self, date, time, name_location, todo_uuid, distance, unit):        
        reminder = Reminder.Reminder(todo_uuid)                
        if name_location != 'NONE':
            #TODO create a list or method getting the specific location            
            location = self._load_location(name_location)
            reminder.location = location
        else:
            reminder.location = 'NONE'
            if date.find('/') != -1:
                date = date.replace('/', '-')
            reminder.dateTime = datetime.datetime.strptime(date +' '+time, '%d-%m-%Y %H:%M')
        todo_reminder = self._retrieve_todo(todo_uuid)            
        reminder.todo = todo_reminder
        reminder.distance = distance
        reminder.unit = unit
        if reminder.dateTime != 'NONE':        
            self._add_reminder_maemo(reminder,todo_reminder)
        self._db.saveReminderDB(reminder)
        reminder_uuid, reminder_time = self._get_next_reminder()
        self._backGroundChecker._set_next_reminder(reminder_uuid, reminder_time)
        #TODO Do all in this class to keep Model Interface Controller concept!        

    def _get_list_reminders_from_Todo(self, todo_uuid):        
        list_reminders = self._db.get_reminders_from_Todo(todo_uuid)
        if len(list_reminders) != 0:            
            list_uuid_reminders = []                   
            for reminder in list_reminders:                
                list_uuid_reminders.append(reminder)                            
            return list_uuid_reminders
        else:
            return []

    def _get_data_reminder(self,reminder_uuid):
        """Returns date, time, location, todo, distance, unit"""
        reminder = self._db.loadRemindernDB(reminder_uuid)              
        if reminder.location == 'NONE':    
            reminder_time = reminder.dateTime.strftime('%H:%M')     
            reminder_date = reminder.dateTime.strftime('%d-%m-%Y')
            location_name = 'NONE'
        else:
            reminder_time = 'NONE'
            reminder_date = 'NONE'
            location_name = reminder.location.name        
        data_reminder = [reminder_date, reminder_time, location_name,reminder.todo,reminder.distance,reminder.unit]
        return data_reminder
    
    def _save_todo(self,uuid,title,date,time,priority, location, category, description,reminder):
        todo = self._retrieve_todo(uuid)
        if date != 'NONE':
            if  time  != 'NONE':
                dueDateTime = datetime.datetime.strptime(date +' '+time, '%d-%m-%Y %H:%M')
            else:
                #Due date and time MUST have the time or will be 23:59
                #TODO change this limitation
                stringDateTime = date+' 23:59'
                dueDateTime = datetime.datetime.strptime(stringDateTime, '%d-%m-%Y %H:%M')
            todo.dueDateTime = dueDateTime
        else:
            if  time  != 'NONE':                
                today = datetime.datetime.now()
                textDueDate = datetime.datetime.strftime(today, '%d-%m-%Y')
                todo.dueDateTime = datetime.datetime.strptime(textDueDate +' '+time, '%d-%m-%Y %H:%M')
            else:
                todo.dueDateTime = 'NONE'
            
        todo.title = title
        todo.priority = priority
        todo.location = self._get_add_location(location)
        todo.category = category
        todo.description = description
        if reminder is not None:
            if reminder != 0:
                reminder_Time = datetime.timedelta(minutes=reminder)
                reminder_dateTime = (todo.dueDateTime - reminder_Time)
            else:
                reminder_dateTime = todo.dueDateTime
            text_dueDate = reminder_dateTime.strftime('%d-%m-%Y')
            text_dueTime = reminder_dateTime.strftime('%H:%M')
            self._add_reminder(text_dueDate, text_dueTime, 'NONE', todo.uuid, -1, -1)
                        
        self._save_todo_internal(todo)
        
    def _set_todo_completed(self, uuid):
        todo = self._retrieve_todo(uuid)
        todo.completed = 1
        self._save_todo_internal(todo)
        
    def _save_todo_internal(self, todo):
        self._db.saveTodoDB(todo)

    def _get_sort_options(self):
        return self._todoList._get_sort_options()

    def _delete_location(self, location_name):
        #TODO CLEAN REMINDERS AS WELL!!!        
        list_todo_changed = self._todoList._location_deleted(location_name)
        for todo_changed in list_todo_changed:
            self._save_todo_internal(todo_changed)
        self._db.deleteLocationDB(location_name)
        self._db.savePreferencesDB(self.preferences.get_sort_by(),self.preferences.get_location(),self.preferences.get_category(), self.preferences.get_not_completed_first(), self.preferences.get_show_completed(),self.preferences.get_show_hide_columns(), self.preferences.get_portrait())
    
    def _delete_reminder(self, reminder_uuid):        
        reminder = self._db.loadRemindernDB(reminder_uuid)
        if reminder.dateTime != 'NONE':
            alarm.delete_event(reminder.maemoID)
        self._db.deleteReminderDB(reminder_uuid)
        reminder_uuid, reminder_time = self._get_next_reminder()
        self._backGroundChecker._set_next_reminder(reminder_uuid, reminder_time)
    
    
    #MAEMO Specific
    def _add_reminder_maemo(self,reminder,todo_reminder):
        #TODO Check if it's not in the future, database should do but...
        if alarm is not None:        
            event = alarm.Event()
            event.appid = 'GeoToDo'
            event.message = todo_reminder.title
            reminder_date_time = reminder.dateTime.timetuple()
            event.alarm_time = time.mktime(reminder_date_time)
    
            action_stop, action_snooze = event.add_actions(2)
            action_stop.label = "Ok, I Remember"
            action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP
    
            action_snooze.label = 'Snooze'
            action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE
            
            cookie = alarm.add_event(event)
            reminder.maemoID = cookie            
        else:
            #sys.exit('No module alarm found, please install python-alarm')
            print 'TO REMOVE'        


    def _gps_check(self):
        pass        
        #location.distance_between(latitude_s, longitude_s, latitude_f, longitude_f)
    
    def _get_options_date_fields(self):
        return self.preferences.get_option_data_field()    
    
    def _purge_todos_done(self):
        list_all_Todos = self._todoList._get_list_view()
        list_todos_delete = []    
        for todo in list_all_Todos:
            if todo.completed == 1:
                list_todos_delete.append(todo) 
        for todo_delete in list_todos_delete:
            self._remove_todo(todo_delete.uuid)
            
    def _get_gps_coordenates(self):
        return self._init_gps()

    def _init_gps(self):    
        control = location.GPSDControl.get_default()
        device = location.GPSDevice()
        control.set_properties(preferred_method=location.METHOD_USER_SELECTED,preferred_interval=location.INTERVAL_DEFAULT)
        if not device:
            return 'NONE', 'NONE'
        list = device.fix                
        novo = []                
        if str(list[4]).rstrip() == 'nan':
            return 'NONE', 'NONE'
        else:
            novo.append(list[4])
            novo.append(list[5])            
            return novo        
    
    def _get_data_todo(self,uuid):
        """ return title, dueDate, dueTime, description, completed, priority, category, location"""
        todo = self._retrieve_todo(uuid)                
        title = todo.title
        if todo.dueDateTime != 'NONE':
            dueDate = todo.dueDateTime.strftime('%d-%m-%Y')
            dueTime = todo.dueDateTime.strftime('%H:%M')
        else:
            dueDate = 'NONE' 
            dueTime = 'NONE'
                        
        description = todo.description
        completed = todo.completed        
        priority = todo.priority
        category = todo.category
        
        if todo.location != 'NONE':
            location = todo.location.name
        else:
            location = 'NONE'        
        style = todo.get_style()
        fg_color = todo.get_fg_color()
        bg_color = todo.get_bg_color()    
        
        return title, dueDate, dueTime, description, completed, priority, category, location, style, fg_color, bg_color
    def _quit(self):
        sys.exit(None)
        
    def _get_next_reminder(self):
        reminder_uuid = None
        reminder_time = None
        for reminder in self._db.get_reminders():
            reminder = self._db.loadRemindernDB(reminder)
            if reminder.dateTime != 'NONE':
                if reminder_time is not None:
                    reminder_time2 = reminder.dateTime.timetuple()
                    reminder_time2 = time.mktime(reminder_time2)
                    if reminder_time2 < reminder_time:
                        reminder_time = reminder_time2
                        reminder_uuid = reminder.uuid
                else:                    
                    reminder_time2 = reminder.dateTime.timetuple()
                    reminder_time2 = time.mktime(reminder_time2)                
                    reminder_time = reminder_time2
                    reminder_uuid = reminder.uuid
        return reminder_uuid, reminder_time
    
    def _get_reminder_by_location(self):            
        list_reminders = []
        for reminder in self._db.get_reminders():
            reminder = self._db.loadRemindernDB(reminder)
            if reminder.location != 'NONE':                
                    list_reminders.append(reminder)
        return list_reminders

    def _get_sort_by(self):
        return self.preferences.get_sort_by()
    
    def _get_defined_location(self):
        return self.preferences.get_location()
    
    def _get_defined_category(self):
        return self.preferences.get_category()
    
    def _get_showFirst(self):
        return self.preferences.get_not_completed_first()
    
    def _get_showDone(self):
        return self.preferences.get_show_completed()
    
    def _show_completed(self,completed):
        self.preferences.set_show_completed(completed)
        self._db.savePreferencesDB(self.preferences.get_sort_by(),self.preferences.get_location(),self.preferences.get_category(), self.preferences.get_not_completed_first(), self.preferences.get_show_completed(),self.preferences.get_show_hide_columns(), self.preferences.get_portrait())
    
    def _not_completed_first(self, first):
        self.preferences.set_not_completed_first(first)
        self._db.savePreferencesDB(self.preferences.get_sort_by(),self.preferences.get_location(),self.preferences.get_category(), self.preferences.get_not_completed_first(), self.preferences.get_show_completed(),self.preferences.get_show_hide_columns(), self.preferences.get_portrait())
    
    def _update_list(self):
        #self._interface._update_todoList_view()
        pass
        
if __name__ == "__main__":
    Controller()