__author__="Rafael Brundo Uriarte"
__date__ ="$Dec 27, 2009 4:26:22 PM$"

#!/usr/bin/python2.5
# -*- coding: UTF-8 -*-

#TODO Add in filter by location, GPS postion
#TODO Add options in todo details to set completed
import datetime
import gtk
import os.path
import sys

try:
    import hildon
except ImportError:
    hildon = None
#Import OSM-GPS-MAP to work with maps
mydir = os.path.dirname(os.path.abspath(__file__))
libdir = os.path.join(mydir, ".libs")
sys.path.insert(0, libdir)
try:
    import osmgpsmap
except:
    print 'ERROR CAN NOT DISPLAY MAPS PROBLEMS WITH THE OSM GPS MAP'
        
gtk.gdk.threads_init()

class GeoToDo:

    __pretty_app_name__ = "GeoToDo"
    __app_name__ = "GeoToDo"
    __version__ = "0.3.1"
    __context__ = "net.geo.GeoTodo"
    glade_file = 'ui/GeoToDo.glade'    
  
    def __init__(self,controller,app,context):
        self.where_from_context = ["main"]
        self.firstReminder = True        
        self.firstTime = 1
        self.firstTimeAdvLocation = 1
        self.firstTimeSorting = 1
        self.firstTimeCategory = 1
        self.firstTimeLocation = 1
        self.controller = controller
        self._callbackList = None
        self.zoomlevel = 0        
        if os.path.isfile(GeoToDo.glade_file):
            self.builder = gtk.Builder()
            self.builder.add_from_file(GeoToDo.glade_file)
        else:
            sys.exit("Glade file not found on " + GeoToDo.glade_file)
        self._window = self.builder.get_object("MainWindow")                

        global hildon
        if hildon is not None and self._window is gtk.Window:
            #warnings.warn("Hildon installed but glade file not updated to work with hildon", UserWarning, 2)
            hildon = None
        elif hildon is not None:
            self._app = None
            self._isFullScreen = False
            self._app =  hildon.Program()
            self._context = context
            self._window = hildon.StackableWindow()
            self._window.set_icon_name('GeoToDo')
            self._window.set_border_width(0)
            self.builder.get_object("VirtualWindow").reparent(self._window)
            self._app.add_window(self._window)
            hildon.hildon_helper_set_thumb_scrollbar(self.builder.get_object('scrolledwindowList'),True)
            self._window.connect("key-press-event", self._on_key_press)            
            self.create_menu()        
            self._window.set_title("GeoToDo")                

#            try:
#                import osso
#            except ImportError:
            osso = None
            self._osso = None
            if osso is not None:
                self._osso = osso.Context(GeoToDo.__app_name__, GeoToDo.__version__, False)
            else:
                print 'No OSSO'
        else:
            self._window.set_title("%s" % self.__pretty_app_name__)
        self._window.show()
        
        callbackMapping = {      
              "on_bAdd_clicked": self._quick_add_todo,
              "on_bsearch_clicked": self._quick_search,
              "on_bCancel_clicked": self._cancel,
              "on_bValidate_clicked": self._validate_save_todo,
              "on_bDelete_clicked": self._delete_todo,
              "on_bGetDate_clicked": self._datepicker_open,
              "on_bDatepickerCancel_clicked": self._datepicker_cancel,
              "on_bDatepickerValidate_clicked": self._datepicker_validate,
              "on_tDisplay_row_activated":self._open_todo_details,
#              "on_bCat_changed":self._category_changed,
              "on_bDone_clicked":self._set_todo_completed,
 #             "on_bSort_changed" : self._sorting_changed,
  #            "on_bLocation_changed" : self._location_changed,
              "on_eLocation_name_adv_changed" : self._location_adv_changed,
              "on_bAdvancedLocation_clicked" : self._view_advanced_location,
              "on_bCancel_location_adv_clicked" : self._return_advanced_location,
              "on_todoDetails_destroy": self.todoDetails_quit,
              "on_VirtualDatepicker_destroy": self.datepicker_quit,
              "edited_checkbox_cb" : self.edited_checkbox_cb,
              "on_bSave_location_adv_clicked" : self._validate_save_location,
              "on_bSetReminder_clicked" : self._view_set_reminder,
              "on_MainWindow_destroy" : self.quit,
              "on_bZoom_out_clicked":self._zoom_out_clicked,
              "on_bZoom_In_clicked":self._zoom_in_clicked,
              "on_bDelete_Location_clicked" : self._delete_location,
              "on_bDelete_reminder_clicked" : self._delete_reminder,
              "on_bSave_reminder_clicked" : self._save_reminder,
              "on_bCancel_reminder_clicked" : self._return_set_reminder,
              "on_tDisplay_reminder_row_activated" : self._select_reminder,              
              "on_rbBy_date_toggled" : self._reminder_by_date,
              "on_rbBy_loc_toggled" : self._reminder_by_location,
              "on_bGet_GPS_Inf_clicked": self._centrate_gps_coordenates,
              "on_entryAddSearch_key_press_event" : self._buttonPressed_eSearchAdd,
              "on_bSearchLocation_clicked" : self._bSearchLocation,
              "on_eSearchLocation_key_press_event" : self._buttonPressed_bSearchLocation,
              "on_entryAddSearch_clear" : self._buttonPressed_eSearchAdd_clear,                            
        }

        #Send the dictionary to map the call from the interface
        self.builder.connect_signals(callbackMapping)
        
        self._cast_widgets()        
        self._update_todoList_view()        
        gtk.main()
        
    def _buttonPressed_eSearchAdd(self, window, event):        
        #if pressed CTRL + Enter add new
        if event.state & gtk.gdk.CONTROL_MASK and gtk.gdk.keyval_name(event.keyval) == 'KP_Enter':                    
            self._quick_add_todo()
        #if pressed Enter search for
        elif gtk.gdk.keyval_name(event.keyval) == 'KP_Enter':
            self._quick_search()                            
        
    def _buttonPressed_eSearchAdd_clear(self, window):                     
            text = self.widget_mainView_textAddSearch.get_text()
            print '2oi',text,'ciao'
            #if text == '' or text.rstrip() == ' ':
            print 'estou aqui'
            self.controller._clean_search()
            self._update_todoList_view()
                            
    def _buttonPressed_bSearchLocation(self, window, event):
        if gtk.gdk.keyval_name(event.keyval) == 'KP_Enter':
            self._bSearchLocation(None)
            
    def _cast_widgets(self):            
                #I decided to do t method to improv the readability of code, it's much easier to understand... It works as a dictionary
                self.widget_todoView_title = self.builder.get_object('titleToDo')
                self.widget_subViews = self.builder.get_object('VirtualEdit')
                self.widget_todoView = self.builder.get_object('TodoDetails')                                
                self.widget_todoView_desc = self.builder.get_object('todo_description')
                self.widget_todoView_cate = self.builder.get_object('eCat')
                self.widget_todoView_date = self.builder.get_object("todo_duedate")
                self.widget_todoView_loca = self.builder.get_object("eLocation")
                self.widget_todoView_quickReminder = self.builder.get_object("cReminder")
                self.widget_todoView_hour = self.builder.get_object("cHours")
                self.widget_todoView_prio = self.builder.get_object('bPriority')                
                self.widget_remView_byDate = self.builder.get_object("rbBy_date")
                self.widget_remView = self.builder.get_object('VirtualReminder')
                self.widget_remView_listReminders = self.builder.get_object("tDisplay_reminder") 
                self.widget_remView_storeList = self.builder.get_object("_list_store_reminder")
                self.widget_remView_date = self.builder.get_object('eDate_reminder')
                self.widget_remView_time = self.builder.get_object('eTime_reminder')
                self.widget_remView_location = self.builder.get_object('eLocation_reminder')
                self.widget_remView_distance = self.builder.get_object('eDistance_reminder')
                self.widget_remView_unit = self.builder.get_object('cUnit_reminder')
                self.widget_mainView_listStore = self.builder.get_object("_list_store")                                
                self.widget_mainView_textAddSearch = self.builder.get_object("entryAddSearch")
                self.widget_mainView = self.builder.get_object('mainView')               
                self.widget_mainView_listTodos = self.builder.get_object("tDisplay")
                self.widget_locationView = self.builder.get_object('AdvacedLocation')         
                self.widget_locationView_name = self.builder.get_object('eLocation_name_adv')
                self.widget_locationView_lati = self.builder.get_object('eLatitude')
                self.widget_locationView_long = self.builder.get_object('eLongitude')                
                self.widget_locationView_desc = self.builder.get_object('eLocation_description_adv')
                self.widget_locationView_map = self.builder.get_object('map_space')
                self.widget_locationView_bCalendar = self.builder.get_object("bGetDate2")                
                self.widget_calendarView = self.builder.get_object('VirtualDatepicker')
                self.widget_calendarView_calendar = self.builder.get_object("tCalendar")
                self.widget_locationView_eSearch = self.builder.get_object("eSearchLocation")                
                            
    def _bSearchLocation(self,widget):
        search_text = self.widget_locationView_eSearch.get_text()
        results = self.controller._search_address(search_text)
        if results is not None:        
            if len(results) > 1:
                selector = hildon.TouchSelector(text = True)
                for result in results:
                    selector.append_text(result[0])
                dialog = hildon.PickerDialog(self._window)
                dialog.set_selector(selector)
                selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)                
                dialog.show_all()                           
                response = dialog.run()
                if response == gtk.RESPONSE_OK:                    
                    self._center_map(results[selector.get_active(0)][2], results[selector.get_active(0)][1], 16)
                    self.widget_locationView_lati.set_text(str(results[selector.get_active(0)][2]))
                    self.widget_locationView_long.set_text(str(results[selector.get_active(0)][1]))
                    self.widget_locationView_desc.set_text(str(results[selector.get_active(0)][0]))
                    #TODO change the zoom level acording to the search, if it's a country, street, etc
                    self.zoomlevel = 15
                    dialog.destroy()
                elif response == gtk.RESPONSE_CANCEL or response == gtk.RESPONSE_DELETE_EVENT:
                    return "User cancelled request"
                else:
                    return "Unrecognized response %r"
            else:
                self._center_map(results[0][2], results[0][1], 11)
                self.widget_locationView_lati.set_text(str(results[0][2]))
                self.widget_locationView_long.set_text(str(results[0][1]))
                self.widget_locationView_desc.set_text(str(results[0][0]))
        else:
            self._show_error_dialog(self._window, 'Not found or no internet Conection, please check and try again')
                
    def _select_reminder(self,widget, *args):        
        selection = self.widget_remView_listReminders.get_selection()
        #TODO remove MODEL variable
        model, selection_iter = selection.get_selected()        
        if (selection_iter):
            self.reminder_uuid = self.widget_remView_storeList.get_value(selection_iter, 4)
        
                    
    def _delete_reminder(self,widget):
        if self.reminder_uuid != 'NONE':            
            if self._ask_dialogue(self._window,'Do you really want to delete this task ?') == True:                    
                self.controller._delete_reminder(self.reminder_uuid)
                self._update_reminder_view()
        else:                
            self._show_error_dialog(self._window,'Please select a reminder first :)')
            
    def _save_reminder(self,widget):
        if self.type_reminder == 'date':
            #TODO verify if the format is correct, 
            textDate = self.widget_remView_date.get_child().get_text()
            if textDate == 'Today':
                today = datetime.datetime.now()                
                textDate = datetime.datetime.strftime(today, '%d-%m-%Y')
            elif textDate == 'Tomorrow':
                today = datetime.datetime.now()                     
                one_day = datetime.timedelta(days=1)
                textDate = datetime.datetime.strftime(today+one_day, '%d-%m-%Y')
            elif textDate == 'In a Week':
                today = datetime.datetime.now()                     
                seven_days = datetime.timedelta(days=7)                
                textDate = datetime.datetime.strftime(today+seven_days, '%d-%m-%Y')
            else:
                #TODO VERIFY ERROS IN THE FORMAT                
                pass                
            textTime = self.widget_remView_time.get_child().get_text()
            #TODO Veryfy if is older than now!
            self.controller._add_reminder(textDate, textTime, 'NONE', self.uuid, -1, -1)
            self._update_reminder_view()                                    
        #it's by location
        else:            
            model = self.widget_remView_location.get_model()
            active = self.widget_remView_location.get_active()
            location = model[active][0]
            if location != 'All':
                distance = self.widget_remView_distance.get_text()
                
                model_unit = self.widget_remView_unit.get_model()
                active_unit = self.widget_remView_unit.get_active()
                unitText = model_unit[active_unit][0]
                
                if unitText == 'km':
                    unit = 0
                else:
                    unit = 1                
                self.controller._add_reminder('NONE', 'NONE', location, self.uuid, distance, unit)
                self._update_reminder_view()
            else:
                self._show_error_dialog(self._window,'You can not add a reminder to "All" locations, please select one :P')
        
    def _update_reminder_view(self):         
        _reminder_list = self.controller._get_list_reminders_from_Todo(self.uuid)        
        self.widget_remView_storeList.clear()        
        for reminder_uuid in _reminder_list:
            reminder = self.controller._get_data_reminder(reminder_uuid)
            #[reminder_date, reminder_time, reminder.location,reminder.todo,reminder.distance,reminder.unit]            
            if reminder[0] == 'NONE':
                if reminder[5] == 0:
                    reminder_unit = ' km'
                else:
                    reminder_unit = ' m '
                reminder_distance = str(reminder[4]) + str(reminder_unit)
                reminder_location_name = reminder[2]                
                self.widget_remView_storeList.append( ('Location',reminder_location_name,reminder_distance, '#FFFFFF',reminder_uuid ))
            else:
                reminder_date = reminder[0]
                reminder_time = reminder[1]
                self.widget_remView_storeList.append( ('Date',reminder_date,reminder_time, '#FFFFFF',reminder_uuid) )
        self._change_color_reminders()
        
    def _return_set_reminder(self,widget):
        self.where_from_context.pop()        
        if len(self.controller._get_list_reminders_from_Todo(self.uuid)) > 0:
            self.widget_todoView_quickReminder.get_child().set_text('Adv')
        else:
            self.widget_todoView_quickReminder.get_child().set_text('NONE')
        self.widget_todoView.show()
        self.widget_remView.hide()
    
    def _reminder_by_location(self,widget):
        self.widget_remView_location.set_sensitive(True)
        self.widget_remView_distance.set_sensitive(True)
        self.widget_remView_unit.set_sensitive(True)
        self.widget_remView_date.set_sensitive(False)
        self.widget_remView_time.set_sensitive(False)
        self.widget_locationView_bCalendar.set_sensitive(False)
        self.type_reminder = 'location'        
        
    def _reminder_by_date(self,widget):
        self.widget_remView_location.set_sensitive(False)
        self.widget_remView_distance.set_sensitive(False)
        self.widget_remView_unit.set_sensitive(False)
        self.widget_remView_date.set_sensitive(True)
        self.widget_remView_time.set_sensitive(True)
        self.widget_locationView_bCalendar.set_sensitive(True)
        self.type_reminder = 'date'        
                    
    def _quick_add_todo(self,widget=None):
        """Method to add a TODO just with the title"""
        text = self.widget_mainView_textAddSearch.get_text()
        if text != '':
            self.controller._quick_add_Todo(text)
            self.widget_mainView_textAddSearch.set_text('')
            self._update_todoList_view()


    def _quick_search(self,widget=None):
        """Method to search for TODOs just with the title"""
        text = self.widget_mainView_textAddSearch.get_text().lower()
        if text != '':
            self.controller._quick_search(text)
            self._update_todoList_view()
            self.widget_mainView_textAddSearch.select_region(0, len(text))
        else:
            self.controller._clean_search()
            self._update_todoList_view()
            
    def _cancel(self,widget):
        self._return_Main()        


    def _return_Main(self):
        self.where_from_context.pop()                    
        self.widget_todoView.hide()
        self.widget_subViews.hide()        
        self.widget_mainView.show()        
        self.uuid = ''        
        self._update_todoList_view()        

    def _validate_save_location(self, widget):       
        text_location = self.widget_locationView_name.get_child().get_text()
        if  text_location.rstrip() != '':
            if text_location != 'All' :
                latitude = self.widget_locationView_lati.get_text()               
                longitude = self.widget_locationView_long.get_text()               
                description = self.widget_locationView_desc.get_text()
                self.controller._add_update_location(text_location,description, latitude,longitude,self.zoomlevel)
                self.widget_todoView_loca.get_child().set_text(text_location)
                self._return_advanced_location(None)                
            else:
                self.widget_todoView_loca.get_child().set_text('All')
                self._return_advanced_location(None)            
        else:
            self._show_error_dialog(self._window,'The "Title" field is empty :)')


    def _validate_save_todo(self,widget):
        #TODO I know it's very stupid to save it all even if you haven't modified anything but we must leave room for improvements!
        #hahahaha that's what I call lazyness
        #TODO add controll of mispelling errors
        if self.widget_todoView_title.get_text().rstrip() == '':
            self._show_error_dialog(self._window,'The "Title" field is empty :)')
        else:
            title = self.widget_todoView_title.get_text()

            #Get the date and time
            textDueDate = self.widget_todoView_date.get_child().get_text()
            textDueTime = self.widget_todoView_hour.get_child().get_text()
            if textDueTime != 'NONE':
                if not self.validateTime(textDueTime):
                        self._show_error_dialog(self._window, 'The Field time is incorrect please use the format HH:MM')
                        return
            
            if textDueDate != 'NONE':
                if textDueDate == 'Today':
                    today = datetime.datetime.now()                
                    textDueDate = datetime.datetime.strftime(today, '%d-%m-%Y')
                elif textDueDate == 'Tomorrow':
                    today = datetime.datetime.now()                     
                    one_day = datetime.timedelta(days=1)
                    textDueDate = datetime.datetime.strftime(today+one_day, '%d-%m-%Y')
                elif textDueDate == 'In a Week':
                    today = datetime.datetime.now()                     
                    seven_days = datetime.timedelta(days=7)                
                    textDueDate = datetime.datetime.strftime(today+seven_days, '%d-%m-%Y')                                
                else:
                    if not self.validateDate(textDueDate):
                        self._show_error_dialog(self._window, 'The Field data is incorrect please use the format DD-MM-YYYY')
                        return
                    
            #Get the Priority
            model = self.widget_todoView_prio.get_model()
            active = self.widget_todoView_prio.get_active()
            defined_priority = model[active][0]
            if defined_priority != 'NONE':
                priority = int(self._conversor_priority(defined_priority))
            else:
                priority = 'NONE'
            #Get Location and add
            text_location = self.widget_todoView_loca.get_child().get_text()
            if text_location == 'All':                
                text_location = 'NONE'
            #Get Category
            text_category = self.widget_todoView_cate.get_child().get_text()
            if text_category == 'All':
                text_category = 'NONE'
            if self.widget_todoView_quickReminder.get_child().get_text() != 'NONE' and self.widget_todoView_quickReminder.get_child().get_text() != 'Adv':
                if textDueDate != 'NONE' or textDueTime != 'NONE':
                    try:                        
                        reminder = int(self.widget_todoView_quickReminder.get_child().get_text()) 
                    except:
                        self._show_error_dialog(self._window, 'Must be in minutes and an int! Please check the field Reminder')
                        return
                else:
                    self._show_error_dialog(self._window, 'To set a reminder you must set the "Due" field')
                    return
            else:
                reminder = None
            #Get Description
            start,end = self.widget_todoView_desc.get_buffer().get_bounds()
            text_description = self.widget_todoView_desc.get_buffer().get_text(start,end)
            description = text_description
            self.controller._save_todo(self.uuid,title, textDueDate,textDueTime,priority,text_location,text_category,description,reminder)
            self._return_Main()
            

    def _set_todo_completed(self,widget):
        self.controller._set_todo_completed(self.uuid)
        self._return_Main()

    def _delete_todo(self,widget):
        if self._ask_dialogue(self._window,'Do you really want to delete this task ?') == True:
            self.controller._remove_todo(self.uuid)
            self._update_todoList_view()
            self._return_Main()
        
    def _delete_location(self,widget):        
        location_name = self.widget_locationView_name.get_child().get_text()
        if location_name != 'All' and location_name != '':
            location_inf = self.controller._get_inf_location(location_name)
            if len(location_inf) != 0:
                if self._ask_dialogue(self._window,'Do you really want to delete this location ?') == True:
                    self.controller._delete_location(location_name)                                        
                    self.widget_locationView_name.get_child().set_text("All")
                    self.widget_locationView_lati.set_text('0.00')
                    self.widget_locationView_long.set_text('0.00')
                    self.zoomlevel = 0
                    self.widget_locationView_desc.set_text('')
                    model2 = gtk.ListStore(str)
                    for loc in self.controller._get_locations():            
                        model2.append([str(loc)])
                        self.widget_locationView_name.set_model(model2)
                    if self.firstTimeAdvLocation == 1:                        
                        cell2 = gtk.CellRendererText()
                        self.widget_locationView_name.pack_start(cell2)
            else:
                self._show_error_dialog(self._window,"The location is not in your Database, you can't delete \n:/")
        else:
            self._show_error_dialog(self._window,"The location is not in your Database, you can't delete \n:/")

    def _datepicker_open(self,widget):
        self.where_from_context.append('datapicker')
        index = len(self.where_from_context)-2
        if self.where_from_context[index] == 'todo_details' :
            objectDate = self.widget_todoView_date
            view_to_hide = self.widget_todoView
        elif self.where_from_context[index] == 'set_reminder' :
            objectDate = self.widget_remView_date
            view_to_hide = self.widget_remView
            
        try:
            date = datetime.datetime.strptime(objectDate.get_text(),'%d-%m-%Y')
            self.widget_calendarView_calendar.select_month(date.month -1,date.year)
            self.widget_calendarView_calendar.select_day(date.day)
        except:
            try:        
                date = datetime.datetime.strptime(objectDate.get_text().replace('/', '-'),'%d-%m-%Y')
                self.widget_calendarView_calendar.select_month(date.month -1,date.year)
                self.widget_calendarView_calendar.select_day(date.day)
            except:
                date = datetime.datetime.now()
                self.widget_calendarView_calendar.select_month(date.month -1,date.year)
                self.widget_calendarView_calendar.select_day(date.day)

        view_to_hide.hide()

        self.widget_calendarView.show()        

    def _datepicker_cancel(self,widget):        
        index = len(self.where_from_context)-2
        if self.where_from_context[index] == 'todo_details' :                    
            self.widget_todoView.show()
        elif self.where_from_context[index] == 'set_reminder' :            
            self.widget_remView.show()            
        self.widget_calendarView.hide()
        self.where_from_context.pop()
                
    def _datepicker_validate(self,widget):        
        index = len(self.where_from_context)-2
        if self.where_from_context[index] == 'todo_details' :                    
            self.widget_todoView.show()
            objectDate = self.widget_todoView_date            
        elif self.where_from_context[index] == 'set_reminder' :            
            self.widget_remView.show()            
            objectDate = self.widget_remView_date            
        y,m,d = self.widget_calendarView_calendar.get_date()
        objectDate.get_child().set_text(str(d)+'-'+str(m+1)+'-'+str(y))
        self.widget_calendarView.hide()        
        self.where_from_context.pop()

    def _category_changed(self,widget,user_data):        
        self.controller._set_category(widget.get_current_text())
        self._update_todoList_view()
                
    def _sorting_changed(self,widget,user_data):
                self.controller._set_sorting(widget.get_current_text())
                self._update_todoList_view()
        
    def _location_changed(self,widget,user_data):
                self.controller._set_location(widget.get_current_text())
                self._update_todoList_view()        

    def validateDate(self, textDueDate):
        try:
            dueDateTime = textDueDate.replace('/', '-')            
            datetime.datetime.strptime(dueDateTime, '%d-%m-%Y')
            return True
        except:
            return False
    def validateTime(self, textDueTime):
        try:            
            datetime.datetime.strptime(textDueTime, '%H:%M')
            return True
        except:
            return False    
        
    def todoDetails_quit(self, widget):                
        self.quit(None)        

    def datepicker_quit(self, widget):
        self.quit(None)        

    def quit(self, widget):   
        gtk.main_quit()
        self.controller._quit()        

    def _update_todoList_view(self):
        """Update the view of todos"""        
        temp_list_todos = self.controller._get_current_List()                
        self.widget_mainView_listStore.clear()        
        for todo_uuid in temp_list_todos:
            title, dueDate, dueTime, description, completed, priority, category, location, style, fg_color, bg_color = self.controller._get_data_todo(todo_uuid)                        
            self.widget_mainView_listStore.append( (completed, title, category, dueDate, dueTime,todo_uuid, style, fg_color, bg_color))                            

    
    def edited_checkbox_cb(self,cell, path):        
        column = 0
        self.widget_mainView_listStore[path][column] = not self.widget_mainView_listStore[path][column]        
        self.widget_mainView_listStore[path][0] = self.controller._invert_todo_completed(self.widget_mainView_listStore[path][5])
        self._update_todoList_view()
        return


    def _open_todo_details_firstTime_two(self):
        if self.firstTime == 1:
                self.widget_todoView_cate.set_text_column(0)                
                self.widget_todoView_loca.set_text_column(0)
                
                        
    def _open_todo_details_firstTime(self):
            if self.firstTime == 1:
                dateLabels = self.controller._get_options_date_fields()                                           
                modelDate = gtk.ListStore(str)
                for dateLabel in dateLabels:                             
                    modelDate.append([dateLabel])        
                self.widget_todoView_date.set_model(modelDate)
                        
                cellDate = gtk.CellRendererText()                    
                self.widget_todoView_date.pack_start(cellDate)
                self.widget_todoView_date.set_text_column(0)
                                            
                
        #Create some options on the reminder ecombobox
                reminderTimeOptionsMinutes = ['NONE', '00', '10', '30', '60', '90']        
                model5 = gtk.ListStore(str)
                for opt in reminderTimeOptionsMinutes:
                    model5.append([opt])
                self.widget_todoView_quickReminder.set_model(model5)        
                cell5 = gtk.CellRendererText()
                self.widget_todoView_quickReminder.pack_start(cell5)
                self.widget_todoView_quickReminder.set_text_column(0)                
                #Hour ComboBox, add from 00:00 to 24:00 with 30 minutes interval        
                model4 = gtk.ListStore(str)
                for hour in self._generate_hours():
                    model4.append([hour])
                self.widget_todoView_hour.set_model(model4)
                self.widget_todoView_hour.set_text_column(0)
                model3 = gtk.ListStore(str)
                model3.append([str('NONE')])
                for priority_tmp in range(0,4):
                    model3.append([str(self._conversor_priority(priority_tmp))])
                self.widget_todoView_prio.set_model(model3)
                cell3 = gtk.CellRendererText()
                self.widget_todoView_prio.pack_start(cell3)
                self.widget_todoView_prio.add_attribute(cell3,'text',0)                                        
                
                
    def _open_todo_details(self,widget, *args):        
        #Get the todo to populate the windows                        
        self.where_from_context.append('todo_details')
        
        selection = self.widget_mainView_listTodos.get_selection()
        #TODO remove MODEL variable
        model, selection_iter = selection.get_selected()                
        if (selection_iter):
            self.uuid = self.widget_mainView_listStore.get_value(selection_iter, 5)
        #TODO add checkbox of completed!?
        title, dueDate, dueTime, description, completed, priority, category, location, style, bg_color,fg_color = self.controller._get_data_todo(self.uuid)
        self._open_todo_details_firstTime()                    
        #Set the fields with the todo data
        self.widget_todoView_title.set_text(title)
                                    
        self.widget_todoView_date.get_child().set_text(dueDate)
        cell4 = gtk.CellRendererText()
        self.widget_todoView_hour.pack_start(cell4)        
        self.widget_todoView_hour.get_child().set_text(dueTime)
                            
        if description != 'NONE':
            self.widget_todoView_desc.get_buffer().set_text(description)
        else:
            self.widget_todoView_desc.get_buffer().set_text('')

        #Set the fied category with the original category and all the options                    
        model = gtk.ListStore(str)
        #get all possible categories and add to the combo
        for cat in self.controller._get_categories():
            model.append([str(cat)])            
        self.widget_todoView_cate.set_model(model)
        
        cell = gtk.CellRendererText()
        self.widget_todoView_cate.pack_start(cell)
                
        #If no category is set use the ALL that in the db means NONE
        if category != 'NONE':
            self.widget_todoView_cate.get_child().set_text(category)
        else:            
            self.widget_todoView_cate.get_child().set_text("All")
            
        model2 = gtk.ListStore(str)
        for loc in self.controller._get_locations():
            model2.append([str(loc)])
        self.widget_todoView_loca.set_model(model2)        
        cell2 = gtk.CellRendererText()
        self.widget_todoView_loca.pack_start(cell2)
        
        if location != 'NONE':
            self.widget_todoView_loca.get_child().set_text(location)
        else:            
            self.widget_todoView_loca.get_child().set_text("All")        
        
        #TODO Verify is there's one set, if there's and is no minutes before the due date write ADV(advanced) NONE for none and the minutes if are minutes
        #self.widget_todoView_quickReminder.get_child().set_text('NONE')
        
        if priority != 'NONE':                            
            self.widget_todoView_prio.set_active(priority+1)
        else:
            self.widget_todoView_prio.set_active(0)                               
                
        if len(self.controller._get_list_reminders_from_Todo(self.uuid)) > 0:
            self.widget_todoView_quickReminder.get_child().set_text('Adv')
        else:
            self.widget_todoView_quickReminder.get_child().set_text('NONE')
        self._open_todo_details_firstTime_two()
        self.firstTime = 0
        self.widget_subViews.show()
        self.widget_todoView.show()
        self.widget_mainView.hide()
            


    def _conversor_priority(self, numberText):
        dic={
            '0' : 'Low',
            '1' : 'Medium',
            '2' : 'High',
            '3' : 'Critical',
            'Low' : '0',
            'Medium' : '1',
            'High' : '2',
            'Critical' : '3',
            'NONE' : 'NONE'
        }
        return dic.get(str(numberText))

    def _generate_hours(self):
        """Generate all day 30 mim 30 to the button due to time, just making the life easier for those who are lazy and don't want to type"""
        hours = []
        final = []
        for h in range(0,24):
            hours.append(str(h))
            
        final.append('NONE')
        for h in hours:
            final.append(h+':00')
            final.append(h+':30')
        return final
        
    def _ask_dialogue(self, win,message):
        dialog = gtk.MessageDialog(win,
                      gtk.DIALOG_MODAL,
                      gtk.MESSAGE_QUESTION,
                      gtk.BUTTONS_YES_NO,
                      message)
        rc = dialog.run ()
        dialog.destroy ()
        if rc == gtk.RESPONSE_YES:
            return True
        else:
            return False

    def _show_error_dialog(self, win, message):
        dialog = gtk.MessageDialog(win,
                      gtk.DIALOG_MODAL,
                      gtk.MESSAGE_ERROR,
                      gtk.BUTTONS_OK,
                      message)
        dialog.run ()
        dialog.destroy()
        
    
    def _location_adv_changed(self,widget):                
        location_name = self.widget_locationView_name.get_child().get_text()
        changeMapCenter = True
        if self.firstTimeAdvLocation == 1:
            changeMapCenter = False
            
        if location_name != 'All':
            location_inf = self.controller._get_inf_location(location_name)            
            if len(location_inf) != 0:            
                self.widget_locationView_lati.set_text(str(location_inf[2]))
                self.widget_locationView_long.set_text(str(location_inf[3]))                
                self.zoomlevel = location_inf[4]
                if not (str(location_inf[2]) == '0.00' and str(location_inf[3]) == '0.00'):
                    self._center_map(location_inf[2],location_inf[3],self.zoomlevel)
                    changeMapCenter = False                
                
                if location_inf[1] != 'NONE':                    
                    self.widget_locationView_desc.set_text(location_inf[1])
                else:
                    self.widget_locationView_desc.set_text('')
                            
        else:            
            self.widget_locationView_name.get_child().set_text("All")
            self.widget_locationView_lati.set_text('0.00')
            self.widget_locationView_long.set_text('0.00')                        
            self.zoomlevel = 0
            self.widget_locationView_desc.set_text('')
        if changeMapCenter:            
            self._center_map(50.00,50.00,1)
        self.widget_locationView_eSearch.set_text('')
    
    def _view_set_reminder(self,widget):
        self.where_from_context.append('set_reminder')
        self.type_reminder = 'date'
        self.reminder_uuid = 'NONE'
        self.type_reminder = 'date'
        if self.firstReminder:            
            unitsAvailable = ["m ","km"]                                           
            model = gtk.ListStore(str)
            for unit in unitsAvailable:                             
                model.append([unit])        
            self.widget_remView_unit.set_model(model)        
            cell = gtk.CellRendererText()        
            self.widget_remView_unit.pack_start(cell)
            self.widget_remView_unit.add_attribute(cell,'text',0)
            self.widget_remView_unit.set_active(0)
                        
        #Add Locations on the options        
        model2 = gtk.ListStore(str)
        for loc in self.controller._get_locations():            
            model2.append([str(loc)])
        self.widget_remView_location.set_model(model2)                
        cell2 = gtk.CellRendererText()
        self.widget_remView_location.pack_start(cell2)
        if self.firstReminder:
            self.widget_remView_location.add_attribute(cell2,'text',0)
        self.widget_remView_location.set_active(0)                
            
            #Set field cHours
        if self.firstReminder:            
            model4 = gtk.ListStore(str)
            for hour in self._generate_hours():
                model4.append([hour])
                self.widget_remView_time.set_model(model4)
            self.widget_remView_time.set_text_column(0)
            cell4 = gtk.CellRendererText()
            self.widget_remView_time.pack_start(cell4)
            #Set field date
            dateLabels = self.controller._get_options_date_fields()                                           
            modelDate = gtk.ListStore(str)
            for dateLabel in dateLabels:                             
                modelDate.append([dateLabel])        
            self.widget_remView_date.set_model(modelDate)
            self.widget_remView_date.set_text_column(0)        
            cellDate = gtk.CellRendererText()                    
            self.widget_remView_date.pack_start(cellDate)
                                    
            #widgetDate.add_attribute(cellDate,'text',0)
            self.widget_remView_date.get_child().set_text("Today") 
            self.firstReminder = False
        self.widget_remView_byDate.set_active(1)
        self.widget_remView_location.set_sensitive(False)
        self.widget_remView_distance.set_sensitive(False)
        self.widget_remView_unit.set_sensitive(False)
        
        self._update_reminder_view()
        self.widget_todoView.hide()
        self.widget_remView.show()


    def _change_color_reminders(self):                   
        iter = self.widget_remView_storeList.get_iter_root()
        pij = True
        while(iter):
            if pij == True:
                color = '#000000'
            else:
                color = '#000000'
            pij = not pij
            self.widget_remView_storeList.set_value(iter, 3, color)
            iter = self.widget_remView_storeList.iter_next(iter)
        self.widget_remView_listReminders.queue_draw()
        
    def _view_advanced_location(self, widget):
        #TODO Change 'cause an user could come from the MENU(not yet but in the future...)
        self.where_from_context.append('adv_location')                
        changeMapCenter = True
        model2 = gtk.ListStore(str)
        for loc in self.controller._get_locations():            
            model2.append([str(loc)])
        self.widget_locationView_name.set_model(model2)
        if self.firstTimeAdvLocation == 1:
            changeMapCenter = False
            self.widget_locationView_name.set_text_column(0)
        cell2 = gtk.CellRendererText()
        self.widget_locationView_name.pack_start(cell2)
        location_name = self.widget_todoView_loca.get_child().get_text()
        self._load_map()
        if location_name != 'All':            
            location_inf = self.controller._get_inf_location(location_name)                    
            if len(location_inf) != 0:
                self.widget_locationView_name.get_child().set_text(str(location_inf[0]))
                self.widget_locationView_lati.set_text(str(location_inf[2]))
                self.widget_locationView_long.set_text(str(location_inf[3]))
                self.zoomlevel = location_inf[4]                                
                if not (str(location_inf[2]) == '0.00' and str(location_inf[3]) == '0.00'):                
                    self._center_map(location_inf[2],location_inf[3],self.zoomlevel)
                    changeMapCenter = False                                
                if location_inf[1] != 'NONE':
                    
                    self.widget_locationView_desc.set_text(location_inf[1])                    
                else:
                    self.widget_locationView_desc.set_text('')
            else:                
                self.widget_locationView_name.get_child().set_text(self.widget_todoView_loca.get_child().get_text())
                self.widget_locationView_lati.set_text('0.00')
                self.widget_locationView_long.set_text('0.00')
                self.zoomlevel = 0            
                self.widget_locationView_desc.set_text('')            
        else:            
            self.widget_locationView_name.get_child().set_text("All")
            self.widget_locationView_lati.set_text('0.00')
            self.widget_locationView_long.set_text('0.00')            
            self.widget_locationView_desc.set_text('')
            self.zoomlevel = 0           
            
        self.widget_locationView.show()
        if changeMapCenter:            
            self._center_map(50.00,50.00,1)            
        self.firstTimeAdvLocation = 0
        self.widget_todoView.hide()

    def _return_advanced_location(self,widget):        
        self.where_from_context.pop()
        #Update Location button
        model2 = gtk.ListStore(str)
        for loc in self.controller._get_locations():
            model2.append([str(loc)])
        self.widget_todoView_loca.set_model(model2)        
        cell2 = gtk.CellRendererText()
        self.widget_todoView_loca.pack_start(cell2)
        title, dueDate, dueTime, description, completed, priority, category, location, style, bg_color,fg_color = self.controller._get_data_todo(self.uuid)
        if location != 'NONE':
            self.widget_todoView_loca.get_child().set_text(location)
        else:            
            self.widget_todoView_loca.get_child().set_text("All")
        self.widget_locationView_eSearch.set_text('')
        self.widget_locationView.hide()
        self.widget_todoView.show()

    def _on_key_press(self, widget, event, *args):
        """
        @note Hildon specific
        """
        if hildon is not None:
            if event.keyval == gtk.keysyms.F6:
                if self._isFullScreen:
                    self._window.unfullscreen()
                else:
                    self._window.fullscreen()

    def onAbout(self, widget):
        dialog = gtk.AboutDialog()        
        dialog.set_name(self.__pretty_app_name__)
        dialog.set_logo_icon_name(os.path.abspath('../ui/GeoToDo.png'))
        dialog.set_authors(("Rafael Brundo Uriarte","Thanks to : Benoit HERVIER (Khertan), John Stowers","",""))
        dialog.set_comments('a Powerful Todo Manager for Maemo')
        dialog.set_version(self.__version__)
        dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
        dialog.set_copyright("By Rafael")
        dialog.set_website("https://garage.maemo.org/projects/geotodo")
        dialog.connect ("response", lambda d, r: d.destroy())
        dialog.show()
        
    def _purge_todos_done(self,widget):
        self.controller._purge_todos_done()
        self._update_todoList_view()
                
    def _delete_multiple_todos(self,widget):        
        results = self.controller._get_current_List()
        if results is not None:        
            if len(results) > 1:
                selector = hildon.TouchSelector(text = True)
                text_titles = []                
                for result in results:                                
                    title, dueDate, dueTime, description, completed, priority, category, location, style, fg_color, bg_color = self.controller._get_data_todo(result)
                    selector.append_text(title)
                    text_titles.append(title)                    
                dialog = hildon.PickerDialog(self._window)
                dialog.set_selector(selector)
                selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE)                
                selector.unselect_all(0)
                dialog.show_all()                           
                response = dialog.run()
                if response == gtk.RESPONSE_OK:
                    #print results[selector.get_active(0)]
                    current_selection = selector.get_current_text()
                    current_selection = current_selection[1:len(current_selection)-1]
                    list_uuids = []
                    text_todos = '\n'
                    for selected in current_selection.split(','):
                        text_todos += (selected+'\n')                        
                        list_uuids.append(text_titles.index(selected))
                    if self._ask_dialogue(self._window,'Do you really want to delete these todos task? ' + text_todos) == True:
                        for index_uuid in list_uuids:
                            self.controller._remove_todo(results[index_uuid])
                        self._update_todoList_view()
                    dialog.destroy()
                elif response == gtk.RESPONSE_CANCEL or response == gtk.RESPONSE_DELETE_EVENT:
                    return "User cancelled request"
                else:
                    return "Unrecognized response %r"            
        else:
            self._show_error_dialog(self._window, 'List of todos is empty')
        
        
    def create_menu(self):
                    ###                                                
               
        self.menubar = hildon.AppMenu()        
        
        
        item = gtk.Button ('Purge Todos done')        
        item.connect ("clicked", self._purge_todos_done)
        item.show ()
        self.menubar.append (item)
        
        
        item = gtk.Button ('Preferences')        
        item.connect ("clicked", self._edit_preferences)
        item.show ()
        self.menubar.append (item)                

        item = gtk.Button ('Delete Multiple ToDos')        
        item.connect ("clicked", self._delete_multiple_todos)
        item.show ()
        self.menubar.append (item)
        
        item = gtk.Button ('About')        
        item.connect ("clicked", self.onAbout)
        item.show ()
        self.menubar.append (item)
        
        self._window.set_main_menu(self.menubar)        

#FOR MAPS
    def _load_map(self):
        if self.firstTimeAdvLocation == 1:            
            self.osm = osmgpsmap.GpsMap( map_source=osmgpsmap.SOURCE_GOOGLE_STREET,tile_cache=osmgpsmap.get_default_cache_directory() )
            self.osm.connect('button_release_event', self._map_clicked)
            self.widget_locationView_map.pack_start(self.osm)            
            self.widget_locationView_map.show_all()
        pass        

    def _zoom_in_clicked(self, button):
        self.osm.set_zoom(self.osm.props.zoom + 1)

    def _zoom_out_clicked(self, button):
        self.osm.set_zoom(self.osm.props.zoom - 1)

    def _map_clicked(self, osm, event):        
        self.widget_locationView_lati.set_text(str(self.osm.props.latitude))
        self.widget_locationView_long.set_text(str(self.osm.props.longitude))        
        self.zoomlevel = self.osm.props.zoom
    
    def _centrate_gps_coordenates(self,widget):
        list = self.controller._get_gps_coordenates()        
        lat = list[0]
        long = list[1]        
        if lat == 'NONE':
            self._show_error_dialog(self._window,'We could not retrieve information from the GPS, please check if it is connected')
        else:
            self._center_map(lat, long, 17)
    
    def _center_map(self,lat,long,zoomlevel):                        
        self.osm.set_mapcenter(float(lat), float(long), zoomlevel)
        
    def _edit_preferences(self,widget):
        dialog = hildon.Dialog()
        dialog.set_title('Preferences')
        results = self.controller._get_sort_options()
        picker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
        picker.set_title("Sort by: ")
        selector = hildon.TouchSelector(text = True)
        for result in results:
            selector.append_text(result)        
        selector.set_active(0, results.index(self.controller._get_sort_by()))
        picker.set_selector(selector)
        selector.connect("changed", self._sorting_changed)

        picker.set_alignment(.0, .5, 1., 0.)
        child = picker.get_child()
        child.set_padding(0, 0, 12, 0)

        
        dialog.vbox.pack_start(picker, True, True, 0)
        
        results = self.controller._get_locations()
        picker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
        picker.set_title("Locations: ")
        selector = hildon.TouchSelector(text = True)
        for result in results:
            selector.append_text(result)
        if self.controller._get_defined_location() == 'NONE':
            selector.set_active(0, 0)
        else:
            selector.set_active(0, results.index(self.controller._get_defined_location()))
        picker.set_selector(selector)
        selector.connect("changed", self._location_changed)
        picker.set_alignment(.0, .5, 1., 0.)
        child = picker.get_child()
        child.set_padding(0, 0, 12, 0)
        dialog.vbox.pack_start(picker, True, True, 0)
        
        results = self.controller._get_categories()
        picker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
        picker.set_title("Category: ")
        selector = hildon.TouchSelector(text = True)
        for result in results:
            selector.append_text(result)        
        if self.controller._get_defined_category() == 'NONE':
            selector.set_active(0, 0)
        else:
            selector.set_active(0, results.index(self.controller._get_defined_category()))
        
                
        picker.set_selector(selector)
        selector.connect("changed", self._category_changed)
        picker.set_alignment(.0, .5, 1., 0.)
        child = picker.get_child()
        child.set_padding(0, 0, 12, 0)
        dialog.vbox.pack_start(picker, True, True, 0)
        self.firstTime_check_button = True
        self.check_button_show_done = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.check_button_show_done.set_label("Show todos done")
        self.check_button_show_done.connect("toggled", self._on_show_todos_done)
        dialog.vbox.pack_start(self.check_button_show_done, True, True, 0)        
        
        
        self.check_button_show_first = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.check_button_show_first.set_label("Show First Not Done")
        self.check_button_show_first.connect("toggled", self._on_show_first_done)        
        dialog.vbox.pack_start(self.check_button_show_first, True, True, 0)
        if self.controller._get_showFirst():
            self.check_button_show_first.set_active(1)                   
        
        if self.controller._get_showDone():
            self.check_button_show_done.set_active(1)            
            
        if self.check_button_show_done.get_active():
            self.check_button_show_first.set_sensitive(True)
        else:
            self.check_button_show_first.set_sensitive(False)
        
        dialog.show_all()
        dialog.run()        
        dialog.destroy()
        
    def _on_show_todos_done(self, checkbutton):
        if (checkbutton.get_active()):
            self.controller._show_completed(True)                
            self.check_button_show_first.set_sensitive(True)
            self._update_todoList_view()
        else:
            self.controller._show_completed(False)
            #self.builder.get_object("column_done").set_visible(True)            
            self.check_button_show_first.set_sensitive(False)
            self._update_todoList_view()
        self.firstTime_check_button = False
            
    def _on_show_first_done(self,checkbutton):
        if (checkbutton.get_active()):
            self.controller._not_completed_first(True)
            self._update_todoList_view()
        else:
            self.controller._not_completed_first(False)
            self._update_todoList_view()