#include "rcqtextedit.h"
#include <QMouseEvent>
#include <QMenu>
#include <QtGui>
#include <QMessageBox>
#include <QDebug>


RCQTextEdit::RCQTextEdit(QWidget *parent) : QTextEdit(parent)
{
    installEventFilter(this);
}

bool RCQTextEdit::eventFilter(QObject *obj, QEvent *event)
{
    if(event->type() == QEvent::ContextMenu)
    {
        refreshAct=new QAction("Refresh",this);
        openAct=new QAction("open",this);
        connect(refreshAct, SIGNAL(triggered()), this, SLOT(signalrefresh()));
        connect(openAct, SIGNAL(triggered()), this, SLOT(signalopen()));
        QMouseEvent *mouseEvent = static_cast<QMouseEvent*> (event);
        QMenu *menu = new QMenu(this);

        menu->addAction(refreshAct);
        menu->addAction(openAct);
        //menu->addAction(new QAction("Delete",this));
        menu->exec(mouseEvent->globalPos());

        return false;
    }
    else
        return QTextEdit::eventFilter(obj, event);
}
void RCQTextEdit::signalrefresh()
{
    //qDebug() << "number:" << QString::number(signalnr);
    emit this->valueChanged(1);

}
void RCQTextEdit::signalopen()
{
    //qDebug() << "number:" << QString::number(signalnr);
    emit this->valueChanged(2);

}
