#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QKeyEvent>
#include <QEvent>
#include <QWebView>
#include <QActionGroup>
#include <QMainWindow>

#include "toolbutton.h"
#include "location.h"

#ifdef Q_WS_MAEMO_5
    #include "geolocation.h"
    #include "maemo5wnd.h"
#endif

class GoogleDirections;
class GeocodeRequester;
class DirectionsDlg;
class CurrDirectionsDlg;

namespace Ui {
    class MainWindow;
}

class MouseSuppressor  : public QObject {
    Q_OBJECT

public:
    MouseSuppressor(QWebView *pView);

protected:
    bool eventFilter(QObject *, QEvent *e);

signals:
    void click(QMouseEvent *pEvent);

private:
    bool m_isMousePressed;
};

class MainWindow :
#ifdef Q_WS_MAEMO_5
        public Maemo5Wnd
#else
        public QMainWindow
#endif
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    virtual void changeEvent(QEvent *e);
    virtual void keyPressEvent(QKeyEvent *event);
    virtual void resizeEvent(QResizeEvent *pEvent);

public:
    void init();

private:
    void createMenu();
    void load();
    void runJavascript(QString script);
    void incrementTimer();
    void showCurrentDirections();
    void resetDirections();
    void showProgressIndicator(bool show);
    void getDirectionsOnMap();
    void setView(int index);

public slots:
    void javaScriptWindowObjectCleared();
    void reload();
    void directions();
    void resetRoute();
    void find();
    void onPositionUpdated();
    void onRequestfinished(QNetworkReply*);
    void onViewChanged(QAction*);
    void onHideButtons();
    void onClick(QMouseEvent *pEvent);
    void onWest();
    void onEast();
    void onNorth();
    void onSouth();
    void onFindDestinationAddress(bool,QString);
    void onDirectionsFinished(bool,QString);
    void onSourceUpdates(int);
    void onAutoRotate();
    void onTrafficLayer();
    void onShowAccuracy();
    void onBicyclingLayer();
    void onLoadFinished(bool);

private:
    Ui::MainWindow *ui;
    QActionGroup            *m_pViewGroup;
    ToolButton              *m_pToolButtons[4];
    QAction                 *m_pAutoRotateAction;
    QAction                 *m_pTrafficLayer;
    QAction                 *m_pCyclingLayer;
    QAction                 *m_pAccuracyAction;

    bool                    m_isAutoCenter;
    bool                    m_isAutoRotate;
    int                     m_angle;
    QNetworkAccessManager   *m_pNetAccessMngr;
    int                     m_timerCount;
    Location                m_startAddress;
    Location                m_destination;

    GeocodeRequester        *m_pRequester;
    GoogleDirections        *m_pGoogleDirections;
    DirectionsDlg           *m_pDirectionsDlg;
    CurrDirectionsDlg       *m_pCurrDirectionsDlg;

#ifdef Q_WS_MAEMO_5
    GeoLocation m_geoLocation;
    PickSelectorAction      *m_pSourceUpdatesBtt;
#endif

};

#endif // MAINWINDOW_H
