#ifndef LOCATION_H
#define LOCATION_H

#include <QString>

class Location {
public:
    Location(QString desc, double lat, double longitude) {
        m_description = desc;
        m_latitude = lat;
        m_longitude = longitude;
    }

    Location() {}

public:
   virtual double latitude() { return m_latitude; }
   virtual double longitude() {return m_longitude; }
   virtual QString description() { return m_description; }
   virtual void setDescription(QString value) { m_description = value;}
   virtual void setCoordinates(double latitude, double longitude) {
       m_latitude = latitude;
       m_longitude = longitude;
   }
   virtual bool operator==(const Location& other) {
       return m_latitude==other.m_latitude && m_longitude==other.m_longitude;
   }

protected:
   double m_latitude;
   double m_longitude;
   QString m_description;
};

#endif // LOCATION_H
