#ifndef GOOGLEDIRECTIONS_H
#define GOOGLEDIRECTIONS_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QStringList>

#include "directions.h"

class GoogleDirections : public QObject
{
    Q_OBJECT
public:
    explicit GoogleDirections(QNetworkAccessManager *pNetAccessMngr, QObject *parent = 0);
    ~GoogleDirections();

public:
    bool query(QString origin, QString destination,
               QString mode="driving", bool alternatives=false, QString units="metric", QStringList avoid=QStringList());

private:
    QNetworkReply *m_pReply;
    QNetworkAccessManager *m_pNetAccessMngr;

signals:
    void finish(bool success, QString error);

public slots:
    void onFinished();

public:
    QList<Directions>  m_directions;
};

#endif // GOOGLEDIRECTIONS_H
