#ifndef FINDDLG_H
#define FINDDLG_H

#include <QDialog>
#include <QNetworkAccessManager>
#include <QModelIndex>

#include "geocoderequester.h"

namespace Ui {
    class FindDlg;
}

class FindDlg : public QDialog
{
    Q_OBJECT

public:
    explicit FindDlg(QNetworkAccessManager *pNetAccessMngr, QWidget *parent = 0);
    explicit FindDlg(GeocodeRequester& requester, QString address, QWidget *parent = 0);
    ~FindDlg();

protected:
    void changeEvent(QEvent *e);

public:
    GeocodeAddress m_selectedAddress;

private:
    Ui::FindDlg *ui;
    GeocodeRequester m_requester;
    QList<GeocodeAddress*> m_items;

private slots:
    void on_listWidget_doubleClicked(QModelIndex index);
    void on_listWidget_clicked(QModelIndex index);
    void on_pushButton_clicked();
    void onFinish(bool,QString);
};

#endif // FINDDLG_H
