#include "toolbutton.h"

ToolButton::ToolButton(QIcon icon, int alpha, QWidget *parent) :
    QToolButton(parent)
{
    // set the fullsize icon from Maemo's theme
    setIcon(icon);

    // ensure that our size is fixed to our ideal size
    setFixedSize(sizeHint());

    // set the background alpha
    QPalette pal = palette();
    QColor backgroundColor = pal.color(backgroundRole());
    backgroundColor.setAlpha(alpha);
    pal.setColor(backgroundRole(), backgroundColor);
    setPalette(pal);

    // ensure that we're painting our background
    setAutoFillBackground(true);
}
