#ifndef GEOLOCATION_H
#define GEOLOCATION_H

#include <QObject>
#include <QGeoPositionInfoSource>
#include <QGeoSatelliteInfoSource>

#include "location.h"

using namespace QtMobility;

class GeoLocation : public QObject
{
    Q_PROPERTY(double latitude READ latitude)
    Q_PROPERTY(double longitude READ longitude)
    Q_OBJECT

public:
    explicit GeoLocation(QObject *parent = 0);
    ~GeoLocation();

public:
    void setUpdatesPerHour(int updates);
    QString toString();
    Location getLastLocation() { return m_lastLocation; }
    double latitude() { return m_lastLocation.latitude(); }
    double longitude() { return m_lastLocation.longitude(); }
    bool isUpdating() { return m_isUpdating; }

signals:
    void updated();

public slots:
    void positionUpdated(const QGeoPositionInfo &update);

private:
    QGeoPositionInfoSource *m_pSource;
    QGeoSatelliteInfoSource *m_pSatellite;
    bool m_isUpdating;
    Location m_lastLocation;
};

#endif // GEOLOCATION_H
