#ifndef PICKSELECTIONACTION_H
#define PICKSELECTIONACTION_H

#include <QWidgetAction>
#include <QStringListModel>

class PickSelectorAction : public QWidgetAction {
    Q_OBJECT

public:
    PickSelectorAction(QObject *parent=0);
    PickSelectorAction(QStringList list, int selIndex=0, QObject *parent=0);
    virtual ~PickSelectorAction();
    QWidget* createWidget(QWidget *parent);

    QStringList& items();
    void setSelectedIndex(int index);
    int selectedIndex();

signals:
    void selectionChanged(int index);

public slots:
    void optionSelected(const QString&);

protected:
   int m_selectedIndex;
   QStringList m_items;
   QStringListModel *m_pModel;
};

#endif // PICKSELECTIONACTION_H
