#ifndef CURRDIRECTIONSDLG_H
#define CURRDIRECTIONSDLG_H

#include <QDialog>
#include <QList>

#include "directions.h"

namespace Ui {
    class CurrDirectionsDlg;
}

class CurrDirectionsDlg : public QDialog
{
    Q_OBJECT

public:
    enum BUTTON {ButtonNone, ButtonClear, ButtonRecalculate, ButtonNew };

public:
    explicit CurrDirectionsDlg(QList<Directions> directions, QWidget *parent = 0);
    ~CurrDirectionsDlg();

    int selectedIndex();

private:
    Ui::CurrDirectionsDlg *ui;
    QList<Directions> m_directions;

public:
    BUTTON  m_button;

private slots:
    void on_clearBtt_clicked();
    void on_newBtt_clicked();
    void on_recalculateBtt_clicked();
    void on_routesCombo_currentIndexChanged(int index);
};

#endif // CURRDIRECTIONSDLG_H
