#include "currdirectionsdlg.h"
#include "ui_currdirectionsdlg.h"

CurrDirectionsDlg::CurrDirectionsDlg(QList<Directions> directions, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::CurrDirectionsDlg)
{
    m_button = ButtonNone;
    m_directions = directions;

    ui->setupUi(this);

    for ( int c=0; c<m_directions.length(); c++ ) {
        ui->routesCombo->addItem(m_directions[c].m_summary);
    }
    ui->routesCombo->setVisible(m_directions.length()>1);

#ifdef Q_WS_MAEMO_5
    ui->copyrightLbl->setStyleSheet("QLabel{font: 'Nokia Sans'; font-size: 8pt;}");
#endif
}

CurrDirectionsDlg::~CurrDirectionsDlg()
{
    delete ui;
}

void CurrDirectionsDlg::on_routesCombo_currentIndexChanged(int index) {
    ui->directionsList->clear();

    if ( index<0 || index>m_directions.length() ) return;
    Directions& dir(m_directions[index]);
    for ( int c=0; c<dir.m_steps.length(); c++ ) {
        QString str = dir.m_steps[c].description();
        str = str.replace(QRegExp("<[/A-Za-z][a-zA-Z0-9]*[^>]*>"), QString(" "));
        str = str.replace(QRegExp("\\s\\s"), QString(" "));
        ui->directionsList->addItem(str);
    }

    if (dir.m_copyrights.isEmpty()) {
        ui->copyrightLbl->setVisible(false);
    } else {
        ui->copyrightLbl->setText(dir.m_copyrights);
        ui->copyrightLbl->setVisible(true);
    }
}

void CurrDirectionsDlg::on_recalculateBtt_clicked() {
    m_button = ButtonRecalculate;
    accept();
}

void CurrDirectionsDlg::on_newBtt_clicked() {
    m_button = ButtonNew;
    accept();
}

void CurrDirectionsDlg::on_clearBtt_clicked() {
    m_button = ButtonClear;
    accept();
}

int CurrDirectionsDlg::selectedIndex() {
    return ui->routesCombo->currentIndex();
}
