/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GEOLOCATION_H
#define GEOLOCATION_H

#include <QObject>
#include <QGeoPositionInfoSource>
#include <QGeoSatelliteInfoSource>

#include "location.h"

using namespace QtMobility;

class GeoLocation : public QObject
{
    Q_PROPERTY(double latitude READ latitude)
    Q_PROPERTY(double longitude READ longitude)
    Q_PROPERTY(double horizontalAccuracy READ horizontalAccuracy)
    Q_OBJECT

public:
    explicit GeoLocation(QObject *parent = 0);
    ~GeoLocation();

public:
    void setUpdatesPerHour(int updates);
    QString toString();
    QString latitudeStr() const { return QString::number(latitude(), 'g', 10); }
    QString longitudeStr() const { return QString::number(longitude(), 'g', 10); }
    double latitude() const;
    double longitude() const;
    qreal horizontalAccuracy();
    bool isUpdating();

signals:
    void updated();

public slots:
    void positionUpdated(const QGeoPositionInfo &update);

private:
    QGeoPositionInfoSource *m_pSource;
    QGeoSatelliteInfoSource *m_pSatellite;
    bool m_isUpdating;
    QGeoPositionInfo m_lastLocation;
    // Location m_lastLocation;
};

#endif // GEOLOCATION_H
