/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DIRECTIONSMODEL_H
#define DIRECTIONSMODEL_H

#include <QAbstractListModel>

#include "directions.h"

class DirectionsModel : public QAbstractListModel
{
    Q_OBJECT
public:
    explicit DirectionsModel(Directions& directions, QObject *parent = 0);

public:
    virtual int rowCount(const QModelIndex &parent=QModelIndex() ) const;
    virtual QVariant data(const QModelIndex & index, int role=Qt::DisplayRole) const;

    virtual QModelIndex	index( int row, int column = 0, const QModelIndex & parent = QModelIndex() ) const;

private:
    int ceiling(float val) const;

private:
    Directions& m_directions;

signals:

public slots:

};

#endif // DIRECTIONSMODEL_H
