/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CURRDIRECTIONSDLG_H
#define CURRDIRECTIONSDLG_H

#include <QDialog>
#include <QList>

#include <QModelIndex>

#include "directions.h"

class DirectionsModel;
class DirectionsItemDelegate;

namespace Ui {
    class CurrDirectionsDlg;
}

class CurrDirectionsDlg : public QDialog
{
    Q_OBJECT

public:
    enum BUTTON {ButtonNone, ButtonClear, ButtonRecalculate, ButtonNew, ButtonStep };

public:
    explicit CurrDirectionsDlg(QList<Directions> directions, QWidget *parent = 0);
    ~CurrDirectionsDlg();

    int selectedRoutIndex();
    int selectedStepIndex();

private:
    Ui::CurrDirectionsDlg *ui;
    QList<Directions> m_directions;
    DirectionsModel     *m_pModel;
    DirectionsItemDelegate *m_pItemDelegate;
    int                 m_stepIndex;

public:
    BUTTON  m_button;

private slots:
    void on_directionsList_clicked(QModelIndex index);
    void on_directionsList_doubleClicked(QModelIndex index);
    void on_clearBtt_clicked();
    void on_newBtt_clicked();
    void on_recalculateBtt_clicked();
    void on_routesCombo_currentIndexChanged(int index);
};

#endif // CURRDIRECTIONSDLG_H
