/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FINDDLG_H
#define FINDDLG_H

#include <QDialog>
#include <QNetworkAccessManager>
#include <QModelIndex>

#include "geocoderequester.h"

namespace Ui {
    class FindDlg;
}

class FindDlg : public QDialog
{
    Q_OBJECT

public:
    explicit FindDlg(QNetworkAccessManager *pNetAccessMngr, QWidget *parent = 0);
    explicit FindDlg(GeocodeRequester& requester, QString address, QWidget *parent = 0);
    ~FindDlg();

protected:
    void changeEvent(QEvent *e);

public:
    GeocodeAddress m_selectedAddress;

private:
    Ui::FindDlg *ui;
    GeocodeRequester m_requester;
    QList<GeocodeAddress*> m_items;

private slots:
    void on_listWidget_doubleClicked(QModelIndex index);
    void on_listWidget_clicked(QModelIndex index);
    void on_pushButton_clicked();
    void onFinish(bool,QString);
};

#endif // FINDDLG_H
