/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BUSINESS_H
#define BUSINESS_H

#include <QObject>
#include <QStringList>
#include <QList>

#include "location.h"

// ---------------------------------------------------------------------------------------------------------------------
class Phone {
public:
    QString m_number;
    QString m_type;
};

// ---------------------------------------------------------------------------------------------------------------------
class Address {
public:
    QString address();
    QString city();
    QString region();
    QString country();

public:
    QString m_address;
    QString m_city;
    QString m_region;
    QString m_country;
};

// ---------------------------------------------------------------------------------------------------------------------
class Business : public Location
{
public:
    Business();

public:
    QString url();
    QList<Phone> phoneNumbers();

public:
    QString m_url;
    Address m_address;
    QList<Phone> m_phoneNumbers;
};

#endif // BUSINESS_H
