/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QKeyEvent>
#include <QEvent>
#include <QWebView>
#include <QActionGroup>
#include <QMainWindow>

#include "toolbutton.h"
#include "location.h"

#ifdef Q_WS_MAEMO_5
    #include "geolocation.h"
    #include "maemo5wnd.h"
#endif

class GoogleDirections;
class GeocodeRequester;
class DirectionsDlg;
class CurrDirectionsDlg;
class SearchDlg;

namespace Ui {
    class MainWindow;
}

class MouseSuppressor  : public QObject {
    Q_OBJECT

public:
    MouseSuppressor(QWebView *pView);

protected:
    bool eventFilter(QObject *, QEvent *e);

signals:
    void click(QMouseEvent *pEvent);

private:
    bool m_isMousePressed;
};

class MainWindow :
#ifdef Q_WS_MAEMO_5
        public Maemo5Wnd
#else
        public QMainWindow
#endif
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    virtual void changeEvent(QEvent *e);
    virtual void keyPressEvent(QKeyEvent *event);
    virtual void keyReleaseEvent(QKeyEvent *event);
    virtual void resizeEvent(QResizeEvent *pEvent);

public:
    void init();
    void runJavascript(QString script);

private:
    void createMenu();
    void incrementTimer();
    void showCurrentDirections();
    void resetDirections();
    void getDirectionsOnMap();
    void getDirections();
    void setView(int index);
    void showProgressIndicator(bool show);
    void showStep();
    void showDirections();
    void nextRoute();
    void prevRoute();
    void nextStep();
    void prevStep();

public slots:
    void load();
    void javaScriptWindowObjectCleared();
    void reload();
    void directions();
    void search();
    void resetRoute();
    void find();
    void onPositionUpdated();
    void onRequestfinished(QNetworkReply*);
    void onViewChanged(QAction*);
    void onHideButtons();
    void onClick(QMouseEvent *pEvent);
    void onWest();
    void onEast();
    void onNorth();
    void onSouth();
    void onFindDestinationAddress(bool,QString);
    void onDirectionsFinished(bool,QString);
    void onSourceUpdates(int);
    void onAutoRotate();
    void onTrafficLayer();
    void onShowAccuracy();
    void onBicyclingLayer();
    void onLoadFinished(bool);
    void onScroll(QPoint off);

    void zoomIn();
    void zoomOut();
    void test();

private:
    Ui::MainWindow *ui;
    QActionGroup            *m_pViewActionGroup;
    ToolButton              *m_pToolButtons[4];
    QAction                 *m_pAutoRotateAction;
    QAction                 *m_pTrafficLayer;
    QAction                 *m_pCyclingLayer;
    QAction                 *m_pAccuracyAction;

    bool                    m_isReady;
    bool                    m_isAutoCenter;
    bool                    m_isAutoRotate;
    int                     m_angle;
    QNetworkAccessManager   *m_pNetAccessMngr;
    int                     m_timerCount;
    Location                m_startAddress;
    Location                m_destination;
    int                     m_currRouteIndex;
    int                     m_currStepIndex;

    GeocodeRequester        *m_pRequester;
    GoogleDirections        *m_pGoogleDirections;
    DirectionsDlg           *m_pDirectionsDlg;
    CurrDirectionsDlg       *m_pCurrDirectionsDlg;
    SearchDlg               *m_pSearchDlg;

    QStringList             m_queue;

#ifdef Q_WS_MAEMO_5
    GeoLocation m_geoLocation;
    PickSelectorAction      *m_pSourceUpdatesAction;
#endif

};

#endif // MAINWINDOW_H
