/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DIRECTIONS_H
#define DIRECTIONS_H

#include <QString>
#include <QList>
#include <QStringList>

#include "location.h"

class Step : public Location {
public:
    QString toString();
    QString plainDescription();

public:
    int m_duration;
    QString m_durationStr;
    int m_distance;
    QString m_distanceStr;
};

class Directions
{
public:
    Directions();

public:
    QString m_summary;
    QString m_copyrights;
    QString m_warnings;
    QList<Step> m_steps;

    QString m_encodedPoints;
    Location m_start;
    Location m_end;

    int m_distance;
    int m_duration;

#ifdef GOOGLEMAPS_JSON
    QString m_json;
#endif
};

#endif // DIRECTIONS_H
