/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAEMO5WND_H
#define MAEMO5WND_H

#include <QMainWindow>

class PickSelectorAction;

class Maemo5Wnd : public QMainWindow
{
    Q_OBJECT

public:
    explicit Maemo5Wnd(QWidget *parent = 0);
    virtual ~Maemo5Wnd();

public: // static
    static void ShowProgressIndicator(QWidget *pWidget, bool show);

protected:
    void grabZoomKeys(bool grab);

protected:
    void addFullscreenToMenu();
    void addOrientationToMenu();

protected slots:
    void onFullscreen();

public:
    // scren orientation
    void setLandscapeOrPortrait(bool landscape);
    void setAutoRotate(bool autoRotate=true);
    bool isAutoRotate();
    bool isLandscape();

protected:
    PickSelectorAction  *m_pOrientationSelector;

protected slots:
    void onOrientationChanged(int);
};

#endif // MAEMO5WND_H
