/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "localsearchmodel.h"

LocalSearchModel::LocalSearchModel(QObject *parent) :
    QAbstractListModel(parent)
{
}


int LocalSearchModel::rowCount(const QModelIndex &parent/*=QModelIndex()*/ ) const {
    return m_business.length();
}

QVariant LocalSearchModel::data(const QModelIndex &index, int role/*=Qt::DisplayRole*/) const {
    if ( index.row()<0 || index.row()>=m_business.length() ) return QVariant();
    switch ( role ) {
        case Qt::DisplayRole:
            return m_business[index.row()].description();

        default:
            break;
    }

    return QVariant();
}

QModelIndex LocalSearchModel::index( int row, int column/* = 0*/, const QModelIndex& parent/*=QModelIndex()*/ ) const {
    if ( row<0 || row>=m_business.length() || column!=0 || parent.isValid() ) return QAbstractListModel::index(row,column,parent);

    return createIndex(row, column, (void *)&(m_business[row]));
}

LocalSearchModel& LocalSearchModel::operator<<(Business business) {
    m_business << business;
    return *this;
}

void LocalSearchModel::clear() {
    m_business.clear();
}

Business* LocalSearchModel::operator[](int index) {
    return index>=0 && index<m_business.length() ? &m_business[index] : NULL;
}
