#!/usr/bin/env python
import sys
import os

from gargoyle_launcher_gui import *


class GLaunch(QtGui.QMainWindow):
    def __init__(self, argv, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.closeOnExit = True
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.setup_settings()
        #connect buttons
        QtCore.QObject.connect(self.ui.pushButtonBrowse, QtCore.SIGNAL('clicked()'), self.doBrowse)
        QtCore.QObject.connect(self.ui.pushButtonLaunch, QtCore.SIGNAL('clicked()'), self.doLaunch)

        try:                                
            self.ui.lineEditPath.setText(sys.argv[2])
        except:          
            print "no arguments"
            self.load_settings()
        
        if(self.closeOnExit):
            self.ui.checkBoxShutdown.setCheckState(QtCore.Qt.Checked)
        else:
            self.ui.checkBoxShutdown.setCheckState(QtCore.Qt.Unchecked)


    def doBrowse(self):
        self.fileName = QtGui.QFileDialog.getOpenFileName(self, "Open", self.ui.lineEditPath.text(), "All Files (*)")
        self.ui.lineEditPath.setText(self.fileName)

    def doLaunch(self):
        os.system("/usr/bin/gargoyle " + str(self.ui.lineEditPath.text()) + " &")
        self.settings.setValue("last_path", self.ui.lineEditPath.text())
        self.settings.setValue("close_on_exit", self.ui.checkBoxShutdown.isChecked())
        if(self.ui.checkBoxShutdown.isChecked()):
            self.close()


    def setup_settings(self):
        settings = QtCore.QSettings()
        QtCore.QCoreApplication.setOrganizationName('gman.me.uk')
        QtCore.QCoreApplication.setOrganizationDomain('gman.me.uk')
        QtCore.QCoreApplication.setApplicationName('Gargoyle Launcher')
        self.settings = settings

    def load_settings(self):
        try:
            self.ui.lineEditPath.setText(str(self.settings.value("last_path").toString()))
            self.closeOnExit = self.settings.value("close_on_exit").toBool()
            print str(self.settings.value("last_path").toString())
        except:
            print "firstRun... no Savefile found"
            self.ui.lineEditPath.setText("/home/user/MyDocs/.documents/")
        

if __name__ == "__main__":
    #This function means this was run directly, not called from another python file.

    # We instantiate a QApplication passing the arguments of the script to it:
    app = QtGui.QApplication(sys.argv)

    glaunch = GLaunch(sys.argv[1:])
    glaunch.show()

    # Now we can start it.
    sys.exit(app.exec_())

