/* cgunigen.c: Unicode case-mapping tables for Glk API, version 0.7.0.
    Designed by Andrew Plotkin <erkyrath@eblong.com>
    http://www.eblong.com/zarf/glk/index.html

    This file is copyright 1998-2007 by Andrew Plotkin. You may copy,
    distribute, and incorporate it into your own programs, by any means
    and under any conditions, as long as you do not modify it. You may
    also modify this file, incorporate it into your own programs,
    and distribute the modified version, as long as you retain a notice
    in your program or documentation which mentions my name and the URL
    shown above.
*/

/* This file was generated by casemap.py. */

static gli_case_block_t unigen_case_block_0x0[256] = {
    { 0x0, 0x0 },
    { 0x1, 0x1 },
    { 0x2, 0x2 },
    { 0x3, 0x3 },
    { 0x4, 0x4 },
    { 0x5, 0x5 },
    { 0x6, 0x6 },
    { 0x7, 0x7 },
    { 0x8, 0x8 },
    { 0x9, 0x9 },
    { 0xa, 0xa },
    { 0xb, 0xb },
    { 0xc, 0xc },
    { 0xd, 0xd },
    { 0xe, 0xe },
    { 0xf, 0xf },
    { 0x10, 0x10 },
    { 0x11, 0x11 },
    { 0x12, 0x12 },
    { 0x13, 0x13 },
    { 0x14, 0x14 },
    { 0x15, 0x15 },
    { 0x16, 0x16 },
    { 0x17, 0x17 },
    { 0x18, 0x18 },
    { 0x19, 0x19 },
    { 0x1a, 0x1a },
    { 0x1b, 0x1b },
    { 0x1c, 0x1c },
    { 0x1d, 0x1d },
    { 0x1e, 0x1e },
    { 0x1f, 0x1f },
    { 0x20, 0x20 },
    { 0x21, 0x21 },
    { 0x22, 0x22 },
    { 0x23, 0x23 },
    { 0x24, 0x24 },
    { 0x25, 0x25 },
    { 0x26, 0x26 },
    { 0x27, 0x27 },
    { 0x28, 0x28 },
    { 0x29, 0x29 },
    { 0x2a, 0x2a },
    { 0x2b, 0x2b },
    { 0x2c, 0x2c },
    { 0x2d, 0x2d },
    { 0x2e, 0x2e },
    { 0x2f, 0x2f },
    { 0x30, 0x30 },
    { 0x31, 0x31 },
    { 0x32, 0x32 },
    { 0x33, 0x33 },
    { 0x34, 0x34 },
    { 0x35, 0x35 },
    { 0x36, 0x36 },
    { 0x37, 0x37 },
    { 0x38, 0x38 },
    { 0x39, 0x39 },
    { 0x3a, 0x3a },
    { 0x3b, 0x3b },
    { 0x3c, 0x3c },
    { 0x3d, 0x3d },
    { 0x3e, 0x3e },
    { 0x3f, 0x3f },
    { 0x40, 0x40 },
    { 0x41, 0x61 },  /* upper */
    { 0x42, 0x62 },  /* upper */
    { 0x43, 0x63 },  /* upper */
    { 0x44, 0x64 },  /* upper */
    { 0x45, 0x65 },  /* upper */
    { 0x46, 0x66 },  /* upper */
    { 0x47, 0x67 },  /* upper */
    { 0x48, 0x68 },  /* upper */
    { 0x49, 0x69 },  /* upper */
    { 0x4a, 0x6a },  /* upper */
    { 0x4b, 0x6b },  /* upper */
    { 0x4c, 0x6c },  /* upper */
    { 0x4d, 0x6d },  /* upper */
    { 0x4e, 0x6e },  /* upper */
    { 0x4f, 0x6f },  /* upper */
    { 0x50, 0x70 },  /* upper */
    { 0x51, 0x71 },  /* upper */
    { 0x52, 0x72 },  /* upper */
    { 0x53, 0x73 },  /* upper */
    { 0x54, 0x74 },  /* upper */
    { 0x55, 0x75 },  /* upper */
    { 0x56, 0x76 },  /* upper */
    { 0x57, 0x77 },  /* upper */
    { 0x58, 0x78 },  /* upper */
    { 0x59, 0x79 },  /* upper */
    { 0x5a, 0x7a },  /* upper */
    { 0x5b, 0x5b },
    { 0x5c, 0x5c },
    { 0x5d, 0x5d },
    { 0x5e, 0x5e },
    { 0x5f, 0x5f },
    { 0x60, 0x60 },
    { 0x41, 0x61 },  /* lower */
    { 0x42, 0x62 },  /* lower */
    { 0x43, 0x63 },  /* lower */
    { 0x44, 0x64 },  /* lower */
    { 0x45, 0x65 },  /* lower */
    { 0x46, 0x66 },  /* lower */
    { 0x47, 0x67 },  /* lower */
    { 0x48, 0x68 },  /* lower */
    { 0x49, 0x69 },  /* lower */
    { 0x4a, 0x6a },  /* lower */
    { 0x4b, 0x6b },  /* lower */
    { 0x4c, 0x6c },  /* lower */
    { 0x4d, 0x6d },  /* lower */
    { 0x4e, 0x6e },  /* lower */
    { 0x4f, 0x6f },  /* lower */
    { 0x50, 0x70 },  /* lower */
    { 0x51, 0x71 },  /* lower */
    { 0x52, 0x72 },  /* lower */
    { 0x53, 0x73 },  /* lower */
    { 0x54, 0x74 },  /* lower */
    { 0x55, 0x75 },  /* lower */
    { 0x56, 0x76 },  /* lower */
    { 0x57, 0x77 },  /* lower */
    { 0x58, 0x78 },  /* lower */
    { 0x59, 0x79 },  /* lower */
    { 0x5a, 0x7a },  /* lower */
    { 0x7b, 0x7b },
    { 0x7c, 0x7c },
    { 0x7d, 0x7d },
    { 0x7e, 0x7e },
    { 0x7f, 0x7f },
    { 0x80, 0x80 },
    { 0x81, 0x81 },
    { 0x82, 0x82 },
    { 0x83, 0x83 },
    { 0x84, 0x84 },
    { 0x85, 0x85 },
    { 0x86, 0x86 },
    { 0x87, 0x87 },
    { 0x88, 0x88 },
    { 0x89, 0x89 },
    { 0x8a, 0x8a },
    { 0x8b, 0x8b },
    { 0x8c, 0x8c },
    { 0x8d, 0x8d },
    { 0x8e, 0x8e },
    { 0x8f, 0x8f },
    { 0x90, 0x90 },
    { 0x91, 0x91 },
    { 0x92, 0x92 },
    { 0x93, 0x93 },
    { 0x94, 0x94 },
    { 0x95, 0x95 },
    { 0x96, 0x96 },
    { 0x97, 0x97 },
    { 0x98, 0x98 },
    { 0x99, 0x99 },
    { 0x9a, 0x9a },
    { 0x9b, 0x9b },
    { 0x9c, 0x9c },
    { 0x9d, 0x9d },
    { 0x9e, 0x9e },
    { 0x9f, 0x9f },
    { 0xa0, 0xa0 },
    { 0xa1, 0xa1 },
    { 0xa2, 0xa2 },
    { 0xa3, 0xa3 },
    { 0xa4, 0xa4 },
    { 0xa5, 0xa5 },
    { 0xa6, 0xa6 },
    { 0xa7, 0xa7 },
    { 0xa8, 0xa8 },
    { 0xa9, 0xa9 },
    { 0xaa, 0xaa },
    { 0xab, 0xab },
    { 0xac, 0xac },
    { 0xad, 0xad },
    { 0xae, 0xae },
    { 0xaf, 0xaf },
    { 0xb0, 0xb0 },
    { 0xb1, 0xb1 },
    { 0xb2, 0xb2 },
    { 0xb3, 0xb3 },
    { 0xb4, 0xb4 },
    { 0x39c, 0xb5 },  /* lower */
    { 0xb6, 0xb6 },
    { 0xb7, 0xb7 },
    { 0xb8, 0xb8 },
    { 0xb9, 0xb9 },
    { 0xba, 0xba },
    { 0xbb, 0xbb },
    { 0xbc, 0xbc },
    { 0xbd, 0xbd },
    { 0xbe, 0xbe },
    { 0xbf, 0xbf },
    { 0xc0, 0xe0 },  /* upper */
    { 0xc1, 0xe1 },  /* upper */
    { 0xc2, 0xe2 },  /* upper */
    { 0xc3, 0xe3 },  /* upper */
    { 0xc4, 0xe4 },  /* upper */
    { 0xc5, 0xe5 },  /* upper */
    { 0xc6, 0xe6 },  /* upper */
    { 0xc7, 0xe7 },  /* upper */
    { 0xc8, 0xe8 },  /* upper */
    { 0xc9, 0xe9 },  /* upper */
    { 0xca, 0xea },  /* upper */
    { 0xcb, 0xeb },  /* upper */
    { 0xcc, 0xec },  /* upper */
    { 0xcd, 0xed },  /* upper */
    { 0xce, 0xee },  /* upper */
    { 0xcf, 0xef },  /* upper */
    { 0xd0, 0xf0 },  /* upper */
    { 0xd1, 0xf1 },  /* upper */
    { 0xd2, 0xf2 },  /* upper */
    { 0xd3, 0xf3 },  /* upper */
    { 0xd4, 0xf4 },  /* upper */
    { 0xd5, 0xf5 },  /* upper */
    { 0xd6, 0xf6 },  /* upper */
    { 0xd7, 0xd7 },
    { 0xd8, 0xf8 },  /* upper */
    { 0xd9, 0xf9 },  /* upper */
    { 0xda, 0xfa },  /* upper */
    { 0xdb, 0xfb },  /* upper */
    { 0xdc, 0xfc },  /* upper */
    { 0xdd, 0xfd },  /* upper */
    { 0xde, 0xfe },  /* upper */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xc0, 0xe0 },  /* lower */
    { 0xc1, 0xe1 },  /* lower */
    { 0xc2, 0xe2 },  /* lower */
    { 0xc3, 0xe3 },  /* lower */
    { 0xc4, 0xe4 },  /* lower */
    { 0xc5, 0xe5 },  /* lower */
    { 0xc6, 0xe6 },  /* lower */
    { 0xc7, 0xe7 },  /* lower */
    { 0xc8, 0xe8 },  /* lower */
    { 0xc9, 0xe9 },  /* lower */
    { 0xca, 0xea },  /* lower */
    { 0xcb, 0xeb },  /* lower */
    { 0xcc, 0xec },  /* lower */
    { 0xcd, 0xed },  /* lower */
    { 0xce, 0xee },  /* lower */
    { 0xcf, 0xef },  /* lower */
    { 0xd0, 0xf0 },  /* lower */
    { 0xd1, 0xf1 },  /* lower */
    { 0xd2, 0xf2 },  /* lower */
    { 0xd3, 0xf3 },  /* lower */
    { 0xd4, 0xf4 },  /* lower */
    { 0xd5, 0xf5 },  /* lower */
    { 0xd6, 0xf6 },  /* lower */
    { 0xf7, 0xf7 },
    { 0xd8, 0xf8 },  /* lower */
    { 0xd9, 0xf9 },  /* lower */
    { 0xda, 0xfa },  /* lower */
    { 0xdb, 0xfb },  /* lower */
    { 0xdc, 0xfc },  /* lower */
    { 0xdd, 0xfd },  /* lower */
    { 0xde, 0xfe },  /* lower */
    { 0x178, 0xff },  /* lower */
};

static gli_case_block_t unigen_case_block_0x1[256] = {
    { 0x100, 0x101 },  /* upper */
    { 0x100, 0x101 },  /* lower */
    { 0x102, 0x103 },  /* upper */
    { 0x102, 0x103 },  /* lower */
    { 0x104, 0x105 },  /* upper */
    { 0x104, 0x105 },  /* lower */
    { 0x106, 0x107 },  /* upper */
    { 0x106, 0x107 },  /* lower */
    { 0x108, 0x109 },  /* upper */
    { 0x108, 0x109 },  /* lower */
    { 0x10a, 0x10b },  /* upper */
    { 0x10a, 0x10b },  /* lower */
    { 0x10c, 0x10d },  /* upper */
    { 0x10c, 0x10d },  /* lower */
    { 0x10e, 0x10f },  /* upper */
    { 0x10e, 0x10f },  /* lower */
    { 0x110, 0x111 },  /* upper */
    { 0x110, 0x111 },  /* lower */
    { 0x112, 0x113 },  /* upper */
    { 0x112, 0x113 },  /* lower */
    { 0x114, 0x115 },  /* upper */
    { 0x114, 0x115 },  /* lower */
    { 0x116, 0x117 },  /* upper */
    { 0x116, 0x117 },  /* lower */
    { 0x118, 0x119 },  /* upper */
    { 0x118, 0x119 },  /* lower */
    { 0x11a, 0x11b },  /* upper */
    { 0x11a, 0x11b },  /* lower */
    { 0x11c, 0x11d },  /* upper */
    { 0x11c, 0x11d },  /* lower */
    { 0x11e, 0x11f },  /* upper */
    { 0x11e, 0x11f },  /* lower */
    { 0x120, 0x121 },  /* upper */
    { 0x120, 0x121 },  /* lower */
    { 0x122, 0x123 },  /* upper */
    { 0x122, 0x123 },  /* lower */
    { 0x124, 0x125 },  /* upper */
    { 0x124, 0x125 },  /* lower */
    { 0x126, 0x127 },  /* upper */
    { 0x126, 0x127 },  /* lower */
    { 0x128, 0x129 },  /* upper */
    { 0x128, 0x129 },  /* lower */
    { 0x12a, 0x12b },  /* upper */
    { 0x12a, 0x12b },  /* lower */
    { 0x12c, 0x12d },  /* upper */
    { 0x12c, 0x12d },  /* lower */
    { 0x12e, 0x12f },  /* upper */
    { 0x12e, 0x12f },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x49, 0x131 },  /* lower */
    { 0x132, 0x133 },  /* upper */
    { 0x132, 0x133 },  /* lower */
    { 0x134, 0x135 },  /* upper */
    { 0x134, 0x135 },  /* lower */
    { 0x136, 0x137 },  /* upper */
    { 0x136, 0x137 },  /* lower */
    { 0x138, 0x138 },
    { 0x139, 0x13a },  /* upper */
    { 0x139, 0x13a },  /* lower */
    { 0x13b, 0x13c },  /* upper */
    { 0x13b, 0x13c },  /* lower */
    { 0x13d, 0x13e },  /* upper */
    { 0x13d, 0x13e },  /* lower */
    { 0x13f, 0x140 },  /* upper */
    { 0x13f, 0x140 },  /* lower */
    { 0x141, 0x142 },  /* upper */
    { 0x141, 0x142 },  /* lower */
    { 0x143, 0x144 },  /* upper */
    { 0x143, 0x144 },  /* lower */
    { 0x145, 0x146 },  /* upper */
    { 0x145, 0x146 },  /* lower */
    { 0x147, 0x148 },  /* upper */
    { 0x147, 0x148 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x14a, 0x14b },  /* upper */
    { 0x14a, 0x14b },  /* lower */
    { 0x14c, 0x14d },  /* upper */
    { 0x14c, 0x14d },  /* lower */
    { 0x14e, 0x14f },  /* upper */
    { 0x14e, 0x14f },  /* lower */
    { 0x150, 0x151 },  /* upper */
    { 0x150, 0x151 },  /* lower */
    { 0x152, 0x153 },  /* upper */
    { 0x152, 0x153 },  /* lower */
    { 0x154, 0x155 },  /* upper */
    { 0x154, 0x155 },  /* lower */
    { 0x156, 0x157 },  /* upper */
    { 0x156, 0x157 },  /* lower */
    { 0x158, 0x159 },  /* upper */
    { 0x158, 0x159 },  /* lower */
    { 0x15a, 0x15b },  /* upper */
    { 0x15a, 0x15b },  /* lower */
    { 0x15c, 0x15d },  /* upper */
    { 0x15c, 0x15d },  /* lower */
    { 0x15e, 0x15f },  /* upper */
    { 0x15e, 0x15f },  /* lower */
    { 0x160, 0x161 },  /* upper */
    { 0x160, 0x161 },  /* lower */
    { 0x162, 0x163 },  /* upper */
    { 0x162, 0x163 },  /* lower */
    { 0x164, 0x165 },  /* upper */
    { 0x164, 0x165 },  /* lower */
    { 0x166, 0x167 },  /* upper */
    { 0x166, 0x167 },  /* lower */
    { 0x168, 0x169 },  /* upper */
    { 0x168, 0x169 },  /* lower */
    { 0x16a, 0x16b },  /* upper */
    { 0x16a, 0x16b },  /* lower */
    { 0x16c, 0x16d },  /* upper */
    { 0x16c, 0x16d },  /* lower */
    { 0x16e, 0x16f },  /* upper */
    { 0x16e, 0x16f },  /* lower */
    { 0x170, 0x171 },  /* upper */
    { 0x170, 0x171 },  /* lower */
    { 0x172, 0x173 },  /* upper */
    { 0x172, 0x173 },  /* lower */
    { 0x174, 0x175 },  /* upper */
    { 0x174, 0x175 },  /* lower */
    { 0x176, 0x177 },  /* upper */
    { 0x176, 0x177 },  /* lower */
    { 0x178, 0xff },  /* upper */
    { 0x179, 0x17a },  /* upper */
    { 0x179, 0x17a },  /* lower */
    { 0x17b, 0x17c },  /* upper */
    { 0x17b, 0x17c },  /* lower */
    { 0x17d, 0x17e },  /* upper */
    { 0x17d, 0x17e },  /* lower */
    { 0x53, 0x17f },  /* lower */
    { 0x180, 0x180 },
    { 0x181, 0x253 },  /* upper */
    { 0x182, 0x183 },  /* upper */
    { 0x182, 0x183 },  /* lower */
    { 0x184, 0x185 },  /* upper */
    { 0x184, 0x185 },  /* lower */
    { 0x186, 0x254 },  /* upper */
    { 0x187, 0x188 },  /* upper */
    { 0x187, 0x188 },  /* lower */
    { 0x189, 0x256 },  /* upper */
    { 0x18a, 0x257 },  /* upper */
    { 0x18b, 0x18c },  /* upper */
    { 0x18b, 0x18c },  /* lower */
    { 0x18d, 0x18d },
    { 0x18e, 0x1dd },  /* upper */
    { 0x18f, 0x259 },  /* upper */
    { 0x190, 0x25b },  /* upper */
    { 0x191, 0x192 },  /* upper */
    { 0x191, 0x192 },  /* lower */
    { 0x193, 0x260 },  /* upper */
    { 0x194, 0x263 },  /* upper */
    { 0x1f6, 0x195 },  /* lower */
    { 0x196, 0x269 },  /* upper */
    { 0x197, 0x268 },  /* upper */
    { 0x198, 0x199 },  /* upper */
    { 0x198, 0x199 },  /* lower */
    { 0x19a, 0x19a },
    { 0x19b, 0x19b },
    { 0x19c, 0x26f },  /* upper */
    { 0x19d, 0x272 },  /* upper */
    { 0x220, 0x19e },  /* lower */
    { 0x19f, 0x275 },  /* upper */
    { 0x1a0, 0x1a1 },  /* upper */
    { 0x1a0, 0x1a1 },  /* lower */
    { 0x1a2, 0x1a3 },  /* upper */
    { 0x1a2, 0x1a3 },  /* lower */
    { 0x1a4, 0x1a5 },  /* upper */
    { 0x1a4, 0x1a5 },  /* lower */
    { 0x1a6, 0x280 },  /* upper */
    { 0x1a7, 0x1a8 },  /* upper */
    { 0x1a7, 0x1a8 },  /* lower */
    { 0x1a9, 0x283 },  /* upper */
    { 0x1aa, 0x1aa },
    { 0x1ab, 0x1ab },
    { 0x1ac, 0x1ad },  /* upper */
    { 0x1ac, 0x1ad },  /* lower */
    { 0x1ae, 0x288 },  /* upper */
    { 0x1af, 0x1b0 },  /* upper */
    { 0x1af, 0x1b0 },  /* lower */
    { 0x1b1, 0x28a },  /* upper */
    { 0x1b2, 0x28b },  /* upper */
    { 0x1b3, 0x1b4 },  /* upper */
    { 0x1b3, 0x1b4 },  /* lower */
    { 0x1b5, 0x1b6 },  /* upper */
    { 0x1b5, 0x1b6 },  /* lower */
    { 0x1b7, 0x292 },  /* upper */
    { 0x1b8, 0x1b9 },  /* upper */
    { 0x1b8, 0x1b9 },  /* lower */
    { 0x1ba, 0x1ba },
    { 0x1bb, 0x1bb },
    { 0x1bc, 0x1bd },  /* upper */
    { 0x1bc, 0x1bd },  /* lower */
    { 0x1be, 0x1be },
    { 0x1f7, 0x1bf },  /* lower */
    { 0x1c0, 0x1c0 },
    { 0x1c1, 0x1c1 },
    { 0x1c2, 0x1c2 },
    { 0x1c3, 0x1c3 },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1cd, 0x1ce },  /* upper */
    { 0x1cd, 0x1ce },  /* lower */
    { 0x1cf, 0x1d0 },  /* upper */
    { 0x1cf, 0x1d0 },  /* lower */
    { 0x1d1, 0x1d2 },  /* upper */
    { 0x1d1, 0x1d2 },  /* lower */
    { 0x1d3, 0x1d4 },  /* upper */
    { 0x1d3, 0x1d4 },  /* lower */
    { 0x1d5, 0x1d6 },  /* upper */
    { 0x1d5, 0x1d6 },  /* lower */
    { 0x1d7, 0x1d8 },  /* upper */
    { 0x1d7, 0x1d8 },  /* lower */
    { 0x1d9, 0x1da },  /* upper */
    { 0x1d9, 0x1da },  /* lower */
    { 0x1db, 0x1dc },  /* upper */
    { 0x1db, 0x1dc },  /* lower */
    { 0x18e, 0x1dd },  /* lower */
    { 0x1de, 0x1df },  /* upper */
    { 0x1de, 0x1df },  /* lower */
    { 0x1e0, 0x1e1 },  /* upper */
    { 0x1e0, 0x1e1 },  /* lower */
    { 0x1e2, 0x1e3 },  /* upper */
    { 0x1e2, 0x1e3 },  /* lower */
    { 0x1e4, 0x1e5 },  /* upper */
    { 0x1e4, 0x1e5 },  /* lower */
    { 0x1e6, 0x1e7 },  /* upper */
    { 0x1e6, 0x1e7 },  /* lower */
    { 0x1e8, 0x1e9 },  /* upper */
    { 0x1e8, 0x1e9 },  /* lower */
    { 0x1ea, 0x1eb },  /* upper */
    { 0x1ea, 0x1eb },  /* lower */
    { 0x1ec, 0x1ed },  /* upper */
    { 0x1ec, 0x1ed },  /* lower */
    { 0x1ee, 0x1ef },  /* upper */
    { 0x1ee, 0x1ef },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1f4, 0x1f5 },  /* upper */
    { 0x1f4, 0x1f5 },  /* lower */
    { 0x1f6, 0x195 },  /* upper */
    { 0x1f7, 0x1bf },  /* upper */
    { 0x1f8, 0x1f9 },  /* upper */
    { 0x1f8, 0x1f9 },  /* lower */
    { 0x1fa, 0x1fb },  /* upper */
    { 0x1fa, 0x1fb },  /* lower */
    { 0x1fc, 0x1fd },  /* upper */
    { 0x1fc, 0x1fd },  /* lower */
    { 0x1fe, 0x1ff },  /* upper */
    { 0x1fe, 0x1ff },  /* lower */
};

static gli_case_block_t unigen_case_block_0x2[256] = {
    { 0x200, 0x201 },  /* upper */
    { 0x200, 0x201 },  /* lower */
    { 0x202, 0x203 },  /* upper */
    { 0x202, 0x203 },  /* lower */
    { 0x204, 0x205 },  /* upper */
    { 0x204, 0x205 },  /* lower */
    { 0x206, 0x207 },  /* upper */
    { 0x206, 0x207 },  /* lower */
    { 0x208, 0x209 },  /* upper */
    { 0x208, 0x209 },  /* lower */
    { 0x20a, 0x20b },  /* upper */
    { 0x20a, 0x20b },  /* lower */
    { 0x20c, 0x20d },  /* upper */
    { 0x20c, 0x20d },  /* lower */
    { 0x20e, 0x20f },  /* upper */
    { 0x20e, 0x20f },  /* lower */
    { 0x210, 0x211 },  /* upper */
    { 0x210, 0x211 },  /* lower */
    { 0x212, 0x213 },  /* upper */
    { 0x212, 0x213 },  /* lower */
    { 0x214, 0x215 },  /* upper */
    { 0x214, 0x215 },  /* lower */
    { 0x216, 0x217 },  /* upper */
    { 0x216, 0x217 },  /* lower */
    { 0x218, 0x219 },  /* upper */
    { 0x218, 0x219 },  /* lower */
    { 0x21a, 0x21b },  /* upper */
    { 0x21a, 0x21b },  /* lower */
    { 0x21c, 0x21d },  /* upper */
    { 0x21c, 0x21d },  /* lower */
    { 0x21e, 0x21f },  /* upper */
    { 0x21e, 0x21f },  /* lower */
    { 0x220, 0x19e },  /* upper */
    { 0x221, 0x221 },
    { 0x222, 0x223 },  /* upper */
    { 0x222, 0x223 },  /* lower */
    { 0x224, 0x225 },  /* upper */
    { 0x224, 0x225 },  /* lower */
    { 0x226, 0x227 },  /* upper */
    { 0x226, 0x227 },  /* lower */
    { 0x228, 0x229 },  /* upper */
    { 0x228, 0x229 },  /* lower */
    { 0x22a, 0x22b },  /* upper */
    { 0x22a, 0x22b },  /* lower */
    { 0x22c, 0x22d },  /* upper */
    { 0x22c, 0x22d },  /* lower */
    { 0x22e, 0x22f },  /* upper */
    { 0x22e, 0x22f },  /* lower */
    { 0x230, 0x231 },  /* upper */
    { 0x230, 0x231 },  /* lower */
    { 0x232, 0x233 },  /* upper */
    { 0x232, 0x233 },  /* lower */
    { 0x234, 0x234 },
    { 0x235, 0x235 },
    { 0x236, 0x236 },
    { 0x237, 0x237 },
    { 0x238, 0x238 },
    { 0x239, 0x239 },
    { 0x23a, 0x23a },
    { 0x23b, 0x23b },
    { 0x23c, 0x23c },
    { 0x23d, 0x23d },
    { 0x23e, 0x23e },
    { 0x23f, 0x23f },
    { 0x240, 0x240 },
    { 0x241, 0x241 },
    { 0x242, 0x242 },
    { 0x243, 0x243 },
    { 0x244, 0x244 },
    { 0x245, 0x245 },
    { 0x246, 0x246 },
    { 0x247, 0x247 },
    { 0x248, 0x248 },
    { 0x249, 0x249 },
    { 0x24a, 0x24a },
    { 0x24b, 0x24b },
    { 0x24c, 0x24c },
    { 0x24d, 0x24d },
    { 0x24e, 0x24e },
    { 0x24f, 0x24f },
    { 0x250, 0x250 },
    { 0x251, 0x251 },
    { 0x252, 0x252 },
    { 0x181, 0x253 },  /* lower */
    { 0x186, 0x254 },  /* lower */
    { 0x255, 0x255 },
    { 0x189, 0x256 },  /* lower */
    { 0x18a, 0x257 },  /* lower */
    { 0x258, 0x258 },
    { 0x18f, 0x259 },  /* lower */
    { 0x25a, 0x25a },
    { 0x190, 0x25b },  /* lower */
    { 0x25c, 0x25c },
    { 0x25d, 0x25d },
    { 0x25e, 0x25e },
    { 0x25f, 0x25f },
    { 0x193, 0x260 },  /* lower */
    { 0x261, 0x261 },
    { 0x262, 0x262 },
    { 0x194, 0x263 },  /* lower */
    { 0x264, 0x264 },
    { 0x265, 0x265 },
    { 0x266, 0x266 },
    { 0x267, 0x267 },
    { 0x197, 0x268 },  /* lower */
    { 0x196, 0x269 },  /* lower */
    { 0x26a, 0x26a },
    { 0x26b, 0x26b },
    { 0x26c, 0x26c },
    { 0x26d, 0x26d },
    { 0x26e, 0x26e },
    { 0x19c, 0x26f },  /* lower */
    { 0x270, 0x270 },
    { 0x271, 0x271 },
    { 0x19d, 0x272 },  /* lower */
    { 0x273, 0x273 },
    { 0x274, 0x274 },
    { 0x19f, 0x275 },  /* lower */
    { 0x276, 0x276 },
    { 0x277, 0x277 },
    { 0x278, 0x278 },
    { 0x279, 0x279 },
    { 0x27a, 0x27a },
    { 0x27b, 0x27b },
    { 0x27c, 0x27c },
    { 0x27d, 0x27d },
    { 0x27e, 0x27e },
    { 0x27f, 0x27f },
    { 0x1a6, 0x280 },  /* lower */
    { 0x281, 0x281 },
    { 0x282, 0x282 },
    { 0x1a9, 0x283 },  /* lower */
    { 0x284, 0x284 },
    { 0x285, 0x285 },
    { 0x286, 0x286 },
    { 0x287, 0x287 },
    { 0x1ae, 0x288 },  /* lower */
    { 0x289, 0x289 },
    { 0x1b1, 0x28a },  /* lower */
    { 0x1b2, 0x28b },  /* lower */
    { 0x28c, 0x28c },
    { 0x28d, 0x28d },
    { 0x28e, 0x28e },
    { 0x28f, 0x28f },
    { 0x290, 0x290 },
    { 0x291, 0x291 },
    { 0x1b7, 0x292 },  /* lower */
    { 0x293, 0x293 },
    { 0x294, 0x294 },
    { 0x295, 0x295 },
    { 0x296, 0x296 },
    { 0x297, 0x297 },
    { 0x298, 0x298 },
    { 0x299, 0x299 },
    { 0x29a, 0x29a },
    { 0x29b, 0x29b },
    { 0x29c, 0x29c },
    { 0x29d, 0x29d },
    { 0x29e, 0x29e },
    { 0x29f, 0x29f },
    { 0x2a0, 0x2a0 },
    { 0x2a1, 0x2a1 },
    { 0x2a2, 0x2a2 },
    { 0x2a3, 0x2a3 },
    { 0x2a4, 0x2a4 },
    { 0x2a5, 0x2a5 },
    { 0x2a6, 0x2a6 },
    { 0x2a7, 0x2a7 },
    { 0x2a8, 0x2a8 },
    { 0x2a9, 0x2a9 },
    { 0x2aa, 0x2aa },
    { 0x2ab, 0x2ab },
    { 0x2ac, 0x2ac },
    { 0x2ad, 0x2ad },
    { 0x2ae, 0x2ae },
    { 0x2af, 0x2af },
    { 0x2b0, 0x2b0 },
    { 0x2b1, 0x2b1 },
    { 0x2b2, 0x2b2 },
    { 0x2b3, 0x2b3 },
    { 0x2b4, 0x2b4 },
    { 0x2b5, 0x2b5 },
    { 0x2b6, 0x2b6 },
    { 0x2b7, 0x2b7 },
    { 0x2b8, 0x2b8 },
    { 0x2b9, 0x2b9 },
    { 0x2ba, 0x2ba },
    { 0x2bb, 0x2bb },
    { 0x2bc, 0x2bc },
    { 0x2bd, 0x2bd },
    { 0x2be, 0x2be },
    { 0x2bf, 0x2bf },
    { 0x2c0, 0x2c0 },
    { 0x2c1, 0x2c1 },
    { 0x2c2, 0x2c2 },
    { 0x2c3, 0x2c3 },
    { 0x2c4, 0x2c4 },
    { 0x2c5, 0x2c5 },
    { 0x2c6, 0x2c6 },
    { 0x2c7, 0x2c7 },
    { 0x2c8, 0x2c8 },
    { 0x2c9, 0x2c9 },
    { 0x2ca, 0x2ca },
    { 0x2cb, 0x2cb },
    { 0x2cc, 0x2cc },
    { 0x2cd, 0x2cd },
    { 0x2ce, 0x2ce },
    { 0x2cf, 0x2cf },
    { 0x2d0, 0x2d0 },
    { 0x2d1, 0x2d1 },
    { 0x2d2, 0x2d2 },
    { 0x2d3, 0x2d3 },
    { 0x2d4, 0x2d4 },
    { 0x2d5, 0x2d5 },
    { 0x2d6, 0x2d6 },
    { 0x2d7, 0x2d7 },
    { 0x2d8, 0x2d8 },
    { 0x2d9, 0x2d9 },
    { 0x2da, 0x2da },
    { 0x2db, 0x2db },
    { 0x2dc, 0x2dc },
    { 0x2dd, 0x2dd },
    { 0x2de, 0x2de },
    { 0x2df, 0x2df },
    { 0x2e0, 0x2e0 },
    { 0x2e1, 0x2e1 },
    { 0x2e2, 0x2e2 },
    { 0x2e3, 0x2e3 },
    { 0x2e4, 0x2e4 },
    { 0x2e5, 0x2e5 },
    { 0x2e6, 0x2e6 },
    { 0x2e7, 0x2e7 },
    { 0x2e8, 0x2e8 },
    { 0x2e9, 0x2e9 },
    { 0x2ea, 0x2ea },
    { 0x2eb, 0x2eb },
    { 0x2ec, 0x2ec },
    { 0x2ed, 0x2ed },
    { 0x2ee, 0x2ee },
    { 0x2ef, 0x2ef },
    { 0x2f0, 0x2f0 },
    { 0x2f1, 0x2f1 },
    { 0x2f2, 0x2f2 },
    { 0x2f3, 0x2f3 },
    { 0x2f4, 0x2f4 },
    { 0x2f5, 0x2f5 },
    { 0x2f6, 0x2f6 },
    { 0x2f7, 0x2f7 },
    { 0x2f8, 0x2f8 },
    { 0x2f9, 0x2f9 },
    { 0x2fa, 0x2fa },
    { 0x2fb, 0x2fb },
    { 0x2fc, 0x2fc },
    { 0x2fd, 0x2fd },
    { 0x2fe, 0x2fe },
    { 0x2ff, 0x2ff },
};

static gli_case_block_t unigen_case_block_0x3[256] = {
    { 0x300, 0x300 },
    { 0x301, 0x301 },
    { 0x302, 0x302 },
    { 0x303, 0x303 },
    { 0x304, 0x304 },
    { 0x305, 0x305 },
    { 0x306, 0x306 },
    { 0x307, 0x307 },
    { 0x308, 0x308 },
    { 0x309, 0x309 },
    { 0x30a, 0x30a },
    { 0x30b, 0x30b },
    { 0x30c, 0x30c },
    { 0x30d, 0x30d },
    { 0x30e, 0x30e },
    { 0x30f, 0x30f },
    { 0x310, 0x310 },
    { 0x311, 0x311 },
    { 0x312, 0x312 },
    { 0x313, 0x313 },
    { 0x314, 0x314 },
    { 0x315, 0x315 },
    { 0x316, 0x316 },
    { 0x317, 0x317 },
    { 0x318, 0x318 },
    { 0x319, 0x319 },
    { 0x31a, 0x31a },
    { 0x31b, 0x31b },
    { 0x31c, 0x31c },
    { 0x31d, 0x31d },
    { 0x31e, 0x31e },
    { 0x31f, 0x31f },
    { 0x320, 0x320 },
    { 0x321, 0x321 },
    { 0x322, 0x322 },
    { 0x323, 0x323 },
    { 0x324, 0x324 },
    { 0x325, 0x325 },
    { 0x326, 0x326 },
    { 0x327, 0x327 },
    { 0x328, 0x328 },
    { 0x329, 0x329 },
    { 0x32a, 0x32a },
    { 0x32b, 0x32b },
    { 0x32c, 0x32c },
    { 0x32d, 0x32d },
    { 0x32e, 0x32e },
    { 0x32f, 0x32f },
    { 0x330, 0x330 },
    { 0x331, 0x331 },
    { 0x332, 0x332 },
    { 0x333, 0x333 },
    { 0x334, 0x334 },
    { 0x335, 0x335 },
    { 0x336, 0x336 },
    { 0x337, 0x337 },
    { 0x338, 0x338 },
    { 0x339, 0x339 },
    { 0x33a, 0x33a },
    { 0x33b, 0x33b },
    { 0x33c, 0x33c },
    { 0x33d, 0x33d },
    { 0x33e, 0x33e },
    { 0x33f, 0x33f },
    { 0x340, 0x340 },
    { 0x341, 0x341 },
    { 0x342, 0x342 },
    { 0x343, 0x343 },
    { 0x344, 0x344 },
    { 0x399, 0x345 },  /* lower */
    { 0x346, 0x346 },
    { 0x347, 0x347 },
    { 0x348, 0x348 },
    { 0x349, 0x349 },
    { 0x34a, 0x34a },
    { 0x34b, 0x34b },
    { 0x34c, 0x34c },
    { 0x34d, 0x34d },
    { 0x34e, 0x34e },
    { 0x34f, 0x34f },
    { 0x350, 0x350 },
    { 0x351, 0x351 },
    { 0x352, 0x352 },
    { 0x353, 0x353 },
    { 0x354, 0x354 },
    { 0x355, 0x355 },
    { 0x356, 0x356 },
    { 0x357, 0x357 },
    { 0x358, 0x358 },
    { 0x359, 0x359 },
    { 0x35a, 0x35a },
    { 0x35b, 0x35b },
    { 0x35c, 0x35c },
    { 0x35d, 0x35d },
    { 0x35e, 0x35e },
    { 0x35f, 0x35f },
    { 0x360, 0x360 },
    { 0x361, 0x361 },
    { 0x362, 0x362 },
    { 0x363, 0x363 },
    { 0x364, 0x364 },
    { 0x365, 0x365 },
    { 0x366, 0x366 },
    { 0x367, 0x367 },
    { 0x368, 0x368 },
    { 0x369, 0x369 },
    { 0x36a, 0x36a },
    { 0x36b, 0x36b },
    { 0x36c, 0x36c },
    { 0x36d, 0x36d },
    { 0x36e, 0x36e },
    { 0x36f, 0x36f },
    { 0x370, 0x370 },
    { 0x371, 0x371 },
    { 0x372, 0x372 },
    { 0x373, 0x373 },
    { 0x374, 0x374 },
    { 0x375, 0x375 },
    { 0x376, 0x376 },
    { 0x377, 0x377 },
    { 0x378, 0x378 },
    { 0x379, 0x379 },
    { 0x37a, 0x37a },
    { 0x37b, 0x37b },
    { 0x37c, 0x37c },
    { 0x37d, 0x37d },
    { 0x37e, 0x37e },
    { 0x37f, 0x37f },
    { 0x380, 0x380 },
    { 0x381, 0x381 },
    { 0x382, 0x382 },
    { 0x383, 0x383 },
    { 0x384, 0x384 },
    { 0x385, 0x385 },
    { 0x386, 0x3ac },  /* upper */
    { 0x387, 0x387 },
    { 0x388, 0x3ad },  /* upper */
    { 0x389, 0x3ae },  /* upper */
    { 0x38a, 0x3af },  /* upper */
    { 0x38b, 0x38b },
    { 0x38c, 0x3cc },  /* upper */
    { 0x38d, 0x38d },
    { 0x38e, 0x3cd },  /* upper */
    { 0x38f, 0x3ce },  /* upper */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x391, 0x3b1 },  /* upper */
    { 0x392, 0x3b2 },  /* upper */
    { 0x393, 0x3b3 },  /* upper */
    { 0x394, 0x3b4 },  /* upper */
    { 0x395, 0x3b5 },  /* upper */
    { 0x396, 0x3b6 },  /* upper */
    { 0x397, 0x3b7 },  /* upper */
    { 0x398, 0x3b8 },  /* upper */
    { 0x399, 0x3b9 },  /* upper */
    { 0x39a, 0x3ba },  /* upper */
    { 0x39b, 0x3bb },  /* upper */
    { 0x39c, 0x3bc },  /* upper */
    { 0x39d, 0x3bd },  /* upper */
    { 0x39e, 0x3be },  /* upper */
    { 0x39f, 0x3bf },  /* upper */
    { 0x3a0, 0x3c0 },  /* upper */
    { 0x3a1, 0x3c1 },  /* upper */
    { 0x3a2, 0x3a2 },
    { 0x3a3, 0x3c3 },  /* upper */
    { 0x3a4, 0x3c4 },  /* upper */
    { 0x3a5, 0x3c5 },  /* upper */
    { 0x3a6, 0x3c6 },  /* upper */
    { 0x3a7, 0x3c7 },  /* upper */
    { 0x3a8, 0x3c8 },  /* upper */
    { 0x3a9, 0x3c9 },  /* upper */
    { 0x3aa, 0x3ca },  /* upper */
    { 0x3ab, 0x3cb },  /* upper */
    { 0x386, 0x3ac },  /* lower */
    { 0x388, 0x3ad },  /* lower */
    { 0x389, 0x3ae },  /* lower */
    { 0x38a, 0x3af },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x391, 0x3b1 },  /* lower */
    { 0x392, 0x3b2 },  /* lower */
    { 0x393, 0x3b3 },  /* lower */
    { 0x394, 0x3b4 },  /* lower */
    { 0x395, 0x3b5 },  /* lower */
    { 0x396, 0x3b6 },  /* lower */
    { 0x397, 0x3b7 },  /* lower */
    { 0x398, 0x3b8 },  /* lower */
    { 0x399, 0x3b9 },  /* lower */
    { 0x39a, 0x3ba },  /* lower */
    { 0x39b, 0x3bb },  /* lower */
    { 0x39c, 0x3bc },  /* lower */
    { 0x39d, 0x3bd },  /* lower */
    { 0x39e, 0x3be },  /* lower */
    { 0x39f, 0x3bf },  /* lower */
    { 0x3a0, 0x3c0 },  /* lower */
    { 0x3a1, 0x3c1 },  /* lower */
    { 0x3a3, 0x3c2 },  /* lower */
    { 0x3a3, 0x3c3 },  /* lower */
    { 0x3a4, 0x3c4 },  /* lower */
    { 0x3a5, 0x3c5 },  /* lower */
    { 0x3a6, 0x3c6 },  /* lower */
    { 0x3a7, 0x3c7 },  /* lower */
    { 0x3a8, 0x3c8 },  /* lower */
    { 0x3a9, 0x3c9 },  /* lower */
    { 0x3aa, 0x3ca },  /* lower */
    { 0x3ab, 0x3cb },  /* lower */
    { 0x38c, 0x3cc },  /* lower */
    { 0x38e, 0x3cd },  /* lower */
    { 0x38f, 0x3ce },  /* lower */
    { 0x3cf, 0x3cf },
    { 0x392, 0x3d0 },  /* lower */
    { 0x398, 0x3d1 },  /* lower */
    { 0x3d2, 0x3d2 },
    { 0x3d3, 0x3d3 },
    { 0x3d4, 0x3d4 },
    { 0x3a6, 0x3d5 },  /* lower */
    { 0x3a0, 0x3d6 },  /* lower */
    { 0x3d7, 0x3d7 },
    { 0x3d8, 0x3d9 },  /* upper */
    { 0x3d8, 0x3d9 },  /* lower */
    { 0x3da, 0x3db },  /* upper */
    { 0x3da, 0x3db },  /* lower */
    { 0x3dc, 0x3dd },  /* upper */
    { 0x3dc, 0x3dd },  /* lower */
    { 0x3de, 0x3df },  /* upper */
    { 0x3de, 0x3df },  /* lower */
    { 0x3e0, 0x3e1 },  /* upper */
    { 0x3e0, 0x3e1 },  /* lower */
    { 0x3e2, 0x3e3 },  /* upper */
    { 0x3e2, 0x3e3 },  /* lower */
    { 0x3e4, 0x3e5 },  /* upper */
    { 0x3e4, 0x3e5 },  /* lower */
    { 0x3e6, 0x3e7 },  /* upper */
    { 0x3e6, 0x3e7 },  /* lower */
    { 0x3e8, 0x3e9 },  /* upper */
    { 0x3e8, 0x3e9 },  /* lower */
    { 0x3ea, 0x3eb },  /* upper */
    { 0x3ea, 0x3eb },  /* lower */
    { 0x3ec, 0x3ed },  /* upper */
    { 0x3ec, 0x3ed },  /* lower */
    { 0x3ee, 0x3ef },  /* upper */
    { 0x3ee, 0x3ef },  /* lower */
    { 0x39a, 0x3f0 },  /* lower */
    { 0x3a1, 0x3f1 },  /* lower */
    { 0x3f9, 0x3f2 },  /* lower */
    { 0x3f3, 0x3f3 },
    { 0x3f4, 0x3b8 },  /* upper */
    { 0x395, 0x3f5 },  /* lower */
    { 0x3f6, 0x3f6 },
    { 0x3f7, 0x3f8 },  /* upper */
    { 0x3f7, 0x3f8 },  /* lower */
    { 0x3f9, 0x3f2 },  /* upper */
    { 0x3fa, 0x3fb },  /* upper */
    { 0x3fa, 0x3fb },  /* lower */
    { 0x3fc, 0x3fc },
    { 0x3fd, 0x3fd },
    { 0x3fe, 0x3fe },
    { 0x3ff, 0x3ff },
};

static gli_case_block_t unigen_case_block_0x4[256] = {
    { 0x400, 0x450 },  /* upper */
    { 0x401, 0x451 },  /* upper */
    { 0x402, 0x452 },  /* upper */
    { 0x403, 0x453 },  /* upper */
    { 0x404, 0x454 },  /* upper */
    { 0x405, 0x455 },  /* upper */
    { 0x406, 0x456 },  /* upper */
    { 0x407, 0x457 },  /* upper */
    { 0x408, 0x458 },  /* upper */
    { 0x409, 0x459 },  /* upper */
    { 0x40a, 0x45a },  /* upper */
    { 0x40b, 0x45b },  /* upper */
    { 0x40c, 0x45c },  /* upper */
    { 0x40d, 0x45d },  /* upper */
    { 0x40e, 0x45e },  /* upper */
    { 0x40f, 0x45f },  /* upper */
    { 0x410, 0x430 },  /* upper */
    { 0x411, 0x431 },  /* upper */
    { 0x412, 0x432 },  /* upper */
    { 0x413, 0x433 },  /* upper */
    { 0x414, 0x434 },  /* upper */
    { 0x415, 0x435 },  /* upper */
    { 0x416, 0x436 },  /* upper */
    { 0x417, 0x437 },  /* upper */
    { 0x418, 0x438 },  /* upper */
    { 0x419, 0x439 },  /* upper */
    { 0x41a, 0x43a },  /* upper */
    { 0x41b, 0x43b },  /* upper */
    { 0x41c, 0x43c },  /* upper */
    { 0x41d, 0x43d },  /* upper */
    { 0x41e, 0x43e },  /* upper */
    { 0x41f, 0x43f },  /* upper */
    { 0x420, 0x440 },  /* upper */
    { 0x421, 0x441 },  /* upper */
    { 0x422, 0x442 },  /* upper */
    { 0x423, 0x443 },  /* upper */
    { 0x424, 0x444 },  /* upper */
    { 0x425, 0x445 },  /* upper */
    { 0x426, 0x446 },  /* upper */
    { 0x427, 0x447 },  /* upper */
    { 0x428, 0x448 },  /* upper */
    { 0x429, 0x449 },  /* upper */
    { 0x42a, 0x44a },  /* upper */
    { 0x42b, 0x44b },  /* upper */
    { 0x42c, 0x44c },  /* upper */
    { 0x42d, 0x44d },  /* upper */
    { 0x42e, 0x44e },  /* upper */
    { 0x42f, 0x44f },  /* upper */
    { 0x410, 0x430 },  /* lower */
    { 0x411, 0x431 },  /* lower */
    { 0x412, 0x432 },  /* lower */
    { 0x413, 0x433 },  /* lower */
    { 0x414, 0x434 },  /* lower */
    { 0x415, 0x435 },  /* lower */
    { 0x416, 0x436 },  /* lower */
    { 0x417, 0x437 },  /* lower */
    { 0x418, 0x438 },  /* lower */
    { 0x419, 0x439 },  /* lower */
    { 0x41a, 0x43a },  /* lower */
    { 0x41b, 0x43b },  /* lower */
    { 0x41c, 0x43c },  /* lower */
    { 0x41d, 0x43d },  /* lower */
    { 0x41e, 0x43e },  /* lower */
    { 0x41f, 0x43f },  /* lower */
    { 0x420, 0x440 },  /* lower */
    { 0x421, 0x441 },  /* lower */
    { 0x422, 0x442 },  /* lower */
    { 0x423, 0x443 },  /* lower */
    { 0x424, 0x444 },  /* lower */
    { 0x425, 0x445 },  /* lower */
    { 0x426, 0x446 },  /* lower */
    { 0x427, 0x447 },  /* lower */
    { 0x428, 0x448 },  /* lower */
    { 0x429, 0x449 },  /* lower */
    { 0x42a, 0x44a },  /* lower */
    { 0x42b, 0x44b },  /* lower */
    { 0x42c, 0x44c },  /* lower */
    { 0x42d, 0x44d },  /* lower */
    { 0x42e, 0x44e },  /* lower */
    { 0x42f, 0x44f },  /* lower */
    { 0x400, 0x450 },  /* lower */
    { 0x401, 0x451 },  /* lower */
    { 0x402, 0x452 },  /* lower */
    { 0x403, 0x453 },  /* lower */
    { 0x404, 0x454 },  /* lower */
    { 0x405, 0x455 },  /* lower */
    { 0x406, 0x456 },  /* lower */
    { 0x407, 0x457 },  /* lower */
    { 0x408, 0x458 },  /* lower */
    { 0x409, 0x459 },  /* lower */
    { 0x40a, 0x45a },  /* lower */
    { 0x40b, 0x45b },  /* lower */
    { 0x40c, 0x45c },  /* lower */
    { 0x40d, 0x45d },  /* lower */
    { 0x40e, 0x45e },  /* lower */
    { 0x40f, 0x45f },  /* lower */
    { 0x460, 0x461 },  /* upper */
    { 0x460, 0x461 },  /* lower */
    { 0x462, 0x463 },  /* upper */
    { 0x462, 0x463 },  /* lower */
    { 0x464, 0x465 },  /* upper */
    { 0x464, 0x465 },  /* lower */
    { 0x466, 0x467 },  /* upper */
    { 0x466, 0x467 },  /* lower */
    { 0x468, 0x469 },  /* upper */
    { 0x468, 0x469 },  /* lower */
    { 0x46a, 0x46b },  /* upper */
    { 0x46a, 0x46b },  /* lower */
    { 0x46c, 0x46d },  /* upper */
    { 0x46c, 0x46d },  /* lower */
    { 0x46e, 0x46f },  /* upper */
    { 0x46e, 0x46f },  /* lower */
    { 0x470, 0x471 },  /* upper */
    { 0x470, 0x471 },  /* lower */
    { 0x472, 0x473 },  /* upper */
    { 0x472, 0x473 },  /* lower */
    { 0x474, 0x475 },  /* upper */
    { 0x474, 0x475 },  /* lower */
    { 0x476, 0x477 },  /* upper */
    { 0x476, 0x477 },  /* lower */
    { 0x478, 0x479 },  /* upper */
    { 0x478, 0x479 },  /* lower */
    { 0x47a, 0x47b },  /* upper */
    { 0x47a, 0x47b },  /* lower */
    { 0x47c, 0x47d },  /* upper */
    { 0x47c, 0x47d },  /* lower */
    { 0x47e, 0x47f },  /* upper */
    { 0x47e, 0x47f },  /* lower */
    { 0x480, 0x481 },  /* upper */
    { 0x480, 0x481 },  /* lower */
    { 0x482, 0x482 },
    { 0x483, 0x483 },
    { 0x484, 0x484 },
    { 0x485, 0x485 },
    { 0x486, 0x486 },
    { 0x487, 0x487 },
    { 0x488, 0x488 },
    { 0x489, 0x489 },
    { 0x48a, 0x48b },  /* upper */
    { 0x48a, 0x48b },  /* lower */
    { 0x48c, 0x48d },  /* upper */
    { 0x48c, 0x48d },  /* lower */
    { 0x48e, 0x48f },  /* upper */
    { 0x48e, 0x48f },  /* lower */
    { 0x490, 0x491 },  /* upper */
    { 0x490, 0x491 },  /* lower */
    { 0x492, 0x493 },  /* upper */
    { 0x492, 0x493 },  /* lower */
    { 0x494, 0x495 },  /* upper */
    { 0x494, 0x495 },  /* lower */
    { 0x496, 0x497 },  /* upper */
    { 0x496, 0x497 },  /* lower */
    { 0x498, 0x499 },  /* upper */
    { 0x498, 0x499 },  /* lower */
    { 0x49a, 0x49b },  /* upper */
    { 0x49a, 0x49b },  /* lower */
    { 0x49c, 0x49d },  /* upper */
    { 0x49c, 0x49d },  /* lower */
    { 0x49e, 0x49f },  /* upper */
    { 0x49e, 0x49f },  /* lower */
    { 0x4a0, 0x4a1 },  /* upper */
    { 0x4a0, 0x4a1 },  /* lower */
    { 0x4a2, 0x4a3 },  /* upper */
    { 0x4a2, 0x4a3 },  /* lower */
    { 0x4a4, 0x4a5 },  /* upper */
    { 0x4a4, 0x4a5 },  /* lower */
    { 0x4a6, 0x4a7 },  /* upper */
    { 0x4a6, 0x4a7 },  /* lower */
    { 0x4a8, 0x4a9 },  /* upper */
    { 0x4a8, 0x4a9 },  /* lower */
    { 0x4aa, 0x4ab },  /* upper */
    { 0x4aa, 0x4ab },  /* lower */
    { 0x4ac, 0x4ad },  /* upper */
    { 0x4ac, 0x4ad },  /* lower */
    { 0x4ae, 0x4af },  /* upper */
    { 0x4ae, 0x4af },  /* lower */
    { 0x4b0, 0x4b1 },  /* upper */
    { 0x4b0, 0x4b1 },  /* lower */
    { 0x4b2, 0x4b3 },  /* upper */
    { 0x4b2, 0x4b3 },  /* lower */
    { 0x4b4, 0x4b5 },  /* upper */
    { 0x4b4, 0x4b5 },  /* lower */
    { 0x4b6, 0x4b7 },  /* upper */
    { 0x4b6, 0x4b7 },  /* lower */
    { 0x4b8, 0x4b9 },  /* upper */
    { 0x4b8, 0x4b9 },  /* lower */
    { 0x4ba, 0x4bb },  /* upper */
    { 0x4ba, 0x4bb },  /* lower */
    { 0x4bc, 0x4bd },  /* upper */
    { 0x4bc, 0x4bd },  /* lower */
    { 0x4be, 0x4bf },  /* upper */
    { 0x4be, 0x4bf },  /* lower */
    { 0x4c0, 0x4c0 },
    { 0x4c1, 0x4c2 },  /* upper */
    { 0x4c1, 0x4c2 },  /* lower */
    { 0x4c3, 0x4c4 },  /* upper */
    { 0x4c3, 0x4c4 },  /* lower */
    { 0x4c5, 0x4c6 },  /* upper */
    { 0x4c5, 0x4c6 },  /* lower */
    { 0x4c7, 0x4c8 },  /* upper */
    { 0x4c7, 0x4c8 },  /* lower */
    { 0x4c9, 0x4ca },  /* upper */
    { 0x4c9, 0x4ca },  /* lower */
    { 0x4cb, 0x4cc },  /* upper */
    { 0x4cb, 0x4cc },  /* lower */
    { 0x4cd, 0x4ce },  /* upper */
    { 0x4cd, 0x4ce },  /* lower */
    { 0x4cf, 0x4cf },
    { 0x4d0, 0x4d1 },  /* upper */
    { 0x4d0, 0x4d1 },  /* lower */
    { 0x4d2, 0x4d3 },  /* upper */
    { 0x4d2, 0x4d3 },  /* lower */
    { 0x4d4, 0x4d5 },  /* upper */
    { 0x4d4, 0x4d5 },  /* lower */
    { 0x4d6, 0x4d7 },  /* upper */
    { 0x4d6, 0x4d7 },  /* lower */
    { 0x4d8, 0x4d9 },  /* upper */
    { 0x4d8, 0x4d9 },  /* lower */
    { 0x4da, 0x4db },  /* upper */
    { 0x4da, 0x4db },  /* lower */
    { 0x4dc, 0x4dd },  /* upper */
    { 0x4dc, 0x4dd },  /* lower */
    { 0x4de, 0x4df },  /* upper */
    { 0x4de, 0x4df },  /* lower */
    { 0x4e0, 0x4e1 },  /* upper */
    { 0x4e0, 0x4e1 },  /* lower */
    { 0x4e2, 0x4e3 },  /* upper */
    { 0x4e2, 0x4e3 },  /* lower */
    { 0x4e4, 0x4e5 },  /* upper */
    { 0x4e4, 0x4e5 },  /* lower */
    { 0x4e6, 0x4e7 },  /* upper */
    { 0x4e6, 0x4e7 },  /* lower */
    { 0x4e8, 0x4e9 },  /* upper */
    { 0x4e8, 0x4e9 },  /* lower */
    { 0x4ea, 0x4eb },  /* upper */
    { 0x4ea, 0x4eb },  /* lower */
    { 0x4ec, 0x4ed },  /* upper */
    { 0x4ec, 0x4ed },  /* lower */
    { 0x4ee, 0x4ef },  /* upper */
    { 0x4ee, 0x4ef },  /* lower */
    { 0x4f0, 0x4f1 },  /* upper */
    { 0x4f0, 0x4f1 },  /* lower */
    { 0x4f2, 0x4f3 },  /* upper */
    { 0x4f2, 0x4f3 },  /* lower */
    { 0x4f4, 0x4f5 },  /* upper */
    { 0x4f4, 0x4f5 },  /* lower */
    { 0x4f6, 0x4f6 },
    { 0x4f7, 0x4f7 },
    { 0x4f8, 0x4f9 },  /* upper */
    { 0x4f8, 0x4f9 },  /* lower */
    { 0x4fa, 0x4fa },
    { 0x4fb, 0x4fb },
    { 0x4fc, 0x4fc },
    { 0x4fd, 0x4fd },
    { 0x4fe, 0x4fe },
    { 0x4ff, 0x4ff },
};

static gli_case_block_t unigen_case_block_0x5[256] = {
    { 0x500, 0x501 },  /* upper */
    { 0x500, 0x501 },  /* lower */
    { 0x502, 0x503 },  /* upper */
    { 0x502, 0x503 },  /* lower */
    { 0x504, 0x505 },  /* upper */
    { 0x504, 0x505 },  /* lower */
    { 0x506, 0x507 },  /* upper */
    { 0x506, 0x507 },  /* lower */
    { 0x508, 0x509 },  /* upper */
    { 0x508, 0x509 },  /* lower */
    { 0x50a, 0x50b },  /* upper */
    { 0x50a, 0x50b },  /* lower */
    { 0x50c, 0x50d },  /* upper */
    { 0x50c, 0x50d },  /* lower */
    { 0x50e, 0x50f },  /* upper */
    { 0x50e, 0x50f },  /* lower */
    { 0x510, 0x510 },
    { 0x511, 0x511 },
    { 0x512, 0x512 },
    { 0x513, 0x513 },
    { 0x514, 0x514 },
    { 0x515, 0x515 },
    { 0x516, 0x516 },
    { 0x517, 0x517 },
    { 0x518, 0x518 },
    { 0x519, 0x519 },
    { 0x51a, 0x51a },
    { 0x51b, 0x51b },
    { 0x51c, 0x51c },
    { 0x51d, 0x51d },
    { 0x51e, 0x51e },
    { 0x51f, 0x51f },
    { 0x520, 0x520 },
    { 0x521, 0x521 },
    { 0x522, 0x522 },
    { 0x523, 0x523 },
    { 0x524, 0x524 },
    { 0x525, 0x525 },
    { 0x526, 0x526 },
    { 0x527, 0x527 },
    { 0x528, 0x528 },
    { 0x529, 0x529 },
    { 0x52a, 0x52a },
    { 0x52b, 0x52b },
    { 0x52c, 0x52c },
    { 0x52d, 0x52d },
    { 0x52e, 0x52e },
    { 0x52f, 0x52f },
    { 0x530, 0x530 },
    { 0x531, 0x561 },  /* upper */
    { 0x532, 0x562 },  /* upper */
    { 0x533, 0x563 },  /* upper */
    { 0x534, 0x564 },  /* upper */
    { 0x535, 0x565 },  /* upper */
    { 0x536, 0x566 },  /* upper */
    { 0x537, 0x567 },  /* upper */
    { 0x538, 0x568 },  /* upper */
    { 0x539, 0x569 },  /* upper */
    { 0x53a, 0x56a },  /* upper */
    { 0x53b, 0x56b },  /* upper */
    { 0x53c, 0x56c },  /* upper */
    { 0x53d, 0x56d },  /* upper */
    { 0x53e, 0x56e },  /* upper */
    { 0x53f, 0x56f },  /* upper */
    { 0x540, 0x570 },  /* upper */
    { 0x541, 0x571 },  /* upper */
    { 0x542, 0x572 },  /* upper */
    { 0x543, 0x573 },  /* upper */
    { 0x544, 0x574 },  /* upper */
    { 0x545, 0x575 },  /* upper */
    { 0x546, 0x576 },  /* upper */
    { 0x547, 0x577 },  /* upper */
    { 0x548, 0x578 },  /* upper */
    { 0x549, 0x579 },  /* upper */
    { 0x54a, 0x57a },  /* upper */
    { 0x54b, 0x57b },  /* upper */
    { 0x54c, 0x57c },  /* upper */
    { 0x54d, 0x57d },  /* upper */
    { 0x54e, 0x57e },  /* upper */
    { 0x54f, 0x57f },  /* upper */
    { 0x550, 0x580 },  /* upper */
    { 0x551, 0x581 },  /* upper */
    { 0x552, 0x582 },  /* upper */
    { 0x553, 0x583 },  /* upper */
    { 0x554, 0x584 },  /* upper */
    { 0x555, 0x585 },  /* upper */
    { 0x556, 0x586 },  /* upper */
    { 0x557, 0x557 },
    { 0x558, 0x558 },
    { 0x559, 0x559 },
    { 0x55a, 0x55a },
    { 0x55b, 0x55b },
    { 0x55c, 0x55c },
    { 0x55d, 0x55d },
    { 0x55e, 0x55e },
    { 0x55f, 0x55f },
    { 0x560, 0x560 },
    { 0x531, 0x561 },  /* lower */
    { 0x532, 0x562 },  /* lower */
    { 0x533, 0x563 },  /* lower */
    { 0x534, 0x564 },  /* lower */
    { 0x535, 0x565 },  /* lower */
    { 0x536, 0x566 },  /* lower */
    { 0x537, 0x567 },  /* lower */
    { 0x538, 0x568 },  /* lower */
    { 0x539, 0x569 },  /* lower */
    { 0x53a, 0x56a },  /* lower */
    { 0x53b, 0x56b },  /* lower */
    { 0x53c, 0x56c },  /* lower */
    { 0x53d, 0x56d },  /* lower */
    { 0x53e, 0x56e },  /* lower */
    { 0x53f, 0x56f },  /* lower */
    { 0x540, 0x570 },  /* lower */
    { 0x541, 0x571 },  /* lower */
    { 0x542, 0x572 },  /* lower */
    { 0x543, 0x573 },  /* lower */
    { 0x544, 0x574 },  /* lower */
    { 0x545, 0x575 },  /* lower */
    { 0x546, 0x576 },  /* lower */
    { 0x547, 0x577 },  /* lower */
    { 0x548, 0x578 },  /* lower */
    { 0x549, 0x579 },  /* lower */
    { 0x54a, 0x57a },  /* lower */
    { 0x54b, 0x57b },  /* lower */
    { 0x54c, 0x57c },  /* lower */
    { 0x54d, 0x57d },  /* lower */
    { 0x54e, 0x57e },  /* lower */
    { 0x54f, 0x57f },  /* lower */
    { 0x550, 0x580 },  /* lower */
    { 0x551, 0x581 },  /* lower */
    { 0x552, 0x582 },  /* lower */
    { 0x553, 0x583 },  /* lower */
    { 0x554, 0x584 },  /* lower */
    { 0x555, 0x585 },  /* lower */
    { 0x556, 0x586 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x588, 0x588 },
    { 0x589, 0x589 },
    { 0x58a, 0x58a },
    { 0x58b, 0x58b },
    { 0x58c, 0x58c },
    { 0x58d, 0x58d },
    { 0x58e, 0x58e },
    { 0x58f, 0x58f },
    { 0x590, 0x590 },
    { 0x591, 0x591 },
    { 0x592, 0x592 },
    { 0x593, 0x593 },
    { 0x594, 0x594 },
    { 0x595, 0x595 },
    { 0x596, 0x596 },
    { 0x597, 0x597 },
    { 0x598, 0x598 },
    { 0x599, 0x599 },
    { 0x59a, 0x59a },
    { 0x59b, 0x59b },
    { 0x59c, 0x59c },
    { 0x59d, 0x59d },
    { 0x59e, 0x59e },
    { 0x59f, 0x59f },
    { 0x5a0, 0x5a0 },
    { 0x5a1, 0x5a1 },
    { 0x5a2, 0x5a2 },
    { 0x5a3, 0x5a3 },
    { 0x5a4, 0x5a4 },
    { 0x5a5, 0x5a5 },
    { 0x5a6, 0x5a6 },
    { 0x5a7, 0x5a7 },
    { 0x5a8, 0x5a8 },
    { 0x5a9, 0x5a9 },
    { 0x5aa, 0x5aa },
    { 0x5ab, 0x5ab },
    { 0x5ac, 0x5ac },
    { 0x5ad, 0x5ad },
    { 0x5ae, 0x5ae },
    { 0x5af, 0x5af },
    { 0x5b0, 0x5b0 },
    { 0x5b1, 0x5b1 },
    { 0x5b2, 0x5b2 },
    { 0x5b3, 0x5b3 },
    { 0x5b4, 0x5b4 },
    { 0x5b5, 0x5b5 },
    { 0x5b6, 0x5b6 },
    { 0x5b7, 0x5b7 },
    { 0x5b8, 0x5b8 },
    { 0x5b9, 0x5b9 },
    { 0x5ba, 0x5ba },
    { 0x5bb, 0x5bb },
    { 0x5bc, 0x5bc },
    { 0x5bd, 0x5bd },
    { 0x5be, 0x5be },
    { 0x5bf, 0x5bf },
    { 0x5c0, 0x5c0 },
    { 0x5c1, 0x5c1 },
    { 0x5c2, 0x5c2 },
    { 0x5c3, 0x5c3 },
    { 0x5c4, 0x5c4 },
    { 0x5c5, 0x5c5 },
    { 0x5c6, 0x5c6 },
    { 0x5c7, 0x5c7 },
    { 0x5c8, 0x5c8 },
    { 0x5c9, 0x5c9 },
    { 0x5ca, 0x5ca },
    { 0x5cb, 0x5cb },
    { 0x5cc, 0x5cc },
    { 0x5cd, 0x5cd },
    { 0x5ce, 0x5ce },
    { 0x5cf, 0x5cf },
    { 0x5d0, 0x5d0 },
    { 0x5d1, 0x5d1 },
    { 0x5d2, 0x5d2 },
    { 0x5d3, 0x5d3 },
    { 0x5d4, 0x5d4 },
    { 0x5d5, 0x5d5 },
    { 0x5d6, 0x5d6 },
    { 0x5d7, 0x5d7 },
    { 0x5d8, 0x5d8 },
    { 0x5d9, 0x5d9 },
    { 0x5da, 0x5da },
    { 0x5db, 0x5db },
    { 0x5dc, 0x5dc },
    { 0x5dd, 0x5dd },
    { 0x5de, 0x5de },
    { 0x5df, 0x5df },
    { 0x5e0, 0x5e0 },
    { 0x5e1, 0x5e1 },
    { 0x5e2, 0x5e2 },
    { 0x5e3, 0x5e3 },
    { 0x5e4, 0x5e4 },
    { 0x5e5, 0x5e5 },
    { 0x5e6, 0x5e6 },
    { 0x5e7, 0x5e7 },
    { 0x5e8, 0x5e8 },
    { 0x5e9, 0x5e9 },
    { 0x5ea, 0x5ea },
    { 0x5eb, 0x5eb },
    { 0x5ec, 0x5ec },
    { 0x5ed, 0x5ed },
    { 0x5ee, 0x5ee },
    { 0x5ef, 0x5ef },
    { 0x5f0, 0x5f0 },
    { 0x5f1, 0x5f1 },
    { 0x5f2, 0x5f2 },
    { 0x5f3, 0x5f3 },
    { 0x5f4, 0x5f4 },
    { 0x5f5, 0x5f5 },
    { 0x5f6, 0x5f6 },
    { 0x5f7, 0x5f7 },
    { 0x5f8, 0x5f8 },
    { 0x5f9, 0x5f9 },
    { 0x5fa, 0x5fa },
    { 0x5fb, 0x5fb },
    { 0x5fc, 0x5fc },
    { 0x5fd, 0x5fd },
    { 0x5fe, 0x5fe },
    { 0x5ff, 0x5ff },
};

static gli_case_block_t unigen_case_block_0x1e[256] = {
    { 0x1e00, 0x1e01 },  /* upper */
    { 0x1e00, 0x1e01 },  /* lower */
    { 0x1e02, 0x1e03 },  /* upper */
    { 0x1e02, 0x1e03 },  /* lower */
    { 0x1e04, 0x1e05 },  /* upper */
    { 0x1e04, 0x1e05 },  /* lower */
    { 0x1e06, 0x1e07 },  /* upper */
    { 0x1e06, 0x1e07 },  /* lower */
    { 0x1e08, 0x1e09 },  /* upper */
    { 0x1e08, 0x1e09 },  /* lower */
    { 0x1e0a, 0x1e0b },  /* upper */
    { 0x1e0a, 0x1e0b },  /* lower */
    { 0x1e0c, 0x1e0d },  /* upper */
    { 0x1e0c, 0x1e0d },  /* lower */
    { 0x1e0e, 0x1e0f },  /* upper */
    { 0x1e0e, 0x1e0f },  /* lower */
    { 0x1e10, 0x1e11 },  /* upper */
    { 0x1e10, 0x1e11 },  /* lower */
    { 0x1e12, 0x1e13 },  /* upper */
    { 0x1e12, 0x1e13 },  /* lower */
    { 0x1e14, 0x1e15 },  /* upper */
    { 0x1e14, 0x1e15 },  /* lower */
    { 0x1e16, 0x1e17 },  /* upper */
    { 0x1e16, 0x1e17 },  /* lower */
    { 0x1e18, 0x1e19 },  /* upper */
    { 0x1e18, 0x1e19 },  /* lower */
    { 0x1e1a, 0x1e1b },  /* upper */
    { 0x1e1a, 0x1e1b },  /* lower */
    { 0x1e1c, 0x1e1d },  /* upper */
    { 0x1e1c, 0x1e1d },  /* lower */
    { 0x1e1e, 0x1e1f },  /* upper */
    { 0x1e1e, 0x1e1f },  /* lower */
    { 0x1e20, 0x1e21 },  /* upper */
    { 0x1e20, 0x1e21 },  /* lower */
    { 0x1e22, 0x1e23 },  /* upper */
    { 0x1e22, 0x1e23 },  /* lower */
    { 0x1e24, 0x1e25 },  /* upper */
    { 0x1e24, 0x1e25 },  /* lower */
    { 0x1e26, 0x1e27 },  /* upper */
    { 0x1e26, 0x1e27 },  /* lower */
    { 0x1e28, 0x1e29 },  /* upper */
    { 0x1e28, 0x1e29 },  /* lower */
    { 0x1e2a, 0x1e2b },  /* upper */
    { 0x1e2a, 0x1e2b },  /* lower */
    { 0x1e2c, 0x1e2d },  /* upper */
    { 0x1e2c, 0x1e2d },  /* lower */
    { 0x1e2e, 0x1e2f },  /* upper */
    { 0x1e2e, 0x1e2f },  /* lower */
    { 0x1e30, 0x1e31 },  /* upper */
    { 0x1e30, 0x1e31 },  /* lower */
    { 0x1e32, 0x1e33 },  /* upper */
    { 0x1e32, 0x1e33 },  /* lower */
    { 0x1e34, 0x1e35 },  /* upper */
    { 0x1e34, 0x1e35 },  /* lower */
    { 0x1e36, 0x1e37 },  /* upper */
    { 0x1e36, 0x1e37 },  /* lower */
    { 0x1e38, 0x1e39 },  /* upper */
    { 0x1e38, 0x1e39 },  /* lower */
    { 0x1e3a, 0x1e3b },  /* upper */
    { 0x1e3a, 0x1e3b },  /* lower */
    { 0x1e3c, 0x1e3d },  /* upper */
    { 0x1e3c, 0x1e3d },  /* lower */
    { 0x1e3e, 0x1e3f },  /* upper */
    { 0x1e3e, 0x1e3f },  /* lower */
    { 0x1e40, 0x1e41 },  /* upper */
    { 0x1e40, 0x1e41 },  /* lower */
    { 0x1e42, 0x1e43 },  /* upper */
    { 0x1e42, 0x1e43 },  /* lower */
    { 0x1e44, 0x1e45 },  /* upper */
    { 0x1e44, 0x1e45 },  /* lower */
    { 0x1e46, 0x1e47 },  /* upper */
    { 0x1e46, 0x1e47 },  /* lower */
    { 0x1e48, 0x1e49 },  /* upper */
    { 0x1e48, 0x1e49 },  /* lower */
    { 0x1e4a, 0x1e4b },  /* upper */
    { 0x1e4a, 0x1e4b },  /* lower */
    { 0x1e4c, 0x1e4d },  /* upper */
    { 0x1e4c, 0x1e4d },  /* lower */
    { 0x1e4e, 0x1e4f },  /* upper */
    { 0x1e4e, 0x1e4f },  /* lower */
    { 0x1e50, 0x1e51 },  /* upper */
    { 0x1e50, 0x1e51 },  /* lower */
    { 0x1e52, 0x1e53 },  /* upper */
    { 0x1e52, 0x1e53 },  /* lower */
    { 0x1e54, 0x1e55 },  /* upper */
    { 0x1e54, 0x1e55 },  /* lower */
    { 0x1e56, 0x1e57 },  /* upper */
    { 0x1e56, 0x1e57 },  /* lower */
    { 0x1e58, 0x1e59 },  /* upper */
    { 0x1e58, 0x1e59 },  /* lower */
    { 0x1e5a, 0x1e5b },  /* upper */
    { 0x1e5a, 0x1e5b },  /* lower */
    { 0x1e5c, 0x1e5d },  /* upper */
    { 0x1e5c, 0x1e5d },  /* lower */
    { 0x1e5e, 0x1e5f },  /* upper */
    { 0x1e5e, 0x1e5f },  /* lower */
    { 0x1e60, 0x1e61 },  /* upper */
    { 0x1e60, 0x1e61 },  /* lower */
    { 0x1e62, 0x1e63 },  /* upper */
    { 0x1e62, 0x1e63 },  /* lower */
    { 0x1e64, 0x1e65 },  /* upper */
    { 0x1e64, 0x1e65 },  /* lower */
    { 0x1e66, 0x1e67 },  /* upper */
    { 0x1e66, 0x1e67 },  /* lower */
    { 0x1e68, 0x1e69 },  /* upper */
    { 0x1e68, 0x1e69 },  /* lower */
    { 0x1e6a, 0x1e6b },  /* upper */
    { 0x1e6a, 0x1e6b },  /* lower */
    { 0x1e6c, 0x1e6d },  /* upper */
    { 0x1e6c, 0x1e6d },  /* lower */
    { 0x1e6e, 0x1e6f },  /* upper */
    { 0x1e6e, 0x1e6f },  /* lower */
    { 0x1e70, 0x1e71 },  /* upper */
    { 0x1e70, 0x1e71 },  /* lower */
    { 0x1e72, 0x1e73 },  /* upper */
    { 0x1e72, 0x1e73 },  /* lower */
    { 0x1e74, 0x1e75 },  /* upper */
    { 0x1e74, 0x1e75 },  /* lower */
    { 0x1e76, 0x1e77 },  /* upper */
    { 0x1e76, 0x1e77 },  /* lower */
    { 0x1e78, 0x1e79 },  /* upper */
    { 0x1e78, 0x1e79 },  /* lower */
    { 0x1e7a, 0x1e7b },  /* upper */
    { 0x1e7a, 0x1e7b },  /* lower */
    { 0x1e7c, 0x1e7d },  /* upper */
    { 0x1e7c, 0x1e7d },  /* lower */
    { 0x1e7e, 0x1e7f },  /* upper */
    { 0x1e7e, 0x1e7f },  /* lower */
    { 0x1e80, 0x1e81 },  /* upper */
    { 0x1e80, 0x1e81 },  /* lower */
    { 0x1e82, 0x1e83 },  /* upper */
    { 0x1e82, 0x1e83 },  /* lower */
    { 0x1e84, 0x1e85 },  /* upper */
    { 0x1e84, 0x1e85 },  /* lower */
    { 0x1e86, 0x1e87 },  /* upper */
    { 0x1e86, 0x1e87 },  /* lower */
    { 0x1e88, 0x1e89 },  /* upper */
    { 0x1e88, 0x1e89 },  /* lower */
    { 0x1e8a, 0x1e8b },  /* upper */
    { 0x1e8a, 0x1e8b },  /* lower */
    { 0x1e8c, 0x1e8d },  /* upper */
    { 0x1e8c, 0x1e8d },  /* lower */
    { 0x1e8e, 0x1e8f },  /* upper */
    { 0x1e8e, 0x1e8f },  /* lower */
    { 0x1e90, 0x1e91 },  /* upper */
    { 0x1e90, 0x1e91 },  /* lower */
    { 0x1e92, 0x1e93 },  /* upper */
    { 0x1e92, 0x1e93 },  /* lower */
    { 0x1e94, 0x1e95 },  /* upper */
    { 0x1e94, 0x1e95 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1e60, 0x1e9b },  /* lower */
    { 0x1e9c, 0x1e9c },
    { 0x1e9d, 0x1e9d },
    { 0x1e9e, 0x1e9e },
    { 0x1e9f, 0x1e9f },
    { 0x1ea0, 0x1ea1 },  /* upper */
    { 0x1ea0, 0x1ea1 },  /* lower */
    { 0x1ea2, 0x1ea3 },  /* upper */
    { 0x1ea2, 0x1ea3 },  /* lower */
    { 0x1ea4, 0x1ea5 },  /* upper */
    { 0x1ea4, 0x1ea5 },  /* lower */
    { 0x1ea6, 0x1ea7 },  /* upper */
    { 0x1ea6, 0x1ea7 },  /* lower */
    { 0x1ea8, 0x1ea9 },  /* upper */
    { 0x1ea8, 0x1ea9 },  /* lower */
    { 0x1eaa, 0x1eab },  /* upper */
    { 0x1eaa, 0x1eab },  /* lower */
    { 0x1eac, 0x1ead },  /* upper */
    { 0x1eac, 0x1ead },  /* lower */
    { 0x1eae, 0x1eaf },  /* upper */
    { 0x1eae, 0x1eaf },  /* lower */
    { 0x1eb0, 0x1eb1 },  /* upper */
    { 0x1eb0, 0x1eb1 },  /* lower */
    { 0x1eb2, 0x1eb3 },  /* upper */
    { 0x1eb2, 0x1eb3 },  /* lower */
    { 0x1eb4, 0x1eb5 },  /* upper */
    { 0x1eb4, 0x1eb5 },  /* lower */
    { 0x1eb6, 0x1eb7 },  /* upper */
    { 0x1eb6, 0x1eb7 },  /* lower */
    { 0x1eb8, 0x1eb9 },  /* upper */
    { 0x1eb8, 0x1eb9 },  /* lower */
    { 0x1eba, 0x1ebb },  /* upper */
    { 0x1eba, 0x1ebb },  /* lower */
    { 0x1ebc, 0x1ebd },  /* upper */
    { 0x1ebc, 0x1ebd },  /* lower */
    { 0x1ebe, 0x1ebf },  /* upper */
    { 0x1ebe, 0x1ebf },  /* lower */
    { 0x1ec0, 0x1ec1 },  /* upper */
    { 0x1ec0, 0x1ec1 },  /* lower */
    { 0x1ec2, 0x1ec3 },  /* upper */
    { 0x1ec2, 0x1ec3 },  /* lower */
    { 0x1ec4, 0x1ec5 },  /* upper */
    { 0x1ec4, 0x1ec5 },  /* lower */
    { 0x1ec6, 0x1ec7 },  /* upper */
    { 0x1ec6, 0x1ec7 },  /* lower */
    { 0x1ec8, 0x1ec9 },  /* upper */
    { 0x1ec8, 0x1ec9 },  /* lower */
    { 0x1eca, 0x1ecb },  /* upper */
    { 0x1eca, 0x1ecb },  /* lower */
    { 0x1ecc, 0x1ecd },  /* upper */
    { 0x1ecc, 0x1ecd },  /* lower */
    { 0x1ece, 0x1ecf },  /* upper */
    { 0x1ece, 0x1ecf },  /* lower */
    { 0x1ed0, 0x1ed1 },  /* upper */
    { 0x1ed0, 0x1ed1 },  /* lower */
    { 0x1ed2, 0x1ed3 },  /* upper */
    { 0x1ed2, 0x1ed3 },  /* lower */
    { 0x1ed4, 0x1ed5 },  /* upper */
    { 0x1ed4, 0x1ed5 },  /* lower */
    { 0x1ed6, 0x1ed7 },  /* upper */
    { 0x1ed6, 0x1ed7 },  /* lower */
    { 0x1ed8, 0x1ed9 },  /* upper */
    { 0x1ed8, 0x1ed9 },  /* lower */
    { 0x1eda, 0x1edb },  /* upper */
    { 0x1eda, 0x1edb },  /* lower */
    { 0x1edc, 0x1edd },  /* upper */
    { 0x1edc, 0x1edd },  /* lower */
    { 0x1ede, 0x1edf },  /* upper */
    { 0x1ede, 0x1edf },  /* lower */
    { 0x1ee0, 0x1ee1 },  /* upper */
    { 0x1ee0, 0x1ee1 },  /* lower */
    { 0x1ee2, 0x1ee3 },  /* upper */
    { 0x1ee2, 0x1ee3 },  /* lower */
    { 0x1ee4, 0x1ee5 },  /* upper */
    { 0x1ee4, 0x1ee5 },  /* lower */
    { 0x1ee6, 0x1ee7 },  /* upper */
    { 0x1ee6, 0x1ee7 },  /* lower */
    { 0x1ee8, 0x1ee9 },  /* upper */
    { 0x1ee8, 0x1ee9 },  /* lower */
    { 0x1eea, 0x1eeb },  /* upper */
    { 0x1eea, 0x1eeb },  /* lower */
    { 0x1eec, 0x1eed },  /* upper */
    { 0x1eec, 0x1eed },  /* lower */
    { 0x1eee, 0x1eef },  /* upper */
    { 0x1eee, 0x1eef },  /* lower */
    { 0x1ef0, 0x1ef1 },  /* upper */
    { 0x1ef0, 0x1ef1 },  /* lower */
    { 0x1ef2, 0x1ef3 },  /* upper */
    { 0x1ef2, 0x1ef3 },  /* lower */
    { 0x1ef4, 0x1ef5 },  /* upper */
    { 0x1ef4, 0x1ef5 },  /* lower */
    { 0x1ef6, 0x1ef7 },  /* upper */
    { 0x1ef6, 0x1ef7 },  /* lower */
    { 0x1ef8, 0x1ef9 },  /* upper */
    { 0x1ef8, 0x1ef9 },  /* lower */
    { 0x1efa, 0x1efa },
    { 0x1efb, 0x1efb },
    { 0x1efc, 0x1efc },
    { 0x1efd, 0x1efd },
    { 0x1efe, 0x1efe },
    { 0x1eff, 0x1eff },
};

static gli_case_block_t unigen_case_block_0x1f[256] = {
    { 0x1f08, 0x1f00 },  /* lower */
    { 0x1f09, 0x1f01 },  /* lower */
    { 0x1f0a, 0x1f02 },  /* lower */
    { 0x1f0b, 0x1f03 },  /* lower */
    { 0x1f0c, 0x1f04 },  /* lower */
    { 0x1f0d, 0x1f05 },  /* lower */
    { 0x1f0e, 0x1f06 },  /* lower */
    { 0x1f0f, 0x1f07 },  /* lower */
    { 0x1f08, 0x1f00 },  /* upper */
    { 0x1f09, 0x1f01 },  /* upper */
    { 0x1f0a, 0x1f02 },  /* upper */
    { 0x1f0b, 0x1f03 },  /* upper */
    { 0x1f0c, 0x1f04 },  /* upper */
    { 0x1f0d, 0x1f05 },  /* upper */
    { 0x1f0e, 0x1f06 },  /* upper */
    { 0x1f0f, 0x1f07 },  /* upper */
    { 0x1f18, 0x1f10 },  /* lower */
    { 0x1f19, 0x1f11 },  /* lower */
    { 0x1f1a, 0x1f12 },  /* lower */
    { 0x1f1b, 0x1f13 },  /* lower */
    { 0x1f1c, 0x1f14 },  /* lower */
    { 0x1f1d, 0x1f15 },  /* lower */
    { 0x1f16, 0x1f16 },
    { 0x1f17, 0x1f17 },
    { 0x1f18, 0x1f10 },  /* upper */
    { 0x1f19, 0x1f11 },  /* upper */
    { 0x1f1a, 0x1f12 },  /* upper */
    { 0x1f1b, 0x1f13 },  /* upper */
    { 0x1f1c, 0x1f14 },  /* upper */
    { 0x1f1d, 0x1f15 },  /* upper */
    { 0x1f1e, 0x1f1e },
    { 0x1f1f, 0x1f1f },
    { 0x1f28, 0x1f20 },  /* lower */
    { 0x1f29, 0x1f21 },  /* lower */
    { 0x1f2a, 0x1f22 },  /* lower */
    { 0x1f2b, 0x1f23 },  /* lower */
    { 0x1f2c, 0x1f24 },  /* lower */
    { 0x1f2d, 0x1f25 },  /* lower */
    { 0x1f2e, 0x1f26 },  /* lower */
    { 0x1f2f, 0x1f27 },  /* lower */
    { 0x1f28, 0x1f20 },  /* upper */
    { 0x1f29, 0x1f21 },  /* upper */
    { 0x1f2a, 0x1f22 },  /* upper */
    { 0x1f2b, 0x1f23 },  /* upper */
    { 0x1f2c, 0x1f24 },  /* upper */
    { 0x1f2d, 0x1f25 },  /* upper */
    { 0x1f2e, 0x1f26 },  /* upper */
    { 0x1f2f, 0x1f27 },  /* upper */
    { 0x1f38, 0x1f30 },  /* lower */
    { 0x1f39, 0x1f31 },  /* lower */
    { 0x1f3a, 0x1f32 },  /* lower */
    { 0x1f3b, 0x1f33 },  /* lower */
    { 0x1f3c, 0x1f34 },  /* lower */
    { 0x1f3d, 0x1f35 },  /* lower */
    { 0x1f3e, 0x1f36 },  /* lower */
    { 0x1f3f, 0x1f37 },  /* lower */
    { 0x1f38, 0x1f30 },  /* upper */
    { 0x1f39, 0x1f31 },  /* upper */
    { 0x1f3a, 0x1f32 },  /* upper */
    { 0x1f3b, 0x1f33 },  /* upper */
    { 0x1f3c, 0x1f34 },  /* upper */
    { 0x1f3d, 0x1f35 },  /* upper */
    { 0x1f3e, 0x1f36 },  /* upper */
    { 0x1f3f, 0x1f37 },  /* upper */
    { 0x1f48, 0x1f40 },  /* lower */
    { 0x1f49, 0x1f41 },  /* lower */
    { 0x1f4a, 0x1f42 },  /* lower */
    { 0x1f4b, 0x1f43 },  /* lower */
    { 0x1f4c, 0x1f44 },  /* lower */
    { 0x1f4d, 0x1f45 },  /* lower */
    { 0x1f46, 0x1f46 },
    { 0x1f47, 0x1f47 },
    { 0x1f48, 0x1f40 },  /* upper */
    { 0x1f49, 0x1f41 },  /* upper */
    { 0x1f4a, 0x1f42 },  /* upper */
    { 0x1f4b, 0x1f43 },  /* upper */
    { 0x1f4c, 0x1f44 },  /* upper */
    { 0x1f4d, 0x1f45 },  /* upper */
    { 0x1f4e, 0x1f4e },
    { 0x1f4f, 0x1f4f },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1f59, 0x1f51 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1f5b, 0x1f53 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1f5d, 0x1f55 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1f5f, 0x1f57 },  /* lower */
    { 0x1f58, 0x1f58 },
    { 0x1f59, 0x1f51 },  /* upper */
    { 0x1f5a, 0x1f5a },
    { 0x1f5b, 0x1f53 },  /* upper */
    { 0x1f5c, 0x1f5c },
    { 0x1f5d, 0x1f55 },  /* upper */
    { 0x1f5e, 0x1f5e },
    { 0x1f5f, 0x1f57 },  /* upper */
    { 0x1f68, 0x1f60 },  /* lower */
    { 0x1f69, 0x1f61 },  /* lower */
    { 0x1f6a, 0x1f62 },  /* lower */
    { 0x1f6b, 0x1f63 },  /* lower */
    { 0x1f6c, 0x1f64 },  /* lower */
    { 0x1f6d, 0x1f65 },  /* lower */
    { 0x1f6e, 0x1f66 },  /* lower */
    { 0x1f6f, 0x1f67 },  /* lower */
    { 0x1f68, 0x1f60 },  /* upper */
    { 0x1f69, 0x1f61 },  /* upper */
    { 0x1f6a, 0x1f62 },  /* upper */
    { 0x1f6b, 0x1f63 },  /* upper */
    { 0x1f6c, 0x1f64 },  /* upper */
    { 0x1f6d, 0x1f65 },  /* upper */
    { 0x1f6e, 0x1f66 },  /* upper */
    { 0x1f6f, 0x1f67 },  /* upper */
    { 0x1fba, 0x1f70 },  /* lower */
    { 0x1fbb, 0x1f71 },  /* lower */
    { 0x1fc8, 0x1f72 },  /* lower */
    { 0x1fc9, 0x1f73 },  /* lower */
    { 0x1fca, 0x1f74 },  /* lower */
    { 0x1fcb, 0x1f75 },  /* lower */
    { 0x1fda, 0x1f76 },  /* lower */
    { 0x1fdb, 0x1f77 },  /* lower */
    { 0x1ff8, 0x1f78 },  /* lower */
    { 0x1ff9, 0x1f79 },  /* lower */
    { 0x1fea, 0x1f7a },  /* lower */
    { 0x1feb, 0x1f7b },  /* lower */
    { 0x1ffa, 0x1f7c },  /* lower */
    { 0x1ffb, 0x1f7d },  /* lower */
    { 0x1f7e, 0x1f7e },
    { 0x1f7f, 0x1f7f },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fb8, 0x1fb0 },  /* lower */
    { 0x1fb9, 0x1fb1 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fb5, 0x1fb5 },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fb8, 0x1fb0 },  /* upper */
    { 0x1fb9, 0x1fb1 },  /* upper */
    { 0x1fba, 0x1f70 },  /* upper */
    { 0x1fbb, 0x1f71 },  /* upper */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fbd, 0x1fbd },
    { 0x399, 0x1fbe },  /* lower */
    { 0x1fbf, 0x1fbf },
    { 0x1fc0, 0x1fc0 },
    { 0x1fc1, 0x1fc1 },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fc5, 0x1fc5 },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fc8, 0x1f72 },  /* upper */
    { 0x1fc9, 0x1f73 },  /* upper */
    { 0x1fca, 0x1f74 },  /* upper */
    { 0x1fcb, 0x1f75 },  /* upper */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fcd, 0x1fcd },
    { 0x1fce, 0x1fce },
    { 0x1fcf, 0x1fcf },
    { 0x1fd8, 0x1fd0 },  /* lower */
    { 0x1fd9, 0x1fd1 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fd4, 0x1fd4 },
    { 0x1fd5, 0x1fd5 },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fd8, 0x1fd0 },  /* upper */
    { 0x1fd9, 0x1fd1 },  /* upper */
    { 0x1fda, 0x1f76 },  /* upper */
    { 0x1fdb, 0x1f77 },  /* upper */
    { 0x1fdc, 0x1fdc },
    { 0x1fdd, 0x1fdd },
    { 0x1fde, 0x1fde },
    { 0x1fdf, 0x1fdf },
    { 0x1fe8, 0x1fe0 },  /* lower */
    { 0x1fe9, 0x1fe1 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fec, 0x1fe5 },  /* lower */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1fe8, 0x1fe0 },  /* upper */
    { 0x1fe9, 0x1fe1 },  /* upper */
    { 0x1fea, 0x1f7a },  /* upper */
    { 0x1feb, 0x1f7b },  /* upper */
    { 0x1fec, 0x1fe5 },  /* upper */
    { 0x1fed, 0x1fed },
    { 0x1fee, 0x1fee },
    { 0x1fef, 0x1fef },
    { 0x1ff0, 0x1ff0 },
    { 0x1ff1, 0x1ff1 },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1ff5, 0x1ff5 },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1ff8, 0x1f78 },  /* upper */
    { 0x1ff9, 0x1f79 },  /* upper */
    { 0x1ffa, 0x1f7c },  /* upper */
    { 0x1ffb, 0x1f7d },  /* upper */
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0x1ffd, 0x1ffd },
    { 0x1ffe, 0x1ffe },
    { 0x1fff, 0x1fff },
};

static gli_case_block_t unigen_case_block_0x21[256] = {
    { 0x2100, 0x2100 },
    { 0x2101, 0x2101 },
    { 0x2102, 0x2102 },
    { 0x2103, 0x2103 },
    { 0x2104, 0x2104 },
    { 0x2105, 0x2105 },
    { 0x2106, 0x2106 },
    { 0x2107, 0x2107 },
    { 0x2108, 0x2108 },
    { 0x2109, 0x2109 },
    { 0x210a, 0x210a },
    { 0x210b, 0x210b },
    { 0x210c, 0x210c },
    { 0x210d, 0x210d },
    { 0x210e, 0x210e },
    { 0x210f, 0x210f },
    { 0x2110, 0x2110 },
    { 0x2111, 0x2111 },
    { 0x2112, 0x2112 },
    { 0x2113, 0x2113 },
    { 0x2114, 0x2114 },
    { 0x2115, 0x2115 },
    { 0x2116, 0x2116 },
    { 0x2117, 0x2117 },
    { 0x2118, 0x2118 },
    { 0x2119, 0x2119 },
    { 0x211a, 0x211a },
    { 0x211b, 0x211b },
    { 0x211c, 0x211c },
    { 0x211d, 0x211d },
    { 0x211e, 0x211e },
    { 0x211f, 0x211f },
    { 0x2120, 0x2120 },
    { 0x2121, 0x2121 },
    { 0x2122, 0x2122 },
    { 0x2123, 0x2123 },
    { 0x2124, 0x2124 },
    { 0x2125, 0x2125 },
    { 0x2126, 0x3c9 },  /* upper */
    { 0x2127, 0x2127 },
    { 0x2128, 0x2128 },
    { 0x2129, 0x2129 },
    { 0x212a, 0x6b },  /* upper */
    { 0x212b, 0xe5 },  /* upper */
    { 0x212c, 0x212c },
    { 0x212d, 0x212d },
    { 0x212e, 0x212e },
    { 0x212f, 0x212f },
    { 0x2130, 0x2130 },
    { 0x2131, 0x2131 },
    { 0x2132, 0x2132 },
    { 0x2133, 0x2133 },
    { 0x2134, 0x2134 },
    { 0x2135, 0x2135 },
    { 0x2136, 0x2136 },
    { 0x2137, 0x2137 },
    { 0x2138, 0x2138 },
    { 0x2139, 0x2139 },
    { 0x213a, 0x213a },
    { 0x213b, 0x213b },
    { 0x213c, 0x213c },
    { 0x213d, 0x213d },
    { 0x213e, 0x213e },
    { 0x213f, 0x213f },
    { 0x2140, 0x2140 },
    { 0x2141, 0x2141 },
    { 0x2142, 0x2142 },
    { 0x2143, 0x2143 },
    { 0x2144, 0x2144 },
    { 0x2145, 0x2145 },
    { 0x2146, 0x2146 },
    { 0x2147, 0x2147 },
    { 0x2148, 0x2148 },
    { 0x2149, 0x2149 },
    { 0x214a, 0x214a },
    { 0x214b, 0x214b },
    { 0x214c, 0x214c },
    { 0x214d, 0x214d },
    { 0x214e, 0x214e },
    { 0x214f, 0x214f },
    { 0x2150, 0x2150 },
    { 0x2151, 0x2151 },
    { 0x2152, 0x2152 },
    { 0x2153, 0x2153 },
    { 0x2154, 0x2154 },
    { 0x2155, 0x2155 },
    { 0x2156, 0x2156 },
    { 0x2157, 0x2157 },
    { 0x2158, 0x2158 },
    { 0x2159, 0x2159 },
    { 0x215a, 0x215a },
    { 0x215b, 0x215b },
    { 0x215c, 0x215c },
    { 0x215d, 0x215d },
    { 0x215e, 0x215e },
    { 0x215f, 0x215f },
    { 0x2160, 0x2170 },  /* upper */
    { 0x2161, 0x2171 },  /* upper */
    { 0x2162, 0x2172 },  /* upper */
    { 0x2163, 0x2173 },  /* upper */
    { 0x2164, 0x2174 },  /* upper */
    { 0x2165, 0x2175 },  /* upper */
    { 0x2166, 0x2176 },  /* upper */
    { 0x2167, 0x2177 },  /* upper */
    { 0x2168, 0x2178 },  /* upper */
    { 0x2169, 0x2179 },  /* upper */
    { 0x216a, 0x217a },  /* upper */
    { 0x216b, 0x217b },  /* upper */
    { 0x216c, 0x217c },  /* upper */
    { 0x216d, 0x217d },  /* upper */
    { 0x216e, 0x217e },  /* upper */
    { 0x216f, 0x217f },  /* upper */
    { 0x2160, 0x2170 },  /* lower */
    { 0x2161, 0x2171 },  /* lower */
    { 0x2162, 0x2172 },  /* lower */
    { 0x2163, 0x2173 },  /* lower */
    { 0x2164, 0x2174 },  /* lower */
    { 0x2165, 0x2175 },  /* lower */
    { 0x2166, 0x2176 },  /* lower */
    { 0x2167, 0x2177 },  /* lower */
    { 0x2168, 0x2178 },  /* lower */
    { 0x2169, 0x2179 },  /* lower */
    { 0x216a, 0x217a },  /* lower */
    { 0x216b, 0x217b },  /* lower */
    { 0x216c, 0x217c },  /* lower */
    { 0x216d, 0x217d },  /* lower */
    { 0x216e, 0x217e },  /* lower */
    { 0x216f, 0x217f },  /* lower */
    { 0x2180, 0x2180 },
    { 0x2181, 0x2181 },
    { 0x2182, 0x2182 },
    { 0x2183, 0x2183 },
    { 0x2184, 0x2184 },
    { 0x2185, 0x2185 },
    { 0x2186, 0x2186 },
    { 0x2187, 0x2187 },
    { 0x2188, 0x2188 },
    { 0x2189, 0x2189 },
    { 0x218a, 0x218a },
    { 0x218b, 0x218b },
    { 0x218c, 0x218c },
    { 0x218d, 0x218d },
    { 0x218e, 0x218e },
    { 0x218f, 0x218f },
    { 0x2190, 0x2190 },
    { 0x2191, 0x2191 },
    { 0x2192, 0x2192 },
    { 0x2193, 0x2193 },
    { 0x2194, 0x2194 },
    { 0x2195, 0x2195 },
    { 0x2196, 0x2196 },
    { 0x2197, 0x2197 },
    { 0x2198, 0x2198 },
    { 0x2199, 0x2199 },
    { 0x219a, 0x219a },
    { 0x219b, 0x219b },
    { 0x219c, 0x219c },
    { 0x219d, 0x219d },
    { 0x219e, 0x219e },
    { 0x219f, 0x219f },
    { 0x21a0, 0x21a0 },
    { 0x21a1, 0x21a1 },
    { 0x21a2, 0x21a2 },
    { 0x21a3, 0x21a3 },
    { 0x21a4, 0x21a4 },
    { 0x21a5, 0x21a5 },
    { 0x21a6, 0x21a6 },
    { 0x21a7, 0x21a7 },
    { 0x21a8, 0x21a8 },
    { 0x21a9, 0x21a9 },
    { 0x21aa, 0x21aa },
    { 0x21ab, 0x21ab },
    { 0x21ac, 0x21ac },
    { 0x21ad, 0x21ad },
    { 0x21ae, 0x21ae },
    { 0x21af, 0x21af },
    { 0x21b0, 0x21b0 },
    { 0x21b1, 0x21b1 },
    { 0x21b2, 0x21b2 },
    { 0x21b3, 0x21b3 },
    { 0x21b4, 0x21b4 },
    { 0x21b5, 0x21b5 },
    { 0x21b6, 0x21b6 },
    { 0x21b7, 0x21b7 },
    { 0x21b8, 0x21b8 },
    { 0x21b9, 0x21b9 },
    { 0x21ba, 0x21ba },
    { 0x21bb, 0x21bb },
    { 0x21bc, 0x21bc },
    { 0x21bd, 0x21bd },
    { 0x21be, 0x21be },
    { 0x21bf, 0x21bf },
    { 0x21c0, 0x21c0 },
    { 0x21c1, 0x21c1 },
    { 0x21c2, 0x21c2 },
    { 0x21c3, 0x21c3 },
    { 0x21c4, 0x21c4 },
    { 0x21c5, 0x21c5 },
    { 0x21c6, 0x21c6 },
    { 0x21c7, 0x21c7 },
    { 0x21c8, 0x21c8 },
    { 0x21c9, 0x21c9 },
    { 0x21ca, 0x21ca },
    { 0x21cb, 0x21cb },
    { 0x21cc, 0x21cc },
    { 0x21cd, 0x21cd },
    { 0x21ce, 0x21ce },
    { 0x21cf, 0x21cf },
    { 0x21d0, 0x21d0 },
    { 0x21d1, 0x21d1 },
    { 0x21d2, 0x21d2 },
    { 0x21d3, 0x21d3 },
    { 0x21d4, 0x21d4 },
    { 0x21d5, 0x21d5 },
    { 0x21d6, 0x21d6 },
    { 0x21d7, 0x21d7 },
    { 0x21d8, 0x21d8 },
    { 0x21d9, 0x21d9 },
    { 0x21da, 0x21da },
    { 0x21db, 0x21db },
    { 0x21dc, 0x21dc },
    { 0x21dd, 0x21dd },
    { 0x21de, 0x21de },
    { 0x21df, 0x21df },
    { 0x21e0, 0x21e0 },
    { 0x21e1, 0x21e1 },
    { 0x21e2, 0x21e2 },
    { 0x21e3, 0x21e3 },
    { 0x21e4, 0x21e4 },
    { 0x21e5, 0x21e5 },
    { 0x21e6, 0x21e6 },
    { 0x21e7, 0x21e7 },
    { 0x21e8, 0x21e8 },
    { 0x21e9, 0x21e9 },
    { 0x21ea, 0x21ea },
    { 0x21eb, 0x21eb },
    { 0x21ec, 0x21ec },
    { 0x21ed, 0x21ed },
    { 0x21ee, 0x21ee },
    { 0x21ef, 0x21ef },
    { 0x21f0, 0x21f0 },
    { 0x21f1, 0x21f1 },
    { 0x21f2, 0x21f2 },
    { 0x21f3, 0x21f3 },
    { 0x21f4, 0x21f4 },
    { 0x21f5, 0x21f5 },
    { 0x21f6, 0x21f6 },
    { 0x21f7, 0x21f7 },
    { 0x21f8, 0x21f8 },
    { 0x21f9, 0x21f9 },
    { 0x21fa, 0x21fa },
    { 0x21fb, 0x21fb },
    { 0x21fc, 0x21fc },
    { 0x21fd, 0x21fd },
    { 0x21fe, 0x21fe },
    { 0x21ff, 0x21ff },
};

static gli_case_block_t unigen_case_block_0x24[256] = {
    { 0x2400, 0x2400 },
    { 0x2401, 0x2401 },
    { 0x2402, 0x2402 },
    { 0x2403, 0x2403 },
    { 0x2404, 0x2404 },
    { 0x2405, 0x2405 },
    { 0x2406, 0x2406 },
    { 0x2407, 0x2407 },
    { 0x2408, 0x2408 },
    { 0x2409, 0x2409 },
    { 0x240a, 0x240a },
    { 0x240b, 0x240b },
    { 0x240c, 0x240c },
    { 0x240d, 0x240d },
    { 0x240e, 0x240e },
    { 0x240f, 0x240f },
    { 0x2410, 0x2410 },
    { 0x2411, 0x2411 },
    { 0x2412, 0x2412 },
    { 0x2413, 0x2413 },
    { 0x2414, 0x2414 },
    { 0x2415, 0x2415 },
    { 0x2416, 0x2416 },
    { 0x2417, 0x2417 },
    { 0x2418, 0x2418 },
    { 0x2419, 0x2419 },
    { 0x241a, 0x241a },
    { 0x241b, 0x241b },
    { 0x241c, 0x241c },
    { 0x241d, 0x241d },
    { 0x241e, 0x241e },
    { 0x241f, 0x241f },
    { 0x2420, 0x2420 },
    { 0x2421, 0x2421 },
    { 0x2422, 0x2422 },
    { 0x2423, 0x2423 },
    { 0x2424, 0x2424 },
    { 0x2425, 0x2425 },
    { 0x2426, 0x2426 },
    { 0x2427, 0x2427 },
    { 0x2428, 0x2428 },
    { 0x2429, 0x2429 },
    { 0x242a, 0x242a },
    { 0x242b, 0x242b },
    { 0x242c, 0x242c },
    { 0x242d, 0x242d },
    { 0x242e, 0x242e },
    { 0x242f, 0x242f },
    { 0x2430, 0x2430 },
    { 0x2431, 0x2431 },
    { 0x2432, 0x2432 },
    { 0x2433, 0x2433 },
    { 0x2434, 0x2434 },
    { 0x2435, 0x2435 },
    { 0x2436, 0x2436 },
    { 0x2437, 0x2437 },
    { 0x2438, 0x2438 },
    { 0x2439, 0x2439 },
    { 0x243a, 0x243a },
    { 0x243b, 0x243b },
    { 0x243c, 0x243c },
    { 0x243d, 0x243d },
    { 0x243e, 0x243e },
    { 0x243f, 0x243f },
    { 0x2440, 0x2440 },
    { 0x2441, 0x2441 },
    { 0x2442, 0x2442 },
    { 0x2443, 0x2443 },
    { 0x2444, 0x2444 },
    { 0x2445, 0x2445 },
    { 0x2446, 0x2446 },
    { 0x2447, 0x2447 },
    { 0x2448, 0x2448 },
    { 0x2449, 0x2449 },
    { 0x244a, 0x244a },
    { 0x244b, 0x244b },
    { 0x244c, 0x244c },
    { 0x244d, 0x244d },
    { 0x244e, 0x244e },
    { 0x244f, 0x244f },
    { 0x2450, 0x2450 },
    { 0x2451, 0x2451 },
    { 0x2452, 0x2452 },
    { 0x2453, 0x2453 },
    { 0x2454, 0x2454 },
    { 0x2455, 0x2455 },
    { 0x2456, 0x2456 },
    { 0x2457, 0x2457 },
    { 0x2458, 0x2458 },
    { 0x2459, 0x2459 },
    { 0x245a, 0x245a },
    { 0x245b, 0x245b },
    { 0x245c, 0x245c },
    { 0x245d, 0x245d },
    { 0x245e, 0x245e },
    { 0x245f, 0x245f },
    { 0x2460, 0x2460 },
    { 0x2461, 0x2461 },
    { 0x2462, 0x2462 },
    { 0x2463, 0x2463 },
    { 0x2464, 0x2464 },
    { 0x2465, 0x2465 },
    { 0x2466, 0x2466 },
    { 0x2467, 0x2467 },
    { 0x2468, 0x2468 },
    { 0x2469, 0x2469 },
    { 0x246a, 0x246a },
    { 0x246b, 0x246b },
    { 0x246c, 0x246c },
    { 0x246d, 0x246d },
    { 0x246e, 0x246e },
    { 0x246f, 0x246f },
    { 0x2470, 0x2470 },
    { 0x2471, 0x2471 },
    { 0x2472, 0x2472 },
    { 0x2473, 0x2473 },
    { 0x2474, 0x2474 },
    { 0x2475, 0x2475 },
    { 0x2476, 0x2476 },
    { 0x2477, 0x2477 },
    { 0x2478, 0x2478 },
    { 0x2479, 0x2479 },
    { 0x247a, 0x247a },
    { 0x247b, 0x247b },
    { 0x247c, 0x247c },
    { 0x247d, 0x247d },
    { 0x247e, 0x247e },
    { 0x247f, 0x247f },
    { 0x2480, 0x2480 },
    { 0x2481, 0x2481 },
    { 0x2482, 0x2482 },
    { 0x2483, 0x2483 },
    { 0x2484, 0x2484 },
    { 0x2485, 0x2485 },
    { 0x2486, 0x2486 },
    { 0x2487, 0x2487 },
    { 0x2488, 0x2488 },
    { 0x2489, 0x2489 },
    { 0x248a, 0x248a },
    { 0x248b, 0x248b },
    { 0x248c, 0x248c },
    { 0x248d, 0x248d },
    { 0x248e, 0x248e },
    { 0x248f, 0x248f },
    { 0x2490, 0x2490 },
    { 0x2491, 0x2491 },
    { 0x2492, 0x2492 },
    { 0x2493, 0x2493 },
    { 0x2494, 0x2494 },
    { 0x2495, 0x2495 },
    { 0x2496, 0x2496 },
    { 0x2497, 0x2497 },
    { 0x2498, 0x2498 },
    { 0x2499, 0x2499 },
    { 0x249a, 0x249a },
    { 0x249b, 0x249b },
    { 0x249c, 0x249c },
    { 0x249d, 0x249d },
    { 0x249e, 0x249e },
    { 0x249f, 0x249f },
    { 0x24a0, 0x24a0 },
    { 0x24a1, 0x24a1 },
    { 0x24a2, 0x24a2 },
    { 0x24a3, 0x24a3 },
    { 0x24a4, 0x24a4 },
    { 0x24a5, 0x24a5 },
    { 0x24a6, 0x24a6 },
    { 0x24a7, 0x24a7 },
    { 0x24a8, 0x24a8 },
    { 0x24a9, 0x24a9 },
    { 0x24aa, 0x24aa },
    { 0x24ab, 0x24ab },
    { 0x24ac, 0x24ac },
    { 0x24ad, 0x24ad },
    { 0x24ae, 0x24ae },
    { 0x24af, 0x24af },
    { 0x24b0, 0x24b0 },
    { 0x24b1, 0x24b1 },
    { 0x24b2, 0x24b2 },
    { 0x24b3, 0x24b3 },
    { 0x24b4, 0x24b4 },
    { 0x24b5, 0x24b5 },
    { 0x24b6, 0x24d0 },  /* upper */
    { 0x24b7, 0x24d1 },  /* upper */
    { 0x24b8, 0x24d2 },  /* upper */
    { 0x24b9, 0x24d3 },  /* upper */
    { 0x24ba, 0x24d4 },  /* upper */
    { 0x24bb, 0x24d5 },  /* upper */
    { 0x24bc, 0x24d6 },  /* upper */
    { 0x24bd, 0x24d7 },  /* upper */
    { 0x24be, 0x24d8 },  /* upper */
    { 0x24bf, 0x24d9 },  /* upper */
    { 0x24c0, 0x24da },  /* upper */
    { 0x24c1, 0x24db },  /* upper */
    { 0x24c2, 0x24dc },  /* upper */
    { 0x24c3, 0x24dd },  /* upper */
    { 0x24c4, 0x24de },  /* upper */
    { 0x24c5, 0x24df },  /* upper */
    { 0x24c6, 0x24e0 },  /* upper */
    { 0x24c7, 0x24e1 },  /* upper */
    { 0x24c8, 0x24e2 },  /* upper */
    { 0x24c9, 0x24e3 },  /* upper */
    { 0x24ca, 0x24e4 },  /* upper */
    { 0x24cb, 0x24e5 },  /* upper */
    { 0x24cc, 0x24e6 },  /* upper */
    { 0x24cd, 0x24e7 },  /* upper */
    { 0x24ce, 0x24e8 },  /* upper */
    { 0x24cf, 0x24e9 },  /* upper */
    { 0x24b6, 0x24d0 },  /* lower */
    { 0x24b7, 0x24d1 },  /* lower */
    { 0x24b8, 0x24d2 },  /* lower */
    { 0x24b9, 0x24d3 },  /* lower */
    { 0x24ba, 0x24d4 },  /* lower */
    { 0x24bb, 0x24d5 },  /* lower */
    { 0x24bc, 0x24d6 },  /* lower */
    { 0x24bd, 0x24d7 },  /* lower */
    { 0x24be, 0x24d8 },  /* lower */
    { 0x24bf, 0x24d9 },  /* lower */
    { 0x24c0, 0x24da },  /* lower */
    { 0x24c1, 0x24db },  /* lower */
    { 0x24c2, 0x24dc },  /* lower */
    { 0x24c3, 0x24dd },  /* lower */
    { 0x24c4, 0x24de },  /* lower */
    { 0x24c5, 0x24df },  /* lower */
    { 0x24c6, 0x24e0 },  /* lower */
    { 0x24c7, 0x24e1 },  /* lower */
    { 0x24c8, 0x24e2 },  /* lower */
    { 0x24c9, 0x24e3 },  /* lower */
    { 0x24ca, 0x24e4 },  /* lower */
    { 0x24cb, 0x24e5 },  /* lower */
    { 0x24cc, 0x24e6 },  /* lower */
    { 0x24cd, 0x24e7 },  /* lower */
    { 0x24ce, 0x24e8 },  /* lower */
    { 0x24cf, 0x24e9 },  /* lower */
    { 0x24ea, 0x24ea },
    { 0x24eb, 0x24eb },
    { 0x24ec, 0x24ec },
    { 0x24ed, 0x24ed },
    { 0x24ee, 0x24ee },
    { 0x24ef, 0x24ef },
    { 0x24f0, 0x24f0 },
    { 0x24f1, 0x24f1 },
    { 0x24f2, 0x24f2 },
    { 0x24f3, 0x24f3 },
    { 0x24f4, 0x24f4 },
    { 0x24f5, 0x24f5 },
    { 0x24f6, 0x24f6 },
    { 0x24f7, 0x24f7 },
    { 0x24f8, 0x24f8 },
    { 0x24f9, 0x24f9 },
    { 0x24fa, 0x24fa },
    { 0x24fb, 0x24fb },
    { 0x24fc, 0x24fc },
    { 0x24fd, 0x24fd },
    { 0x24fe, 0x24fe },
    { 0x24ff, 0x24ff },
};

static gli_case_block_t unigen_case_block_0xfb[256] = {
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xfb07, 0xfb07 },
    { 0xfb08, 0xfb08 },
    { 0xfb09, 0xfb09 },
    { 0xfb0a, 0xfb0a },
    { 0xfb0b, 0xfb0b },
    { 0xfb0c, 0xfb0c },
    { 0xfb0d, 0xfb0d },
    { 0xfb0e, 0xfb0e },
    { 0xfb0f, 0xfb0f },
    { 0xfb10, 0xfb10 },
    { 0xfb11, 0xfb11 },
    { 0xfb12, 0xfb12 },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xFFFFFFFF, 0xFFFFFFFF },
    { 0xfb18, 0xfb18 },
    { 0xfb19, 0xfb19 },
    { 0xfb1a, 0xfb1a },
    { 0xfb1b, 0xfb1b },
    { 0xfb1c, 0xfb1c },
    { 0xfb1d, 0xfb1d },
    { 0xfb1e, 0xfb1e },
    { 0xfb1f, 0xfb1f },
    { 0xfb20, 0xfb20 },
    { 0xfb21, 0xfb21 },
    { 0xfb22, 0xfb22 },
    { 0xfb23, 0xfb23 },
    { 0xfb24, 0xfb24 },
    { 0xfb25, 0xfb25 },
    { 0xfb26, 0xfb26 },
    { 0xfb27, 0xfb27 },
    { 0xfb28, 0xfb28 },
    { 0xfb29, 0xfb29 },
    { 0xfb2a, 0xfb2a },
    { 0xfb2b, 0xfb2b },
    { 0xfb2c, 0xfb2c },
    { 0xfb2d, 0xfb2d },
    { 0xfb2e, 0xfb2e },
    { 0xfb2f, 0xfb2f },
    { 0xfb30, 0xfb30 },
    { 0xfb31, 0xfb31 },
    { 0xfb32, 0xfb32 },
    { 0xfb33, 0xfb33 },
    { 0xfb34, 0xfb34 },
    { 0xfb35, 0xfb35 },
    { 0xfb36, 0xfb36 },
    { 0xfb37, 0xfb37 },
    { 0xfb38, 0xfb38 },
    { 0xfb39, 0xfb39 },
    { 0xfb3a, 0xfb3a },
    { 0xfb3b, 0xfb3b },
    { 0xfb3c, 0xfb3c },
    { 0xfb3d, 0xfb3d },
    { 0xfb3e, 0xfb3e },
    { 0xfb3f, 0xfb3f },
    { 0xfb40, 0xfb40 },
    { 0xfb41, 0xfb41 },
    { 0xfb42, 0xfb42 },
    { 0xfb43, 0xfb43 },
    { 0xfb44, 0xfb44 },
    { 0xfb45, 0xfb45 },
    { 0xfb46, 0xfb46 },
    { 0xfb47, 0xfb47 },
    { 0xfb48, 0xfb48 },
    { 0xfb49, 0xfb49 },
    { 0xfb4a, 0xfb4a },
    { 0xfb4b, 0xfb4b },
    { 0xfb4c, 0xfb4c },
    { 0xfb4d, 0xfb4d },
    { 0xfb4e, 0xfb4e },
    { 0xfb4f, 0xfb4f },
    { 0xfb50, 0xfb50 },
    { 0xfb51, 0xfb51 },
    { 0xfb52, 0xfb52 },
    { 0xfb53, 0xfb53 },
    { 0xfb54, 0xfb54 },
    { 0xfb55, 0xfb55 },
    { 0xfb56, 0xfb56 },
    { 0xfb57, 0xfb57 },
    { 0xfb58, 0xfb58 },
    { 0xfb59, 0xfb59 },
    { 0xfb5a, 0xfb5a },
    { 0xfb5b, 0xfb5b },
    { 0xfb5c, 0xfb5c },
    { 0xfb5d, 0xfb5d },
    { 0xfb5e, 0xfb5e },
    { 0xfb5f, 0xfb5f },
    { 0xfb60, 0xfb60 },
    { 0xfb61, 0xfb61 },
    { 0xfb62, 0xfb62 },
    { 0xfb63, 0xfb63 },
    { 0xfb64, 0xfb64 },
    { 0xfb65, 0xfb65 },
    { 0xfb66, 0xfb66 },
    { 0xfb67, 0xfb67 },
    { 0xfb68, 0xfb68 },
    { 0xfb69, 0xfb69 },
    { 0xfb6a, 0xfb6a },
    { 0xfb6b, 0xfb6b },
    { 0xfb6c, 0xfb6c },
    { 0xfb6d, 0xfb6d },
    { 0xfb6e, 0xfb6e },
    { 0xfb6f, 0xfb6f },
    { 0xfb70, 0xfb70 },
    { 0xfb71, 0xfb71 },
    { 0xfb72, 0xfb72 },
    { 0xfb73, 0xfb73 },
    { 0xfb74, 0xfb74 },
    { 0xfb75, 0xfb75 },
    { 0xfb76, 0xfb76 },
    { 0xfb77, 0xfb77 },
    { 0xfb78, 0xfb78 },
    { 0xfb79, 0xfb79 },
    { 0xfb7a, 0xfb7a },
    { 0xfb7b, 0xfb7b },
    { 0xfb7c, 0xfb7c },
    { 0xfb7d, 0xfb7d },
    { 0xfb7e, 0xfb7e },
    { 0xfb7f, 0xfb7f },
    { 0xfb80, 0xfb80 },
    { 0xfb81, 0xfb81 },
    { 0xfb82, 0xfb82 },
    { 0xfb83, 0xfb83 },
    { 0xfb84, 0xfb84 },
    { 0xfb85, 0xfb85 },
    { 0xfb86, 0xfb86 },
    { 0xfb87, 0xfb87 },
    { 0xfb88, 0xfb88 },
    { 0xfb89, 0xfb89 },
    { 0xfb8a, 0xfb8a },
    { 0xfb8b, 0xfb8b },
    { 0xfb8c, 0xfb8c },
    { 0xfb8d, 0xfb8d },
    { 0xfb8e, 0xfb8e },
    { 0xfb8f, 0xfb8f },
    { 0xfb90, 0xfb90 },
    { 0xfb91, 0xfb91 },
    { 0xfb92, 0xfb92 },
    { 0xfb93, 0xfb93 },
    { 0xfb94, 0xfb94 },
    { 0xfb95, 0xfb95 },
    { 0xfb96, 0xfb96 },
    { 0xfb97, 0xfb97 },
    { 0xfb98, 0xfb98 },
    { 0xfb99, 0xfb99 },
    { 0xfb9a, 0xfb9a },
    { 0xfb9b, 0xfb9b },
    { 0xfb9c, 0xfb9c },
    { 0xfb9d, 0xfb9d },
    { 0xfb9e, 0xfb9e },
    { 0xfb9f, 0xfb9f },
    { 0xfba0, 0xfba0 },
    { 0xfba1, 0xfba1 },
    { 0xfba2, 0xfba2 },
    { 0xfba3, 0xfba3 },
    { 0xfba4, 0xfba4 },
    { 0xfba5, 0xfba5 },
    { 0xfba6, 0xfba6 },
    { 0xfba7, 0xfba7 },
    { 0xfba8, 0xfba8 },
    { 0xfba9, 0xfba9 },
    { 0xfbaa, 0xfbaa },
    { 0xfbab, 0xfbab },
    { 0xfbac, 0xfbac },
    { 0xfbad, 0xfbad },
    { 0xfbae, 0xfbae },
    { 0xfbaf, 0xfbaf },
    { 0xfbb0, 0xfbb0 },
    { 0xfbb1, 0xfbb1 },
    { 0xfbb2, 0xfbb2 },
    { 0xfbb3, 0xfbb3 },
    { 0xfbb4, 0xfbb4 },
    { 0xfbb5, 0xfbb5 },
    { 0xfbb6, 0xfbb6 },
    { 0xfbb7, 0xfbb7 },
    { 0xfbb8, 0xfbb8 },
    { 0xfbb9, 0xfbb9 },
    { 0xfbba, 0xfbba },
    { 0xfbbb, 0xfbbb },
    { 0xfbbc, 0xfbbc },
    { 0xfbbd, 0xfbbd },
    { 0xfbbe, 0xfbbe },
    { 0xfbbf, 0xfbbf },
    { 0xfbc0, 0xfbc0 },
    { 0xfbc1, 0xfbc1 },
    { 0xfbc2, 0xfbc2 },
    { 0xfbc3, 0xfbc3 },
    { 0xfbc4, 0xfbc4 },
    { 0xfbc5, 0xfbc5 },
    { 0xfbc6, 0xfbc6 },
    { 0xfbc7, 0xfbc7 },
    { 0xfbc8, 0xfbc8 },
    { 0xfbc9, 0xfbc9 },
    { 0xfbca, 0xfbca },
    { 0xfbcb, 0xfbcb },
    { 0xfbcc, 0xfbcc },
    { 0xfbcd, 0xfbcd },
    { 0xfbce, 0xfbce },
    { 0xfbcf, 0xfbcf },
    { 0xfbd0, 0xfbd0 },
    { 0xfbd1, 0xfbd1 },
    { 0xfbd2, 0xfbd2 },
    { 0xfbd3, 0xfbd3 },
    { 0xfbd4, 0xfbd4 },
    { 0xfbd5, 0xfbd5 },
    { 0xfbd6, 0xfbd6 },
    { 0xfbd7, 0xfbd7 },
    { 0xfbd8, 0xfbd8 },
    { 0xfbd9, 0xfbd9 },
    { 0xfbda, 0xfbda },
    { 0xfbdb, 0xfbdb },
    { 0xfbdc, 0xfbdc },
    { 0xfbdd, 0xfbdd },
    { 0xfbde, 0xfbde },
    { 0xfbdf, 0xfbdf },
    { 0xfbe0, 0xfbe0 },
    { 0xfbe1, 0xfbe1 },
    { 0xfbe2, 0xfbe2 },
    { 0xfbe3, 0xfbe3 },
    { 0xfbe4, 0xfbe4 },
    { 0xfbe5, 0xfbe5 },
    { 0xfbe6, 0xfbe6 },
    { 0xfbe7, 0xfbe7 },
    { 0xfbe8, 0xfbe8 },
    { 0xfbe9, 0xfbe9 },
    { 0xfbea, 0xfbea },
    { 0xfbeb, 0xfbeb },
    { 0xfbec, 0xfbec },
    { 0xfbed, 0xfbed },
    { 0xfbee, 0xfbee },
    { 0xfbef, 0xfbef },
    { 0xfbf0, 0xfbf0 },
    { 0xfbf1, 0xfbf1 },
    { 0xfbf2, 0xfbf2 },
    { 0xfbf3, 0xfbf3 },
    { 0xfbf4, 0xfbf4 },
    { 0xfbf5, 0xfbf5 },
    { 0xfbf6, 0xfbf6 },
    { 0xfbf7, 0xfbf7 },
    { 0xfbf8, 0xfbf8 },
    { 0xfbf9, 0xfbf9 },
    { 0xfbfa, 0xfbfa },
    { 0xfbfb, 0xfbfb },
    { 0xfbfc, 0xfbfc },
    { 0xfbfd, 0xfbfd },
    { 0xfbfe, 0xfbfe },
    { 0xfbff, 0xfbff },
};

static gli_case_block_t unigen_case_block_0xff[256] = {
    { 0xff00, 0xff00 },
    { 0xff01, 0xff01 },
    { 0xff02, 0xff02 },
    { 0xff03, 0xff03 },
    { 0xff04, 0xff04 },
    { 0xff05, 0xff05 },
    { 0xff06, 0xff06 },
    { 0xff07, 0xff07 },
    { 0xff08, 0xff08 },
    { 0xff09, 0xff09 },
    { 0xff0a, 0xff0a },
    { 0xff0b, 0xff0b },
    { 0xff0c, 0xff0c },
    { 0xff0d, 0xff0d },
    { 0xff0e, 0xff0e },
    { 0xff0f, 0xff0f },
    { 0xff10, 0xff10 },
    { 0xff11, 0xff11 },
    { 0xff12, 0xff12 },
    { 0xff13, 0xff13 },
    { 0xff14, 0xff14 },
    { 0xff15, 0xff15 },
    { 0xff16, 0xff16 },
    { 0xff17, 0xff17 },
    { 0xff18, 0xff18 },
    { 0xff19, 0xff19 },
    { 0xff1a, 0xff1a },
    { 0xff1b, 0xff1b },
    { 0xff1c, 0xff1c },
    { 0xff1d, 0xff1d },
    { 0xff1e, 0xff1e },
    { 0xff1f, 0xff1f },
    { 0xff20, 0xff20 },
    { 0xff21, 0xff41 },  /* upper */
    { 0xff22, 0xff42 },  /* upper */
    { 0xff23, 0xff43 },  /* upper */
    { 0xff24, 0xff44 },  /* upper */
    { 0xff25, 0xff45 },  /* upper */
    { 0xff26, 0xff46 },  /* upper */
    { 0xff27, 0xff47 },  /* upper */
    { 0xff28, 0xff48 },  /* upper */
    { 0xff29, 0xff49 },  /* upper */
    { 0xff2a, 0xff4a },  /* upper */
    { 0xff2b, 0xff4b },  /* upper */
    { 0xff2c, 0xff4c },  /* upper */
    { 0xff2d, 0xff4d },  /* upper */
    { 0xff2e, 0xff4e },  /* upper */
    { 0xff2f, 0xff4f },  /* upper */
    { 0xff30, 0xff50 },  /* upper */
    { 0xff31, 0xff51 },  /* upper */
    { 0xff32, 0xff52 },  /* upper */
    { 0xff33, 0xff53 },  /* upper */
    { 0xff34, 0xff54 },  /* upper */
    { 0xff35, 0xff55 },  /* upper */
    { 0xff36, 0xff56 },  /* upper */
    { 0xff37, 0xff57 },  /* upper */
    { 0xff38, 0xff58 },  /* upper */
    { 0xff39, 0xff59 },  /* upper */
    { 0xff3a, 0xff5a },  /* upper */
    { 0xff3b, 0xff3b },
    { 0xff3c, 0xff3c },
    { 0xff3d, 0xff3d },
    { 0xff3e, 0xff3e },
    { 0xff3f, 0xff3f },
    { 0xff40, 0xff40 },
    { 0xff21, 0xff41 },  /* lower */
    { 0xff22, 0xff42 },  /* lower */
    { 0xff23, 0xff43 },  /* lower */
    { 0xff24, 0xff44 },  /* lower */
    { 0xff25, 0xff45 },  /* lower */
    { 0xff26, 0xff46 },  /* lower */
    { 0xff27, 0xff47 },  /* lower */
    { 0xff28, 0xff48 },  /* lower */
    { 0xff29, 0xff49 },  /* lower */
    { 0xff2a, 0xff4a },  /* lower */
    { 0xff2b, 0xff4b },  /* lower */
    { 0xff2c, 0xff4c },  /* lower */
    { 0xff2d, 0xff4d },  /* lower */
    { 0xff2e, 0xff4e },  /* lower */
    { 0xff2f, 0xff4f },  /* lower */
    { 0xff30, 0xff50 },  /* lower */
    { 0xff31, 0xff51 },  /* lower */
    { 0xff32, 0xff52 },  /* lower */
    { 0xff33, 0xff53 },  /* lower */
    { 0xff34, 0xff54 },  /* lower */
    { 0xff35, 0xff55 },  /* lower */
    { 0xff36, 0xff56 },  /* lower */
    { 0xff37, 0xff57 },  /* lower */
    { 0xff38, 0xff58 },  /* lower */
    { 0xff39, 0xff59 },  /* lower */
    { 0xff3a, 0xff5a },  /* lower */
    { 0xff5b, 0xff5b },
    { 0xff5c, 0xff5c },
    { 0xff5d, 0xff5d },
    { 0xff5e, 0xff5e },
    { 0xff5f, 0xff5f },
    { 0xff60, 0xff60 },
    { 0xff61, 0xff61 },
    { 0xff62, 0xff62 },
    { 0xff63, 0xff63 },
    { 0xff64, 0xff64 },
    { 0xff65, 0xff65 },
    { 0xff66, 0xff66 },
    { 0xff67, 0xff67 },
    { 0xff68, 0xff68 },
    { 0xff69, 0xff69 },
    { 0xff6a, 0xff6a },
    { 0xff6b, 0xff6b },
    { 0xff6c, 0xff6c },
    { 0xff6d, 0xff6d },
    { 0xff6e, 0xff6e },
    { 0xff6f, 0xff6f },
    { 0xff70, 0xff70 },
    { 0xff71, 0xff71 },
    { 0xff72, 0xff72 },
    { 0xff73, 0xff73 },
    { 0xff74, 0xff74 },
    { 0xff75, 0xff75 },
    { 0xff76, 0xff76 },
    { 0xff77, 0xff77 },
    { 0xff78, 0xff78 },
    { 0xff79, 0xff79 },
    { 0xff7a, 0xff7a },
    { 0xff7b, 0xff7b },
    { 0xff7c, 0xff7c },
    { 0xff7d, 0xff7d },
    { 0xff7e, 0xff7e },
    { 0xff7f, 0xff7f },
    { 0xff80, 0xff80 },
    { 0xff81, 0xff81 },
    { 0xff82, 0xff82 },
    { 0xff83, 0xff83 },
    { 0xff84, 0xff84 },
    { 0xff85, 0xff85 },
    { 0xff86, 0xff86 },
    { 0xff87, 0xff87 },
    { 0xff88, 0xff88 },
    { 0xff89, 0xff89 },
    { 0xff8a, 0xff8a },
    { 0xff8b, 0xff8b },
    { 0xff8c, 0xff8c },
    { 0xff8d, 0xff8d },
    { 0xff8e, 0xff8e },
    { 0xff8f, 0xff8f },
    { 0xff90, 0xff90 },
    { 0xff91, 0xff91 },
    { 0xff92, 0xff92 },
    { 0xff93, 0xff93 },
    { 0xff94, 0xff94 },
    { 0xff95, 0xff95 },
    { 0xff96, 0xff96 },
    { 0xff97, 0xff97 },
    { 0xff98, 0xff98 },
    { 0xff99, 0xff99 },
    { 0xff9a, 0xff9a },
    { 0xff9b, 0xff9b },
    { 0xff9c, 0xff9c },
    { 0xff9d, 0xff9d },
    { 0xff9e, 0xff9e },
    { 0xff9f, 0xff9f },
    { 0xffa0, 0xffa0 },
    { 0xffa1, 0xffa1 },
    { 0xffa2, 0xffa2 },
    { 0xffa3, 0xffa3 },
    { 0xffa4, 0xffa4 },
    { 0xffa5, 0xffa5 },
    { 0xffa6, 0xffa6 },
    { 0xffa7, 0xffa7 },
    { 0xffa8, 0xffa8 },
    { 0xffa9, 0xffa9 },
    { 0xffaa, 0xffaa },
    { 0xffab, 0xffab },
    { 0xffac, 0xffac },
    { 0xffad, 0xffad },
    { 0xffae, 0xffae },
    { 0xffaf, 0xffaf },
    { 0xffb0, 0xffb0 },
    { 0xffb1, 0xffb1 },
    { 0xffb2, 0xffb2 },
    { 0xffb3, 0xffb3 },
    { 0xffb4, 0xffb4 },
    { 0xffb5, 0xffb5 },
    { 0xffb6, 0xffb6 },
    { 0xffb7, 0xffb7 },
    { 0xffb8, 0xffb8 },
    { 0xffb9, 0xffb9 },
    { 0xffba, 0xffba },
    { 0xffbb, 0xffbb },
    { 0xffbc, 0xffbc },
    { 0xffbd, 0xffbd },
    { 0xffbe, 0xffbe },
    { 0xffbf, 0xffbf },
    { 0xffc0, 0xffc0 },
    { 0xffc1, 0xffc1 },
    { 0xffc2, 0xffc2 },
    { 0xffc3, 0xffc3 },
    { 0xffc4, 0xffc4 },
    { 0xffc5, 0xffc5 },
    { 0xffc6, 0xffc6 },
    { 0xffc7, 0xffc7 },
    { 0xffc8, 0xffc8 },
    { 0xffc9, 0xffc9 },
    { 0xffca, 0xffca },
    { 0xffcb, 0xffcb },
    { 0xffcc, 0xffcc },
    { 0xffcd, 0xffcd },
    { 0xffce, 0xffce },
    { 0xffcf, 0xffcf },
    { 0xffd0, 0xffd0 },
    { 0xffd1, 0xffd1 },
    { 0xffd2, 0xffd2 },
    { 0xffd3, 0xffd3 },
    { 0xffd4, 0xffd4 },
    { 0xffd5, 0xffd5 },
    { 0xffd6, 0xffd6 },
    { 0xffd7, 0xffd7 },
    { 0xffd8, 0xffd8 },
    { 0xffd9, 0xffd9 },
    { 0xffda, 0xffda },
    { 0xffdb, 0xffdb },
    { 0xffdc, 0xffdc },
    { 0xffdd, 0xffdd },
    { 0xffde, 0xffde },
    { 0xffdf, 0xffdf },
    { 0xffe0, 0xffe0 },
    { 0xffe1, 0xffe1 },
    { 0xffe2, 0xffe2 },
    { 0xffe3, 0xffe3 },
    { 0xffe4, 0xffe4 },
    { 0xffe5, 0xffe5 },
    { 0xffe6, 0xffe6 },
    { 0xffe7, 0xffe7 },
    { 0xffe8, 0xffe8 },
    { 0xffe9, 0xffe9 },
    { 0xffea, 0xffea },
    { 0xffeb, 0xffeb },
    { 0xffec, 0xffec },
    { 0xffed, 0xffed },
    { 0xffee, 0xffee },
    { 0xffef, 0xffef },
    { 0xfff0, 0xfff0 },
    { 0xfff1, 0xfff1 },
    { 0xfff2, 0xfff2 },
    { 0xfff3, 0xfff3 },
    { 0xfff4, 0xfff4 },
    { 0xfff5, 0xfff5 },
    { 0xfff6, 0xfff6 },
    { 0xfff7, 0xfff7 },
    { 0xfff8, 0xfff8 },
    { 0xfff9, 0xfff9 },
    { 0xfffa, 0xfffa },
    { 0xfffb, 0xfffb },
    { 0xfffc, 0xfffc },
    { 0xfffd, 0xfffd },
    { 0xfffe, 0xfffe },
    { 0xffff, 0xffff },
};

static gli_case_block_t unigen_case_block_0x104[256] = {
    { 0x10400, 0x10428 },  /* upper */
    { 0x10401, 0x10429 },  /* upper */
    { 0x10402, 0x1042a },  /* upper */
    { 0x10403, 0x1042b },  /* upper */
    { 0x10404, 0x1042c },  /* upper */
    { 0x10405, 0x1042d },  /* upper */
    { 0x10406, 0x1042e },  /* upper */
    { 0x10407, 0x1042f },  /* upper */
    { 0x10408, 0x10430 },  /* upper */
    { 0x10409, 0x10431 },  /* upper */
    { 0x1040a, 0x10432 },  /* upper */
    { 0x1040b, 0x10433 },  /* upper */
    { 0x1040c, 0x10434 },  /* upper */
    { 0x1040d, 0x10435 },  /* upper */
    { 0x1040e, 0x10436 },  /* upper */
    { 0x1040f, 0x10437 },  /* upper */
    { 0x10410, 0x10438 },  /* upper */
    { 0x10411, 0x10439 },  /* upper */
    { 0x10412, 0x1043a },  /* upper */
    { 0x10413, 0x1043b },  /* upper */
    { 0x10414, 0x1043c },  /* upper */
    { 0x10415, 0x1043d },  /* upper */
    { 0x10416, 0x1043e },  /* upper */
    { 0x10417, 0x1043f },  /* upper */
    { 0x10418, 0x10440 },  /* upper */
    { 0x10419, 0x10441 },  /* upper */
    { 0x1041a, 0x10442 },  /* upper */
    { 0x1041b, 0x10443 },  /* upper */
    { 0x1041c, 0x10444 },  /* upper */
    { 0x1041d, 0x10445 },  /* upper */
    { 0x1041e, 0x10446 },  /* upper */
    { 0x1041f, 0x10447 },  /* upper */
    { 0x10420, 0x10448 },  /* upper */
    { 0x10421, 0x10449 },  /* upper */
    { 0x10422, 0x1044a },  /* upper */
    { 0x10423, 0x1044b },  /* upper */
    { 0x10424, 0x1044c },  /* upper */
    { 0x10425, 0x1044d },  /* upper */
    { 0x10426, 0x1044e },  /* upper */
    { 0x10427, 0x1044f },  /* upper */
    { 0x10400, 0x10428 },  /* lower */
    { 0x10401, 0x10429 },  /* lower */
    { 0x10402, 0x1042a },  /* lower */
    { 0x10403, 0x1042b },  /* lower */
    { 0x10404, 0x1042c },  /* lower */
    { 0x10405, 0x1042d },  /* lower */
    { 0x10406, 0x1042e },  /* lower */
    { 0x10407, 0x1042f },  /* lower */
    { 0x10408, 0x10430 },  /* lower */
    { 0x10409, 0x10431 },  /* lower */
    { 0x1040a, 0x10432 },  /* lower */
    { 0x1040b, 0x10433 },  /* lower */
    { 0x1040c, 0x10434 },  /* lower */
    { 0x1040d, 0x10435 },  /* lower */
    { 0x1040e, 0x10436 },  /* lower */
    { 0x1040f, 0x10437 },  /* lower */
    { 0x10410, 0x10438 },  /* lower */
    { 0x10411, 0x10439 },  /* lower */
    { 0x10412, 0x1043a },  /* lower */
    { 0x10413, 0x1043b },  /* lower */
    { 0x10414, 0x1043c },  /* lower */
    { 0x10415, 0x1043d },  /* lower */
    { 0x10416, 0x1043e },  /* lower */
    { 0x10417, 0x1043f },  /* lower */
    { 0x10418, 0x10440 },  /* lower */
    { 0x10419, 0x10441 },  /* lower */
    { 0x1041a, 0x10442 },  /* lower */
    { 0x1041b, 0x10443 },  /* lower */
    { 0x1041c, 0x10444 },  /* lower */
    { 0x1041d, 0x10445 },  /* lower */
    { 0x1041e, 0x10446 },  /* lower */
    { 0x1041f, 0x10447 },  /* lower */
    { 0x10420, 0x10448 },  /* lower */
    { 0x10421, 0x10449 },  /* lower */
    { 0x10422, 0x1044a },  /* lower */
    { 0x10423, 0x1044b },  /* lower */
    { 0x10424, 0x1044c },  /* lower */
    { 0x10425, 0x1044d },  /* lower */
    { 0x10426, 0x1044e },  /* lower */
    { 0x10427, 0x1044f },  /* lower */
    { 0x10450, 0x10450 },
    { 0x10451, 0x10451 },
    { 0x10452, 0x10452 },
    { 0x10453, 0x10453 },
    { 0x10454, 0x10454 },
    { 0x10455, 0x10455 },
    { 0x10456, 0x10456 },
    { 0x10457, 0x10457 },
    { 0x10458, 0x10458 },
    { 0x10459, 0x10459 },
    { 0x1045a, 0x1045a },
    { 0x1045b, 0x1045b },
    { 0x1045c, 0x1045c },
    { 0x1045d, 0x1045d },
    { 0x1045e, 0x1045e },
    { 0x1045f, 0x1045f },
    { 0x10460, 0x10460 },
    { 0x10461, 0x10461 },
    { 0x10462, 0x10462 },
    { 0x10463, 0x10463 },
    { 0x10464, 0x10464 },
    { 0x10465, 0x10465 },
    { 0x10466, 0x10466 },
    { 0x10467, 0x10467 },
    { 0x10468, 0x10468 },
    { 0x10469, 0x10469 },
    { 0x1046a, 0x1046a },
    { 0x1046b, 0x1046b },
    { 0x1046c, 0x1046c },
    { 0x1046d, 0x1046d },
    { 0x1046e, 0x1046e },
    { 0x1046f, 0x1046f },
    { 0x10470, 0x10470 },
    { 0x10471, 0x10471 },
    { 0x10472, 0x10472 },
    { 0x10473, 0x10473 },
    { 0x10474, 0x10474 },
    { 0x10475, 0x10475 },
    { 0x10476, 0x10476 },
    { 0x10477, 0x10477 },
    { 0x10478, 0x10478 },
    { 0x10479, 0x10479 },
    { 0x1047a, 0x1047a },
    { 0x1047b, 0x1047b },
    { 0x1047c, 0x1047c },
    { 0x1047d, 0x1047d },
    { 0x1047e, 0x1047e },
    { 0x1047f, 0x1047f },
    { 0x10480, 0x10480 },
    { 0x10481, 0x10481 },
    { 0x10482, 0x10482 },
    { 0x10483, 0x10483 },
    { 0x10484, 0x10484 },
    { 0x10485, 0x10485 },
    { 0x10486, 0x10486 },
    { 0x10487, 0x10487 },
    { 0x10488, 0x10488 },
    { 0x10489, 0x10489 },
    { 0x1048a, 0x1048a },
    { 0x1048b, 0x1048b },
    { 0x1048c, 0x1048c },
    { 0x1048d, 0x1048d },
    { 0x1048e, 0x1048e },
    { 0x1048f, 0x1048f },
    { 0x10490, 0x10490 },
    { 0x10491, 0x10491 },
    { 0x10492, 0x10492 },
    { 0x10493, 0x10493 },
    { 0x10494, 0x10494 },
    { 0x10495, 0x10495 },
    { 0x10496, 0x10496 },
    { 0x10497, 0x10497 },
    { 0x10498, 0x10498 },
    { 0x10499, 0x10499 },
    { 0x1049a, 0x1049a },
    { 0x1049b, 0x1049b },
    { 0x1049c, 0x1049c },
    { 0x1049d, 0x1049d },
    { 0x1049e, 0x1049e },
    { 0x1049f, 0x1049f },
    { 0x104a0, 0x104a0 },
    { 0x104a1, 0x104a1 },
    { 0x104a2, 0x104a2 },
    { 0x104a3, 0x104a3 },
    { 0x104a4, 0x104a4 },
    { 0x104a5, 0x104a5 },
    { 0x104a6, 0x104a6 },
    { 0x104a7, 0x104a7 },
    { 0x104a8, 0x104a8 },
    { 0x104a9, 0x104a9 },
    { 0x104aa, 0x104aa },
    { 0x104ab, 0x104ab },
    { 0x104ac, 0x104ac },
    { 0x104ad, 0x104ad },
    { 0x104ae, 0x104ae },
    { 0x104af, 0x104af },
    { 0x104b0, 0x104b0 },
    { 0x104b1, 0x104b1 },
    { 0x104b2, 0x104b2 },
    { 0x104b3, 0x104b3 },
    { 0x104b4, 0x104b4 },
    { 0x104b5, 0x104b5 },
    { 0x104b6, 0x104b6 },
    { 0x104b7, 0x104b7 },
    { 0x104b8, 0x104b8 },
    { 0x104b9, 0x104b9 },
    { 0x104ba, 0x104ba },
    { 0x104bb, 0x104bb },
    { 0x104bc, 0x104bc },
    { 0x104bd, 0x104bd },
    { 0x104be, 0x104be },
    { 0x104bf, 0x104bf },
    { 0x104c0, 0x104c0 },
    { 0x104c1, 0x104c1 },
    { 0x104c2, 0x104c2 },
    { 0x104c3, 0x104c3 },
    { 0x104c4, 0x104c4 },
    { 0x104c5, 0x104c5 },
    { 0x104c6, 0x104c6 },
    { 0x104c7, 0x104c7 },
    { 0x104c8, 0x104c8 },
    { 0x104c9, 0x104c9 },
    { 0x104ca, 0x104ca },
    { 0x104cb, 0x104cb },
    { 0x104cc, 0x104cc },
    { 0x104cd, 0x104cd },
    { 0x104ce, 0x104ce },
    { 0x104cf, 0x104cf },
    { 0x104d0, 0x104d0 },
    { 0x104d1, 0x104d1 },
    { 0x104d2, 0x104d2 },
    { 0x104d3, 0x104d3 },
    { 0x104d4, 0x104d4 },
    { 0x104d5, 0x104d5 },
    { 0x104d6, 0x104d6 },
    { 0x104d7, 0x104d7 },
    { 0x104d8, 0x104d8 },
    { 0x104d9, 0x104d9 },
    { 0x104da, 0x104da },
    { 0x104db, 0x104db },
    { 0x104dc, 0x104dc },
    { 0x104dd, 0x104dd },
    { 0x104de, 0x104de },
    { 0x104df, 0x104df },
    { 0x104e0, 0x104e0 },
    { 0x104e1, 0x104e1 },
    { 0x104e2, 0x104e2 },
    { 0x104e3, 0x104e3 },
    { 0x104e4, 0x104e4 },
    { 0x104e5, 0x104e5 },
    { 0x104e6, 0x104e6 },
    { 0x104e7, 0x104e7 },
    { 0x104e8, 0x104e8 },
    { 0x104e9, 0x104e9 },
    { 0x104ea, 0x104ea },
    { 0x104eb, 0x104eb },
    { 0x104ec, 0x104ec },
    { 0x104ed, 0x104ed },
    { 0x104ee, 0x104ee },
    { 0x104ef, 0x104ef },
    { 0x104f0, 0x104f0 },
    { 0x104f1, 0x104f1 },
    { 0x104f2, 0x104f2 },
    { 0x104f3, 0x104f3 },
    { 0x104f4, 0x104f4 },
    { 0x104f5, 0x104f5 },
    { 0x104f6, 0x104f6 },
    { 0x104f7, 0x104f7 },
    { 0x104f8, 0x104f8 },
    { 0x104f9, 0x104f9 },
    { 0x104fa, 0x104fa },
    { 0x104fb, 0x104fb },
    { 0x104fc, 0x104fc },
    { 0x104fd, 0x104fd },
    { 0x104fe, 0x104fe },
    { 0x104ff, 0x104ff },
};

#define GET_CASE_BLOCK(ch, blockptr)  \
switch ((glui32)(ch) >> 8) {  \
    case 0x0:  \
        *blockptr = unigen_case_block_0x0;  \
        break;  \
    case 0x1:  \
        *blockptr = unigen_case_block_0x1;  \
        break;  \
    case 0x2:  \
        *blockptr = unigen_case_block_0x2;  \
        break;  \
    case 0x3:  \
        *blockptr = unigen_case_block_0x3;  \
        break;  \
    case 0x4:  \
        *blockptr = unigen_case_block_0x4;  \
        break;  \
    case 0x5:  \
        *blockptr = unigen_case_block_0x5;  \
        break;  \
    case 0x1e:  \
        *blockptr = unigen_case_block_0x1e;  \
        break;  \
    case 0x1f:  \
        *blockptr = unigen_case_block_0x1f;  \
        break;  \
    case 0x21:  \
        *blockptr = unigen_case_block_0x21;  \
        break;  \
    case 0x24:  \
        *blockptr = unigen_case_block_0x24;  \
        break;  \
    case 0xfb:  \
        *blockptr = unigen_case_block_0xfb;  \
        break;  \
    case 0xff:  \
        *blockptr = unigen_case_block_0xff;  \
        break;  \
    case 0x104:  \
        *blockptr = unigen_case_block_0x104;  \
        break;  \
    default:  \
        *blockptr = NULL;  \
}
static glui32 unigen_special_array[] = {
    2, 0x53, 0x53,  /* 0xdf upcase */
    1, 0xdf,  /* 0xdf downcase */
    2, 0x53, 0x73,  /* 0xdf titlecase */
    1, 0x130,  /* 0x130 upcase */
    2, 0x69, 0x307,  /* 0x130 downcase */
    1, 0x130,  /* 0x130 titlecase */
    2, 0x2bc, 0x4e,  /* 0x149 upcase */
    1, 0x149,  /* 0x149 downcase */
    2, 0x2bc, 0x4e,  /* 0x149 titlecase */
    1, 0x1c4,  /* 0x1c4 upcase */
    1, 0x1c6,  /* 0x1c4 downcase */
    1, 0x1c5,  /* 0x1c4 titlecase */
    1, 0x1c4,  /* 0x1c5 upcase */
    1, 0x1c6,  /* 0x1c5 downcase */
    1, 0x1c5,  /* 0x1c5 titlecase */
    1, 0x1c4,  /* 0x1c6 upcase */
    1, 0x1c6,  /* 0x1c6 downcase */
    1, 0x1c5,  /* 0x1c6 titlecase */
    1, 0x1c7,  /* 0x1c7 upcase */
    1, 0x1c9,  /* 0x1c7 downcase */
    1, 0x1c8,  /* 0x1c7 titlecase */
    1, 0x1c7,  /* 0x1c8 upcase */
    1, 0x1c9,  /* 0x1c8 downcase */
    1, 0x1c8,  /* 0x1c8 titlecase */
    1, 0x1c7,  /* 0x1c9 upcase */
    1, 0x1c9,  /* 0x1c9 downcase */
    1, 0x1c8,  /* 0x1c9 titlecase */
    1, 0x1ca,  /* 0x1ca upcase */
    1, 0x1cc,  /* 0x1ca downcase */
    1, 0x1cb,  /* 0x1ca titlecase */
    1, 0x1ca,  /* 0x1cb upcase */
    1, 0x1cc,  /* 0x1cb downcase */
    1, 0x1cb,  /* 0x1cb titlecase */
    1, 0x1ca,  /* 0x1cc upcase */
    1, 0x1cc,  /* 0x1cc downcase */
    1, 0x1cb,  /* 0x1cc titlecase */
    2, 0x4a, 0x30c,  /* 0x1f0 upcase */
    1, 0x1f0,  /* 0x1f0 downcase */
    2, 0x4a, 0x30c,  /* 0x1f0 titlecase */
    1, 0x1f1,  /* 0x1f1 upcase */
    1, 0x1f3,  /* 0x1f1 downcase */
    1, 0x1f2,  /* 0x1f1 titlecase */
    1, 0x1f1,  /* 0x1f2 upcase */
    1, 0x1f3,  /* 0x1f2 downcase */
    1, 0x1f2,  /* 0x1f2 titlecase */
    1, 0x1f1,  /* 0x1f3 upcase */
    1, 0x1f3,  /* 0x1f3 downcase */
    1, 0x1f2,  /* 0x1f3 titlecase */
    3, 0x399, 0x308, 0x301,  /* 0x390 upcase */
    1, 0x390,  /* 0x390 downcase */
    3, 0x399, 0x308, 0x301,  /* 0x390 titlecase */
    3, 0x3a5, 0x308, 0x301,  /* 0x3b0 upcase */
    1, 0x3b0,  /* 0x3b0 downcase */
    3, 0x3a5, 0x308, 0x301,  /* 0x3b0 titlecase */
    2, 0x535, 0x552,  /* 0x587 upcase */
    1, 0x587,  /* 0x587 downcase */
    2, 0x535, 0x582,  /* 0x587 titlecase */
    2, 0x48, 0x331,  /* 0x1e96 upcase */
    1, 0x1e96,  /* 0x1e96 downcase */
    2, 0x48, 0x331,  /* 0x1e96 titlecase */
    2, 0x54, 0x308,  /* 0x1e97 upcase */
    1, 0x1e97,  /* 0x1e97 downcase */
    2, 0x54, 0x308,  /* 0x1e97 titlecase */
    2, 0x57, 0x30a,  /* 0x1e98 upcase */
    1, 0x1e98,  /* 0x1e98 downcase */
    2, 0x57, 0x30a,  /* 0x1e98 titlecase */
    2, 0x59, 0x30a,  /* 0x1e99 upcase */
    1, 0x1e99,  /* 0x1e99 downcase */
    2, 0x59, 0x30a,  /* 0x1e99 titlecase */
    2, 0x41, 0x2be,  /* 0x1e9a upcase */
    1, 0x1e9a,  /* 0x1e9a downcase */
    2, 0x41, 0x2be,  /* 0x1e9a titlecase */
    2, 0x3a5, 0x313,  /* 0x1f50 upcase */
    1, 0x1f50,  /* 0x1f50 downcase */
    2, 0x3a5, 0x313,  /* 0x1f50 titlecase */
    3, 0x3a5, 0x313, 0x300,  /* 0x1f52 upcase */
    1, 0x1f52,  /* 0x1f52 downcase */
    3, 0x3a5, 0x313, 0x300,  /* 0x1f52 titlecase */
    3, 0x3a5, 0x313, 0x301,  /* 0x1f54 upcase */
    1, 0x1f54,  /* 0x1f54 downcase */
    3, 0x3a5, 0x313, 0x301,  /* 0x1f54 titlecase */
    3, 0x3a5, 0x313, 0x342,  /* 0x1f56 upcase */
    1, 0x1f56,  /* 0x1f56 downcase */
    3, 0x3a5, 0x313, 0x342,  /* 0x1f56 titlecase */
    2, 0x1f08, 0x399,  /* 0x1f80 upcase */
    1, 0x1f80,  /* 0x1f80 downcase */
    1, 0x1f88,  /* 0x1f80 titlecase */
    2, 0x1f09, 0x399,  /* 0x1f81 upcase */
    1, 0x1f81,  /* 0x1f81 downcase */
    1, 0x1f89,  /* 0x1f81 titlecase */
    2, 0x1f0a, 0x399,  /* 0x1f82 upcase */
    1, 0x1f82,  /* 0x1f82 downcase */
    1, 0x1f8a,  /* 0x1f82 titlecase */
    2, 0x1f0b, 0x399,  /* 0x1f83 upcase */
    1, 0x1f83,  /* 0x1f83 downcase */
    1, 0x1f8b,  /* 0x1f83 titlecase */
    2, 0x1f0c, 0x399,  /* 0x1f84 upcase */
    1, 0x1f84,  /* 0x1f84 downcase */
    1, 0x1f8c,  /* 0x1f84 titlecase */
    2, 0x1f0d, 0x399,  /* 0x1f85 upcase */
    1, 0x1f85,  /* 0x1f85 downcase */
    1, 0x1f8d,  /* 0x1f85 titlecase */
    2, 0x1f0e, 0x399,  /* 0x1f86 upcase */
    1, 0x1f86,  /* 0x1f86 downcase */
    1, 0x1f8e,  /* 0x1f86 titlecase */
    2, 0x1f0f, 0x399,  /* 0x1f87 upcase */
    1, 0x1f87,  /* 0x1f87 downcase */
    1, 0x1f8f,  /* 0x1f87 titlecase */
    2, 0x1f08, 0x399,  /* 0x1f88 upcase */
    1, 0x1f80,  /* 0x1f88 downcase */
    1, 0x1f88,  /* 0x1f88 titlecase */
    2, 0x1f09, 0x399,  /* 0x1f89 upcase */
    1, 0x1f81,  /* 0x1f89 downcase */
    1, 0x1f89,  /* 0x1f89 titlecase */
    2, 0x1f0a, 0x399,  /* 0x1f8a upcase */
    1, 0x1f82,  /* 0x1f8a downcase */
    1, 0x1f8a,  /* 0x1f8a titlecase */
    2, 0x1f0b, 0x399,  /* 0x1f8b upcase */
    1, 0x1f83,  /* 0x1f8b downcase */
    1, 0x1f8b,  /* 0x1f8b titlecase */
    2, 0x1f0c, 0x399,  /* 0x1f8c upcase */
    1, 0x1f84,  /* 0x1f8c downcase */
    1, 0x1f8c,  /* 0x1f8c titlecase */
    2, 0x1f0d, 0x399,  /* 0x1f8d upcase */
    1, 0x1f85,  /* 0x1f8d downcase */
    1, 0x1f8d,  /* 0x1f8d titlecase */
    2, 0x1f0e, 0x399,  /* 0x1f8e upcase */
    1, 0x1f86,  /* 0x1f8e downcase */
    1, 0x1f8e,  /* 0x1f8e titlecase */
    2, 0x1f0f, 0x399,  /* 0x1f8f upcase */
    1, 0x1f87,  /* 0x1f8f downcase */
    1, 0x1f8f,  /* 0x1f8f titlecase */
    2, 0x1f28, 0x399,  /* 0x1f90 upcase */
    1, 0x1f90,  /* 0x1f90 downcase */
    1, 0x1f98,  /* 0x1f90 titlecase */
    2, 0x1f29, 0x399,  /* 0x1f91 upcase */
    1, 0x1f91,  /* 0x1f91 downcase */
    1, 0x1f99,  /* 0x1f91 titlecase */
    2, 0x1f2a, 0x399,  /* 0x1f92 upcase */
    1, 0x1f92,  /* 0x1f92 downcase */
    1, 0x1f9a,  /* 0x1f92 titlecase */
    2, 0x1f2b, 0x399,  /* 0x1f93 upcase */
    1, 0x1f93,  /* 0x1f93 downcase */
    1, 0x1f9b,  /* 0x1f93 titlecase */
    2, 0x1f2c, 0x399,  /* 0x1f94 upcase */
    1, 0x1f94,  /* 0x1f94 downcase */
    1, 0x1f9c,  /* 0x1f94 titlecase */
    2, 0x1f2d, 0x399,  /* 0x1f95 upcase */
    1, 0x1f95,  /* 0x1f95 downcase */
    1, 0x1f9d,  /* 0x1f95 titlecase */
    2, 0x1f2e, 0x399,  /* 0x1f96 upcase */
    1, 0x1f96,  /* 0x1f96 downcase */
    1, 0x1f9e,  /* 0x1f96 titlecase */
    2, 0x1f2f, 0x399,  /* 0x1f97 upcase */
    1, 0x1f97,  /* 0x1f97 downcase */
    1, 0x1f9f,  /* 0x1f97 titlecase */
    2, 0x1f28, 0x399,  /* 0x1f98 upcase */
    1, 0x1f90,  /* 0x1f98 downcase */
    1, 0x1f98,  /* 0x1f98 titlecase */
    2, 0x1f29, 0x399,  /* 0x1f99 upcase */
    1, 0x1f91,  /* 0x1f99 downcase */
    1, 0x1f99,  /* 0x1f99 titlecase */
    2, 0x1f2a, 0x399,  /* 0x1f9a upcase */
    1, 0x1f92,  /* 0x1f9a downcase */
    1, 0x1f9a,  /* 0x1f9a titlecase */
    2, 0x1f2b, 0x399,  /* 0x1f9b upcase */
    1, 0x1f93,  /* 0x1f9b downcase */
    1, 0x1f9b,  /* 0x1f9b titlecase */
    2, 0x1f2c, 0x399,  /* 0x1f9c upcase */
    1, 0x1f94,  /* 0x1f9c downcase */
    1, 0x1f9c,  /* 0x1f9c titlecase */
    2, 0x1f2d, 0x399,  /* 0x1f9d upcase */
    1, 0x1f95,  /* 0x1f9d downcase */
    1, 0x1f9d,  /* 0x1f9d titlecase */
    2, 0x1f2e, 0x399,  /* 0x1f9e upcase */
    1, 0x1f96,  /* 0x1f9e downcase */
    1, 0x1f9e,  /* 0x1f9e titlecase */
    2, 0x1f2f, 0x399,  /* 0x1f9f upcase */
    1, 0x1f97,  /* 0x1f9f downcase */
    1, 0x1f9f,  /* 0x1f9f titlecase */
    2, 0x1f68, 0x399,  /* 0x1fa0 upcase */
    1, 0x1fa0,  /* 0x1fa0 downcase */
    1, 0x1fa8,  /* 0x1fa0 titlecase */
    2, 0x1f69, 0x399,  /* 0x1fa1 upcase */
    1, 0x1fa1,  /* 0x1fa1 downcase */
    1, 0x1fa9,  /* 0x1fa1 titlecase */
    2, 0x1f6a, 0x399,  /* 0x1fa2 upcase */
    1, 0x1fa2,  /* 0x1fa2 downcase */
    1, 0x1faa,  /* 0x1fa2 titlecase */
    2, 0x1f6b, 0x399,  /* 0x1fa3 upcase */
    1, 0x1fa3,  /* 0x1fa3 downcase */
    1, 0x1fab,  /* 0x1fa3 titlecase */
    2, 0x1f6c, 0x399,  /* 0x1fa4 upcase */
    1, 0x1fa4,  /* 0x1fa4 downcase */
    1, 0x1fac,  /* 0x1fa4 titlecase */
    2, 0x1f6d, 0x399,  /* 0x1fa5 upcase */
    1, 0x1fa5,  /* 0x1fa5 downcase */
    1, 0x1fad,  /* 0x1fa5 titlecase */
    2, 0x1f6e, 0x399,  /* 0x1fa6 upcase */
    1, 0x1fa6,  /* 0x1fa6 downcase */
    1, 0x1fae,  /* 0x1fa6 titlecase */
    2, 0x1f6f, 0x399,  /* 0x1fa7 upcase */
    1, 0x1fa7,  /* 0x1fa7 downcase */
    1, 0x1faf,  /* 0x1fa7 titlecase */
    2, 0x1f68, 0x399,  /* 0x1fa8 upcase */
    1, 0x1fa0,  /* 0x1fa8 downcase */
    1, 0x1fa8,  /* 0x1fa8 titlecase */
    2, 0x1f69, 0x399,  /* 0x1fa9 upcase */
    1, 0x1fa1,  /* 0x1fa9 downcase */
    1, 0x1fa9,  /* 0x1fa9 titlecase */
    2, 0x1f6a, 0x399,  /* 0x1faa upcase */
    1, 0x1fa2,  /* 0x1faa downcase */
    1, 0x1faa,  /* 0x1faa titlecase */
    2, 0x1f6b, 0x399,  /* 0x1fab upcase */
    1, 0x1fa3,  /* 0x1fab downcase */
    1, 0x1fab,  /* 0x1fab titlecase */
    2, 0x1f6c, 0x399,  /* 0x1fac upcase */
    1, 0x1fa4,  /* 0x1fac downcase */
    1, 0x1fac,  /* 0x1fac titlecase */
    2, 0x1f6d, 0x399,  /* 0x1fad upcase */
    1, 0x1fa5,  /* 0x1fad downcase */
    1, 0x1fad,  /* 0x1fad titlecase */
    2, 0x1f6e, 0x399,  /* 0x1fae upcase */
    1, 0x1fa6,  /* 0x1fae downcase */
    1, 0x1fae,  /* 0x1fae titlecase */
    2, 0x1f6f, 0x399,  /* 0x1faf upcase */
    1, 0x1fa7,  /* 0x1faf downcase */
    1, 0x1faf,  /* 0x1faf titlecase */
    2, 0x1fba, 0x399,  /* 0x1fb2 upcase */
    1, 0x1fb2,  /* 0x1fb2 downcase */
    2, 0x1fba, 0x345,  /* 0x1fb2 titlecase */
    2, 0x391, 0x399,  /* 0x1fb3 upcase */
    1, 0x1fb3,  /* 0x1fb3 downcase */
    1, 0x1fbc,  /* 0x1fb3 titlecase */
    2, 0x386, 0x399,  /* 0x1fb4 upcase */
    1, 0x1fb4,  /* 0x1fb4 downcase */
    2, 0x386, 0x345,  /* 0x1fb4 titlecase */
    2, 0x391, 0x342,  /* 0x1fb6 upcase */
    1, 0x1fb6,  /* 0x1fb6 downcase */
    2, 0x391, 0x342,  /* 0x1fb6 titlecase */
    3, 0x391, 0x342, 0x399,  /* 0x1fb7 upcase */
    1, 0x1fb7,  /* 0x1fb7 downcase */
    3, 0x391, 0x342, 0x345,  /* 0x1fb7 titlecase */
    2, 0x391, 0x399,  /* 0x1fbc upcase */
    1, 0x1fb3,  /* 0x1fbc downcase */
    1, 0x1fbc,  /* 0x1fbc titlecase */
    2, 0x1fca, 0x399,  /* 0x1fc2 upcase */
    1, 0x1fc2,  /* 0x1fc2 downcase */
    2, 0x1fca, 0x345,  /* 0x1fc2 titlecase */
    2, 0x397, 0x399,  /* 0x1fc3 upcase */
    1, 0x1fc3,  /* 0x1fc3 downcase */
    1, 0x1fcc,  /* 0x1fc3 titlecase */
    2, 0x389, 0x399,  /* 0x1fc4 upcase */
    1, 0x1fc4,  /* 0x1fc4 downcase */
    2, 0x389, 0x345,  /* 0x1fc4 titlecase */
    2, 0x397, 0x342,  /* 0x1fc6 upcase */
    1, 0x1fc6,  /* 0x1fc6 downcase */
    2, 0x397, 0x342,  /* 0x1fc6 titlecase */
    3, 0x397, 0x342, 0x399,  /* 0x1fc7 upcase */
    1, 0x1fc7,  /* 0x1fc7 downcase */
    3, 0x397, 0x342, 0x345,  /* 0x1fc7 titlecase */
    2, 0x397, 0x399,  /* 0x1fcc upcase */
    1, 0x1fc3,  /* 0x1fcc downcase */
    1, 0x1fcc,  /* 0x1fcc titlecase */
    3, 0x399, 0x308, 0x300,  /* 0x1fd2 upcase */
    1, 0x1fd2,  /* 0x1fd2 downcase */
    3, 0x399, 0x308, 0x300,  /* 0x1fd2 titlecase */
    3, 0x399, 0x308, 0x301,  /* 0x1fd3 upcase */
    1, 0x1fd3,  /* 0x1fd3 downcase */
    3, 0x399, 0x308, 0x301,  /* 0x1fd3 titlecase */
    2, 0x399, 0x342,  /* 0x1fd6 upcase */
    1, 0x1fd6,  /* 0x1fd6 downcase */
    2, 0x399, 0x342,  /* 0x1fd6 titlecase */
    3, 0x399, 0x308, 0x342,  /* 0x1fd7 upcase */
    1, 0x1fd7,  /* 0x1fd7 downcase */
    3, 0x399, 0x308, 0x342,  /* 0x1fd7 titlecase */
    3, 0x3a5, 0x308, 0x300,  /* 0x1fe2 upcase */
    1, 0x1fe2,  /* 0x1fe2 downcase */
    3, 0x3a5, 0x308, 0x300,  /* 0x1fe2 titlecase */
    3, 0x3a5, 0x308, 0x301,  /* 0x1fe3 upcase */
    1, 0x1fe3,  /* 0x1fe3 downcase */
    3, 0x3a5, 0x308, 0x301,  /* 0x1fe3 titlecase */
    2, 0x3a1, 0x313,  /* 0x1fe4 upcase */
    1, 0x1fe4,  /* 0x1fe4 downcase */
    2, 0x3a1, 0x313,  /* 0x1fe4 titlecase */
    2, 0x3a5, 0x342,  /* 0x1fe6 upcase */
    1, 0x1fe6,  /* 0x1fe6 downcase */
    2, 0x3a5, 0x342,  /* 0x1fe6 titlecase */
    3, 0x3a5, 0x308, 0x342,  /* 0x1fe7 upcase */
    1, 0x1fe7,  /* 0x1fe7 downcase */
    3, 0x3a5, 0x308, 0x342,  /* 0x1fe7 titlecase */
    2, 0x1ffa, 0x399,  /* 0x1ff2 upcase */
    1, 0x1ff2,  /* 0x1ff2 downcase */
    2, 0x1ffa, 0x345,  /* 0x1ff2 titlecase */
    2, 0x3a9, 0x399,  /* 0x1ff3 upcase */
    1, 0x1ff3,  /* 0x1ff3 downcase */
    1, 0x1ffc,  /* 0x1ff3 titlecase */
    2, 0x38f, 0x399,  /* 0x1ff4 upcase */
    1, 0x1ff4,  /* 0x1ff4 downcase */
    2, 0x38f, 0x345,  /* 0x1ff4 titlecase */
    2, 0x3a9, 0x342,  /* 0x1ff6 upcase */
    1, 0x1ff6,  /* 0x1ff6 downcase */
    2, 0x3a9, 0x342,  /* 0x1ff6 titlecase */
    3, 0x3a9, 0x342, 0x399,  /* 0x1ff7 upcase */
    1, 0x1ff7,  /* 0x1ff7 downcase */
    3, 0x3a9, 0x342, 0x345,  /* 0x1ff7 titlecase */
    2, 0x3a9, 0x399,  /* 0x1ffc upcase */
    1, 0x1ff3,  /* 0x1ffc downcase */
    1, 0x1ffc,  /* 0x1ffc titlecase */
    2, 0x46, 0x46,  /* 0xfb00 upcase */
    1, 0xfb00,  /* 0xfb00 downcase */
    2, 0x46, 0x66,  /* 0xfb00 titlecase */
    2, 0x46, 0x49,  /* 0xfb01 upcase */
    1, 0xfb01,  /* 0xfb01 downcase */
    2, 0x46, 0x69,  /* 0xfb01 titlecase */
    2, 0x46, 0x4c,  /* 0xfb02 upcase */
    1, 0xfb02,  /* 0xfb02 downcase */
    2, 0x46, 0x6c,  /* 0xfb02 titlecase */
    3, 0x46, 0x46, 0x49,  /* 0xfb03 upcase */
    1, 0xfb03,  /* 0xfb03 downcase */
    3, 0x46, 0x66, 0x69,  /* 0xfb03 titlecase */
    3, 0x46, 0x46, 0x4c,  /* 0xfb04 upcase */
    1, 0xfb04,  /* 0xfb04 downcase */
    3, 0x46, 0x66, 0x6c,  /* 0xfb04 titlecase */
    2, 0x53, 0x54,  /* 0xfb05 upcase */
    1, 0xfb05,  /* 0xfb05 downcase */
    2, 0x53, 0x74,  /* 0xfb05 titlecase */
    2, 0x53, 0x54,  /* 0xfb06 upcase */
    1, 0xfb06,  /* 0xfb06 downcase */
    2, 0x53, 0x74,  /* 0xfb06 titlecase */
    2, 0x544, 0x546,  /* 0xfb13 upcase */
    1, 0xfb13,  /* 0xfb13 downcase */
    2, 0x544, 0x576,  /* 0xfb13 titlecase */
    2, 0x544, 0x535,  /* 0xfb14 upcase */
    1, 0xfb14,  /* 0xfb14 downcase */
    2, 0x544, 0x565,  /* 0xfb14 titlecase */
    2, 0x544, 0x53b,  /* 0xfb15 upcase */
    1, 0xfb15,  /* 0xfb15 downcase */
    2, 0x544, 0x56b,  /* 0xfb15 titlecase */
    2, 0x54e, 0x546,  /* 0xfb16 upcase */
    1, 0xfb16,  /* 0xfb16 downcase */
    2, 0x54e, 0x576,  /* 0xfb16 titlecase */
    2, 0x544, 0x53d,  /* 0xfb17 upcase */
    1, 0xfb17,  /* 0xfb17 downcase */
    2, 0x544, 0x56d,  /* 0xfb17 titlecase */
};

static gli_case_special_t unigen_special_0xdf = { 0, 3, 5 };
static gli_case_special_t unigen_special_0x130 = { 8, 10, 13 };
static gli_case_special_t unigen_special_0x149 = { 15, 18, 20 };
static gli_case_special_t unigen_special_0x1c4 = { 23, 25, 27 };
static gli_case_special_t unigen_special_0x1c5 = { 29, 31, 33 };
static gli_case_special_t unigen_special_0x1c6 = { 35, 37, 39 };
static gli_case_special_t unigen_special_0x1c7 = { 41, 43, 45 };
static gli_case_special_t unigen_special_0x1c8 = { 47, 49, 51 };
static gli_case_special_t unigen_special_0x1c9 = { 53, 55, 57 };
static gli_case_special_t unigen_special_0x1ca = { 59, 61, 63 };
static gli_case_special_t unigen_special_0x1cb = { 65, 67, 69 };
static gli_case_special_t unigen_special_0x1cc = { 71, 73, 75 };
static gli_case_special_t unigen_special_0x1f0 = { 77, 80, 82 };
static gli_case_special_t unigen_special_0x1f1 = { 85, 87, 89 };
static gli_case_special_t unigen_special_0x1f2 = { 91, 93, 95 };
static gli_case_special_t unigen_special_0x1f3 = { 97, 99, 101 };
static gli_case_special_t unigen_special_0x390 = { 103, 107, 109 };
static gli_case_special_t unigen_special_0x3b0 = { 113, 117, 119 };
static gli_case_special_t unigen_special_0x587 = { 123, 126, 128 };
static gli_case_special_t unigen_special_0x1e96 = { 131, 134, 136 };
static gli_case_special_t unigen_special_0x1e97 = { 139, 142, 144 };
static gli_case_special_t unigen_special_0x1e98 = { 147, 150, 152 };
static gli_case_special_t unigen_special_0x1e99 = { 155, 158, 160 };
static gli_case_special_t unigen_special_0x1e9a = { 163, 166, 168 };
static gli_case_special_t unigen_special_0x1f50 = { 171, 174, 176 };
static gli_case_special_t unigen_special_0x1f52 = { 179, 183, 185 };
static gli_case_special_t unigen_special_0x1f54 = { 189, 193, 195 };
static gli_case_special_t unigen_special_0x1f56 = { 199, 203, 205 };
static gli_case_special_t unigen_special_0x1f80 = { 209, 212, 214 };
static gli_case_special_t unigen_special_0x1f81 = { 216, 219, 221 };
static gli_case_special_t unigen_special_0x1f82 = { 223, 226, 228 };
static gli_case_special_t unigen_special_0x1f83 = { 230, 233, 235 };
static gli_case_special_t unigen_special_0x1f84 = { 237, 240, 242 };
static gli_case_special_t unigen_special_0x1f85 = { 244, 247, 249 };
static gli_case_special_t unigen_special_0x1f86 = { 251, 254, 256 };
static gli_case_special_t unigen_special_0x1f87 = { 258, 261, 263 };
static gli_case_special_t unigen_special_0x1f88 = { 265, 268, 270 };
static gli_case_special_t unigen_special_0x1f89 = { 272, 275, 277 };
static gli_case_special_t unigen_special_0x1f8a = { 279, 282, 284 };
static gli_case_special_t unigen_special_0x1f8b = { 286, 289, 291 };
static gli_case_special_t unigen_special_0x1f8c = { 293, 296, 298 };
static gli_case_special_t unigen_special_0x1f8d = { 300, 303, 305 };
static gli_case_special_t unigen_special_0x1f8e = { 307, 310, 312 };
static gli_case_special_t unigen_special_0x1f8f = { 314, 317, 319 };
static gli_case_special_t unigen_special_0x1f90 = { 321, 324, 326 };
static gli_case_special_t unigen_special_0x1f91 = { 328, 331, 333 };
static gli_case_special_t unigen_special_0x1f92 = { 335, 338, 340 };
static gli_case_special_t unigen_special_0x1f93 = { 342, 345, 347 };
static gli_case_special_t unigen_special_0x1f94 = { 349, 352, 354 };
static gli_case_special_t unigen_special_0x1f95 = { 356, 359, 361 };
static gli_case_special_t unigen_special_0x1f96 = { 363, 366, 368 };
static gli_case_special_t unigen_special_0x1f97 = { 370, 373, 375 };
static gli_case_special_t unigen_special_0x1f98 = { 377, 380, 382 };
static gli_case_special_t unigen_special_0x1f99 = { 384, 387, 389 };
static gli_case_special_t unigen_special_0x1f9a = { 391, 394, 396 };
static gli_case_special_t unigen_special_0x1f9b = { 398, 401, 403 };
static gli_case_special_t unigen_special_0x1f9c = { 405, 408, 410 };
static gli_case_special_t unigen_special_0x1f9d = { 412, 415, 417 };
static gli_case_special_t unigen_special_0x1f9e = { 419, 422, 424 };
static gli_case_special_t unigen_special_0x1f9f = { 426, 429, 431 };
static gli_case_special_t unigen_special_0x1fa0 = { 433, 436, 438 };
static gli_case_special_t unigen_special_0x1fa1 = { 440, 443, 445 };
static gli_case_special_t unigen_special_0x1fa2 = { 447, 450, 452 };
static gli_case_special_t unigen_special_0x1fa3 = { 454, 457, 459 };
static gli_case_special_t unigen_special_0x1fa4 = { 461, 464, 466 };
static gli_case_special_t unigen_special_0x1fa5 = { 468, 471, 473 };
static gli_case_special_t unigen_special_0x1fa6 = { 475, 478, 480 };
static gli_case_special_t unigen_special_0x1fa7 = { 482, 485, 487 };
static gli_case_special_t unigen_special_0x1fa8 = { 489, 492, 494 };
static gli_case_special_t unigen_special_0x1fa9 = { 496, 499, 501 };
static gli_case_special_t unigen_special_0x1faa = { 503, 506, 508 };
static gli_case_special_t unigen_special_0x1fab = { 510, 513, 515 };
static gli_case_special_t unigen_special_0x1fac = { 517, 520, 522 };
static gli_case_special_t unigen_special_0x1fad = { 524, 527, 529 };
static gli_case_special_t unigen_special_0x1fae = { 531, 534, 536 };
static gli_case_special_t unigen_special_0x1faf = { 538, 541, 543 };
static gli_case_special_t unigen_special_0x1fb2 = { 545, 548, 550 };
static gli_case_special_t unigen_special_0x1fb3 = { 553, 556, 558 };
static gli_case_special_t unigen_special_0x1fb4 = { 560, 563, 565 };
static gli_case_special_t unigen_special_0x1fb6 = { 568, 571, 573 };
static gli_case_special_t unigen_special_0x1fb7 = { 576, 580, 582 };
static gli_case_special_t unigen_special_0x1fbc = { 586, 589, 591 };
static gli_case_special_t unigen_special_0x1fc2 = { 593, 596, 598 };
static gli_case_special_t unigen_special_0x1fc3 = { 601, 604, 606 };
static gli_case_special_t unigen_special_0x1fc4 = { 608, 611, 613 };
static gli_case_special_t unigen_special_0x1fc6 = { 616, 619, 621 };
static gli_case_special_t unigen_special_0x1fc7 = { 624, 628, 630 };
static gli_case_special_t unigen_special_0x1fcc = { 634, 637, 639 };
static gli_case_special_t unigen_special_0x1fd2 = { 641, 645, 647 };
static gli_case_special_t unigen_special_0x1fd3 = { 651, 655, 657 };
static gli_case_special_t unigen_special_0x1fd6 = { 661, 664, 666 };
static gli_case_special_t unigen_special_0x1fd7 = { 669, 673, 675 };
static gli_case_special_t unigen_special_0x1fe2 = { 679, 683, 685 };
static gli_case_special_t unigen_special_0x1fe3 = { 689, 693, 695 };
static gli_case_special_t unigen_special_0x1fe4 = { 699, 702, 704 };
static gli_case_special_t unigen_special_0x1fe6 = { 707, 710, 712 };
static gli_case_special_t unigen_special_0x1fe7 = { 715, 719, 721 };
static gli_case_special_t unigen_special_0x1ff2 = { 725, 728, 730 };
static gli_case_special_t unigen_special_0x1ff3 = { 733, 736, 738 };
static gli_case_special_t unigen_special_0x1ff4 = { 740, 743, 745 };
static gli_case_special_t unigen_special_0x1ff6 = { 748, 751, 753 };
static gli_case_special_t unigen_special_0x1ff7 = { 756, 760, 762 };
static gli_case_special_t unigen_special_0x1ffc = { 766, 769, 771 };
static gli_case_special_t unigen_special_0xfb00 = { 773, 776, 778 };
static gli_case_special_t unigen_special_0xfb01 = { 781, 784, 786 };
static gli_case_special_t unigen_special_0xfb02 = { 789, 792, 794 };
static gli_case_special_t unigen_special_0xfb03 = { 797, 801, 803 };
static gli_case_special_t unigen_special_0xfb04 = { 807, 811, 813 };
static gli_case_special_t unigen_special_0xfb05 = { 817, 820, 822 };
static gli_case_special_t unigen_special_0xfb06 = { 825, 828, 830 };
static gli_case_special_t unigen_special_0xfb13 = { 833, 836, 838 };
static gli_case_special_t unigen_special_0xfb14 = { 841, 844, 846 };
static gli_case_special_t unigen_special_0xfb15 = { 849, 852, 854 };
static gli_case_special_t unigen_special_0xfb16 = { 857, 860, 862 };
static gli_case_special_t unigen_special_0xfb17 = { 865, 868, 870 };

#define GET_CASE_SPECIAL(ch, specptr)  \
switch (ch) {  \
    case 0xdf:  \
        *specptr = unigen_special_0xdf;  \
        break;  \
    case 0x130:  \
        *specptr = unigen_special_0x130;  \
        break;  \
    case 0x149:  \
        *specptr = unigen_special_0x149;  \
        break;  \
    case 0x1c4:  \
        *specptr = unigen_special_0x1c4;  \
        break;  \
    case 0x1c5:  \
        *specptr = unigen_special_0x1c5;  \
        break;  \
    case 0x1c6:  \
        *specptr = unigen_special_0x1c6;  \
        break;  \
    case 0x1c7:  \
        *specptr = unigen_special_0x1c7;  \
        break;  \
    case 0x1c8:  \
        *specptr = unigen_special_0x1c8;  \
        break;  \
    case 0x1c9:  \
        *specptr = unigen_special_0x1c9;  \
        break;  \
    case 0x1ca:  \
        *specptr = unigen_special_0x1ca;  \
        break;  \
    case 0x1cb:  \
        *specptr = unigen_special_0x1cb;  \
        break;  \
    case 0x1cc:  \
        *specptr = unigen_special_0x1cc;  \
        break;  \
    case 0x1f0:  \
        *specptr = unigen_special_0x1f0;  \
        break;  \
    case 0x1f1:  \
        *specptr = unigen_special_0x1f1;  \
        break;  \
    case 0x1f2:  \
        *specptr = unigen_special_0x1f2;  \
        break;  \
    case 0x1f3:  \
        *specptr = unigen_special_0x1f3;  \
        break;  \
    case 0x390:  \
        *specptr = unigen_special_0x390;  \
        break;  \
    case 0x3b0:  \
        *specptr = unigen_special_0x3b0;  \
        break;  \
    case 0x587:  \
        *specptr = unigen_special_0x587;  \
        break;  \
    case 0x1e96:  \
        *specptr = unigen_special_0x1e96;  \
        break;  \
    case 0x1e97:  \
        *specptr = unigen_special_0x1e97;  \
        break;  \
    case 0x1e98:  \
        *specptr = unigen_special_0x1e98;  \
        break;  \
    case 0x1e99:  \
        *specptr = unigen_special_0x1e99;  \
        break;  \
    case 0x1e9a:  \
        *specptr = unigen_special_0x1e9a;  \
        break;  \
    case 0x1f50:  \
        *specptr = unigen_special_0x1f50;  \
        break;  \
    case 0x1f52:  \
        *specptr = unigen_special_0x1f52;  \
        break;  \
    case 0x1f54:  \
        *specptr = unigen_special_0x1f54;  \
        break;  \
    case 0x1f56:  \
        *specptr = unigen_special_0x1f56;  \
        break;  \
    case 0x1f80:  \
        *specptr = unigen_special_0x1f80;  \
        break;  \
    case 0x1f81:  \
        *specptr = unigen_special_0x1f81;  \
        break;  \
    case 0x1f82:  \
        *specptr = unigen_special_0x1f82;  \
        break;  \
    case 0x1f83:  \
        *specptr = unigen_special_0x1f83;  \
        break;  \
    case 0x1f84:  \
        *specptr = unigen_special_0x1f84;  \
        break;  \
    case 0x1f85:  \
        *specptr = unigen_special_0x1f85;  \
        break;  \
    case 0x1f86:  \
        *specptr = unigen_special_0x1f86;  \
        break;  \
    case 0x1f87:  \
        *specptr = unigen_special_0x1f87;  \
        break;  \
    case 0x1f88:  \
        *specptr = unigen_special_0x1f88;  \
        break;  \
    case 0x1f89:  \
        *specptr = unigen_special_0x1f89;  \
        break;  \
    case 0x1f8a:  \
        *specptr = unigen_special_0x1f8a;  \
        break;  \
    case 0x1f8b:  \
        *specptr = unigen_special_0x1f8b;  \
        break;  \
    case 0x1f8c:  \
        *specptr = unigen_special_0x1f8c;  \
        break;  \
    case 0x1f8d:  \
        *specptr = unigen_special_0x1f8d;  \
        break;  \
    case 0x1f8e:  \
        *specptr = unigen_special_0x1f8e;  \
        break;  \
    case 0x1f8f:  \
        *specptr = unigen_special_0x1f8f;  \
        break;  \
    case 0x1f90:  \
        *specptr = unigen_special_0x1f90;  \
        break;  \
    case 0x1f91:  \
        *specptr = unigen_special_0x1f91;  \
        break;  \
    case 0x1f92:  \
        *specptr = unigen_special_0x1f92;  \
        break;  \
    case 0x1f93:  \
        *specptr = unigen_special_0x1f93;  \
        break;  \
    case 0x1f94:  \
        *specptr = unigen_special_0x1f94;  \
        break;  \
    case 0x1f95:  \
        *specptr = unigen_special_0x1f95;  \
        break;  \
    case 0x1f96:  \
        *specptr = unigen_special_0x1f96;  \
        break;  \
    case 0x1f97:  \
        *specptr = unigen_special_0x1f97;  \
        break;  \
    case 0x1f98:  \
        *specptr = unigen_special_0x1f98;  \
        break;  \
    case 0x1f99:  \
        *specptr = unigen_special_0x1f99;  \
        break;  \
    case 0x1f9a:  \
        *specptr = unigen_special_0x1f9a;  \
        break;  \
    case 0x1f9b:  \
        *specptr = unigen_special_0x1f9b;  \
        break;  \
    case 0x1f9c:  \
        *specptr = unigen_special_0x1f9c;  \
        break;  \
    case 0x1f9d:  \
        *specptr = unigen_special_0x1f9d;  \
        break;  \
    case 0x1f9e:  \
        *specptr = unigen_special_0x1f9e;  \
        break;  \
    case 0x1f9f:  \
        *specptr = unigen_special_0x1f9f;  \
        break;  \
    case 0x1fa0:  \
        *specptr = unigen_special_0x1fa0;  \
        break;  \
    case 0x1fa1:  \
        *specptr = unigen_special_0x1fa1;  \
        break;  \
    case 0x1fa2:  \
        *specptr = unigen_special_0x1fa2;  \
        break;  \
    case 0x1fa3:  \
        *specptr = unigen_special_0x1fa3;  \
        break;  \
    case 0x1fa4:  \
        *specptr = unigen_special_0x1fa4;  \
        break;  \
    case 0x1fa5:  \
        *specptr = unigen_special_0x1fa5;  \
        break;  \
    case 0x1fa6:  \
        *specptr = unigen_special_0x1fa6;  \
        break;  \
    case 0x1fa7:  \
        *specptr = unigen_special_0x1fa7;  \
        break;  \
    case 0x1fa8:  \
        *specptr = unigen_special_0x1fa8;  \
        break;  \
    case 0x1fa9:  \
        *specptr = unigen_special_0x1fa9;  \
        break;  \
    case 0x1faa:  \
        *specptr = unigen_special_0x1faa;  \
        break;  \
    case 0x1fab:  \
        *specptr = unigen_special_0x1fab;  \
        break;  \
    case 0x1fac:  \
        *specptr = unigen_special_0x1fac;  \
        break;  \
    case 0x1fad:  \
        *specptr = unigen_special_0x1fad;  \
        break;  \
    case 0x1fae:  \
        *specptr = unigen_special_0x1fae;  \
        break;  \
    case 0x1faf:  \
        *specptr = unigen_special_0x1faf;  \
        break;  \
    case 0x1fb2:  \
        *specptr = unigen_special_0x1fb2;  \
        break;  \
    case 0x1fb3:  \
        *specptr = unigen_special_0x1fb3;  \
        break;  \
    case 0x1fb4:  \
        *specptr = unigen_special_0x1fb4;  \
        break;  \
    case 0x1fb6:  \
        *specptr = unigen_special_0x1fb6;  \
        break;  \
    case 0x1fb7:  \
        *specptr = unigen_special_0x1fb7;  \
        break;  \
    case 0x1fbc:  \
        *specptr = unigen_special_0x1fbc;  \
        break;  \
    case 0x1fc2:  \
        *specptr = unigen_special_0x1fc2;  \
        break;  \
    case 0x1fc3:  \
        *specptr = unigen_special_0x1fc3;  \
        break;  \
    case 0x1fc4:  \
        *specptr = unigen_special_0x1fc4;  \
        break;  \
    case 0x1fc6:  \
        *specptr = unigen_special_0x1fc6;  \
        break;  \
    case 0x1fc7:  \
        *specptr = unigen_special_0x1fc7;  \
        break;  \
    case 0x1fcc:  \
        *specptr = unigen_special_0x1fcc;  \
        break;  \
    case 0x1fd2:  \
        *specptr = unigen_special_0x1fd2;  \
        break;  \
    case 0x1fd3:  \
        *specptr = unigen_special_0x1fd3;  \
        break;  \
    case 0x1fd6:  \
        *specptr = unigen_special_0x1fd6;  \
        break;  \
    case 0x1fd7:  \
        *specptr = unigen_special_0x1fd7;  \
        break;  \
    case 0x1fe2:  \
        *specptr = unigen_special_0x1fe2;  \
        break;  \
    case 0x1fe3:  \
        *specptr = unigen_special_0x1fe3;  \
        break;  \
    case 0x1fe4:  \
        *specptr = unigen_special_0x1fe4;  \
        break;  \
    case 0x1fe6:  \
        *specptr = unigen_special_0x1fe6;  \
        break;  \
    case 0x1fe7:  \
        *specptr = unigen_special_0x1fe7;  \
        break;  \
    case 0x1ff2:  \
        *specptr = unigen_special_0x1ff2;  \
        break;  \
    case 0x1ff3:  \
        *specptr = unigen_special_0x1ff3;  \
        break;  \
    case 0x1ff4:  \
        *specptr = unigen_special_0x1ff4;  \
        break;  \
    case 0x1ff6:  \
        *specptr = unigen_special_0x1ff6;  \
        break;  \
    case 0x1ff7:  \
        *specptr = unigen_special_0x1ff7;  \
        break;  \
    case 0x1ffc:  \
        *specptr = unigen_special_0x1ffc;  \
        break;  \
    case 0xfb00:  \
        *specptr = unigen_special_0xfb00;  \
        break;  \
    case 0xfb01:  \
        *specptr = unigen_special_0xfb01;  \
        break;  \
    case 0xfb02:  \
        *specptr = unigen_special_0xfb02;  \
        break;  \
    case 0xfb03:  \
        *specptr = unigen_special_0xfb03;  \
        break;  \
    case 0xfb04:  \
        *specptr = unigen_special_0xfb04;  \
        break;  \
    case 0xfb05:  \
        *specptr = unigen_special_0xfb05;  \
        break;  \
    case 0xfb06:  \
        *specptr = unigen_special_0xfb06;  \
        break;  \
    case 0xfb13:  \
        *specptr = unigen_special_0xfb13;  \
        break;  \
    case 0xfb14:  \
        *specptr = unigen_special_0xfb14;  \
        break;  \
    case 0xfb15:  \
        *specptr = unigen_special_0xfb15;  \
        break;  \
    case 0xfb16:  \
        *specptr = unigen_special_0xfb16;  \
        break;  \
    case 0xfb17:  \
        *specptr = unigen_special_0xfb17;  \
        break;  \
    default:  \
        *specptr = NULL;  \
}

