import time
# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__ = "nerdknight"
__date__ = "$18/11/2010 18:17:04$"

import sys
import random
from PyQt4 import QtCore
from PyQt4 import QtGui
from threading import Thread

class Celula:
    cellW = 10
    cellH = 10;
    def __init__(self, x=0, y=0, viva=True):
        self.viva = viva
        self.x = x
        self.y = y
        self.vecinos=[]
        self.proxEstado=self.viva
    def isViva(self):
        return self.viva
    def setViva(self, viva):
        self.viva = viva
    def setProxEstado(self,viva):
        self.proxEstado=viva
    def confirmarProxEstado(self):
        self.viva=self.proxEstado
    def inverseState(self):
        self.setViva(not self.isViva())
    def paint(self, painter, rx, ry):
        if self.isViva():
            painter.setBrush(QtCore.Qt.black)
        else:
            painter.setBrush(QtCore.Qt.white)
        px=rx + Celula.cellW * self.x
        py=ry + Celula.cellH * self.y
        painter.drawRect(px, py, Celula.cellW, Celula.cellH)
    def addVecino(self,celula):
        if len(self.vecinos)<8 and celula!=self:
            self.vecinos.append(celula)
    def getNumVecinosVivos(self):
        num=0;
        for i in range(len(self.vecinos)):
            if self.vecinos[i].isViva():
                num+=1;
        return num
    def getNumVecinosMuertos(self):
        num=0;
        for i in range(len(self.vecinos)):
            if not self.vecinos[i].isViva():
                num+=1;
        return num
    def getVecionos(self):
        return vecinos
        
class ReglaNace:
    def __init__(self,num):
        self.num=num
    def sobrevive(self,c):
        return False
    def nace(self,c):
        return self.num==c.getNumVecinosVivos()
class ReglaSobrevive:
    def __init__(self,num):
        self.num=num
    def sobrevive(self,c):
        return c.getNumVecinosVivos()==self.num
    def nace(self,c):
        return False
class ReglaCompuesta:
    def __init__(self):
        self.reglas=[]

    def sobrevive(self,c):
        r=False
        for i in range(len(self.reglas)):
            r=r or self.reglas[i].sobrevive(c)
        return r

    def nace(self,c):
        r=False
        for i in range(len(self.reglas)):
            r=r or self.reglas[i].nace(c)
        return r 
    
    def addRegla(self, r):
        self.reglas.append(r)

class EvaluadorReglas:
    def __init__(self):
        self.regla=ReglaCompuesta()
        self.regla.addRegla(ReglaSobrevive(2))
        self.regla.addRegla(ReglaSobrevive(3))
        self.regla.addRegla(ReglaNace(3))

    def evaluar(self,c):
        c.setProxEstado((not c.isViva() and self.regla.nace(c))or
        (c.isViva() and self.regla.sobrevive(c)))

class Posicion:
    def __init__(self,x=0,y=0):
        self.x=x
        self.y=y
    def getX(self):
        return self.x
    def setX(self,x):
        self.x=x
    def getY(self):
        return self.y
    def setY(self,y):
        self.y=y
    def __cmp__(self,obj):
        res=1
        if obj.__class__==Posicion and self.x==obj.x and self.y==obj.y:
            res=0
        return res

class Patron:
    def __init__(self,nombre=""):
        self.nombre=nombre
        self.posiciones=[]
    def getNombre(self):
        return self.nombre
    def setNombre(self,nombre):
        self.nombre=nombre
    def __str__(self):
        return self.getNombre()
    def addPosicion(self,valor):
        self.posiciones.append(valor)
    def getPosiciones(self):
        return self.posiciones
    
class Matriz(QtGui.QWidget):
    def __init__(self, parent=None, cantX=10, cantY=10,interval=0.25):
        QtGui.QWidget.__init__(self, parent)

        self.setGeometry(300, 300, 600, 300)
        self.setWindowTitle('Matriz')
        self.cantX = cantX
        self.cantY = cantY
        self.x = 2
        self.y = 2
        self.celulas = []
        self.timer=None
        self.interval=interval
        self.initCelulas()
        self.evaluador=EvaluadorReglas()
        self.patrones=[]
        self.initPatrones()
        self.patronActual=None
        self.lastCellDrew=None
    def initPatrones(self):
        p=Patron("Block")
        p.addPosicion(Posicion(0,0))
        p.addPosicion(Posicion(0,1))
        p.addPosicion(Posicion(1,0))
        p.addPosicion(Posicion(1,1))
        self.patrones.append(p)
        p=Patron("Boat")
        p.addPosicion(Posicion(0,0))
        p.addPosicion(Posicion(0,1))
        p.addPosicion(Posicion(1,0))
        p.addPosicion(Posicion(2,1))
        p.addPosicion(Posicion(1,2))
        self.patrones.append(p)

        p=Patron("Blinker")
        p.addPosicion(Posicion(0,0))
        p.addPosicion(Posicion(0,1))
        p.addPosicion(Posicion(0,2))
        self.patrones.append(p)

        p=Patron("Toad")
        p.addPosicion(Posicion(1,0))
        p.addPosicion(Posicion(2,0))
        p.addPosicion(Posicion(3,0))
        p.addPosicion(Posicion(0,1))
        p.addPosicion(Posicion(1,1))
        p.addPosicion(Posicion(2,1))
        self.patrones.append(p)

        p=Patron("Glider")
        p.addPosicion(Posicion(1,0))
        p.addPosicion(Posicion(0,1))
        p.addPosicion(Posicion(0,2))
        p.addPosicion(Posicion(2,2))
        p.addPosicion(Posicion(1,2))
        self.patrones.append(p)

        p=Patron("Lightweight Spaceship")
        p.addPosicion(Posicion(0,1))
        p.addPosicion(Posicion(0,2))
        p.addPosicion(Posicion(0,3))
        p.addPosicion(Posicion(1,0))
        p.addPosicion(Posicion(1,3))
        p.addPosicion(Posicion(2,3))
        p.addPosicion(Posicion(3,3))
        p.addPosicion(Posicion(4,0))
        p.addPosicion(Posicion(4,2))
        self.patrones.append(p)

        p=Patron("Die Hard")
        p.addPosicion(Posicion(0,1))
        p.addPosicion(Posicion(1,1))
        p.addPosicion(Posicion(1,2))
        p.addPosicion(Posicion(5,2))
        p.addPosicion(Posicion(6,2))
        p.addPosicion(Posicion(6,0))
        p.addPosicion(Posicion(7,2))
        self.patrones.append(p)

        p=Patron("Gosper Glider Gun")

        p.addPosicion(Posicion(0,5))
        p.addPosicion(Posicion(0,6))
        p.addPosicion(Posicion(1,5))
        p.addPosicion(Posicion(1,6))

        p.addPosicion(Posicion(10,5))
        p.addPosicion(Posicion(10,6))
        p.addPosicion(Posicion(10,7))
        p.addPosicion(Posicion(11,4))
        p.addPosicion(Posicion(11,8))
        p.addPosicion(Posicion(12,3))
        p.addPosicion(Posicion(12,9))
        p.addPosicion(Posicion(13,3))
        p.addPosicion(Posicion(13,9))
        p.addPosicion(Posicion(14,6))
        p.addPosicion(Posicion(15,4))
        p.addPosicion(Posicion(15,8))
        p.addPosicion(Posicion(16,5))
        p.addPosicion(Posicion(16,6))
        p.addPosicion(Posicion(16,7))
        p.addPosicion(Posicion(17,6))
        #
        p.addPosicion(Posicion(20,3))
        p.addPosicion(Posicion(20,4))
        p.addPosicion(Posicion(20,5))
        p.addPosicion(Posicion(21,3))
        p.addPosicion(Posicion(21,4))
        p.addPosicion(Posicion(21,5))
        p.addPosicion(Posicion(22,2))
        p.addPosicion(Posicion(22,6))
        p.addPosicion(Posicion(24,1))
        p.addPosicion(Posicion(24,2))
        p.addPosicion(Posicion(24,6))
        p.addPosicion(Posicion(24,7))
        #
        p.addPosicion(Posicion(34,3))
        p.addPosicion(Posicion(34,4))
        p.addPosicion(Posicion(35,3))
        p.addPosicion(Posicion(35,4))
        #
        self.patrones.append(p)
    def getPatrones(self):
        return self.patrones
    def getPatronActual(self):
        return self.patronActual
    def setPatronActual(self,patron):
        self.patronActual=patron
    def start(self):
        self.stop()
        self.timer=Thread(target=self.run)
        self.timer.start()
        self.emit(QtCore.SIGNAL("start"))
    def stop(self):
        if self.timer!=None:
            self.timer=None
        self.emit(QtCore.SIGNAL("stop"))
    def killAll(self):
        self.stop()
        for i in range(self.cantX):
            for j in range(self.cantY):
                self.celulas[i][j].setViva(False)
        self.update()
    def stepForward(self):
        self.evaluar()
        self.confirmarProximoEstado()
        self.update()
    def run(self):
        while self.timer!=None:
            self.stepForward()
            time.sleep(self.interval)
    def evaluar(self):
        for i in range(self.cantX):
            for j in range(self.cantY):
                self.evaluador.evaluar(self.celulas[i][j])
    def confirmarProximoEstado(self):
        for i in range(self.cantX):
            for j in range(self.cantY):
                self.celulas[i][j].confirmarProxEstado()
    def dibujarPatron(self, x,y,pat):
        for i in range(len(pat.getPosiciones())):
            pos = pat.getPosiciones()[i]
            x2=x+pos.getX();
            y2=y+pos.getY();
            if x2<self.cantX and y2<self.cantY:
                self.celulas[x2][y2].setViva(True)
    def setInterval(self,interval):
        self.interval=interval
    def getInterval(self):
        return self.interval
    def initCelulas(self):
        self.stop()
        self.celulas = []
        for i in range(self.cantX):
            self.celulas.append([])
            for j in range(self.cantY):
                self.celulas[i].append(Celula(i, j, random.randint(0,1)==1))
        for i in range(self.cantX):
           for j in range(self.cantY):
                for rx in [-1,0,1]:
                    for ry in [-1,0,1]:
                        px=rx+i
                        py=ry+j
                        if px<0:
                            px=self.cantX-1
                        if px==self.cantX:
                            px=0
                        if py<0:
                            py=self.cantY-1
                        if py==self.cantY:
                            py=0
                        if px>=0 and px<self.cantX and py>=0 and py<self.cantY:
                            self.celulas[i][j].addVecino(self.celulas[px][py])
        self.update()                    
    def paintCells(self, painter):
        for i in range(self.cantX):
            for j in range(self.cantY):
                self.celulas[i][j].paint(painter, self.x, self.y)
    def paintEvent(self, event):
        paint = QtGui.QPainter()
        paint.begin(self)
        self.paintCells(paint)
        pen = QtGui.QPen(QtCore.Qt.blue, 1, QtCore.Qt.SolidLine)
        paint.setPen(pen)
        for i in range(self.cantX + 1):
            paint.drawLine(self.x + Celula.cellW * i, self.y, self.x + Celula.cellW * i, self.y + Celula.cellH * self.cantY)
        for i in range(self.cantY + 1):
            paint.drawLine(self.x, self.x + Celula.cellH * i, self.x + Celula.cellW * self.cantX, self.x + Celula.cellH * i)

        paint.end()
    def fromMousePosToCellPos(self,cx,cy):
        p=None
        x = (cx-self.x) // Celula.cellW
        if x >= 0 and x < self.cantX:
            y = (cy-self.y) // Celula.cellH
            if y >= 0 and y < self.cantY:
                p=Posicion(x,y)
        return p
    def matrizClick(self,posicion):
        # @type posicion Posicion
        if posicion!=None:
            if self.patronActual==None:
                self.celulas[posicion.getX()][posicion.getY()].inverseState()    
            else:
                self.dibujarPatron(posicion.getX(), posicion.getY(), self.patronActual)
            self.update()
    def mousePressEvent(self, ev):
        self.lastCellDrew=self.fromMousePosToCellPos(ev.x(),ev.y())
        self.matrizClick(self.lastCellDrew)
        QtGui.QWidget.mousePressEvent(self,ev)
    def mouseMoveEvent(self, ev):
        pos=self.fromMousePosToCellPos(ev.x(),ev.y())
        if pos!=self.lastCellDrew:
            self.lastCellDrew=pos
            self.matrizClick(pos)
        QtGui.QWidget.mouseMoveEvent(self,ev)
    def closeEvent(self,ev):
        print "closing.."
        self.__del__()
if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    dt = Matriz()
    dt.show()
    app.exec_()


