#include "exercisewidget.h"

#include <QToolBar>
#include <QSpinBox>
#include <QHBoxLayout>

ExerciseWidget::ExerciseWidget(QWidget *parent) :
    QWidget(parent)
{
    exercise = new Exercise;

    m_vbLayout.setMargin(0);
    m_vbLayout.setSpacing(10);

    m_vbLayout.addWidget(exercise);

    QHBoxLayout *hbLayout = new QHBoxLayout;
    m_slider.setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Fixed);
    m_slider.setTickPosition(QSlider::NoTicks);
    m_slider.setValue(0);
    m_slider.setOrientation(Qt::Horizontal);
    m_slider.setDisabled(true);
    m_slider.setTracking(false);
    hbLayout->addWidget(&m_slider);

    m_lblProgress = new QLabel("0");
    connect(&m_slider,SIGNAL(valueChanged(int)),m_lblProgress,SLOT(setNum(int)));
    hbLayout->addWidget(m_lblProgress);

    m_vbLayout.addLayout(hbLayout);

    QToolBar *toolBar = new QToolBar;

    m_actionGotoStart = toolBar->addAction(tr("New"));
    m_actionGotoStart->setIcon(QIcon::fromTheme("document-new", QIcon(":/img/document-new.png")));
    connect(m_actionGotoStart,SIGNAL(triggered()),this,SLOT(emitGotoStart()));

    m_actionOpen = toolBar->addAction(tr("Open"));
    m_actionOpen->setIcon(QIcon::fromTheme("document-open", QIcon(":/img/open.png")));
    connect(m_actionOpen,SIGNAL(triggered()),this,SLOT(emitShowEditor()));

    m_actionSettings = toolBar->addAction(tr("Settings"));
    m_actionSettings->setIcon(QIcon::fromTheme("preferences-other", QIcon(":/img/prefs.png")));
    connect(m_actionSettings,SIGNAL(triggered()),this,SLOT(showSettings()));

    toolBar->addSeparator();

    m_actionSlower = toolBar->addAction(tr("Slower"));
    m_actionSlower->setIcon(QIcon::fromTheme("media-seek-backward", QIcon(":/img/rewind1m.png")));

    m_lblSpeed.setNum(0);
    toolBar->addWidget(&m_lblSpeed);

    m_actionFaster = toolBar->addAction(tr("Faster"));
    m_actionFaster->setIcon(QIcon::fromTheme("media-seek-forward", QIcon(":/img/forward1m.png")));

    m_actionZoomIn = toolBar->addAction(tr("Zoom In"));
    m_actionZoomIn->setIcon(QIcon::fromTheme("zoom-in", QIcon(":/img/zoom-in.png")));

    m_actionZoomOut = toolBar->addAction(tr("Zoom Out"));
    m_actionZoomOut->setIcon(QIcon::fromTheme("zoom-out", QIcon(":/img/zoom-out.png")));

    toolBar->addSeparator();

    m_actionStartPause = toolBar->addAction(tr("Start"));
    QIcon icon;
    QPixmap pxm = QIcon::fromTheme("media-playback-start", QIcon(":/img/play.png")).pixmap(toolBar->iconSize());
    icon.addPixmap(pxm,QIcon::Normal,QIcon::Off);
    pxm = QIcon::fromTheme("media-playback-pause", QIcon(":/img/pause.png")).pixmap(toolBar->iconSize());
    icon.addPixmap(pxm,QIcon::Normal,QIcon::On);
    m_actionStartPause->setCheckable(true);
    m_actionStartPause->setIcon(icon);
    connect(m_actionStartPause,SIGNAL(triggered()),this,SLOT(startPause()));

    m_actionStop = toolBar->addAction(tr("Stop"));
    m_actionStop->setIcon(QIcon::fromTheme("media-playback-stop", QIcon(":/img/stop.png")));
    connect(m_actionStop,SIGNAL(triggered()),this,SLOT(stop()));

    m_vbLayout.addWidget(toolBar);

    setLayout(&m_vbLayout);

    toolBar->setToolButtonStyle(Qt::ToolButtonIconOnly);
}

void ExerciseWidget::selectExercise(int mode){
    if (mode!=exercise->mode()){
        delete exercise;

        switch (mode) {
        case Exercise::Rapid: exercise = new ExerciseRapid; break;
        case Exercise::Classic: exercise = new ExerciseClassic; break;
        case Exercise::Shulte: exercise = new ExerciseShulte; break;
        default: exercise = new ExerciseRapid;
        }

        emit exerciseChanged(true);

        m_vbLayout.insertWidget(0,exercise);

        connect(exercise,SIGNAL(clicked()),this,SLOT(startPause()));
        connect(exercise,SIGNAL(maxZoomExceed(bool)),m_actionZoomIn,SLOT(setDisabled(bool)));
        connect(exercise,SIGNAL(minZoomExceed(bool)),m_actionZoomOut,SLOT(setDisabled(bool)));
        connect(m_actionZoomIn,SIGNAL(triggered()),exercise,SLOT(zoomIn()));
        connect(m_actionZoomOut,SIGNAL(triggered()),exercise,SLOT(zoomOut()));

        if (exercise->advancedMode()){
            connect(m_actionFaster,SIGNAL(triggered()),exercise,SLOT(faster()));
            connect(m_actionSlower,SIGNAL(triggered()),exercise,SLOT(slower()));
            connect(exercise,SIGNAL(maxSpeedExceed(bool)),m_actionFaster,SLOT(setDisabled(bool)));
            connect(exercise,SIGNAL(minSpeedExceed(bool)),m_actionSlower,SLOT(setDisabled(bool)));
            connect(exercise,SIGNAL(speedChanged(int)),&m_lblSpeed,SLOT(setNum(int)));
            connect(&m_slider,SIGNAL(sliderMoved(int)),exercise,SLOT(setOffset(int)));
            connect(exercise,SIGNAL(progressChanged(int)),&m_slider,SLOT(setValue(int)));
            connect(exercise,SIGNAL(maxProgressChanged(int)),this,SLOT(setMaxProgress(int)));
            m_lblSpeed.setNum(exercise->speed());
        } else {
            m_lblSpeed.setText("");
        }

        m_actionOpen->setVisible(exercise->advancedMode());
        m_actionFaster->setVisible(exercise->advancedMode());
        m_actionSlower->setVisible(exercise->advancedMode());
        m_slider.setVisible(exercise->advancedMode());
        m_lblSpeed.setVisible(exercise->advancedMode());
        m_lblProgress->setVisible(exercise->advancedMode());
    }
}

void ExerciseWidget::emitShowEditor(){
    emit showEditor();
    pause();
    m_actionStartPause->setChecked(false);
}

void ExerciseWidget::setText(QString& text){
    exercise->stop();
    exercise->setText(text);

    m_slider.setMaximum(exercise->maxProgress());
    m_slider.setMinimum(0);
    m_slider.setValue(0);
    m_slider.setDisabled(false);    
    m_slider.setTickPosition(QSlider::TicksBelow);
}

void ExerciseWidget::startPause(){
    if (!exercise->isActive())
        start();
    else
        pause();
}

void ExerciseWidget::start(){
    if (!exercise->isEmptyText()&&!exercise->isActive()) {
        m_actionStartPause->setChecked(true);
        exercise->start();
    } else {
       m_actionStartPause->setChecked(false);
   }
}

void ExerciseWidget::pause(){
    if (m_actionStartPause->isChecked()||exercise->isActive()){
        exercise->pause();
        m_actionStartPause->setChecked(false);
    }
}

void ExerciseWidget::stop(){
    exercise->stop();
    m_actionStartPause->setChecked(false);
    m_slider.setValue(0);
}

void ExerciseWidget::showSettings(){
    if (exercise->settingsWidget()!=NULL){
        if (exercise->isActive())
            pause();
        QWidget *wgtSettings = exercise->settingsWidget();
        wgtSettings->setParent(this);
        wgtSettings->raise();
        wgtSettings->show();
    }
}

void ExerciseWidget::emitGotoStart(){
    if (exercise->isActive())
        exercise->pause();
    emit gotoStart();
}

void ExerciseWidget::setMaxProgress(int n){
    m_slider.setValue(0);
    m_slider.setMaximum(n);
}
